/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SetOperator;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SQLFragmentUtils {
    private SQLFragmentUtils() {
    }

    public static SelectObject[] getSelectObjects(SQLQuery query) {
        SetOperator setOperator = query.getSetOperator();
        if (setOperator != null) {
            SQLQuery my_query = (SQLQuery)setOperator.getArguments()[0];
            return SQLFragmentUtils.getSelectObjects(my_query);
        }
        return query.getSelectObjects();
    }

    public static void replaceStarColumns(SQLQuery query) {
        if (query.isDeclarative()) {
            List<SelectObject> expandedSelects = SQLFragmentUtils.expandStarColumns(query);
            query.setSelectObjects(expandedSelects.toArray(new SelectObject[expandedSelects.size()]));
        }
    }

    public static List<SelectObject> expandStarColumns(SQLQuery query) {
        ArrayList<SelectObject> expandedSelects = new ArrayList<SelectObject>();
        for (SelectObject sel : SQLFragmentUtils.getSelectObjects(query)) {
            String keyword;
            int count = expandedSelects.size();
            SQLFragment exp = sel.getExpression();
            if (exp instanceof ColumnKeywordUsage && "*".equals(keyword = ((ColumnKeywordUsage)exp).getColumnName())) {
                FromObject from = ((ColumnKeywordUsage)exp).resolveFromObject();
                if (from == null) {
                    for (FromObject qfrom : query.getFromObjects()) {
                        SQLFragmentUtils.addAllColumns(qfrom, expandedSelects);
                    }
                } else {
                    SQLFragmentUtils.addAllColumns(from, expandedSelects);
                }
            }
            if (count != expandedSelects.size()) continue;
            expandedSelects.add(sel);
        }
        return expandedSelects;
    }

    private static void addAllColumns(FromObject from, Collection<SelectObject> expandedSelects) {
        if (from != null) {
            for (Column col : SQLFragmentUtils.listColumns(from)) {
                DBObjectID colID = col.getID();
                if (colID == null) continue;
                SelectObject newSel = new SelectObject();
                newSel.setExpression(new ColumnUsage(colID, from));
                expandedSelects.add(newSel);
            }
        }
    }

    public static Relation getTable(FromObject from) {
        DBObjectID id;
        Relation retval = null;
        SQLFragment exp = from.getExpression();
        if (exp instanceof DBObjectUsage && (id = ((DBObjectUsage)exp).getObjectID()) != null) {
            try {
                DBObject obj = id.resolveID();
                if (obj instanceof Relation) {
                    retval = (Relation)obj;
                }
            }
            catch (DBException dbe) {
                SQLFragmentUtils.getLogger().log(Level.WARNING, "Couldn't find table for FROM {0}: {1}", new Object[]{from.getName(), dbe.getMessage()});
            }
        }
        return retval;
    }

    public static String getTableName(FromObjectUsage usage) {
        FromObject obj = usage.resolveFromObject();
        return obj == null ? null : obj.getName();
    }

    public static Set<String> listFromObjectNames(SQLQuery query) {
        HashSet<String> retval = new HashSet<String>();
        SQLFragmentUtils.addFromNames(query, retval);
        return retval;
    }

    private static void addFromNames(SQLFragment obj, Set<String> names) {
        if (obj != null) {
            if (obj instanceof FromObject) {
                names.add(obj.getName());
            }
            for (DBObject kid : obj.getOwnedObjects()) {
                if (!(kid instanceof SQLFragment)) continue;
                SQLFragmentUtils.addFromNames((SQLFragment)kid, names);
            }
        }
    }

    public static Collection<String> listCommonColumns(JoinObject join) {
        return SQLFragmentUtils.listCommonColumns(join.getLeftExpression(), join.getRightExpression());
    }

    public static Collection<String> listCommonColumns(FromObject left, FromObject right) {
        Collection<String> leftCols = SQLFragmentUtils.listColumnNames(left.getExpression());
        Collection<String> rightCols = SQLFragmentUtils.listColumnNames(right.getExpression());
        Iterator<String> iter = leftCols.iterator();
        while (iter.hasNext()) {
            if (rightCols.contains(iter.next())) continue;
            iter.remove();
        }
        return leftCols;
    }

    public static Collection<Column> listColumns(SQLFragment expression) {
        ArrayList<Column> retval = new ArrayList<Column>();
        SQLFragmentUtils.queryColumns(expression, null, retval, Column.class);
        return retval;
    }

    public static Collection<ColumnUsage> listColumnUsages(SQLFragment expression) {
        ArrayList<ColumnUsage> retval = new ArrayList<ColumnUsage>();
        SQLFragmentUtils.queryColumns(expression, null, retval, ColumnUsage.class);
        return retval;
    }

    public static Collection<String> listColumnNames(SQLFragment expression) {
        ArrayList<String> retval = new ArrayList<String>();
        SQLFragmentUtils.queryColumns(expression, null, retval, String.class);
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> void queryColumns(SQLFragment expression, FromObject from, Collection<T> retval, Class<T> type) {
        if (expression instanceof FromObject) {
            SQLFragmentUtils.queryColumns(((FromObject)expression).getExpression(), (FromObject)expression, retval, type);
            return;
        } else if (expression instanceof RelationUsage) {
            DBObjectID id = ((RelationUsage)expression).getObjectID();
            if (id == null) return;
            try {
                Relation rel = (Relation)id.resolveID();
                if (rel == null) return;
                for (Column col : rel.getColumns()) {
                    retval.add(SQLFragmentUtils.createColumnObject(col, from, type));
                }
                return;
            }
            catch (DBException dbe) {
                SQLFragmentUtils.getLogger().log(Level.WARNING, "Couldn't resolve ID", dbe);
                return;
            }
        } else if (expression instanceof SynonymUsage) {
            DBObjectID id = ((SynonymUsage)expression).getObjectID();
            if (id == null) return;
            try {
                Synonym syn = (Synonym)id.resolveID();
                SchemaObject rel = DBUtil.getSynonymReference(syn);
                if (!(rel instanceof Relation)) return;
                for (Column col : ((Relation)rel).getColumns()) {
                    retval.add(SQLFragmentUtils.createColumnObject(col, from, type));
                }
                return;
            }
            catch (DBException dbe) {
                SQLFragmentUtils.getLogger().log(Level.WARNING, "Couldn't resolve ID", dbe);
                return;
            }
        } else if (expression instanceof JoinObject) {
            FromObject left = ((JoinObject)expression).getLeftExpression();
            SQLFragmentUtils.queryColumns(left, from, retval, type);
            FromObject right = ((JoinObject)expression).getRightExpression();
            SQLFragmentUtils.queryColumns(right, from, retval, type);
            return;
        } else {
            if (!(expression instanceof SQLQuery)) return;
            List<SelectObject> sels = SQLFragmentUtils.expandStarColumns((SQLQuery)expression);
            for (SelectObject sel : sels) {
                ColumnUsage cu;
                DBObjectID cid;
                if (!(sel.getExpression() instanceof ColumnUsage) || (cid = (cu = (ColumnUsage)sel.getExpression()).getObjectID()) == null) continue;
                try {
                    Column col = (Column)cid.resolveID();
                    if (col == null) continue;
                    retval.add(SQLFragmentUtils.createColumnObject(col, from, type));
                }
                catch (DBException e) {}
            }
        }
    }

    private static <T> T createColumnObject(Column col, FromObject from, Class<T> type) {
        if (type == Column.class) {
            return type.cast(col);
        }
        if (type == ColumnUsage.class) {
            return type.cast(new ColumnUsage(col.getID(), from));
        }
        if (type == String.class) {
            String alias = "";
            if (from != null) {
                alias = from.getAlias();
                alias = ModelUtil.hasLength((String)alias) ? alias + "." : "";
            }
            return type.cast(alias + col.getName());
        }
        throw new IllegalArgumentException("Unknown column query type.");
    }

    public static boolean hasPKCols(Collection<String> colNames, FromObject from) {
        PKConstraint pk;
        Relation table;
        if (colNames != null && !colNames.isEmpty() && (table = SQLFragmentUtils.getTable(from)) != null && (pk = PKConstraint.getPrimaryKey(table)) != null) {
            for (DBObjectID colID : pk.getColumnIDs()) {
                if (!colNames.contains(DBUtil.getDBObjectName(colID))) continue;
                return true;
            }
        }
        return false;
    }

    private static Logger getLogger() {
        return DBLog.getLogger(SQLFragmentUtils.class);
    }

    public static Collection<DBObjectID> getReferenceIDs(String sql, DBObjectProvider pro) {
        ArrayList<DBObjectID> retval = new ArrayList<DBObjectID>();
        if (ModelUtil.hasLength((String)sql)) {
            HashSet<String> tokens = new HashSet<String>();
            PlSqlToken tk = PlSqlTokenizer.tokenize((String)sql, (String[])new String[0]);
            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                String source = tk.getSource();
                String s = pro == null ? source : pro.getInternalName(source);
                tokens.add(s);
                tk = tk.getNextCodeToken();
            }
            for (String tok : tokens) {
                retval.add(new ReferenceID("UNSPECIFIED_TYPE", (String)null, tok));
            }
        }
        return retval;
    }

    public static Collection<String> listBindVariables(String sqlText) {
        HashSet<String> retval = new HashSet<String>();
        PlSqlToken tk = PlSqlTokenizer.tokenize((String)sqlText, (String[])new String[0]);
        while (tk.getType() != PlSqlToken.Type.END_MARKER) {
            PlSqlToken next;
            if (tk.matches(":") && (next = tk.getNextCodeToken()) != null) {
                String source = next.getSource();
                retval.add(next.getSource());
            }
            tk = tk.getNextToken();
        }
        return retval;
    }
}

