/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Arrays;
import java.util.List;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;

public class SetOperation
extends Operation {
    public SetOperation() {
        this(Operator.IN, null);
    }

    public SetOperation(Operator operator, SQLFragment[] args) {
        this.setFunctionFormat(false);
        this.setArguments(args);
        this.setOperator(operator);
    }

    public void setOperator(Operator operator) {
        if (operator == Operator.BETWEEN || operator == Operator.NOT_BETWEEN) {
            this.setSeparator(" AND ");
        } else {
            this.setSeparator(", ");
        }
        this.setProperty("operator", (Object)operator);
    }

    public Operator getOperator() {
        return (Operator)((Object)this.getProperty("operator"));
    }

    protected String getOperatorText() {
        Operator op = this.getOperator();
        return op == null ? null : op.getSQLText();
    }

    public String getSQLText() {
        String retval = null;
        Operator operator = this.getOperator();
        if (operator == Operator.IN || operator == Operator.NOT_IN) {
            List<SQLFragment> args = Arrays.asList(this.getArguments());
            StringBuffer buf = new StringBuffer();
            buf.append(args.iterator().next());
            buf.append(" ").append(this.getOperatorText()).append(" ");
            String argsText = this.argsToString(args, false, this.getSeparator(), 1);
            if (args.size() > 2 || args.size() == 2 && !argsText.startsWith("(")) {
                argsText = this.surroundWithBrackets(argsText, true);
            }
            buf.append(argsText);
            retval = buf.toString();
        } else {
            retval = super.getSQLText();
        }
        return retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        BETWEEN(704),
        NOT_BETWEEN(706),
        IN(705),
        EQUALS_ANY(729),
        NOT_IN(707);

        private final int m_oldValue;

        private Operator(int oldValue) {
            this.m_oldValue = oldValue;
        }

        public String getSQLText() {
            String retval = this == EQUALS_ANY ? "=ANY" : this.toString().replace("_", " ");
            return retval;
        }

        public static Operator migrate(String old) {
            Operator retval = null;
            if (old != null) {
                for (Operator op : Operator.values()) {
                    if (!old.equals(String.valueOf(op.m_oldValue))) continue;
                    retval = op;
                    break;
                }
            }
            return retval;
        }
    }
}

