/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;

public class SetOperator
extends Operation {
    public SetOperator() {
        this(Operator.UNION, null);
    }

    public SetOperator(Operator operator, SQLFragment[] args) {
        this.setFunctionFormat(false);
        this.setArguments(args);
        this.setOperator(operator);
    }

    public void setOperator(Operator operator) {
        this.setProperty("operator", (Object)operator);
    }

    public Operator getOperator() {
        return (Operator)((Object)this.getProperty("operator"));
    }

    protected String getOperatorText() {
        Operator op = this.getOperator();
        return op == null ? null : op.getSQLText();
    }

    public static Operator getSetOperator(String operator) {
        Operator retval = null;
        for (Operator op : Operator.values()) {
            if (!op.getSQLText().equalsIgnoreCase(operator)) continue;
            retval = op;
            break;
        }
        return retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        INTERSECT(7),
        UNION(8),
        MINUS(9),
        UNION_ALL(122);

        private int m_oldValue;

        private Operator(int oldValue) {
            this.m_oldValue = oldValue;
        }

        public String getSQLText() {
            return this.toString().replace("_", " ");
        }

        public static Operator migrate(String old) {
            Operator retval = null;
            if (old != null) {
                for (Operator op : Operator.values()) {
                    if (!old.equals(String.valueOf(op.m_oldValue))) continue;
                    retval = op;
                    break;
                }
            }
            return retval;
        }
    }
}

