/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.util;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import oracle.javatools.db.DatabaseDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameComparator
implements Comparator<String> {
    private final DatabaseDescriptor m_desc;
    private final boolean m_external;

    public NameComparator(DatabaseDescriptor desc, boolean external) {
        this.m_desc = desc;
        if (this.m_desc == null) {
            throw new IllegalArgumentException("DatabaseDescriptor cannot be null");
        }
        this.m_external = external;
    }

    @Override
    public int compare(String o1, String o2) {
        int retval = this.m_desc.areNamesEqual(o1, o2, null, this.m_external) ? 0 : (o1 == null ? -10 : (o2 == null ? 10 : o1.compareTo(o2)));
        return retval;
    }

    public static Set<String> createNameSet(DatabaseDescriptor desc, boolean external) {
        return new TreeSet<String>(new NameComparator(desc, external));
    }
}

