/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.javatools.db.DBObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedBuildCache<T extends DBObject> {
    private final Collection<ObjectHolder> m_objects = new ArrayList<ObjectHolder>();
    private final Collection<BuildCacheListener<T>> m_listeners = new CopyOnWriteArrayList<BuildCacheListener<T>>();

    public boolean addBuildCacheListener(BuildCacheListener<T> listener) {
        if (listener != null) {
            return this.m_listeners.add(listener);
        }
        return false;
    }

    public boolean removeBuildCacheListener(BuildCacheListener<T> listener) {
        if (listener != null) {
            return this.m_listeners.remove(listener);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T object) throws InterruptedException {
        boolean ret = false;
        if (object != null) {
            Collection<ObjectHolder> collection = this.m_objects;
            synchronized (collection) {
                long threadId = Thread.currentThread().getId();
                ObjectHolder holder = new ObjectHolder(this, threadId, (DBObject)object);
                if (!this.currentThreadHoldsLock(holder)) {
                    while (this.m_objects.contains(holder)) {
                        this.fireWaiting(object);
                        this.m_objects.wait();
                    }
                    this.fireAdding(object);
                    ret = this.m_objects.add(holder);
                } else {
                    this.fireAlreadyLocked(object);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T object) {
        boolean ret = false;
        if (object != null) {
            Collection<ObjectHolder> collection = this.m_objects;
            synchronized (collection) {
                long threadId = Thread.currentThread().getId();
                ret = this.m_objects.remove(new ObjectHolder(this, threadId, (DBObject)object));
                this.fireRemoved(object);
                this.m_objects.notifyAll();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T object) {
        boolean retval = false;
        if (object != null) {
            Collection<ObjectHolder> collection = this.m_objects;
            synchronized (collection) {
                for (ObjectHolder holder : this.m_objects) {
                    if (holder.m_payload != object) continue;
                    retval = true;
                    break;
                }
            }
        }
        return retval;
    }

    private boolean currentThreadHoldsLock(ObjectHolder holder) {
        boolean lockHeld = false;
        for (ObjectHolder cachedHolder : this.m_objects) {
            if (cachedHolder.m_threadId != holder.m_threadId || cachedHolder.m_payload != holder.m_payload) continue;
            lockHeld = true;
            break;
        }
        return lockHeld;
    }

    private void fireWaiting(T obj) {
        for (BuildCacheListener<T> listener : this.m_listeners) {
            listener.waiting(Thread.currentThread().getName(), obj);
        }
    }

    private void fireAdding(T obj) {
        for (BuildCacheListener<T> listener : this.m_listeners) {
            listener.addToCache(Thread.currentThread().getName(), obj);
        }
    }

    private void fireAlreadyLocked(T obj) {
        for (BuildCacheListener<T> listener : this.m_listeners) {
            listener.alreadyLocked(Thread.currentThread().getName(), obj);
        }
    }

    private void fireRemoved(T obj) {
        for (BuildCacheListener<T> listener : this.m_listeners) {
            listener.removeFromCache(Thread.currentThread().getName(), obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BuildCacheListener<C extends DBObject> {
        public void addToCache(String var1, C var2);

        public void removeFromCache(String var1, C var2);

        public void waiting(String var1, C var2);

        public void alreadyLocked(String var1, C var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ObjectHolder {
        private final long m_threadId;
        private final T m_payload;
        final /* synthetic */ SynchronizedBuildCache this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private ObjectHolder(long payload, T t) {
            void threadId;
            this.this$0 = (SynchronizedBuildCache)l;
            this.m_threadId = threadId;
            this.m_payload = payload;
            if (this.m_payload == null) {
                throw new NullPointerException("ObjectHolder must hold an object");
            }
        }

        public boolean equals(Object other) {
            if (other instanceof ObjectHolder) {
                return ((ObjectHolder)other).m_payload == this.m_payload;
            }
            return false;
        }

        public int hashCode() {
            return this.m_payload.hashCode();
        }
    }
}

