/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.util.DBObjectIDMap;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBObjectValidationModel {
    private DBObjectIDMap<MultiMap<String, ValidationException>> m_objs = new DBObjectIDMap(true);

    public void add(ValidationException ... exceptions) {
        if (exceptions != null) {
            ValidationException[] arr$ = exceptions;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                for (ValidationException ve = arr$[i$]; ve != null; ve = (ValidationException)ve.getNextException()) {
                    for (DBObject obj = ve.getObject(); obj != null; obj = obj.getParent()) {
                        this.addImpl(obj, ve);
                    }
                }
            }
        }
    }

    private void addImpl(DBObject obj, ValidationException ve) {
        DBObjectID id = this.normaliseID(obj);
        if (id != null) {
            MultiMap propsMap = (MultiMap)this.m_objs.get(id);
            if (propsMap == null) {
                propsMap = new MultiMap(LinkedHashSet.class);
                this.m_objs.put(id, propsMap);
            }
            String prop = ve.getPropertyName();
            DBObject veObj = ve.getObject();
            if (veObj != obj) {
                prop = Property.createPath(DBUtil.getPropertyPath(obj, veObj), prop);
            }
            propsMap.add((Object)prop, (Object)ve);
        }
    }

    private DBObjectID normaliseID(DBObject obj) {
        return obj == null ? null : this.normaliseID(obj.getID());
    }

    private DBObjectID normaliseID(DBObjectID id) {
        DBObjectID orig;
        DBObjectID retval = id;
        if (id instanceof TemporaryObjectID && (orig = TemporaryObjectID.findOriginalID((TemporaryObjectID)id)) != null) {
            retval = orig;
        }
        return retval;
    }

    public Map<String, Collection<ValidationException>> getValidationMap(DBObject obj) {
        MultiMap<String, ValidationException> retval = this.getValidationMapImpl(obj);
        return retval == null ? Collections.emptyMap() : Collections.unmodifiableMap(retval);
    }

    private MultiMap<String, ValidationException> getValidationMapImpl(DBObject obj) {
        MultiMap retval = null;
        DBObjectID id = this.normaliseID(obj);
        if (id != null) {
            retval = (MultiMap)this.m_objs.get(id);
        }
        return retval;
    }

    public boolean isValid(DBObject obj) {
        return this.getValidationMapImpl(obj) == null;
    }

    public Collection<String> getInvalidProperties(DBObject obj) {
        Set retval = null;
        MultiMap<String, ValidationException> propsMap = this.getValidationMapImpl(obj);
        if (propsMap != null) {
            retval = propsMap.keySet();
        }
        return retval == null ? Collections.emptyList() : Collections.unmodifiableCollection(retval);
    }

    public boolean isValid(DBObject obj, String prop) {
        return !this.getInvalidProperties(obj).contains(prop);
    }

    public Collection<ValidationException> getValidation(DBObject obj, String prop) {
        Collection retval = null;
        MultiMap<String, ValidationException> propsMap = this.getValidationMapImpl(obj);
        if (propsMap != null) {
            retval = propsMap.get((Object)prop);
        }
        return retval == null ? Collections.emptyList() : Collections.unmodifiableCollection(retval);
    }
}

