/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Index;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.refactoring.CascadeWorker;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.MissingValidatorException;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBObjectValidator<T extends DBObject>
extends CascadeWorker<T>
implements oracle.javatools.db.DBObjectValidator<T> {
    private Map<String, Method> m_propMap;
    private Collection<String> m_ownedObjectProperties;

    protected DBObjectValidator(DBObjectProvider pro) {
        super(pro);
    }

    @Override
    public final void validateObject(T object) throws ValidationException {
        T existing;
        if (object instanceof SystemObject && !(object instanceof Index) && (existing = this.findExistingObject(object)) != null) {
            throw new NameInUseException((DBObject)object);
        }
        this.validateObject(null, object);
    }

    @Override
    public final void validateObjectProperty(T object, String property) throws ValidationException {
        this.validateObjectProperty(this.findExistingObject(object), object, property);
    }

    private boolean isTemporaryCopy(T original, T updated) {
        return original != null && TemporaryObjectID.findOriginalObject(updated) == original;
    }

    private boolean shouldValidateProperty(T original, T updated, String property) {
        return !this.isTemporaryCopy(original, updated) || !DBUtil.needsBuilding(updated, property);
    }

    @Override
    public void validateObject(T original, T updated) throws ValidationException {
        ValidationException firstVE = null;
        HashSet<String> doneProperties = new HashSet<String>();
        HashSet<Method> doneMethods = new HashSet<Method>();
        for (Map.Entry<String, Method> entry : this.getPropertyMethodMap().entrySet()) {
            String propName = entry.getKey();
            if (this.shouldValidateProperty(original, updated, propName)) {
                Method method = entry.getValue();
                if (doneMethods.contains(method)) continue;
                doneProperties.add(propName);
                doneMethods.add(method);
                try {
                    this.invokePropertyMethod(method, original, updated);
                }
                catch (ValidationException ve) {
                    if (ve.getPropertyName() == null) {
                        ve.setPropertyName(propName);
                    }
                    firstVE = ValidationException.append(firstVE, ve);
                }
                continue;
            }
            this.getLogger().log(Level.FINE, "Skipping validation for {0} on {1}", new String[]{propName, updated.getName()});
        }
        Map<String, Object> props = this.isTemporaryCopy(original, updated) ? DBUtil.getFrozenProperties(updated) : updated.getProperties();
        for (Map.Entry<String, Object> propEntry : props.entrySet()) {
            String propName = propEntry.getKey();
            if (doneProperties.contains(propName)) continue;
            Object value = propEntry.getValue();
            try {
                if (value instanceof DBObject[]) {
                    this.validateOwnedObjects((DBObject[])value);
                    continue;
                }
                if (!(value instanceof DBObject)) continue;
                DBObject orig = original == null ? null : (DBObject)original.getProperty(propName);
                this.getProvider().validateObject(orig, (DBObject)value);
            }
            catch (MissingValidatorException mve) {
                this.getLogger().fine(mve.getMessage());
            }
            catch (ValidationException ve) {
                if (ve.getPropertyName() == null) {
                    ve.setPropertyName(propName);
                }
                firstVE = ValidationException.append(firstVE, ve);
            }
        }
        if (firstVE != null) {
            throw firstVE;
        }
    }

    @Override
    public void validateObjectProperty(T original, T updated, String property) throws ValidationException {
        Method validationMethod = this.findValidationPropertyMethod(property = this.upgradeLegacyProperty(property));
        if (validationMethod != null) {
            this.invokePropertyMethod(validationMethod, original, updated);
        } else {
            String remainingPropPath;
            boolean done = false;
            PropertyHelper propHelper = new PropertyHelper();
            String[] chunks = Property.getProperties(property);
            String pathToObject = chunks[0];
            if (chunks.length > 1) {
                String[] chunksAfter = new String[chunks.length - 1];
                System.arraycopy(chunks, 1, chunksAfter, 0, chunksAfter.length);
                remainingPropPath = Property.createPath(chunksAfter);
            } else {
                remainingPropPath = null;
            }
            Object origValue = original == null ? null : propHelper.getPropertyValue(updated, pathToObject);
            Object updValue = propHelper.getPropertyValue(updated, pathToObject);
            if (updValue == null && (remainingPropPath != null || this.isChildObjectProperty((DBObject)updated, pathToObject))) {
                done = true;
                this.validateMissingPath(original, updated, property);
            } else if (updValue instanceof DBObject) {
                try {
                    done = true;
                    this.getProvider().validateObjectProperty((DBObject)origValue, (DBObject)updValue, remainingPropPath);
                }
                catch (MissingValidatorException mve) {
                    done = false;
                }
            } else if (remainingPropPath == null && updValue instanceof DBObject[]) {
                done = true;
                this.validateOwnedObjects((DBObject[])updValue);
            }
            if (!done && !this.listAlwaysValidProperties().contains(property)) {
                throw new MissingValidatorException((DBObject)updated, property);
            }
        }
    }

    private boolean isChildObjectProperty(DBObject obj, String prop) {
        boolean retval = false;
        PropertyInfo info = this.getProvider().getPropertyManager().findPropertyInfo(obj.getClass(), prop);
        if (info != null) {
            retval = DBObject.class.isAssignableFrom(DBUtil.decodeArrayClass(info.getPropertyClass()));
        }
        return retval;
    }

    protected void validateMissingPath(T original, T updated, String property) throws ValidationException {
    }

    private final String upgradeLegacyProperty(String prop) {
        if ("COLUMN".equals(prop)) {
            return "columns";
        }
        if ("CONSTRAINT".equals(prop)) {
            return "constraints";
        }
        if ("INDEX".equals(prop)) {
            return "indexes";
        }
        return Property.stripProperties(prop);
    }

    protected Collection<String> listAlwaysValidProperties() {
        return new TreeSet<String>();
    }

    private void invokePropertyMethod(Method m, T original, T updated) throws ValidationException {
        try {
            m.invoke((Object)this, original, updated);
        }
        catch (IllegalArgumentException e) {
            this.processPropException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof ValidationException) {
                throw (ValidationException)t;
            }
            this.processPropException(t == null ? e : t);
        }
        catch (IllegalAccessException e) {
            this.processPropException(e);
        }
    }

    private void processPropException(Throwable t) {
        this.getLogger().log(Level.SEVERE, "Error calling property validation", t);
    }

    private Method findValidationPropertyMethod(String property) {
        Method retval = null;
        if (ModelUtil.hasLength((String)property)) {
            retval = this.getPropertyMethodMap().get(property);
        }
        return retval;
    }

    private synchronized Map<String, Method> getPropertyMethodMap() {
        if (this.m_propMap == null) {
            this.m_propMap = new TreeMap<String, Method>();
            Class<?> c = this.getClass();
            for (Method m : c.getMethods()) {
                PropertyValidator v = m.getAnnotation(PropertyValidator.class);
                if (v == null) continue;
                String[] value = v.value();
                if (v.path()) {
                    String path = Property.createPath(value);
                    this.putPropertyMethod(m, Property.stripProperties(path));
                    continue;
                }
                for (String p : v.value()) {
                    this.putPropertyMethod(m, p);
                }
            }
        }
        return this.m_propMap;
    }

    private void putPropertyMethod(Method m, String p) {
        if (!ModelUtil.hasLength((String)p)) {
            throw new IllegalArgumentException("Must have a property name");
        }
        if (this.m_propMap.containsKey(p)) {
            throw new IllegalStateException("Cannot have two methods validating " + p);
        }
        this.m_propMap.put(p, m);
    }

    private String toString(Property ... p) {
        StringBuilder buff = new StringBuilder();
        for (Property prop : p) {
            if (buff.length() > 0) {
                buff.append(".");
            }
            buff.append(prop.toString());
        }
        return buff.toString();
    }

    @PropertyValidator(value={"type"})
    public final void validateType(T original, T updated) throws ValidationException {
        if (original != null && ModelUtil.areDifferent((Object)original.getType(), (Object)updated.getType())) {
            throw new ValidationException((DBObject)updated, APIBundle.get("DBOV_NO_TYPE_CHANGE"));
        }
    }

    @PropertyValidator(value={"name"})
    @PropertyDependency(value={"schema"})
    public final void validateName(T original, T updated) throws ValidationException {
        this.validateName(updated);
        if (original == null) {
            this.validateNameInUse(updated);
        } else if (!this.getProvider().getDescriptor().areNamesEqual((DBObject)original, (DBObject)updated)) {
            if (this.canRename()) {
                this.validateNameInUse(updated);
            } else {
                throw new ValidationException((DBObject)updated, APIBundle.get("DBOV_NO_RENAME"));
            }
        }
    }

    protected final boolean isChildOfPendingObject(DBObject obj) {
        boolean childOfPendingObject = false;
        DBObject so = obj;
        while (so.getParent() != null) {
            so = so.getParent();
            childOfPendingObject = true;
        }
        if (so instanceof SchemaObject && !this.isPendingObject((SchemaObject)so)) {
            childOfPendingObject = false;
        }
        return childOfPendingObject;
    }

    protected final boolean isPendingObject(SchemaObject obj) {
        return TemplateExpander.isPendingObject(obj);
    }

    protected void validateName(T obj) throws InvalidNameException {
        String name = obj.getName();
        if (!ModelUtil.hasLength((String)name) && !this.canHaveEmptyName()) {
            throw new InvalidNameException((DBObject)obj, APIBundle.get("DBOV_NO_NAME"));
        }
        DBObjectProvider pro = this.getProvider();
        if (pro != null && ModelUtil.hasLength((String)name)) {
            try {
                String extName = pro.getExternalName(name);
                this.validateName(obj.getType(), extName);
            }
            catch (InvalidNameException ine) {
                String reason = ine.getMessage();
                throw new InvalidNameException((DBObject)obj, APIBundle.format("DBOV_INVALID_NAME", name, reason));
            }
        }
    }

    public void validateName(String type, String externalName) throws InvalidNameException {
        DBObjectProvider pro = this.getProvider();
        if (pro != null) {
            pro.getDescriptor().validateName(type, externalName);
        }
    }

    protected final void validateNonNullableProperty(DBObject original, DBObject updated, String propName) throws ValidationException {
        if (original != null && this.getProvider() instanceof Database) {
            Object oldValue = original.getProperty(propName);
            Object newValue = updated.getProperty(propName);
            if (oldValue != null && newValue == null) {
                throw new ValidationException(updated, APIBundle.format("INVALID_NULL_VALUE", DisplayNames.getPropertyDisplayName(propName)));
            }
        }
    }

    protected boolean canHaveEmptyName() {
        return false;
    }

    protected boolean canRename() {
        return true;
    }

    protected void validateNameInUse(T object) throws NameInUseException {
        String parProp;
        Object propValue;
        NamespaceType nsType = this.getNamespaceType();
        Schema schema = DBUtil.getSchema(object);
        String type = object.getType();
        String name = object.getName();
        DBObjectProvider pro = this.getProvider();
        DBObject parent = object.getParent();
        if (parent != null && nsType.compareTo(NamespaceType.TYPE_PARENT) >= 0 && (propValue = parent.getProperty(parProp = DBUtil.getParentProperty(object))) instanceof DBObject[]) {
            for (DBObject other : (DBObject[])propValue) {
                if (other == object || !pro.getDescriptor().areNamesEqual(name, other.getName(), object.getType(), false)) continue;
                throw new NameInUseException((DBObject)object, other);
            }
        }
        if (!(nsType.compareTo(NamespaceType.TYPE) < 0 || parent != null && this.isChildOfPendingObject((DBObject)object))) {
            pro.validateUniqueName((DBObject)object, schema);
        }
    }

    protected T findExistingObject(T object) throws ValidationException {
        DBObjectID id = object.getID();
        DBObject existing = null;
        if (id != null) {
            try {
                existing = id instanceof TemporaryObjectID ? TemporaryObjectID.findOriginalObject((TemporaryObjectID)id) : id.resolveID();
            }
            catch (DBException dbe) {
                throw new ValidationException((DBObject)object, dbe.getMessage());
            }
            if (existing != null && ModelUtil.areDifferent((Object)existing.getType(), (Object)object.getType())) {
                throw new ValidationException((DBObject)object, APIBundle.format("DBOV_OBJ_ID_ERR", object.getName()));
            }
        }
        if (existing == null && object instanceof SystemObject && (id == null || id instanceof TemporaryObjectID)) {
            try {
                existing = DBUtil.getProviderDefinition((SystemObject)object, this.getProvider());
            }
            catch (DBException dbe) {
                this.getLogger().warning(dbe.getMessage());
            }
        }
        return (T)existing;
    }

    public NamespaceType getNamespaceType() {
        return this.canHaveEmptyName() ? NamespaceType.NONE : NamespaceType.TYPE;
    }

    public boolean initializeWithDefaultName() {
        return !this.canHaveEmptyName();
    }

    @Deprecated
    protected boolean enforceChildNameUniqueInSchema(DBObject child) {
        return false;
    }

    @PropertyValidator(value={"Comment"})
    public void validateComment(T original, T update) throws ValidationException {
        String comment = (String)update.getProperty("Comment");
        if (comment != null) {
            DatabaseDescriptor dd = this.getProvider().getDescriptor();
            try {
                dd.validateEncoding(comment, "Comment");
            }
            catch (ValidationException ve) {
                throw new ValidationException((DBObject)update, ve.getMessage());
            }
        }
    }

    public Collection<String[]> getDependencies(String path) {
        PropertyDependency pd;
        ArrayList<String[]> retval = null;
        Method m = this.findValidationPropertyMethod(path);
        if (m != null && (pd = m.getAnnotation(PropertyDependency.class)) != null) {
            for (String prop : pd.value()) {
                if (retval == null) {
                    retval = new ArrayList<String[]>();
                }
                retval.add(new String[]{prop});
            }
        }
        return retval == null ? Collections.emptyList() : retval;
    }

    protected final void validateOwnedObjects(DBObject[] children) throws ValidationException {
        ValidationException ex = null;
        for (DBObject kid : children) {
            DBObject orig = null;
            DBObjectID id = kid.getID();
            if (id instanceof TemporaryObjectID) {
                orig = TemporaryObjectID.findOriginalObject((TemporaryObjectID)id);
            }
            try {
                this.getProvider().validateObject(orig, kid);
            }
            catch (ValidationException ve) {
                ex = DBException.append(ex, ve);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Deprecated
    public static void validateUniqueNames(DBObject[] objs) throws ValidationException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NamespaceType {
        NONE,
        TYPE_PARENT,
        TYPE,
        SCHEMA;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface PropertyDependency {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface PropertyValidator {
        public String[] value();

        public boolean path() default false;
    }
}

