/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SchemaObjectValidator<T extends SchemaObject>
extends DBObjectValidator<T> {
    public SchemaObjectValidator(DBObjectProvider pro) {
        super(pro);
    }

    private void validateSchema(SchemaObject object) throws ValidationException {
        Schema schema = object.getSchema();
        if (schema == null) {
            throw new ValidationException((DBObject)object, APIBundle.get("DBOV_NO_SCHEMA"));
        }
        DBObjectProvider pro = this.getProvider();
        String name = schema.getName();
        if (!ModelUtil.hasLength((String)name)) {
            throw new InvalidNameException((DBObject)schema, APIBundle.get("DBOV_SCHEMA_NO_NAME"));
        }
        if (!pro.isValidName("SCHEMA", pro.getExternalName(name))) {
            throw new InvalidNameException((DBObject)schema, APIBundle.format("DBOV_SCHEMA_INVALID_NAME", name));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"schema"})
    public void validateSchema(T original, T updated) throws ValidationException {
        Schema schema1 = original == null ? null : original.getSchema();
        Schema schema2 = updated.getSchema();
        if (schema1 == null) {
            this.validateSchema((SchemaObject)updated);
        } else {
            DatabaseDescriptor desc = this.getProvider().getDescriptor();
            if (!desc.areNamesEqual(schema1, schema2)) {
                if (this.canChangeSchema()) {
                    this.validateSchema((SchemaObject)updated);
                    if (desc.areNamesEqual((DBObject)original, (DBObject)updated)) {
                        this.validateNameInUse(updated);
                    }
                } else {
                    throw new ValidationException((DBObject)updated, APIBundle.get("DBOV_NO_SCHEMA_CHANGE"));
                }
            }
        }
    }

    protected boolean canChangeSchema() {
        return true;
    }

    @Override
    public CascadeAction cascadeDelete(DBObject removed, T obj) {
        if (this.checkSchemaDelete(removed, obj)) {
            return CascadeAction.DELETE;
        }
        return super.cascadeDelete(removed, obj);
    }

    protected boolean checkSchemaDelete(DBObject removed, T obj) {
        return removed instanceof Schema && DBUtil.areNamesAndTypesEqual(removed, obj.getSchema());
    }

    @Override
    protected CascadeAction cascadePropertyChange(Difference objDiff, String propName, Object oldValue, Object newValue, T obj) {
        CascadeAction retval = super.cascadePropertyChange(objDiff, propName, oldValue, newValue, obj);
        if (this.checkSchemaRename(objDiff, propName, obj)) {
            retval = CascadeAction.UPDATE;
        }
        return retval;
    }

    protected boolean checkSchemaRename(Difference objDiff, String propName, T obj) {
        DBObject orig;
        boolean retval = false;
        if ("name".equals(propName) && DBUtil.areNamesAndTypesEqual(orig = (DBObject)objDiff.getOriginalObject(), obj.getSchema())) {
            obj.setSchema((Schema)objDiff.getUpdatedObject());
            retval = true;
        }
        return retval;
    }
}

