/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.axischart;

import java.awt.Color;
import java.util.Date;
import java.util.Vector;
import oracle.charts.axischart.AxisChart;
import oracle.charts.axischart.AxisCore;
import oracle.charts.axischart.internal.LineDescription;
import oracle.charts.axischart.internal.XLabel;
import oracle.charts.internal.Errorfcn;
import oracle.charts.internal.MsgUtil;
import oracle.charts.types.ChartException;
import oracle.charts.types.SeriesDesc;

public class AxisChartInteractive
extends AxisChart {
    String LastSeriesName = "";
    int LastSeriesIndex = -1;
    int YDelta = 15;

    public void setXSeriesReserve(int numTimestamps) throws ChartException {
        this.Ch.TStamps = new Date[0];
        this.Ch.TStampsCount = 0;
        this.Ch.XAxisCount = numTimestamps;
        this.Ch.containsTStamps = true;
        this.initChartX();
    }

    public void setXSeriesReserveLabels(int numLabels) throws ChartException {
        this.Ch.labelXCount = 0;
        this.Ch.XAxisCount = numLabels;
        this.Ch.containsXLabels = true;
        this.Ch.XStringLabel = new String[0];
        this.initChartLabelX("foo");
    }

    public void setXSeriesAppend(Date[] tstamps) throws ChartException {
        String fcn = "setXSeriesAppend()";
        if (tstamps.length == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-150"));
        }
        if (this.Ch.labelXCount != 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-149"));
        }
        if (tstamps[0] == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-146"));
        }
        int newCount = this.Ch.TStampsCount + tstamps.length;
        Date[] temptstamps = new Date[this.Ch.TStampsCount];
        if (tstamps.length > 1) {
            this.checkAscendingDates(fcn, tstamps, tstamps.length);
        }
        if (this.Ch.TStampsCount > 0 && tstamps[0].before(this.Ch.TStamps[this.Ch.TStampsCount - 1])) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-148") + " #" + 0 + " " + " (" + this.Ch.TStamps[this.Ch.TStampsCount - 1] + ", " + tstamps[0] + ")");
        }
        int i = 0;
        while (i < this.Ch.TStampsCount) {
            temptstamps[i] = this.Ch.TStamps[i];
            ++i;
        }
        this.Ch.TStamps = new Date[newCount];
        int i2 = 0;
        while (i2 < this.Ch.TStampsCount) {
            this.Ch.TStamps[i2] = temptstamps[i2];
            ++i2;
        }
        int i3 = 0;
        while (i3 < tstamps.length) {
            this.Ch.TStamps[this.Ch.TStampsCount + i3] = tstamps[i3];
            ++i3;
        }
        this.Ch.TStampsCount = newCount;
        this.Ch.containsTStamps = true;
        if (this.Ch.XAxisCount == 0 || this.Ch.XAxisCount < this.Ch.TStampsCount) {
            this.Ch.XAxisCount = newCount;
        }
        this.initChartX();
    }

    public void setXSeriesShift(Date[] tstamps) throws ChartException {
        String fcn = "setXSeriesShift()";
        if (this.Ch.TStampsCount < tstamps.length) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-181"));
        }
        Date[] newtstamps = new Date[this.Ch.TStampsCount];
        int i = 0;
        while (i < this.Ch.TStampsCount - tstamps.length) {
            newtstamps[i] = this.Ch.TStamps[i + tstamps.length];
            ++i;
        }
        int offset = this.Ch.TStampsCount - tstamps.length;
        int i2 = 0;
        while (i2 < tstamps.length) {
            newtstamps[offset + i2] = tstamps[i2];
            ++i2;
        }
        this.Ch.TStampsCount = 0;
        this.setXSeries(newtstamps, newtstamps.length);
        int k = 0;
        while (k < this.Ch.SC.size()) {
            AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(k);
            int s = 0;
            while (s < sc.plotLineDes.size()) {
                LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
                line.shiftSeries(this.Ch.genImageMapCoords, tstamps.length);
                ++s;
            }
            ++k;
        }
    }

    public void setYSeries(String seriesName) throws ChartException {
        this.checkDuplicateSeries("setYSeries()", seriesName);
        LineDescription line = new LineDescription(seriesName, this.Ch.genImageMapCoords);
        this.initYSeries(seriesName, line);
    }

    public void setHiLoCloseSeries(String seriesName) throws ChartException {
        String fcn = "setHiLoCloseSeries()";
        this.checkDuplicateSeries(fcn, seriesName);
        double[] temp = new double[]{};
        LineDescription line = new LineDescription(seriesName, this.Ch.TStamps, this.Ch.genImageMapCoords, temp, temp, temp, 0, temp.length);
        line.lineType = 7;
        this.initHiLoCloseSeries(seriesName, line);
    }

    public void setOpenHiLoCloseSeries(String seriesName) throws ChartException {
        this.setOpenHiLoCloseSeriesSeq(seriesName, 8);
    }

    public void setCandlestickSeries(String seriesName) throws ChartException {
        this.setOpenHiLoCloseSeriesSeq(seriesName, 9);
    }

    private void setOpenHiLoCloseSeriesSeq(String seriesName, int lineType) throws ChartException {
        String fcn = "setOpenHiLoCloseSeries()";
        this.checkDuplicateSeries(fcn, seriesName);
        double[] temp = new double[]{};
        LineDescription line = new LineDescription(seriesName, 0, this.Ch.genImageMapCoords, temp, temp, temp, temp, 0, temp.length);
        line.lineType = lineType;
        this.initOpenHiLoCloseSeries(seriesName, line);
    }

    public void setYSeriesAppend(String seriesName, double[] yvalues) throws ChartException {
        int newLength;
        String fcn = "setYSeriesAppend()";
        this.checkTimeStampsAndValues(fcn, yvalues.length);
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
        if (!this.isBasicLineType(line.lineType)) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-180") + seriesName);
        }
        if ((newLength = line.num_points + yvalues.length) > this.Ch.TStampsCount) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-153") + seriesName);
        }
        line.appendSeries(this.Ch.genImageMapCoords, yvalues);
        line.MinMax();
        this.SubCh.YAxis1.yAxisMet.assignGlobalMinMax(line.ymin, line.ymax);
    }

    public void setCandlestickSeriesAppend(String seriesName, double[] yopen, double[] yhigh, double[] ylow, double[] yclose) throws ChartException {
        this.setOpenHiLoCloseSeriesAppend(seriesName, yopen, yhigh, ylow, yclose, 9);
    }

    public void setOpenHiLoCloseSeriesAppend(String seriesName, double[] yopen, double[] yhigh, double[] ylow, double[] yclose) throws ChartException {
        this.setOpenHiLoCloseSeriesAppend(seriesName, yopen, yhigh, ylow, yclose, 8);
    }

    private void setOpenHiLoCloseSeriesAppend(String seriesName, double[] yopen, double[] yhigh, double[] ylow, double[] yclose, int lineType) throws ChartException {
        int newLength;
        String fcn = "setOpenHiLoCloseSeriesAppend()";
        this.checkOHLCEqualLength("setOpenHiLoCloseSeries()", seriesName, yopen.length, yhigh.length, ylow.length, yclose.length);
        this.checkTimeStampsAndValues(fcn, yclose.length);
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
        if (!this.isOHLCLineType(line.lineType)) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-180") + seriesName);
        }
        if ((newLength = line.num_points + yclose.length) > this.Ch.TStampsCount) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-153") + seriesName);
        }
        line.appendSeries(this.Ch.genImageMapCoords, yopen, yhigh, ylow, yclose);
        line.MinMaxStock();
        this.SubCh.YAxis1.yAxisMet.assignGlobalMinMax(line.ymin, line.ymax);
    }

    public void setHiLoCloseSeriesAppend(String seriesName, double[] yhigh, double[] ylow, double[] yclose) throws ChartException {
        int newLength;
        String fcn = "setOpenHiLoCloseSeriesAppend()";
        this.checkHLCEqualLength("setHiLoCloseSeries()", seriesName, yhigh.length, ylow.length, yclose.length);
        this.checkTimeStampsAndValues(fcn, yclose.length);
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
        if (!this.isHLCLineType(line.lineType)) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-180") + seriesName);
        }
        if ((newLength = line.num_points + yclose.length) > this.Ch.TStampsCount) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-153") + seriesName);
        }
        line.appendSeries(this.Ch.genImageMapCoords, yhigh, ylow, yclose);
        line.MinMaxStock();
        this.SubCh.YAxis1.yAxisMet.assignGlobalMinMax(line.ymin, line.ymax);
    }

    public void setDeleteYSeries(String seriesName) throws ChartException {
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound("setDeleteYSeries()", seriesName);
        }
        LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
        this.SubCh.plotLineDes.removeElement(line);
        if (!this.L2.getLegendDesc().getLegendDisable()) {
            this.L2.setDeleteLegendItem(seriesName);
        }
    }

    public void setDeleteAllYSeries() {
        int k = this.Ch.SC.size() - 1;
        while (k >= 0) {
            this.SubCh = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(k);
            int s = this.SubCh.plotLineDes.size() - 1;
            while (s >= 0) {
                this.SubCh.plotLineDes.removeElementAt(s);
                --s;
            }
            if (k > 0) {
                this.Ch.SC.removeElementAt(k);
            }
            --k;
        }
        this.SubCh = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(0);
        if (!this.L2.getLegendDesc().getLegendDisable()) {
            this.L2.clearLegend();
        }
    }

    public void setDeleteAllXYSeries() {
        this.setDeleteAllYSeries();
        this.Ch.XAxisCount = 0;
        if (this.Ch.TStampsCount > 0) {
            this.Ch.TStampsCount = 0;
            this.Ch.TStamps = new Date[0];
            this.xl = new XLabel(this.ChartLocale);
            this.xl.firstLevelField = this.xl.firstLevelField_default;
            this.xl.lastLevelField = this.xl.lastLevelField_default;
            this.xval = new double[0];
            super.initBorderFlags();
        } else if (this.Ch.labelXCount > 0) {
            this.Ch.labelXCount = 0;
            this.xval = new double[0];
            this.Ch.XStringLabel = new String[0];
        }
    }

    public void setYSeriesSparseAppend(String seriesName, Date[] tstamps, double[] yvalues) throws ChartException {
        int s;
        String fcn = "setYSeriesSparseAppend() ";
        if (this.Ch.TStampsCount == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-114"));
        }
        if (tstamps.length == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-130"));
        }
        if (tstamps.length != yvalues.length) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-131"));
        }
        int length = tstamps.length;
        this.checkAscendingDates(fcn, tstamps, length);
        if (tstamps[length - 1].after(this.Ch.TStamps[this.Ch.TStampsCount - 1])) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-170"));
        }
        if ((s = this.LookupSeries(seriesName)) <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
        if (!line.subFrequency) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-132") + seriesName);
        }
        if (tstamps[0].before(this.Ch.TStamps[line.timestampIndex[line.timestampIndex.length - 1]])) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-172") + tstamps[0] + " " + MsgUtil.getMsg("CHT-175") + " " + this.Ch.TStamps[line.timestampIndex[line.timestampIndex.length - 1]] + ")");
        }
        line.appendSparse(this.Ch.TStamps, tstamps, yvalues);
        line.appendSeries(this.Ch.genImageMapCoords, yvalues);
        line.MinMax();
        this.SubCh.YAxis1.yAxisMet.assignGlobalMinMax(line.ymin, line.ymax);
    }

    public void eraseChart() {
        this.Ch.TStampsCount = 0;
        this.Ch.XAxisCount = 0;
        this.Ch.containsTStamps = false;
        this.Ch.containsXLabels = false;
        this.Ch.labelXCount = 0;
        this.SubCh.plotLineDes = new Vector();
        this.SubCh.YAxis1.yAxisMet.Ymax_non_adjusted = Double.NEGATIVE_INFINITY;
        this.SubCh.YAxis1.yAxisMet.Ymin_non_adjusted = Double.MAX_VALUE;
        this.SubCh.YAxis2.yAxisMet.Ymax_non_adjusted = Double.NEGATIVE_INFINITY;
        this.SubCh.YAxis2.yAxisMet.Ymin_non_adjusted = Double.MAX_VALUE;
    }

    public boolean getSeriesElementEntered(int x, int y) throws ChartException {
        SeriesDesc SD = this.getSeriesIndexDesc(x, y);
        int currentSeriesIndex = SD.getSeriesIndex();
        if (currentSeriesIndex == -1) {
            return false;
        }
        String currentSeriesName = SD.getSeriesName();
        if (currentSeriesName == "") {
            return false;
        }
        if (currentSeriesName != this.LastSeriesName || currentSeriesIndex != this.LastSeriesIndex) {
            this.LastSeriesName = currentSeriesName;
            this.LastSeriesIndex = currentSeriesIndex;
            return true;
        }
        return false;
    }

    public boolean getSeriesElementExited(int x, int y) throws ChartException {
        String currentSeriesName;
        SeriesDesc SD = this.getSeriesIndexDesc(x, y);
        int currentSeriesIndex = SD.getSeriesIndex();
        if (this.LastSeriesIndex != -1 && currentSeriesIndex == -1) {
            this.LastSeriesName = SD.getSeriesName();
            this.LastSeriesIndex = currentSeriesIndex;
            return true;
        }
        return this.LastSeriesIndex != -1 && currentSeriesIndex != -1 && (currentSeriesName = SD.getSeriesName()) != this.LastSeriesName;
    }

    public int getSeriesIndex(int x, int y) throws ChartException {
        SeriesDesc SD = this.getSeriesIndexDesc(x, y);
        return SD.getSeriesIndex();
    }

    public SeriesDesc getSeriesIndexDesc(int x, int y) throws ChartException {
        LineDescription line;
        SeriesDesc SD = new SeriesDesc();
        SD.setSeriesName("");
        SD.setSeriesIndex(-1);
        if (x >= this.getRightMostXDC()) {
            return SD;
        }
        if (x < this.Ch.border_left) {
            return SD;
        }
        if (y < this.Ch.border_top) {
            return SD;
        }
        int seriesElements = this.Ch.XAxisCount;
        if (this.Ch.vertical) {
            LineDescription[] lineArray;
            int seriesNameIndex;
            LineDescription line2;
            double x_scale = this.SubCh.xAxisWidth / this.SubCh.x_coordinate_spread;
            double intervalDC = this.SubCh.xAxisWidth / (double)seriesElements;
            double seriesIndex = (double)(x -= this.Ch.border_left) / intervalDC;
            AxisCore.SubChartDescription sc = this.Ch.SC.size() == 1 ? this.SubCh : this.getSubchart(y);
            if (sc == null) {
                SD.setSeriesIndex(-1);
                return SD;
            }
            int numbars = 0;
            int s = 0;
            while (s < sc.plotLineDes.size()) {
                line2 = (LineDescription)sc.plotLineDes.elementAt(s);
                if (line2.lineType == 4) {
                    ++numbars;
                }
                ++s;
            }
            s = 0;
            while (s < sc.plotLineDes.size()) {
                line2 = (LineDescription)sc.plotLineDes.elementAt(s);
                switch (line2.lineType) {
                    case 1: 
                    case 2: {
                        if (!this.containedInBarWidth(x, intervalDC, line2, s, 1) || (seriesNameIndex = this.containedInLine(y, (int)seriesIndex, lineArray = this.getAllLines(sc))) == -1) break;
                        LineDescription linetemp = lineArray[seriesNameIndex];
                        SD.setSeriesName(linetemp.seriesName);
                        if (linetemp.subFrequency) {
                            SD.setSeriesIndex(linetemp.getSparseIndex((int)seriesIndex));
                        } else {
                            SD.setSeriesIndex((int)seriesIndex);
                        }
                        return SD;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        if (!this.containedInBarWidth(x, intervalDC, line2, s, 1) || (seriesNameIndex = this.containedInHighLow(y, (int)seriesIndex, lineArray = this.getAllStockLines(sc))) == -1) break;
                        LineDescription linetemp = lineArray[seriesNameIndex];
                        SD.setSeriesName(linetemp.seriesName);
                        if (linetemp.subFrequency) {
                            SD.setSeriesIndex(linetemp.getSparseIndex((int)seriesIndex));
                        } else {
                            SD.setSeriesIndex((int)seriesIndex);
                        }
                        return SD;
                    }
                }
                ++s;
            }
            s = 0;
            while (s < sc.plotLineDes.size()) {
                line2 = (LineDescription)sc.plotLineDes.elementAt(s);
                switch (line2.lineType) {
                    case 4: {
                        if (!this.containedInBarWidth(x, intervalDC, line2, s, numbars)) break;
                        SD.setSeriesName(line2.seriesName);
                        if (!this.containedIn(sc, y, (int)seriesIndex, line2)) break;
                        if (line2.subFrequency) {
                            SD.setSeriesIndex(line2.getSparseIndex((int)seriesIndex));
                        } else {
                            SD.setSeriesIndex((int)seriesIndex);
                        }
                        return SD;
                    }
                    case 5: {
                        if (!this.containedInBarWidth(x, intervalDC, line2, s, 1)) break;
                        lineArray = null;
                        lineArray = this.getStackedBars(sc, 5, false);
                        seriesNameIndex = this.containedInStackedBar(sc, y, (int)seriesIndex, lineArray);
                        if (seriesNameIndex == -1) break;
                        LineDescription linetemp = lineArray[seriesNameIndex];
                        SD.setSeriesName(linetemp.seriesName);
                        if (linetemp.subFrequency) {
                            SD.setSeriesIndex(linetemp.getSparseIndex((int)seriesIndex));
                        } else {
                            SD.setSeriesIndex((int)seriesIndex);
                        }
                        return SD;
                    }
                }
                ++s;
            }
            SD.setSeriesIndex(-1);
            return SD;
        }
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(0);
        double x_scale = sc.Displayheight / sc.x_coordinate_spread;
        double intervalDC = sc.Displayheight / (double)seriesElements;
        double seriesIndex = (double)(y -= this.Ch.border_top) / intervalDC;
        seriesIndex = (double)seriesElements - seriesIndex;
        boolean isContained = false;
        int s = 0;
        while (s < sc.plotLineDes.size()) {
            line = (LineDescription)sc.plotLineDes.elementAt(s);
            if (this.containedInBarWidth(y, intervalDC, line, s, sc.plotLineDes.size())) {
                isContained = true;
                SD.setSeriesName(line.seriesName);
                break;
            }
            ++s;
        }
        if (!isContained) {
            SD.setSeriesIndex(-1);
            return SD;
        }
        line = (LineDescription)sc.plotLineDes.elementAt(s);
        if (!this.containedIn(sc, x, (int)seriesIndex, line)) {
            SD.setSeriesIndex(-1);
            return SD;
        }
        SD.setSeriesIndex((int)seriesIndex);
        return SD;
    }

    private boolean containedInBarWidth(double x, double intervalDC, LineDescription line, int lineIndex, int numLines) {
        if (this.isBarType(line.lineType)) {
            double intervalPlacement = x % intervalDC;
            double edgeFraction = (1.0 - line.BarThicknessPct) * 0.5;
            double barStart = edgeFraction * intervalDC;
            double barEnd = intervalDC - barStart;
            if (numLines == 1) {
                if (intervalPlacement < barStart || intervalPlacement > barEnd) {
                    return false;
                }
            } else {
                double clusterBarWidth = barEnd - barStart;
                double oneBarWidth = clusterBarWidth / (double)numLines;
                int lineIndexTemp = lineIndex;
                if (!this.Ch.vertical) {
                    lineIndexTemp = numLines - lineIndex - 1;
                }
                double indexedBarStart = barStart + (double)lineIndexTemp * oneBarWidth;
                double indexedBarEnd = barStart + (double)(lineIndexTemp + 1) * oneBarWidth;
                if (intervalPlacement < indexedBarStart || intervalPlacement > indexedBarEnd) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean containedInBarWidth(double x, double intervalDC, LineDescription line) {
        return this.containedInBarWidth(x, intervalDC, line, 0, 1);
    }

    private boolean containedIn(AxisCore.SubChartDescription sc, double y, int seriesIndex, LineDescription line) {
        int baseline = this.getYBaselineInt(sc);
        int index = seriesIndex;
        if (!line.subFrequency && seriesIndex >= line.yval_int.length) {
            return false;
        }
        if (seriesIndex < 0) {
            return false;
        }
        if (line.subFrequency && (index = line.getSparseIndex(seriesIndex)) == -1) {
            return false;
        }
        int yval_int_temp = line.yval_int[index];
        if (this.isBarType(line.lineType)) {
            int barMin = baseline;
            int barMax = yval_int_temp;
            if (yval_int_temp < baseline) {
                barMin = yval_int_temp;
                barMax = baseline;
            }
            if (y < (double)barMin) {
                return false;
            }
            if (y > (double)barMax) {
                return false;
            }
        }
        return true;
    }

    private int containedInLine(int y, int seriesIndex, LineDescription[] lineArray) {
        int minDistance = Integer.MAX_VALUE;
        int selectedIndex = -1;
        int s = 0;
        while (s < lineArray.length) {
            int distance;
            int index = seriesIndex;
            if (lineArray[s].subFrequency) {
                index = lineArray[s].getSparseIndex(seriesIndex);
            }
            if (index != -1 && index < lineArray[s].yval_int.length && (distance = Math.abs(y - lineArray[s].yval_int[index])) < minDistance) {
                minDistance = distance;
                selectedIndex = s;
            }
            ++s;
        }
        if (minDistance <= this.YDelta) {
            return selectedIndex;
        }
        return -1;
    }

    private int containedInHighLow(int y, int seriesIndex, LineDescription[] lineArray) {
        int selectedIndex = -1;
        int s = 0;
        while (s < lineArray.length) {
            int index = seriesIndex;
            if (lineArray[s].subFrequency) {
                index = lineArray[s].getSparseIndex(seriesIndex);
            }
            if (index != -1 && index < lineArray[s].ylow_int.length && y <= lineArray[s].ylow_int[index] && y >= lineArray[s].yhigh_int[index]) {
                selectedIndex = s;
            }
            ++s;
        }
        return selectedIndex;
    }

    private int containedInStackedBar(AxisCore.SubChartDescription sc, double y, int seriesIndex, LineDescription[] lineArray) {
        int[] ypos = new int[lineArray.length];
        int[] yposLineIndex = new int[lineArray.length];
        int[] yneg = new int[lineArray.length];
        int[] ynegLineIndex = new int[lineArray.length];
        double y_zero = 0.0;
        int y_zero_int = this.ScaleYToPlotWindow(sc, y_zero);
        int index_neg = 0;
        int index_pos = 0;
        if (y <= (double)y_zero_int) {
            int s = 0;
            while (s < lineArray.length) {
                int index = seriesIndex;
                if (lineArray[s].subFrequency) {
                    index = lineArray[s].getSparseIndex(seriesIndex);
                }
                if (index != -1 && index < lineArray[s].yval.length && lineArray[s].yval[index] >= 0.0) {
                    ypos[index_pos] = lineArray[s].yval_int[index];
                    yposLineIndex[index_pos] = s;
                    ++index_pos;
                }
                ++s;
            }
            int yLow = y_zero_int;
            int yHigh = y_zero_int;
            int yheight = 0;
            int s2 = 0;
            while (s2 < index_pos) {
                int currentIndex = s2;
                int posLineIndex = yposLineIndex[currentIndex];
                yheight = y_zero_int - ypos[s2];
                yLow = yHigh - yheight;
                if (y <= (double)yHigh && y >= (double)yLow) {
                    return posLineIndex;
                }
                yHigh = yLow;
                ++s2;
            }
        } else {
            int s = 0;
            while (s < lineArray.length) {
                int index = seriesIndex;
                if (lineArray[s].subFrequency) {
                    index = lineArray[s].getSparseIndex(seriesIndex);
                }
                if (index != -1 && index < lineArray[s].yval.length && lineArray[s].yval[index] < 0.0) {
                    yneg[index_neg] = lineArray[s].yval_int[index];
                    ynegLineIndex[index_neg] = s;
                    ++index_neg;
                }
                ++s;
            }
            int yHigh = y_zero_int;
            int yLow = y_zero_int;
            int yheight = 0;
            int s3 = 0;
            while (s3 < index_neg) {
                int currentIndex = s3;
                int negLineIndex = ynegLineIndex[currentIndex];
                yLow = yHigh;
                yheight = yneg[s3] - y_zero_int;
                if (y <= (double)(yHigh = yLow + yheight) && y >= (double)yLow) {
                    return negLineIndex;
                }
                ++s3;
            }
        }
        return -1;
    }

    private LineDescription[] getAllLines(AxisCore.SubChartDescription sc) {
        LineDescription line;
        int numLines = 0;
        int s = 0;
        while (s < this.SubCh.plotLineDes.size()) {
            line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            switch (line.lineType) {
                case 1: 
                case 2: {
                    ++numLines;
                }
            }
            ++s;
        }
        LineDescription[] LineArray = new LineDescription[numLines];
        numLines = 0;
        s = 0;
        while (s < this.SubCh.plotLineDes.size()) {
            line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            switch (line.lineType) {
                case 1: 
                case 2: {
                    LineArray[numLines++] = line;
                }
            }
            ++s;
        }
        return LineArray;
    }

    private LineDescription[] getAllStockLines(AxisCore.SubChartDescription sc) {
        LineDescription line;
        int numLines = 0;
        int s = 0;
        while (s < this.SubCh.plotLineDes.size()) {
            line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            switch (line.lineType) {
                case 7: 
                case 8: 
                case 9: {
                    ++numLines;
                }
            }
            ++s;
        }
        LineDescription[] LineArray = new LineDescription[numLines];
        numLines = 0;
        s = 0;
        while (s < this.SubCh.plotLineDes.size()) {
            line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            switch (line.lineType) {
                case 7: 
                case 8: 
                case 9: {
                    LineArray[numLines++] = line;
                }
            }
            ++s;
        }
        return LineArray;
    }

    public void setSeriesUnHighlight() throws ChartException {
        int k = 0;
        while (k < this.Ch.SC.size()) {
            AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(k);
            int s = 0;
            while (s < sc.plotLineDes.size()) {
                LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
                line.hilightIndex = -1;
                ++s;
            }
            ++k;
        }
    }

    public void setSeriesHighlight(String seriesName, int seriesIndex, Color c) throws ChartException {
        int s;
        String fcn = "setSeriesHighlight()";
        if (seriesIndex < -1) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-220"));
        }
        if ((s = this.LookupSeries(seriesName)) == -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            int lineLength = 0;
            if (line.yval != null) {
                lineLength = line.yval.length;
            } else if (line.yhigh != null) {
                lineLength = line.yhigh.length;
            }
            int tempSeriesIndex = seriesIndex;
            if (!this.Ch.vertical && !line.subFrequency) {
                int seriesElements = this.Ch.labelXCount;
                tempSeriesIndex = seriesElements - seriesIndex - 1;
            }
            if (tempSeriesIndex > lineLength) {
                Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-221"));
            }
            line.hilightColor = c;
            line.hilightIndex = tempSeriesIndex;
        }
    }

    public void setSeriesUnHighlight(String seriesName) throws ChartException {
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound("getSeriesUnHighlight()", seriesName);
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            line.hilightIndex = -1;
        }
    }

    public void setSeriesAnnotation(String seriesName, int seriesIndex) throws ChartException {
        String fcn = "setSeriesAnnotation()";
        if (seriesIndex < -1) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-220"));
        }
        if (!this.Ch.vertical) {
            // empty if block
        }
        int tempSeriesIndex = seriesIndex;
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            int lineLength = 0;
            if (line.yval != null) {
                lineLength = line.yval.length;
            } else if (line.yhigh != null) {
                lineLength = line.yhigh.length;
            }
            if (tempSeriesIndex > lineLength) {
                Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-221"));
            }
            line.popupIndex = tempSeriesIndex;
        }
    }

    public void setSeriesAnnotationRemove(String seriesName) throws ChartException {
        int s = this.LookupSeries(seriesName);
        if (s == -1) {
            this.chartErrorSeriesNotFound("setSeriesAnnotationRemove()", seriesName);
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            line.popupIndex = -1;
        }
    }

    public void setSeriesAnnotationRemove() throws ChartException {
        int k = 0;
        while (k < this.Ch.SC.size()) {
            AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(k);
            int s = 0;
            while (s < sc.plotLineDes.size()) {
                LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
                line.popupIndex = -1;
                ++s;
            }
            ++k;
        }
    }
}

