/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.axischart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import oracle.charts.axischart.AxisCore;
import oracle.charts.axischart.GanttTaskTree;
import oracle.charts.axischart.internal.MillisecondsCalendar;
import oracle.charts.internal.Errorfcn;
import oracle.charts.internal.LineMarker;
import oracle.charts.internal.MsgUtil;
import oracle.charts.types.ChartException;
import oracle.charts.types.ImageMapAreaDescSingle;
import oracle.charts.types.MarkerDesc;
import oracle.charts.types.TaskBase;
import oracle.charts.types.TaskDesc;
import oracle.charts.types.TaskLink;
import oracle.viz.util.DFTreeIterator;

public class GanttChart
extends AxisCore {
    LinkedList taskVizData = null;
    Hashtable taskVizIndex = null;
    LinkedList linkVizData = null;
    MillisecondsCalendar tempCal = new MillisecondsCalendar();
    private int LabelIndentPixels;
    private int BBW = 1;
    int ArrowStemLength = 9;
    int ArrowHeadLength = 6;
    int ArrowHeadHalfWidth = 3;
    int NullDate = -999999;
    int completionWS;
    int compWidth;
    static final int MARKER_CONNECTOR_STYLE2 = 0;
    static final int MARKER_CONNECTOR_STYLE1 = 1;
    int markerConnectorStyle = 1;
    LineMarker LM = new LineMarker();
    static final int GLYPH_INDENT = 5;
    boolean ToggleEnabled = false;
    GanttDesc ganttD = new GanttDesc();
    ToggleTreeNode toggle = new ToggleTreeNode();
    TaskLabels TLabels = new TaskLabels();
    private boolean fontMetricsGanttGot = false;

    public GanttChart() {
        this.xl.timeAxisD.setDayOfWeek(true);
    }

    public void setTimeLine(Date startDate, Date endDate) throws ChartException {
        super.setXSeriesContinuous(startDate, endDate, true);
    }

    public void setGanttTasks(GanttTaskTree tasks) throws ChartException {
        String fcn = "SetGanttTasks";
        if (!this.Ch.containsTStamps) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-400"));
        }
        if (tasks == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-140"));
        }
        this.mapTasks(tasks);
    }

    public void setMarkerConnectorStyle(int connectorStyle) {
        switch (connectorStyle) {
            case 0: 
            case 1: {
                this.markerConnectorStyle = connectorStyle;
            }
        }
    }

    protected void mapTasks(GanttTaskTree tasks) throws ChartException {
        int i;
        int i2;
        this.taskVizData = new LinkedList();
        this.taskVizIndex = new Hashtable();
        DFTreeIterator iter = tasks.viewIterator();
        while (iter.hasNext()) {
            TaskViz viz = new TaskViz();
            viz.task = (TaskDesc)iter.next();
            viz.base = viz.task;
            viz.indent = iter.depth();
            viz.hasChildren = iter.depth() == 0 || iter.hasChildren();
            this.calculateVizData(viz);
            long totalMillis = viz.endDateMillis - viz.startDateMillis;
            TaskViz[] rViz = new TaskViz[viz.task.getNumRepeats()];
            i2 = 0;
            while (i2 < rViz.length) {
                rViz[i2] = new TaskViz();
                rViz[i2].base = viz.task.getRepeat(i2);
                rViz[i2].task = viz.task;
                rViz[i2].isRepeat = true;
                this.calculateVizData(rViz[i2]);
                if (rViz[i2].endDateMillis != (long)this.NullDate && rViz[i2].startDateMillis != (long)this.NullDate) {
                    totalMillis += rViz[i2].endDateMillis - rViz[i2].startDateMillis;
                }
                ++i2;
            }
            long completion = (long)(viz.task.getCompletion() * (float)totalMillis);
            if (completion != 0L) {
                long startMillis = 0L;
                long endMillis = viz.endDateMillis - viz.startDateMillis;
                viz.completion = endMillis > completion ? (float)(completion - startMillis) / (float)(endMillis - startMillis) : 1.0f;
                int i3 = 0;
                while (endMillis < completion && i3 < rViz.length) {
                    startMillis = endMillis;
                    rViz[i3].completion = (endMillis += rViz[i3].endDateMillis - rViz[i3].startDateMillis) > completion ? (float)(completion - startMillis) / (float)(endMillis - startMillis) : 1.0f;
                    ++i3;
                }
            }
            this.taskVizData.add(viz);
            this.taskVizIndex.put(new Long(viz.base.getID()), viz);
            i = 0;
            while (i < rViz.length) {
                this.taskVizData.add(rViz[i]);
                this.taskVizIndex.put(new Long(rViz[i].base.getID()), rViz[i]);
                ++i;
            }
        }
        this.linkVizData = new LinkedList();
        ListIterator linkIter = tasks.getDependencies();
        while (linkIter.hasNext()) {
            TaskLink link = (TaskLink)linkIter.next();
            LinkViz lviz = new LinkViz();
            lviz.base = link;
            int srcCount = 0;
            i2 = 0;
            while (i2 < link.srcID.length) {
                if (null != this.findTaskViz(link.srcID[i2])) {
                    ++srcCount;
                }
                ++i2;
            }
            if (srcCount <= 0) continue;
            lviz.srcID = new long[srcCount];
            srcCount = 0;
            int i4 = 0;
            while (i4 < link.srcID.length) {
                if (null != this.findTaskViz(link.srcID[i4])) {
                    lviz.srcID[srcCount++] = link.srcID[i4];
                }
                ++i4;
            }
            int sinkCount = 0;
            i = 0;
            while (i < link.sinkID.length) {
                if (null != this.findTaskViz(link.sinkID[i])) {
                    ++sinkCount;
                }
                ++i;
            }
            if (sinkCount <= 0) continue;
            lviz.sinkID = new long[sinkCount];
            sinkCount = 0;
            int i5 = 0;
            while (i5 < link.sinkID.length) {
                if (null != this.findTaskViz(link.sinkID[i5])) {
                    lviz.sinkID[sinkCount++] = link.sinkID[i5];
                }
                ++i5;
            }
            this.linkVizData.add(lviz);
        }
    }

    protected void calculateVizData(TaskViz viz) {
        if (viz.base.getStartDate() != null) {
            this.tempCal.setTime(viz.base.getStartDate());
            viz.startDateMillis = this.tempCal.getTimeInMillis();
            viz.startDateFraction = viz.startDateMillis - this.TimeAxisCont.xAxisStartMillis;
            viz.startDateFraction /= (double)this.TimeAxisCont.xAxisSpanMillis;
        } else {
            viz.startDateMillis = this.NullDate;
            viz.startDateFraction = this.NullDate;
        }
        if (viz.base.getEndDate() != null) {
            this.tempCal.setTime(viz.base.getEndDate());
            viz.endDateMillis = this.tempCal.getTimeInMillis();
            viz.endDateFraction = viz.endDateMillis - this.TimeAxisCont.xAxisStartMillis;
            viz.endDateFraction /= (double)this.TimeAxisCont.xAxisSpanMillis;
        } else {
            viz.endDateMillis = this.NullDate;
            viz.endDateFraction = this.NullDate;
        }
    }

    private synchronized void drawBuffer0(Graphics2D g2, String fcn) throws ChartException {
        boolean test = false;
        if (test) {
            System.out.println("*** drawBuffer0 ****");
        }
        this.initChartLayoutAttributes();
        this.checkDrawBufferErrors(g2, fcn);
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(0);
        this.DrawBufferCalled = true;
        this.getFMetrics(g2);
        this.getFMetricsGantt(g2);
        this.determineDrawOutsideLegend();
        this.setDefaultDescriptors();
        RenderingHints RHOriginal = null;
        if (this.isSetRenderingHintsChart()) {
            g2.setRenderingHints(super.getRenderingHintsChart());
        } else {
            RHOriginal = g2.getRenderingHints();
        }
        if (test) {
            System.out.println("drawBuffer: a" + this.Ch.TStampsCount + " " + this.Ch.labelXCount);
        }
        this.initHBarLayout(g2);
        this.computeMaxLabelWidth();
        this.setPlotWidthHBar(sc);
        this.Ch.border_left = sc.HLayout.labelXSpaceLeft;
        this.setBorderLeftInternal(this.Ch.border_left);
        this.resetDisplaySize();
        if (test) {
            System.out.println("Calling ScaleAll1");
        }
        this.ScaleAll1(g2);
        this.initXL();
        if (test) {
            System.out.println("Called ScaleAll1");
        }
        this.generateXAxisLabels(g2);
        this.alignLegendFootnote(g2);
        this.legendHeuristics(g2);
        if (test) {
            System.out.println("Calling ScaleAll2");
        }
        this.ScaleAll2(g2);
    }

    public synchronized void drawBuffer(Graphics2D g2) throws ChartException {
        boolean debug = false;
        if (debug) {
            System.out.println("");
            System.out.println("*** Gantt Draw Buffer ****");
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.setGraphicsBuffer(g2);
            g2 = this.svgChartGraphics;
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_chart");
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.setChartType(1);
        }
        String fcn = "drawBuffer";
        this.drawBuffer0(g2, fcn);
        if (debug) {
            System.out.println("Calling ScaleAll3");
        }
        this.ScaleAll3Gantt(g2);
        if (debug) {
            System.out.println("1 dHeight = " + this.Ch.displayHeight);
            System.out.println("border_top = " + this.Ch.border_top);
            System.out.println("border_bottom = " + this.Ch.border_bottom);
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_frame");
        }
        this.drawOutsideFrame(g2);
        this.drawChartBackground(g2, true, false);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(0);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_hgrid");
        }
        this.drawGanttHorizontalGrid(g2);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_background");
        }
        this.drawChartBackground(g2, false, true);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
        this.adjustInsideLegendAlignment(g2);
        if (debug) {
            System.out.println("2 dHeight = " + this.Ch.displayHeight);
            System.out.println("border_top = " + this.Ch.border_top);
            System.out.println("border_bottom = " + this.Ch.border_bottom);
        }
        this.drawHorizontalGridLines(g2, this.Ch.vertical);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_vgrid");
        }
        if (this.Ch.vertical) {
            this.xl.drawBuffer(g2, this.svgChartGraphics, false, this.UserXGrid, this.DefaultStroke, this.DashedStroke, this.DashedStroke2);
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
        this.PlotBarGantt(g2);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_chartstatic");
        }
        int maxLines = 0;
        this.drawInteriorLegend(g2, maxLines);
        g2.setStroke(this.DefaultStroke);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_plotoutline");
        }
        this.drawPlotOutline(g2);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
        g2.setColor(this.foreground);
        this.drawTitlesAndFootnotes(g2);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_axislabels");
        }
        this.drawXAxisLabels(g2, sc.x_coordinate_spread, (int)sc.xAxisWidth);
        if (this.DrawOutsideLegend && !this.L2.getLegendDesc().getLegendDisable() && !this.L2.getLegendDisableInternal()) {
            this.L2.drawLegendBuffer(g2, this.svgChartGraphics, this.Ch.genImageMapCoords);
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
        if (debug) {
            System.out.println("K dHeight = " + this.Ch.displayHeight);
        }
    }

    protected void computeMaxLabelWidth() {
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(0);
        this.LabelIndentPixels = this.TLabels.fontmet.stringWidth("M");
        int maxPosLabelWidth = 0;
        Iterator iter = this.taskVizData.iterator();
        double taskIntervalHeight = this.getTaskIntervalHeight();
        this.toggle.init();
        while (iter.hasNext()) {
            TaskViz viz = (TaskViz)iter.next();
            if (this.toggle.skip(viz) || viz.isRepeat) continue;
            String labelString = viz.task.getLabel();
            int currentLabelWidth = viz.indent * this.LabelIndentPixels + this.TLabels.fontmet.stringWidth(labelString);
            if (this.ToggleEnabled && viz.hasChildren) {
                currentLabelWidth = (int)((double)currentLabelWidth + (taskIntervalHeight + 5.0));
            }
            if (currentLabelWidth <= maxPosLabelWidth) continue;
            maxPosLabelWidth = currentLabelWidth;
        }
        sc.HLayout.maxPosLabelWidth = maxPosLabelWidth;
        if (sc.HLayout.maxPosLabelWidth > 0) {
            sc.HLayout.maxPosLabelWidth += sc.HLayout.padCharWidthBaseLabels * 2;
        }
        sc.HLayout.maxPosLabelWidth += 8;
        sc.HLayout.labelXSpaceLeft = sc.HLayout.maxPosLabelWidth;
        sc.HLayout.labelXSpaceRight = 0;
    }

    public int getChartHeightDerived() throws ChartException {
        int newHeight;
        if (this.BI == null) {
            this.BI = new BufferedImage(1, 1, 1);
        }
        Graphics2D g2 = this.BI.createGraphics();
        this.drawBuffer0(g2, "getChartHeightDerived()");
        int plotWindowHeight = this.getPlotWindowHeight();
        this.Ch.displayHeight = newHeight = this.Ch.border_top + this.Ch.border_bottom + plotWindowHeight;
        this.Ch.displayWidth = this.getWidth();
        return newHeight;
    }

    protected void ScaleAll3Gantt(Graphics2D g2) throws ChartException {
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(0);
        this.ScaleGanttTasksToPlotWindow();
        this.ScaleXAxisToPlotWindow(this.xval, this.xval_int.length, sc.x_coordinate_spread);
        if (this.xl.timeAxisD.getDayOfWeek() || this.xl.timeAxisD.getDayOfWeekOnly()) {
            this.ScaleXAxisShadeToPlotWindow(this.AxisTimeBandHolder.AxisTimebands_v);
        }
    }

    private void ScaleGanttTasksToPlotWindow() {
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(0);
        int x_const = this.Ch.border_left + sc.XOrigin;
        x_const += this.Ch.border_time_extra / 2;
        double factor = sc.xAxisWidth;
        Iterator iter = this.taskVizData.iterator();
        this.toggle.init();
        while (iter.hasNext()) {
            TaskViz viz = (TaskViz)iter.next();
            if (this.toggle.skip(viz)) continue;
            viz.xStartDate_dc = viz.startDateFraction != (double)this.NullDate ? x_const + (int)Math.round(viz.startDateFraction * factor) : this.NullDate;
            viz.xEndDate_dc = viz.endDateFraction != (double)this.NullDate ? x_const + (int)Math.round(viz.endDateFraction * factor) : this.NullDate;
        }
    }

    private synchronized void drawArrowHeadRight(Graphics2D g2, int pointX, int pointY) {
        int[] XTemp = new int[5];
        int[] YTemp = new int[5];
        XTemp[0] = pointX - this.ArrowHeadLength;
        YTemp[0] = pointY - this.ArrowHeadHalfWidth;
        XTemp[1] = pointX;
        YTemp[1] = pointY;
        XTemp[2] = pointX - 1;
        YTemp[2] = pointY;
        XTemp[3] = pointX - this.ArrowHeadLength;
        YTemp[3] = pointY + this.ArrowHeadHalfWidth;
        g2.fillPolygon(XTemp, YTemp, 4);
        g2.drawPolygon(XTemp, YTemp, 4);
    }

    private boolean isPointMarker(TaskDesc task) {
        return task.getTaskStyle() == 1 || task.getTaskStyle() == 3;
    }

    private boolean isMarker(TaskDesc task) {
        return task.getTaskStyle() == 3;
    }

    private synchronized void drawLink(Graphics2D g2, LinkViz lviz, int barWidth) {
        switch (lviz.base.type) {
            case 1: {
                if (lviz.srcID.length == 1 && lviz.sinkID.length == 1) {
                    TaskViz vizSink = this.findTaskViz(lviz.sinkID[0]);
                    TaskViz vizSrc = this.findTaskViz(lviz.srcID[0]);
                    if (this.isPointMarker(vizSink.task) && this.isPointMarker(vizSrc.task) && this.markerConnectorStyle == 1) {
                        this.drawSimpleFPSLink(g2, lviz, barWidth);
                        break;
                    }
                    this.drawFPSLink(g2, lviz, barWidth);
                    break;
                }
                this.drawFPSLink(g2, lviz, barWidth);
                break;
            }
        }
    }

    private synchronized void drawFPSLink(Graphics2D g2, LinkViz lviz, int barWidth) {
        lviz.srcX = new int[lviz.srcID.length];
        lviz.srcY = new int[lviz.srcID.length];
        int minSrcX = Integer.MAX_VALUE;
        int maxSrcX = Integer.MIN_VALUE;
        int minSrcY = Integer.MAX_VALUE;
        int maxSrcY = Integer.MIN_VALUE;
        int i = 0;
        while (i < lviz.srcID.length) {
            TaskViz viz = this.findTaskViz(lviz.srcID[i]);
            if (viz.xEndDate_dc != this.NullDate) {
                lviz.srcX[i] = viz.xEndDate_dc;
                lviz.srcY[i] = viz.yStart_dc + barWidth / 2;
                if (!viz.isRepeat && this.isPointMarker(viz.task)) {
                    lviz.srcX[i] = viz.xStartDate_dc;
                }
                if (!viz.isRepeat && (this.isPointMarker(viz.task) || viz.task.getTaskStyle() == 2)) {
                    int n = i;
                    lviz.srcX[n] = lviz.srcX[n] + (barWidth / 2 + 2);
                }
                minSrcX = Math.min(lviz.srcX[i], minSrcX);
                minSrcY = Math.min(lviz.srcY[i], minSrcY);
                maxSrcX = Math.max(lviz.srcX[i], maxSrcX);
                maxSrcY = Math.max(lviz.srcY[i], maxSrcY);
            }
            ++i;
        }
        lviz.sinkX = new int[lviz.sinkID.length];
        lviz.sinkY = new int[lviz.sinkID.length];
        int minSinkX = Integer.MAX_VALUE;
        int maxSinkX = Integer.MIN_VALUE;
        int minSinkY = Integer.MAX_VALUE;
        int maxSinkY = Integer.MIN_VALUE;
        int i2 = 0;
        while (i2 < lviz.sinkID.length) {
            TaskViz viz = this.findTaskViz(lviz.sinkID[i2]);
            if (viz.xStartDate_dc != this.NullDate) {
                lviz.sinkX[i2] = viz.xStartDate_dc;
                lviz.sinkY[i2] = viz.yStart_dc + barWidth / 2;
                if (!viz.isRepeat && (this.isPointMarker(viz.task) || viz.task.getTaskStyle() == 2)) {
                    int n = i2;
                    lviz.sinkX[n] = lviz.sinkX[n] - barWidth / 2;
                }
                minSinkX = Math.min(lviz.sinkX[i2], minSinkX);
                minSinkY = Math.min(lviz.sinkY[i2], minSinkY);
                maxSinkX = Math.max(lviz.sinkX[i2], maxSinkX);
                maxSinkY = Math.max(lviz.sinkY[i2], maxSinkY);
            }
            ++i2;
        }
        int srcGroupX = maxSrcX + this.ArrowHeadLength;
        if (1 == lviz.srcID.length) {
            srcGroupX = maxSrcX;
        } else {
            int i3 = 0;
            while (i3 < lviz.srcID.length) {
                TaskViz viz = this.findTaskViz(lviz.srcID[i3]);
                g2.drawLine(lviz.srcX[i3], lviz.srcY[i3], srcGroupX, lviz.srcY[i3]);
                ++i3;
            }
            g2.drawLine(srcGroupX, minSrcY, srcGroupX, maxSrcY);
        }
        int sinkGroupX = minSinkX - this.ArrowHeadLength * 2;
        if (1 == lviz.sinkID.length) {
            sinkGroupX = minSinkX - this.ArrowHeadLength;
            this.drawArrowHeadRight(g2, lviz.sinkX[0] - 2, lviz.sinkY[0]);
        } else {
            int i4 = 0;
            while (i4 < lviz.sinkID.length) {
                g2.drawLine(sinkGroupX, lviz.sinkY[i4], lviz.sinkX[i4] - this.ArrowHeadLength, lviz.sinkY[i4]);
                this.drawArrowHeadRight(g2, lviz.sinkX[i4] - 2, lviz.sinkY[i4]);
                ++i4;
            }
            g2.drawLine(sinkGroupX, minSinkY, sinkGroupX, maxSinkY);
        }
        int[] connX = new int[6];
        int[] connY = new int[6];
        int connLen = 0;
        int originY = (maxSrcY + minSrcY) / 2;
        connX[connLen] = srcGroupX;
        connY[connLen] = originY;
        connX[++connLen] = connX[connLen - 1] + this.ArrowHeadLength;
        connY[connLen] = originY;
        ++connLen;
        if (sinkGroupX - 2 * this.ArrowHeadLength < srcGroupX) {
            int switchbackY = maxSrcY + barWidth / 2 + this.ganttD.halfShave;
            if (maxSinkY < minSrcY) {
                switchbackY = minSrcY - barWidth / 2 - this.ganttD.halfShave;
            }
            connX[connLen] = connX[connLen - 1];
            connY[connLen] = switchbackY;
            connX[++connLen] = sinkGroupX - this.ArrowHeadLength;
            connY[connLen] = switchbackY;
            ++connLen;
        }
        int insertionY = (maxSinkY + minSinkY) / 2;
        connX[connLen] = connX[connLen - 1];
        connY[connLen] = insertionY;
        connX[++connLen] = sinkGroupX;
        connY[connLen] = insertionY;
        g2.drawPolyline(connX, connY, ++connLen);
    }

    private synchronized void drawSimpleFPSLink(Graphics2D g2, LinkViz lviz, int barWidth) {
        TaskViz vizSrc = this.findTaskViz(lviz.srcID[0]);
        int srcX = vizSrc.xStartDate_dc;
        int srcY = vizSrc.yStart_dc + barWidth / 2;
        TaskViz vizSink = this.findTaskViz(lviz.sinkID[0]);
        int sinkX = vizSink.xStartDate_dc;
        int sinkY = vizSink.yStart_dc + barWidth / 2;
        if (!vizSink.isRepeat && (this.isPointMarker(vizSink.task) || vizSink.task.getTaskStyle() == 2)) {
            sinkX -= barWidth / 2;
        }
        if (this.isMarker(vizSrc.task)) {
            int[] connX = new int[2];
            int[] connY = new int[2];
            int connLen = 0;
            connX[connLen] = srcX;
            connY[connLen] = srcY;
            connX[++connLen] = sinkX;
            connY[connLen] = sinkY;
            g2.setColor(vizSrc.task.getLinkColor());
            g2.drawPolyline(connX, connY, ++connLen);
        }
    }

    private synchronized void oldDrawFPSLink(Graphics2D g2, LinkViz lviz, int barWidth) {
        int i = 0;
        while (i < lviz.srcID.length) {
            int j = 0;
            while (j < lviz.sinkID.length) {
                this.oldDrawFPSArrow(g2, this.findTaskViz(lviz.srcID[i]), this.findTaskViz(lviz.sinkID[j]), barWidth);
                ++j;
            }
            ++i;
        }
    }

    private synchronized void oldDrawFPSArrow(Graphics2D g2, TaskViz fromViz, TaskViz toViz, int barWidth) {
        g2.setColor(fromViz.task.getLinkColor());
        int x = fromViz.xEndDate_dc;
        int y = fromViz.yStart_dc + barWidth;
        int conHeight = this.ganttD.halfShave;
        int conLength = this.ArrowHeadLength * 2;
        int barCenterY2 = toViz.yStart_dc + barWidth / 2;
        int[] XTemp = new int[5];
        int[] YTemp = new int[5];
        XTemp[0] = x;
        YTemp[0] = y;
        XTemp[1] = x;
        YTemp[1] = y + conHeight;
        XTemp[2] = x - conLength;
        YTemp[2] = y + conHeight;
        XTemp[3] = x - conLength;
        YTemp[3] = barCenterY2;
        XTemp[4] = toViz.xStartDate_dc - 2;
        YTemp[4] = barCenterY2;
        g2.drawPolyline(XTemp, YTemp, 5);
        this.drawArrowHeadRight(g2, toViz.xStartDate_dc - 2, barCenterY2);
    }

    private synchronized void oldDrawDepLink(Graphics2D g2, LinkViz lviz, int barWidth) {
        int i = 0;
        while (i < lviz.srcID.length) {
            int j = 0;
            while (j < lviz.sinkID.length) {
                this.drawDepArrowOld(g2, this.findTaskViz(lviz.srcID[i]), this.findTaskViz(lviz.sinkID[j]), barWidth);
                ++j;
            }
            ++i;
        }
    }

    private synchronized void drawDepArrowOld(Graphics2D g2, TaskViz fromViz, TaskViz toViz, int barWidth) {
        Color myGray = new Color(200, 200, 200);
        g2.setColor(Color.black);
        int yOffset = barWidth / 2;
        int y = fromViz.yStart_dc + yOffset;
        int xCorner = fromViz.xEndDate_dc + this.ArrowStemLength;
        g2.drawLine(fromViz.xEndDate_dc + 1, y, xCorner, y);
        g2.drawLine(xCorner, y, xCorner, toViz.yStart_dc);
        int[] xTemp = new int[4];
        int[] yTemp = new int[4];
        xTemp[0] = xCorner;
        yTemp[0] = toViz.yStart_dc;
        xTemp[1] = xCorner - this.ArrowHeadHalfWidth;
        yTemp[1] = toViz.yStart_dc - this.ArrowHeadLength;
        xTemp[2] = xCorner + this.ArrowHeadHalfWidth;
        yTemp[2] = toViz.yStart_dc - this.ArrowHeadLength;
        xTemp[3] = xCorner;
        yTemp[3] = toViz.yStart_dc;
        g2.fillPolygon(xTemp, yTemp, 4);
    }

    private synchronized ImageMapAreaDescSingle drawTaskBar(Graphics2D g2, TaskViz viz, int xStart, int yStart, int barLength, int barWidth) {
        ImageMapAreaDescSingle iMap1 = new ImageMapAreaDescSingle();
        g2.setColor(viz.task.getBackground());
        g2.fillRect(xStart, yStart, barLength, barWidth);
        g2.setColor(Color.black);
        g2.drawRect(xStart, yStart, barLength, barWidth);
        if (barWidth > 1 && (double)viz.completion != 0.0) {
            g2.setColor(Color.black);
            int xCompStart = xStart + this.BBW;
            int compLength = (int)((float)(barLength - this.BBW) * viz.completion);
            int yCompStart = yStart + this.BBW + this.completionWS;
            g2.fillRect(xCompStart, yCompStart, compLength, this.compWidth);
        }
        int[] coords = new int[]{xStart, yStart, xStart + barLength, yStart + barWidth};
        iMap1.setCoords(coords);
        iMap1.setShape(0);
        return iMap1;
    }

    private synchronized void drawDiamond(Graphics2D g2, TaskViz viz, int xStart, int yStart, int barWidth) {
        int[] xPts = new int[4];
        int[] yPts = new int[4];
        int half = barWidth / 2;
        xPts[0] = xStart;
        yPts[0] = yStart;
        xPts[1] = xStart - half;
        yPts[1] = yStart + half;
        xPts[2] = xStart;
        yPts[2] = yStart + barWidth;
        xPts[3] = xStart + half;
        yPts[3] = yStart + half;
        g2.setColor(viz.task.getBackground());
        g2.fillPolygon(xPts, yPts, 4);
        g2.setColor(Color.black);
        g2.drawPolygon(xPts, yPts, 4);
    }

    private synchronized void drawGroup(Graphics2D g2, TaskViz viz, int xStart, int yStart, int barLength, int barWidth) {
        int[] xPts = new int[8];
        int[] yPts = new int[8];
        int half = barWidth / 2;
        xPts[0] = xStart - half;
        yPts[0] = yStart;
        xPts[1] = xStart - half;
        yPts[1] = yStart + half;
        xPts[2] = xStart;
        yPts[2] = yStart + barWidth;
        xPts[3] = xStart + half;
        yPts[3] = yStart + half;
        xPts[4] = xStart + barLength - half;
        yPts[4] = yStart + half;
        xPts[5] = xStart + barLength;
        yPts[5] = yStart + barWidth;
        xPts[6] = xStart + barLength + half;
        yPts[6] = yStart + half;
        xPts[7] = xStart + barLength + half;
        yPts[7] = yStart;
        g2.setColor(viz.task.getBackground());
        g2.fillPolygon(xPts, yPts, 8);
        g2.setColor(Color.black);
        g2.drawPolygon(xPts, yPts, 8);
    }

    private synchronized void PlotBarGantt(Graphics2D g2) {
        TaskViz viz;
        int yStart;
        int xLeft;
        boolean test;
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.setSliderPosition(this.Ch.border_left, this.Ch.displayHeight - this.Ch.border_bottom, this.Ch.displayWidth - this.Ch.border_left - this.Ch.border_right);
            this.svgChartGraphics.startGroup("cb_coords");
        }
        if (test = false) {
            System.out.println();
            System.out.println("PlotBarGantt");
        }
        Shape savedClip = g2.getClip();
        g2.setClip(this.Ch.border_left, this.Ch.border_top, this.Ch.displayWidth - this.Ch.border_left - this.Ch.border_right + 1, this.Ch.displayHeight - this.Ch.border_bottom - this.Ch.border_top + 1);
        if (this.svgChartGraphics.getEnableSVG()) {
            String foo = this.svgChartGraphics.getPlotWindowClipDef("cb_plotWindowClip", this.Ch.border_left, 0, this.Ch.displayWidth - this.Ch.border_left - this.Ch.border_right + 1, this.Ch.displayHeight - this.Ch.border_bottom - this.Ch.border_top + 1);
            this.svgChartGraphics.setSVGDefinitionsInternal(foo);
        }
        int labelAscent = this.TLabels.fontmet.getAscent();
        int labelAscentCenter = (int)((double)labelAscent / 2.7);
        double taskIntervalHeight = this.getTaskIntervalHeight();
        int taskIntervalHeightInt = (int)Math.round(taskIntervalHeight);
        int barWidth = taskIntervalHeightInt - this.ganttD.shave;
        int halfInterval = (int)Math.round(taskIntervalHeight / 2.0);
        int textYOffset = halfInterval + labelAscentCenter;
        this.completionWS = barWidth < 3 ? 0 : (barWidth - this.BBW + 2) / 3;
        this.compWidth = barWidth - this.BBW - 2 * this.completionWS;
        if (this.compWidth < 1) {
            this.compWidth = 1;
        }
        g2.setFont(this.TLabels.font);
        int yTop = this.Ch.border_top + this.ganttD.halfShave + this.ganttD.topOffset;
        int xBarStart = xLeft = this.Ch.border_left;
        int halfCharWidth = (int)((double)this.TLabels.fontmet.stringWidth("@") * 0.5);
        int plotWidth = this.Ch.displayWidth - xLeft - this.Ch.border_right;
        int rowCount = 0;
        Iterator iter = this.taskVizData.iterator();
        this.toggle.init();
        while (iter.hasNext()) {
            TaskViz viz2 = (TaskViz)iter.next();
            if (this.toggle.skip(viz2)) continue;
            if (!viz2.isRepeat) {
                ++rowCount;
            }
            viz2.yStart_dc = yStart = (int)Math.round((double)(rowCount - 1) * taskIntervalHeight) + yTop;
        }
        ListIterator linkIter = this.linkVizData.listIterator();
        while (linkIter.hasNext()) {
            LinkViz lviz = (LinkViz)linkIter.next();
            this.drawLink(g2, lviz, barWidth);
        }
        rowCount = 0;
        iter = this.taskVizData.iterator();
        boolean skip = false;
        int skip_level = 0;
        int last_viz_indent = 0;
        while (iter.hasNext()) {
            viz = (TaskViz)iter.next();
            if (!viz.isRepeat) {
                last_viz_indent = viz.indent;
                if (skip && last_viz_indent <= skip_level) {
                    skip = false;
                }
                if (viz.hasChildren && !viz.expand) {
                    skip = true;
                    skip_level = viz.indent;
                }
            }
            if (skip && last_viz_indent > skip_level) continue;
            if (test) {
                System.out.println("Iterate " + rowCount + " " + viz.task.getLabel());
            }
            yStart = viz.yStart_dc;
            if (viz.xStartDate_dc == this.NullDate) continue;
            xBarStart = viz.xStartDate_dc;
            int barLength = viz.xEndDate_dc - xBarStart;
            if (0 == viz.task.getTaskStyle()) {
                viz.task.imapTask = this.drawTaskBar(g2, viz, xBarStart, yStart, barLength, barWidth);
                continue;
            }
            if (2 == viz.task.getTaskStyle()) {
                this.drawGroup(g2, viz, xBarStart, yStart, barLength, barWidth);
                continue;
            }
            if (1 == viz.task.getTaskStyle()) {
                this.drawDiamond(g2, viz, xBarStart, yStart, barWidth);
                continue;
            }
            if (3 != viz.task.getTaskStyle()) continue;
            int markerType = 1;
            double markerScale = 1.0;
            Color markerColor = Color.black;
            MarkerDesc md = viz.task.getTaskStyleMarker();
            if (md != null) {
                markerType = md.getMarkerType();
                markerScale = md.getMarkerScale();
                markerColor = md.getMarkerColor();
            }
            g2.setStroke(this.LM.getLineMarkerStroke(markerType));
            g2.setColor(markerColor);
            viz.base.imap = this.LM.drawMarker(g2, markerType, markerScale, xBarStart, yStart + barWidth / 2);
        }
        g2.setClip(savedClip);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_tasklabels");
        }
        iter = this.taskVizData.iterator();
        this.toggle.init();
        while (iter.hasNext()) {
            viz = (TaskViz)iter.next();
            if (this.toggle.skip(viz) || viz.isRepeat) continue;
            int xcoord = 0 + halfCharWidth + this.LabelIndentPixels * viz.indent;
            if (this.ToggleEnabled && viz.hasChildren) {
                int x = xcoord;
                int y = viz.yStart_dc + 1;
                int w = barWidth - 1;
                int h = barWidth - 1;
                viz.task.imapNavigator = this.drawPlusMinus(g2, x, y, w, h, !viz.expand);
                xcoord += w + 5;
            }
            g2.setColor(this.TLabels.color);
            g2.drawString(viz.task.getLabel(), xcoord, viz.yStart_dc + textYOffset);
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
    }

    private ImageMapAreaDescSingle drawPlusMinus(Graphics2D g2, int x, int y, int w, int h, boolean plus) {
        ImageMapAreaDescSingle iMap1 = new ImageMapAreaDescSingle();
        g2.setColor(new Color(230, 230, 230));
        g2.fillRect(x, y, w, h);
        g2.setColor(new Color(53, 153, 255));
        g2.drawRect(x, y, w, h);
        g2.setColor(Color.black);
        g2.drawLine(x + 3, y + h / 2, x + w - 3, y + h / 2);
        if (plus) {
            g2.drawLine(x + w / 2, y + 3, x + w / 2, y + h - 3);
        }
        int[] coords = new int[]{x, y, x + w, y + h};
        iMap1.setCoords(coords);
        iMap1.setShape(0);
        return iMap1;
    }

    public void collapseParentNode(long ID) {
        TaskViz viz = (TaskViz)this.taskVizIndex.get(new Long(ID));
        if (viz != null) {
            viz.expand = false;
        }
    }

    public void setTaskTreeToggle(boolean enabled) {
        this.ToggleEnabled = enabled;
    }

    public boolean getTaskTreeToggle() {
        return this.ToggleEnabled;
    }

    private TaskViz findTaskViz(long ID) {
        return (TaskViz)this.taskVizIndex.get(new Long(ID));
    }

    protected double getTaskIntervalHeight() {
        int labelHeight = this.TLabels.fontmet.getHeight();
        double taskIntervalHeight = (double)labelHeight * 1.0;
        return taskIntervalHeight;
    }

    private int getPlotWindowHeight() {
        int taskCount = 1;
        Iterator iter = this.taskVizData.iterator();
        this.toggle.init();
        while (iter.hasNext()) {
            TaskViz viz = (TaskViz)iter.next();
            if (viz.isRepeat || this.toggle.skip(viz)) continue;
            ++taskCount;
        }
        double taskIntervalHeight = this.getTaskIntervalHeight();
        int yTop = this.ganttD.topOffset + this.ganttD.topOffset;
        int plotWindowHeight = (int)Math.round((double)taskCount * taskIntervalHeight) + yTop;
        return plotWindowHeight;
    }

    protected synchronized void drawGanttBackground(Graphics2D g2) {
        double taskIntervalHeight = this.getTaskIntervalHeight();
        int taskIntervalHeightInt = (int)Math.round(taskIntervalHeight);
        int yTop = this.Ch.border_top + this.ganttD.topOffset;
        int stripeWidth = this.Ch.displayWidth - this.Ch.border_right;
        int i = 0;
        Iterator iter = this.taskVizData.iterator();
        this.toggle.init();
        while (iter.hasNext()) {
            TaskViz viz = (TaskViz)iter.next();
            if (this.toggle.skip(viz) || viz.isRepeat) continue;
            int yStart = (int)Math.round((double)i * taskIntervalHeight) + yTop;
            if (i % 2 == 0) {
                g2.setColor(this.ganttD.stripe0);
            } else {
                g2.setColor(this.ganttD.stripe1);
            }
            g2.fillRect(0, yStart, stripeWidth, taskIntervalHeightInt);
            ++i;
        }
        g2.setStroke(this.DefaultStroke);
    }

    protected synchronized void drawGanttHorizontalGrid(Graphics2D g2) {
        double taskIntervalHeight = this.getTaskIntervalHeight();
        int taskIntervalHeightInt = (int)Math.round(taskIntervalHeight);
        int yTop = this.Ch.border_top + this.ganttD.topOffset;
        int stripeWidth = this.Ch.displayWidth - this.Ch.border_right;
        g2.setColor(new Color(204, 204, 204));
        g2.setStroke(this.DashedStroke);
        int i = 1;
        Iterator iter = this.taskVizData.iterator();
        this.toggle.init();
        while (iter.hasNext()) {
            TaskViz viz = (TaskViz)iter.next();
            if (viz.isRepeat || this.toggle.skip(viz)) continue;
            int yStart = (int)Math.round((double)i * taskIntervalHeight) + yTop;
            g2.drawLine(this.Ch.border_left, yStart, this.Ch.displayWidth - this.Ch.border_right, yStart);
            ++i;
        }
        g2.setStroke(this.DefaultStroke);
    }

    protected synchronized void getFMetricsGantt(Graphics2D g2) {
        if (this.fontMetricsGanttGot) {
            return;
        }
        this.TLabels.fontmet = g2.getFontMetrics(this.TLabels.font);
        this.fontMetricsGanttGot = true;
    }

    private final class TaskLabels {
        Color color = Color.black;
        Font font = new Font("sansserif", 0, 11);
        FontMetrics fontmet;

        public void setFont(Font f) {
            this.font = f;
            GanttChart.this.fontMetricsGanttGot = false;
        }
    }

    private class ToggleTreeNode {
        boolean skip = false;
        int skip_level = 0;

        public void init() {
            this.skip = false;
            this.skip_level = 0;
        }

        public boolean skip(TaskViz viz) {
            if (!viz.isRepeat) {
                if (this.skip && viz.indent > this.skip_level) {
                    return true;
                }
                if (this.skip && viz.indent <= this.skip_level) {
                    this.skip = false;
                }
                if (viz.hasChildren && !viz.expand) {
                    this.skip = true;
                    this.skip_level = viz.indent;
                }
            }
            return false;
        }
    }

    private final class GanttDesc {
        int topOffset = 0;
        int shave = 4;
        int halfShave = this.shave / 2;
        Color stripe0 = new Color(240, 240, 240);
        Color stripe1 = Color.white;

        private GanttDesc() {
        }

        public void GanttDesc() {
        }
    }

    protected final class LinkViz {
        TaskLink base = null;
        long[] srcID = null;
        long[] sinkID = null;
        int[] srcX = null;
        int[] srcY = null;
        int[] sinkX = null;
        int[] sinkY = null;

        protected LinkViz() {
        }
    }

    protected final class TaskViz {
        TaskBase base = null;
        TaskDesc task = null;
        boolean isRepeat = false;
        float completion = 0.0f;
        int indent;
        long startDateMillis;
        long endDateMillis;
        double startDateFraction;
        double endDateFraction;
        int xStartDate_dc;
        int xEndDate_dc;
        int yStart_dc;
        boolean hasChildren = false;
        boolean expand = true;

        protected TaskViz() {
        }
    }
}

