/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.internal;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import oracle.charts.types.ImageMapAreaDescSingle;

public class LineMarker {
    private static final int LINE_SOLID = 1;
    private static final int LINE_DASHED = 2;
    private static final int LINE_DASHED2 = 3;
    BasicStroke LineStroke = new BasicStroke(2.0f, 0, 2);
    BasicStroke DefaultStroke = new BasicStroke(1.0f, 0, 2);
    BasicStroke LineMarkerStroke = new BasicStroke(1.5f, 0, 2);
    final double LineDeltaD = 5.0f * this.LineStroke.getLineWidth() / 2.0f + 1.0f;
    double QuarterPie = 0.7854;
    final double LineDeltaSquareD = Math.sqrt(this.LineDeltaD * this.LineDeltaD * this.QuarterPie);
    final double LineDeltaDiamondD = Math.sqrt(this.LineDeltaD * this.LineDeltaD * this.QuarterPie * 1.7);

    public LineMarker(BasicStroke lineStroke) {
        this.LineStroke = lineStroke;
    }

    public LineMarker() {
    }

    public int getLineDelta() {
        return (int)Math.round(this.LineDeltaD);
    }

    public BasicStroke getLineStroke(int lineStyle, float lineWidth) {
        switch (lineStyle) {
            case 1: {
                return new BasicStroke(lineWidth, 0, 2);
            }
            case 2: {
                return new BasicStroke(lineWidth, 0, 2, 1.0f, new float[]{lineWidth, lineWidth / 2.0f}, 0.0f);
            }
            case 3: {
                return new BasicStroke(lineWidth, 0, 2, 1.0f, new float[]{lineWidth * 2.0f, lineWidth}, 0.0f);
            }
        }
        return new BasicStroke(lineWidth, 0, 2);
    }

    public BasicStroke getLineStroke() {
        return this.LineStroke;
    }

    public BasicStroke getLineMarkerStroke(int markerType) {
        switch (markerType) {
            case 5: 
            case 6: {
                return this.LineMarkerStroke;
            }
        }
        return this.DefaultStroke;
    }

    public ImageMapAreaDescSingle drawMarker(Graphics2D g2, int markerType, double markerScaleFactor, int x, int y) {
        ImageMapAreaDescSingle iMap1 = new ImageMapAreaDescSingle();
        switch (markerType) {
            case 1: {
                double radiusD = this.LineDeltaD * markerScaleFactor;
                int radius = (int)Math.round(radiusD);
                int radiusHalf = (int)Math.round(radiusD * 0.5);
                int[] coords = new int[]{x, y, radiusHalf};
                iMap1.setCoords(coords);
                iMap1.setShape(1);
                int originX = x - radiusHalf;
                int originY = y - radiusHalf;
                Ellipse2D.Double e = new Ellipse2D.Double(originX, originY, radius, radius);
                g2.fill(e);
                break;
            }
            case 10: 
            case 11: {
                double radiusD = this.LineDeltaD * markerScaleFactor;
                int radius = (int)Math.round(radiusD);
                int radiusHalf = (int)Math.round(radiusD * 0.5);
                int[] coords = new int[]{x, y, radiusHalf};
                iMap1.setCoords(coords);
                iMap1.setShape(1);
                if (markerType == 10) {
                    this.drawStar(g2, x, y, 5, markerScaleFactor);
                }
                if (markerType != 11) break;
                this.drawStar(g2, x, y, 8, markerScaleFactor);
                break;
            }
            case 2: {
                double widthD = this.LineDeltaSquareD * markerScaleFactor;
                int width = (int)Math.round(widthD);
                int widthHalf = (int)Math.round(widthD * 0.5);
                int originX = x - widthHalf;
                int originY = y - widthHalf;
                g2.fillRect(originX, originY, width, width);
                int[] coords = new int[]{originX, originY, originX + width, originY + width};
                iMap1.setCoords(coords);
                iMap1.setShape(0);
                break;
            }
            case 4: {
                int[] triangle_x = new int[4];
                int[] triangle_y = new int[4];
                double widthD = this.LineDeltaDiamondD * markerScaleFactor;
                int widthHalf = (int)Math.round(widthD * 0.5);
                triangle_x[0] = x - widthHalf;
                triangle_y[0] = y + widthHalf;
                triangle_x[1] = x + widthHalf;
                triangle_y[1] = y + widthHalf;
                triangle_x[2] = x;
                triangle_y[2] = y - widthHalf;
                triangle_x[3] = triangle_x[0];
                triangle_y[3] = triangle_y[0];
                g2.fillPolygon(triangle_x, triangle_y, 3);
                iMap1.setShape(2);
                int[] coords = new int[8];
                int i = 0;
                while (i < 4) {
                    coords[i * 2] = triangle_x[i];
                    coords[i * 2 + 1] = triangle_y[i];
                    ++i;
                }
                iMap1.setCoords(coords);
                break;
            }
            case 6: {
                double widthD = this.LineDeltaSquareD * markerScaleFactor;
                int widthHalf = (int)Math.round(widthD * 0.5);
                int minX = x - widthHalf;
                int minY = y - widthHalf;
                int maxX = x + widthHalf;
                int maxY = y + widthHalf;
                g2.drawLine(minX, minY, maxX, maxY);
                g2.drawLine(minX, maxY, maxX, minY);
                int[] coords = new int[]{minX, minY, minX + (int)Math.round(widthD), minY + (int)Math.round(widthD)};
                iMap1.setCoords(coords);
                iMap1.setShape(0);
                break;
            }
            case 5: {
                double widthD = this.LineDeltaD * markerScaleFactor;
                int widthHalf = (int)Math.round(widthD * 0.5);
                int originX = x - widthHalf;
                int originY = y - widthHalf;
                g2.setStroke(this.LineStroke);
                g2.drawLine(x, y - widthHalf, x, y + widthHalf);
                g2.drawLine(x - widthHalf, y, x + widthHalf, y);
                g2.setStroke(this.DefaultStroke);
                int[] coords = new int[]{x, y, widthHalf};
                iMap1.setCoords(coords);
                iMap1.setShape(1);
                break;
            }
            case 3: {
                int[] diamond_x = new int[5];
                int[] diamond_y = new int[5];
                double widthD = this.LineDeltaDiamondD * markerScaleFactor;
                int widthHalf = (int)Math.round(widthD * 0.5);
                diamond_x[0] = x;
                diamond_y[0] = y - widthHalf;
                diamond_x[1] = x - widthHalf;
                diamond_y[1] = y;
                diamond_x[2] = x;
                diamond_y[2] = y + widthHalf;
                diamond_x[3] = x + widthHalf;
                diamond_y[3] = y;
                diamond_x[4] = diamond_x[0];
                diamond_y[4] = diamond_y[0];
                g2.fillPolygon(diamond_x, diamond_y, 5);
                iMap1.setShape(2);
                int[] coords = new int[10];
                int i = 0;
                while (i < 5) {
                    coords[i * 2] = diamond_x[i];
                    coords[i * 2 + 1] = diamond_y[i];
                    ++i;
                }
                iMap1.setCoords(coords);
            }
        }
        return iMap1;
    }

    private void drawStar(Graphics2D g2, int x, int y, int points, double markerScaleFactor) {
        int[] star_x = new int[2 * points + 1];
        int[] star_y = new int[2 * points + 1];
        double radiusHalf = this.LineDeltaD * markerScaleFactor * 0.78;
        double radiusInner = this.LineDeltaD * markerScaleFactor * 0.3;
        double theta = -90.0;
        double degreeDelta = 360.0 / (double)points;
        int i = 0;
        while (i < 2 * points) {
            double xOffset = Math.cos(Math.toRadians(theta)) * radiusHalf;
            double yOffset = Math.sin(Math.toRadians(theta)) * radiusHalf;
            star_x[i] = x + (int)Math.round(xOffset);
            star_y[i] = y + (int)Math.round(yOffset);
            xOffset = Math.cos(Math.toRadians(theta + degreeDelta * 0.5)) * radiusInner;
            yOffset = Math.sin(Math.toRadians(theta + degreeDelta * 0.5)) * radiusInner;
            star_x[i + 1] = x + (int)Math.round(xOffset);
            star_y[i + 1] = y + (int)Math.round(yOffset);
            theta += degreeDelta;
            i += 2;
        }
        star_x[2 * points] = star_x[0];
        star_y[2 * points] = star_y[0];
        g2.fillPolygon(star_x, star_y, 2 * points + 1);
    }
}

