/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.parser.TranslatorDescriptor;
import oracle.dbtools.migration.parser.TranslatorHook;
import oracle.dbtools.migration.translation.api.ITranslator;

public class ParserFactory {
    private Logger LOGGER = Logger.getLogger(ParserFactory.class.getName());
    private Hashtable<String, Class> m_parserMainMap = new Hashtable();
    public static final String TSQL_PARSER = "oracle.dbtools.migration.parser.tsql.TSQLParserMain";
    public static final String MSACCESS_PARSER = "oracle.dbtools.migration.parser.msaccess.MSAccessParserMain";
    public static final String MYSQL_PARSER = "oracle.dbtools.migration.mysql.parser.MySQLParserMain";
    public static final String SYBASE_PARSER = "oracle.dbtools.migration.parser.sybase.SybaseParserMain";
    public static final String DB2_PARSER = "oracle.dbtools.migration.parser.db2.Db2ParserMain";
    public static final String TERADATA_PARSER = "oracle.dbtools.migration.teradata.parser.TeradataParserMain";
    private static ParserFactory m_factory;
    private boolean hookProcessed = false;
    private static Map<String, TranslatorDescriptor> s_loadedTranslators;

    public static synchronized ParserFactory getInstance() {
        if (m_factory == null) {
            m_factory = new ParserFactory();
        }
        return m_factory;
    }

    private ITranslator newParser(String string) {
        if (!this.hookProcessed) {
            TranslatorHook.getInstance();
            this.hookProcessed = true;
        }
        ITranslator iTranslator = null;
        try {
            if (s_loadedTranslators.containsKey(string)) {
                TranslatorDescriptor translatorDescriptor = s_loadedTranslators.get(string);
                iTranslator = translatorDescriptor.getTranslator();
            }
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.SEVERE, MessageFormat.format("Failed to get Translator for {0}", string));
            iTranslator = null;
        }
        return iTranslator;
    }

    private ITranslator newParserNonOSGI(String string) {
        ITranslator iTranslator = null;
        try {
            if (!this.m_parserMainMap.contains(string)) {
                Class<?> clazz = Class.forName(string);
                iTranslator = (ITranslator)clazz.newInstance();
                this.m_parserMainMap.put(string, clazz);
            } else {
                iTranslator = (ITranslator)this.m_parserMainMap.get(string).newInstance();
            }
        }
        catch (Exception exception) {
            iTranslator = null;
        }
        return iTranslator;
    }

    public static ITranslator getParser(String string) {
        return ParserFactory.getInstance().newParser(string);
    }

    public static ITranslator getParserNonOSGI(String string) {
        return ParserFactory.getInstance().newParserNonOSGI(string);
    }

    public static String getParserString(String string) {
        if (string.toLowerCase().equals("sybase")) {
            return SYBASE_PARSER;
        }
        if (string.toLowerCase().equals("teradata")) {
            return TERADATA_PARSER;
        }
        if (string.toLowerCase().equals("db2")) {
            return DB2_PARSER;
        }
        if (string.toLowerCase().equals("sqlserver")) {
            return TSQL_PARSER;
        }
        if (string.toLowerCase().equals("mysql")) {
            return MYSQL_PARSER;
        }
        if (string.toLowerCase().equals("access")) {
            return MSACCESS_PARSER;
        }
        return "";
    }

    public void registerTranslator(TranslatorDescriptor translatorDescriptor) {
        s_loadedTranslators.put(translatorDescriptor.getClazz(), translatorDescriptor);
    }

    public boolean containsParser(String string) {
        return s_loadedTranslators.containsKey(string);
    }

    static {
        s_loadedTranslators = new HashMap<String, TranslatorDescriptor>();
    }
}

