/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser;

import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import oracle.dbtools.migration.parser.ParserFactory;
import oracle.dbtools.migration.parser.TranslatorDescriptor;
import oracle.dbtools.migration.translation.api.ITranslator;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;

public class TranslatorHook {
    Logger LOGGER = Logger.getLogger(TranslatorHook.class.getName());
    private static TranslatorHook m_instance = null;
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-migration-translator";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-migration-translator", "sqldev-migration-translator");
    private HashStructureHookListener tl_listener;
    private final String TRANSLATOR_ID = "translator";
    private final String TRANSLATOR_NAME = "name";
    private final String TRANSLATOR_CLASS = "clazz";

    public static synchronized TranslatorHook getInstance() {
        if (m_instance == null) {
            m_instance = new TranslatorHook();
        }
        return m_instance;
    }

    public TranslatorHook() {
        this.initTranslatorHookListener();
    }

    private void initTranslatorHookListener() {
        if (this.tl_listener == null) {
            HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
            this.tl_listener = new TLListener();
            hashStructureHook.addHashStructureHookListener(this.tl_listener);
        }
    }

    private final class TLListener
    implements HashStructureHookListener {
        private TLListener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processTranslators(hashStructureHookEvent.getCombinedHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processTranslators(hashStructureHookEvent.getCombinedHashStructure());
        }

        private void processTranslators(HashStructure hashStructure) {
            if (hashStructure != null) {
                List list = hashStructure.getAsList("translator");
                TranslatorHook.this.LOGGER.info(MessageFormat.format("{0} migration translators found", list.size()));
                for (HashStructure hashStructure2 : list) {
                    String string = hashStructure2.getString("name");
                    String string2 = hashStructure2.getString("clazz");
                    LazyClassAdapter lazyClassAdapter = LazyClassAdapter.getInstance((HashStructure)hashStructure2);
                    MetaClass metaClass = lazyClassAdapter.getMetaClass("clazz");
                    this.createDescriptor(string, string2, (MetaClass<? extends ITranslator>)metaClass);
                }
            }
        }

        private void createDescriptor(String string, String string2, MetaClass<? extends ITranslator> metaClass) {
            ParserFactory parserFactory = ParserFactory.getInstance();
            if (!parserFactory.containsParser(string2)) {
                TranslatorDescriptor translatorDescriptor = new TranslatorDescriptor(string, string2, metaClass);
                parserFactory.registerTranslator(translatorDescriptor);
            }
        }
    }
}

