/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.analysis.action;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.parser.analysis.action.TreeParserAction;
import oracle.dbtools.migration.parser.ext.ExtAST;
import oracle.dbtools.migration.parser.ext.ExtTreeParser;
import oracle.dbtools.migration.parser.grammar.TSQLVocabTokenTypes;
import oracle.dbtools.migration.parser.helper.CodeBlockManager;
import oracle.dbtools.migration.parser.helper.TranslationHelper;
import oracle.dbtools.migration.parser.helper.TranslationMetaData;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.components.SQLStatement;
import oracle.dbtools.migration.translation.api.components.TranslationDataType;
import oracle.dbtools.migration.translation.api.components.TranslationParamList;
import oracle.dbtools.migration.translation.api.components.TranslationParamPair;
import oracle.dbtools.migration.translation.api.components.TranslationParameter;
import oracle.dbtools.migration.translation.api.components.Var;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;

public class TSQLMetaDataAnalysisAction
extends TreeParserAction
implements TSQLVocabTokenTypes {
    protected TranslationHelper helper;
    protected TranslationMetaData metadata;
    protected CodeBlockManager codeBlockMgr;

    public TSQLMetaDataAnalysisAction(ExtTreeParser extTreeParser) {
        super(extTreeParser);
    }

    public void start_GRAMMARROOT(AST aST) {
        if (aST == null) {
            this.getHelper().getTriggerHelper().popTrigger();
        }
    }

    public void procedureParameter_ALL(AST aST, AST aST2, TranslationDataType translationDataType, AST aST3, AST aST4, AST aST5) {
        TranslationParameter translationParameter = new TranslationParameter();
        if (aST3 != null) {
            translationParameter.setDefaultValue(aST3);
            translationParameter.setDefaultValueEquals(aST5);
        }
        if (aST4 != null) {
            translationParameter.setParamType("TYPE_OUTPUT");
        }
        if (translationParameter.getParamType().equals("TYPE_INPUT")) {
            this.getHelper().setInputParam(aST2.toString(), translationParameter);
        }
        translationParameter.setName(this.getHelper().getVariableNameTranslator().translateVariableName(aST2.toString()));
        translationParameter.setDataType(translationDataType);
        translationParameter.setTreePosition(aST2);
        translationParameter.setObjectBlock(this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "CREATEOBJBLOCK"));
        this.getHelper().getTranslationMetaData().addTranslationParameter(translationParameter);
        if (translationDataType != null && translationDataType.getDataType().equalsIgnoreCase("CURSOR")) {
            this.getHelper().getCursorHelper().addCursor(aST2, aST2.getText());
        }
    }

    public void triggerDefinition_TRIGGER(AST aST, AST aST2) {
        this.getHelper().getTriggerHelper().popTrigger();
        this.getHelper().getTriggerHelper().pushTrigger(aST);
        this.getHelper().getTriggerHelper().getTrigger(aST).setTargetObjectName(TSQLMetaDataAnalysisAction.getDBObjectFullName(aST2));
    }

    public void triggerEvents_ALL(AST aST) {
        String string = aST.getText();
        if (string.equalsIgnoreCase("DELETE")) {
            this.getHelper().getTriggerHelper().addDeleteTriggerEvent();
        } else if (string.equalsIgnoreCase("INSERT")) {
            this.getHelper().getTriggerHelper().addInsertTriggerEvent();
        } else if (string.equalsIgnoreCase("UPDATE")) {
            this.getHelper().getTriggerHelper().addUpdateTriggerEvent();
        }
    }

    public void withCommonTableExpression_SELECT(AST aST) {
        this.getHelper().getCursorHelper().addCursorVariable(aST);
    }

    public void queryExpression_MULTISET(AST aST) {
        this.getHelper().getTriggerHelper().addDMLStatement(aST);
    }

    public void queryExpression_ALL(AST aST) {
        this.getHelper().getCursorHelper().addCursorVariable(aST);
    }

    public void querySpecification_SELECT(AST aST) {
        this.getHelper().getTriggerHelper().addDMLStatement(aST);
        Block block = this.getHelper().getCodeBlockManager().findEnclosingDMLStatmentBlock(aST);
        if (block == null) {
            return;
        }
        if (block.hasDescendentBlock("CLAUSEBLOCK", "PIVOT")) {
            this.getHelper().getStatementHelper().addCrossTableQueryStatement(aST);
        } else {
            this.getHelper().getStatementHelper().addSQLStatement(aST);
        }
    }

    public void querySpecification_VARASSIGNMENT(AST aST) {
        if (this.getHelper().isInputParam(aST.toString())) {
            this.getHelper().setInputAssignVar(aST.toString());
        }
    }

    public void querySpecification_SELECT_ITEM(AST aST, AST aST2, AST aST3) {
        if (aST2 != null) {
            if (!this.getHelper().getStatementHelper().isCrossTableQueryStatement(aST)) {
                if (aST2.getText().equalsIgnoreCase("DBOBJECT_NAME")) {
                    this.getHelper().getStatementHelper().addColumn(aST, TSQLMetaDataAnalysisAction.getDBObjectFullName(aST2), aST3 != null ? aST3.getFirstChild().getText() : null);
                } else if (aST3 != null) {
                    this.getHelper().getStatementHelper().addColumn(aST, aST2.toString(), aST3.getFirstChild().getText());
                }
            } else {
                this.getHelper().getStatementHelper().addCrossTableQueryColumn(aST, aST2);
            }
        }
    }

    public void querySpecification_ALL(AST aST, AST aST2, AST aST3) {
        if (aST2 == null && aST3 == null) {
            this.getHelper().getCursorHelper().addCursorVariable(aST);
        }
    }

    public void intoClause_ALL(AST aST, AST aST2) {
        String string = aST2.toStringList();
        TranslationDBObject translationDBObject = null;
        translationDBObject = string.indexOf(35) > 0 ? new TranslationDBObject(new TranslationDBObjectReference(null, null, null, null, null, TranslationObjectType.TEMP_TABLE_TYPE, null), null) : new TranslationDBObject(new TranslationDBObjectReference(null, null, null, null, null, TranslationObjectType.TABLE_TYPE, null), null);
        Block block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "STMTBLOCK");
        if (block != null && block.getAST() != null) {
            this.getHelper().getTranslationMetaData().addExtraObject(block.getAST(), translationDBObject);
        }
    }

    public void intoClause_ALL(AST aST) {
        TranslationDBObject translationDBObject = new TranslationDBObject(new TranslationDBObjectReference(null, null, null, null, null, TranslationObjectType.TABLE_TYPE, null), null);
        Block block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "STMTBLOCK");
        if (block != null && block.getAST() != null) {
            this.getHelper().getTranslationMetaData().addExtraObject(block.getAST(), translationDBObject);
        }
    }

    public void deleteStatement_DELETE(AST aST) {
        this.getHelper().getTriggerHelper().addDMLStatement(aST);
        this.getHelper().getStatementHelper().addSQLStatement(aST);
    }

    public void insertStatement_INSERT(AST aST) {
        this.getHelper().getTriggerHelper().addDMLStatement(aST);
        this.getHelper().getStatementHelper().addSQLStatement(aST);
    }

    public void columnList_COLUMN(AST aST) {
        SQLStatement sQLStatement = this.getHelper().getStatementHelper().getSQLStatement(aST);
        if (sQLStatement != null) {
            sQLStatement.addColumn(TSQLMetaDataAnalysisAction.getDBObjectFullName(aST), null);
        }
    }

    public void insertStatement_ALL(AST aST, AST aST2, AST aST3) {
        Block block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "BEGINBLOCK");
        if (aST2 != null && aST3 != null && block != null) {
            this.getHelper().getTranslationMetaData().addGeneratedVariable(block, "v_temp", "INSERT%ROWTYPE", null, aST, true);
            this.getHelper().getTranslationMetaData().addGeneratedVariable(block, "cv_ins", "SYS_REFCURSOR", null, aST, true);
        }
    }

    public void updateStatement_UPDATE(AST aST) {
        this.getHelper().getTriggerHelper().addDMLStatement(aST);
        this.getHelper().getStatementHelper().addSQLStatement(aST);
    }

    public void updateSetClause_ALL(AST aST, AST aST2, AST aST3, AST aST4) {
        if (aST2 == null && aST3 != null && aST4 == null) {
            return;
        }
        SQLStatement sQLStatement = this.getHelper().getStatementHelper().getSQLStatement(aST);
        if (sQLStatement != null) {
            sQLStatement.addColumn(TSQLMetaDataAnalysisAction.getDBObjectFullName(aST2 != null ? aST2 : aST3), null);
        }
    }

    public void createTableStatement_TABLE(AST aST, AST aST2) {
        Block block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "STMTBLOCK");
        if (block != null) {
            Block block2 = block.getOutermostProgramBlock();
            if (block2 != null && block2.getBlockType().equalsIgnoreCase("CREATEOBJBLOCK")) {
                TranslationDBObject translationDBObject = null;
                translationDBObject = this.isTempTable(aST2) ? new TranslationDBObject(new TranslationDBObjectReference(null, null, null, null, null, TranslationObjectType.TEMP_TABLE_TYPE, null), null) : new TranslationDBObject(new TranslationDBObjectReference(null, null, null, null, null, TranslationObjectType.TABLE_TYPE, null), null);
                this.getHelper().getTranslationMetaData().addExtraObject(block.getAST(), translationDBObject);
            }
            this.getHelper().getTableHelper().addTable(aST, TSQLMetaDataAnalysisAction.getDBObjectFullName(aST2));
        }
    }

    private boolean isTempTable(AST aST) {
        ExtAST extAST = (ExtAST)aST.getFirstChild().getNextSibling().getNextSibling().getNextSibling();
        ExtAST extAST2 = (ExtAST)aST.getFirstChild().getNextSibling();
        return extAST.getText().startsWith("#") || extAST2.getText().toLowerCase().equals("tempdb");
    }

    public void columnDefinition_ALL(AST aST, AST aST2, TranslationDataType translationDataType) {
        if (aST2 != null) {
            this.getHelper().getTableHelper().addColumn(aST2, aST2.getText(), translationDataType);
        }
    }

    public void alterTableStatement_TABLE(AST aST, AST aST2) {
        Block block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "STMTBLOCK");
        if (block != null) {
            Block block2 = block.getOutermostProgramBlock();
            if (block2 != null && block2.getBlockType().equalsIgnoreCase("CREATEOBJBLOCK")) {
                TranslationDBObject translationDBObject = new TranslationDBObject(new TranslationDBObjectReference(null, null, null, null, null, TranslationObjectType.TABLE_TYPE, null), null);
                this.getHelper().getTranslationMetaData().addExtraObject(block.getAST(), translationDBObject);
            }
            this.getHelper().getTableHelper().addTable(aST, TSQLMetaDataAnalysisAction.getDBObjectFullName(aST2));
        }
    }

    public void declareStatement_TABLE(AST aST, AST aST2) {
        TranslationDBObject translationDBObject = new TranslationDBObject(new TranslationDBObjectReference(null, null, null, null, null, TranslationObjectType.TABLE_TYPE, null), null);
        Block block = ((ExtAST)aST).getBlock();
        this.getHelper().getTranslationMetaData().addExtraObject(block.getAST(), translationDBObject);
        this.getHelper().getTableHelper().addTable(aST, TSQLMetaDataAnalysisAction.getDBObjectFullName(aST2));
    }

    public void declareStatement_VAR(AST aST, AST aST2, TranslationDataType translationDataType, AST aST3) {
        Block block = ((ExtAST)aST).getBlock();
        if (block != null) {
            block = block.getEnclosingProgramBlock();
        }
        if (block == null) {
            return;
        }
        if (translationDataType.getDataType().indexOf("CURSOR") == -1) {
            Var var = new Var(this.getHelper().getVariableNameTranslator().translateVariableName(aST2.getText()), translationDataType, block, aST2);
            this.getHelper().getTranslationMetaData().addVariable(var);
        } else {
            this.getHelper().getCursorHelper().addCursorVariable(aST, this.getHelper().getVariableNameTranslator().translateVariableName(aST2.getText()));
        }
    }

    public void declareStatement_CURSOR(AST aST, AST aST2) {
        this.getHelper().getCursorHelper().addCursor(aST, aST2.getText());
    }

    public void cursorStatement_CLOSE(AST aST, AST aST2, AST aST3) {
        String string = aST2 != null ? aST2.getText() : this.getHelper().getVariableNameTranslator().translateVariableName(aST3.getText());
        this.getHelper().getCursorHelper().setCursorScopeEnd(aST, string);
    }

    public void cursorStatement_OPEN(AST aST, AST aST2, AST aST3) {
        if (aST2 == null && aST3 == null) {
            return;
        }
        String string = aST2 != null ? aST2.getText() : this.getHelper().getVariableNameTranslator().translateVariableName(aST3.getText());
        this.getHelper().getTranslationMetaData().addFetch(string, aST);
        this.getHelper().getCursorHelper().setCursorScopeBegin(aST, string);
    }

    public void fetchStatement_ALL(AST aST, AST aST2, AST aST3, AST aST4) {
        Block block;
        if (aST2 == null && aST3 == null) {
            return;
        }
        String string = aST2 != null ? aST2.getText() : this.getHelper().getVariableNameTranslator().translateVariableName(aST3.getText());
        this.getHelper().getTranslationMetaData().addFetch(string, aST);
        if (aST4 == null && (block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "BEGINBLOCK")) != null) {
            this.getHelper().getTranslationMetaData().addGeneratedVariable(block, "v_temp", string + "%ROWTYPE", null, aST, true);
        }
    }

    public void functionReturnType_RETURNS(AST aST) {
        this.getHelper().getFunctionHelper().addFunction(aST);
    }

    public void functionReturnType_TABLE(AST aST, AST aST2) {
        this.getHelper().getTableHelper().addTable(aST, TSQLMetaDataAnalysisAction.getDBObjectFullName(aST2));
    }

    public void functionReturnType_ALL(AST aST, AST aST2, AST aST3, TranslationDataType translationDataType) {
        Block block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "CREATEOBJBLOCK");
        if (aST3 != null || aST2 != null) {
            this.getHelper().getFunctionHelper().setTableValuedFunction(aST, true);
            TranslationDBObject translationDBObject = new TranslationDBObject(new TranslationDBObjectReference(null, null, null, null, null, TranslationObjectType.TABLE_TYPE, null), null);
            TranslationDBObject translationDBObject2 = new TranslationDBObject(new TranslationDBObjectReference(null, null, null, null, null, TranslationObjectType.PACKAGE_TYPE, null), null);
            if (block != null && block.getAST() != null) {
                this.getHelper().getTranslationMetaData().addExtraObject(block.getAST(), translationDBObject);
                this.getHelper().getTranslationMetaData().addExtraObject(block.getAST(), translationDBObject2);
            }
        } else {
            this.getHelper().getTranslationMetaData().addObjectReturnType(block, translationDataType);
        }
    }

    public void returnStatement_ALL(AST aST) {
        TranslationDBObject translationDBObject;
        Block block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "CREATEOBJBLOCK");
        if (block != null && block.getAST() != null && (translationDBObject = this.getHelper().getTranslationMetaData().getExtraObject(block.getAST(), TranslationObjectType.TABLE_TYPE)) != null) {
            if (!this.getHelper().getFunctionHelper().isTableValuedFunction(aST)) {
                this.getHelper().getCursorHelper().addCursorVariable(block.getAST());
            } else {
                Block block2 = this.getBlock(aST, "BEGINBLOCK");
                if (block2 != null) {
                    this.getHelper().getTranslationMetaData().addGeneratedVariable(block2, "v_temp", "SYS_REFCURSOR", null, aST, true);
                    this.getHelper().getTranslationMetaData().addGeneratedVariable(block2, "v_temp", "%ROWTYPE", null, aST, true);
                }
            }
        }
    }

    public void returnStatementExpr_ALL(AST aST, AST aST2) {
        Block block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "CREATEOBJBLOCK");
        if (block != null && aST2 != null) {
            TranslationDataType translationDataType = this.getHelper().getTranslationMetaData().getObjectReturnType(block);
            if (translationDataType != null) {
                block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "BEGINBLOCK");
                String string = translationDataType.getDataType();
                if (translationDataType.getPrecision() != null) {
                    string = string + "(" + translationDataType.getPrecision();
                    if (translationDataType.getScale() != null) {
                        string = string + "," + translationDataType.getScale();
                    }
                    string = string + ")";
                }
                this.getHelper().getTranslationMetaData().addGeneratedVariable(block, "v_temp", string, null, aST, false);
            } else if (block.getBlockName().equalsIgnoreCase("PROCEDURE")) {
                block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "BEGINBLOCK");
                this.getHelper().getTranslationMetaData().addGeneratedVariable(block, "v_temp", "SYS_REFCURSOR", null, aST, false);
            }
        } else {
            TranslationDataType translationDataType = this.getHelper().getTranslationMetaData().getObjectReturnType(block);
            if (translationDataType == null) {
                translationDataType = new TranslationDataType("Number");
            }
            TranslationParameter translationParameter = new TranslationParameter();
            translationParameter.setParamType("TYPE_RETURN");
            translationParameter.setName("RETURN");
            translationParameter.setDataType(translationDataType);
            translationParameter.setObjectBlock(block);
            translationParameter.setParamPosition(0);
            this.getHelper().getTranslationMetaData().addReturnTranslationParameter(translationParameter);
        }
    }

    public void setStatement_ALL(AST aST, AST aST2, AST aST3) {
        if (aST3 == null && aST2 != null && this.getHelper().isInputParam(aST2.toString())) {
            this.getHelper().setInputAssignVar(aST2.toString());
        } else if (aST2 != null && aST3 != null) {
            String string = this.getHelper().getVariableNameTranslator().translateVariableName(aST2.getText());
            this.getHelper().getCursorHelper().addCursor(aST, string);
        }
    }

    public void valueSessionSettings_ROWCOUNT(AST aST) {
        this.getHelper().getTranslationMetaData().setSessionSetting(aST, aST.getText(), aST.getFirstChild().getText());
    }

    public void transactionStatement_ROLLBACK(AST aST) {
        if (this.getHelper().getTriggerHelper().isPartOfTriggerDefinition(aST)) {
            this.getHelper().getTranslationMetaData().addPragma(this.getHelper().getTriggerHelper().getTrigger(aST).getObjectBlock(), TranslationMetaData.Pragma.AUTONOMOUS_TRANSACTION);
        }
    }

    public void transactionStatement_SAVEPOINT(AST aST, AST aST2, AST aST3) {
        String string = aST3 != null ? this.getHelper().getVariableNameTranslator().translateVariableName(aST3.getText()) : aST2.getText();
        this.getHelper().getTransactionHelper().addSavepoint(aST, string);
    }

    public void subquery_ALL(AST aST) {
        Block block;
        Block block2;
        if (aST != null && (block2 = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "STMTBLOCK")) != null && (block2.getBlockName().equalsIgnoreCase("IFSTATEMENT") || block2.getBlockName().equalsIgnoreCase("WHILE")) && (block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "CONTROLBLOCK")) != null) {
            Block block3;
            Block block4 = this.getHelper().getCodeBlockManager().findEnclosingBlock(block.getAST(), "BEGINBLOCK");
            if (block4 == null && (block3 = this.getHelper().getCodeBlockManager().findEnclosingBlock(block.getAST(), "STMTBLOCK")) != null) {
                block4 = block3.getParent() != null && block3.getParent().getBlockType().equals("CONTEXTBLOCK") ? block3.getParent() : block3;
            }
            if (block4 != null) {
                this.getHelper().getTranslationMetaData().addGeneratedVariable(block4, "v_temp", "NUMBER(1, 0)", "0", block.getAST(), false);
            }
        }
    }

    public void tableSpec_ALL(AST aST, AST aST2, AST aST3, AST aST4, AST aST5) {
        AST aST6 = aST2 != null ? aST2 : (aST3 != null ? aST3 : null);
        String string = "";
        if (aST6 != null) {
            if (aST3 == null) {
                string = aST6.getText();
            } else {
                for (AST aST7 = ((ExtAST)aST3).getFirstChild(); aST7 != null; aST7 = aST7.getNextSibling()) {
                    if (aST7.getText().equalsIgnoreCase("EMPTY")) continue;
                    string = aST7.getText();
                }
            }
            this.getHelper().getTriggerHelper().addTableRef(aST, string, aST5 != null ? aST5.getText() : null);
        }
        if (aST3 != null) {
            this.getHelper().getStatementHelper().addTableReference(aST, TSQLMetaDataAnalysisAction.getDBObjectFullName(aST3), aST5 != null ? aST5.getText() : null);
        }
        if (aST4 != null) {
            this.getHelper().getStatementHelper().addNestedSQLStatement(aST, aST4);
        }
        if ((aST3 == null || aST4 != null) && aST5 != null) {
            this.getHelper().getStatementHelper().addTableReference(aST, aST5.getText(), null);
        }
    }

    public void systemVariable_ERROR(AST aST) {
        this.getHelper().getTranslationMetaData().setSystemError(true);
        Block block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "STMTBLOCK");
        if (block != null) {
            this.getHelper().getTranslationMetaData().addErrorCodeReference(block.getAST());
        }
    }

    public void systemVariable_TRANCOUNT(AST aST) {
    }

    public void executeProcedure_ALL(AST aST, AST aST2, AST aST3) {
        if (aST2 != null) {
            TranslationDBObjectReference translationDBObjectReference = (TranslationDBObjectReference)((ExtAST)aST2).getExtraInfo((Object)TranslationDBObjectReference.ModelType.SOURCE_REF);
            TranslationDBObjectReference translationDBObjectReference2 = (TranslationDBObjectReference)((ExtAST)aST2).getExtraInfo((Object)TranslationDBObjectReference.ModelType.TARGET_REF);
            TranslationParamList translationParamList = new TranslationParamList();
            TranslationParamPair translationParamPair = null;
            TranslationParameter translationParameter = null;
            try {
                ArrayList<TranslationParameter> arrayList;
                if (translationDBObjectReference2 != null && (arrayList = this.getHelper().getTranslationContext().getTargetParameters(translationDBObjectReference2)) != null) {
                    for (TranslationParameter translationParameter2 : arrayList) {
                        if (translationParameter2.isExtra()) {
                            TranslationParameter translationParameter3 = this.getHelper().getCursorHelper().addCursorVariable(aST3);
                            translationParamPair = new TranslationParamPair(translationParameter3, translationParameter2);
                            translationParamList.addPair(translationParamPair);
                            continue;
                        }
                        if (translationParameter2.getParamPosition() > 0) {
                            translationParamPair = new TranslationParamPair(null, translationParameter2);
                            translationParamList.addPair(translationParamPair);
                            continue;
                        }
                        translationParameter = translationParameter2;
                    }
                    ((ExtAST)aST).addExtraInfo((Object)TranslationDBObjectReference.ModelType.TARGET_PARAM, translationParamList);
                    if (translationParameter != null) {
                        ((ExtAST)aST).addExtraInfo((Object)TranslationDBObjectReference.ModelType.TARGET_RETURN_PARAM, translationParameter);
                    }
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    public static String getDBObjectFullName(AST aST) {
        String string = "";
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            if (!aST2.getText().equalsIgnoreCase("EMPTY")) {
                if (string.trim().length() > 0) {
                    string = string + ".";
                }
                string = string + aST2.getText();
                continue;
            }
            if (string.length() <= 0) continue;
            string = string + ".";
        }
        while (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

