/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.filter.comments;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.migration.parser.ext.ExtAST;
import oracle.dbtools.migration.parser.filter.comments.ASTDescriptor;
import oracle.dbtools.migration.parser.filter.comments.Comment;
import oracle.dbtools.migration.parser.filter.comments.TagInfo;
import oracle.dbtools.migration.parser.filter.comments.TemplateDescriptor;
import oracle.dbtools.migration.translation.api.components.Block;
import org.antlr.stringtemplate.StringTemplate;

public class CommentHelper {
    private static final String COMMENT_END_MARKER = "*/";
    private static final String COMMENT_END_REPLACEMENT_MARKER = "* /";
    private static final String COMMA_SEPARATOR_COMMENT = "--COMMASEPCOM:";
    private List<Comment> m_commentList;
    private StringTemplate m_outputTemplate;
    private Block m_topBlock;
    private Map<Integer, TemplateDescriptor> m_templateDescriptors;
    private Map<Integer, ASTDescriptor> m_astDescriptors;
    private ArrayList<String> m_statementNames = new ArrayList();

    public CommentHelper() {
        this.m_statementNames.add("sqlStatement");
        this.m_statementNames.add("parameter");
        this.m_statementNames.add("varDefinition");
        this.m_statementNames.add("varAssignment");
        this.m_statementNames.add("cursorDeclaration");
        this.m_commentList = new ArrayList<Comment>();
        this.m_templateDescriptors = new HashMap<Integer, TemplateDescriptor>();
        this.m_astDescriptors = new HashMap<Integer, ASTDescriptor>();
    }

    public void addComment(Comment comment) {
        if (comment.getType() == Comment.Type.MULTI_LINE_NESTED || comment.getType() == Comment.Type.MULTI_LINE_SEPARATE_LINE) {
            String string = comment.getText();
            StringTokenizer stringTokenizer = new StringTokenizer(string, COMMENT_END_MARKER);
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n - 1; ++i) {
                string = string.replace(COMMENT_END_MARKER, COMMENT_END_REPLACEMENT_MARKER);
            }
        }
        this.m_commentList.add(comment);
    }

    public boolean hasComments() {
        return !this.m_commentList.isEmpty();
    }

    private void groupRelatedComments() {
        ArrayList<Comment> arrayList = new ArrayList<Comment>();
        Comment comment = null;
        for (Comment comment2 : this.m_commentList) {
            if (!(comment2.isSingleLineComment() || comment == null || comment.isNested() || comment2.isNested())) {
                arrayList.add(comment2);
            } else {
                arrayList.add(comment2);
            }
            comment = comment2;
        }
        this.m_commentList = arrayList;
    }

    public void removeComment(Comment comment) {
        this.m_commentList.remove(comment);
    }

    public Comment getLastComment() {
        if (this.m_commentList.isEmpty()) {
            return null;
        }
        return this.m_commentList.remove(this.m_commentList.size() - 1);
    }

    public void setStringTemplate(StringTemplate stringTemplate) {
        this.m_outputTemplate = stringTemplate;
    }

    public void setTopBlock(Block block) {
        this.m_topBlock = block;
    }

    private void buildDescriptors() {
        this.createDescriptorsFromTemplateTree();
        this.updateTemplateDescriptorsWithPosInfo();
        this.updateASTDescriptorsWithPosInfo();
    }

    private void createDescriptorsFromTemplateTree() {
        Stack<TemplateDescriptor> stack = new Stack<TemplateDescriptor>();
        TemplateDescriptor templateDescriptor = null;
        templateDescriptor = new TemplateDescriptor(this.m_outputTemplate);
        this.m_templateDescriptors.put(this.m_outputTemplate.getTemplateID(), templateDescriptor);
        stack.push(templateDescriptor);
        while (!stack.isEmpty()) {
            templateDescriptor = (TemplateDescriptor)stack.pop();
            Map map = templateDescriptor.getTemplate().getAttributes();
            if (map == null) continue;
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                this.readTemplateAttribute(stack, templateDescriptor, iterator.next());
            }
        }
    }

    private void readTemplateAttribute(Stack<TemplateDescriptor> stack, TemplateDescriptor templateDescriptor, Object object) {
        AST aST;
        if (object instanceof StringTemplate.STAttributeList) {
            StringTemplate.STAttributeList sTAttributeList = (StringTemplate.STAttributeList)object;
            int n = sTAttributeList.size();
            for (int i = 0; i < n; ++i) {
                this.readTemplateAttribute(stack, templateDescriptor, sTAttributeList.get(i));
            }
        } else if (object instanceof StringTemplate) {
            StringTemplate stringTemplate = (StringTemplate)object;
            if (!this.m_templateDescriptors.containsKey(stringTemplate.getTemplateID())) {
                TemplateDescriptor templateDescriptor2 = new TemplateDescriptor(stringTemplate);
                this.m_templateDescriptors.put(stringTemplate.getTemplateID(), templateDescriptor2);
                stack.push(templateDescriptor2);
            }
        } else if (object instanceof AST && !this.m_astDescriptors.containsKey((aST = (AST)object).hashCode())) {
            ASTDescriptor aSTDescriptor = new ASTDescriptor(aST);
            this.m_astDescriptors.put(aST.hashCode(), aSTDescriptor);
            aSTDescriptor.addTemplateDescriptor(templateDescriptor);
            templateDescriptor.addASTDescriptor(aSTDescriptor);
        }
    }

    private void updateTemplateDescriptorsWithPosInfo() {
        for (TemplateDescriptor templateDescriptor : this.m_templateDescriptors.values()) {
            StringTemplate stringTemplate = templateDescriptor.getTemplate();
            templateDescriptor.setStartLine(stringTemplate.getStartLine());
            templateDescriptor.setStartColumn(stringTemplate.getStartColumn());
            templateDescriptor.setEndLine(stringTemplate.getEndLine());
            templateDescriptor.setEndColumn(stringTemplate.getEndColumn());
        }
    }

    private void updateASTDescriptorsWithPosInfo() {
        this.setTagRendered(true);
        String string = this.m_outputTemplate.toString();
        String[] stringArray = string.split("\\n");
        List<TagInfo> list = this.readASTTagInfo(stringArray);
        for (TagInfo tagInfo : list) {
            ASTDescriptor aSTDescriptor = this.m_astDescriptors.get(tagInfo.getId());
            if (aSTDescriptor == null) continue;
            aSTDescriptor.setRendered(true);
            aSTDescriptor.setTargetStartLine(tagInfo.getStartLine());
            aSTDescriptor.setTargetStartColumn(tagInfo.getStartColumn());
            aSTDescriptor.setTargetEndLine(tagInfo.getEndLine());
            aSTDescriptor.setTargetEndColumn(tagInfo.getEndColumn());
        }
        this.setTagRendered(false);
    }

    private void setTagRendered(boolean bl) {
        Iterator<ASTDescriptor> iterator = this.m_astDescriptors.values().iterator();
        while (iterator.hasNext()) {
            AST aST = iterator.next().getAST();
            if (!(aST instanceof ExtAST)) continue;
            ((ExtAST)aST).setTagRendered(bl);
        }
    }

    private List<TagInfo> readASTTagInfo(String[] stringArray) {
        String string;
        String string2;
        String string3;
        Matcher matcher;
        ArrayList<TagInfo> arrayList = new ArrayList<TagInfo>();
        TagInfo tagInfo = null;
        int n = 0;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String n2 : stringArray) {
            do {
                if (!(matcher = Pattern.compile("/\\*AST\\[(\\-|\\+)?([0-9])+\\]\\{([^}])*\\}\\*/").matcher(n2)).find()) continue;
                string3 = matcher.group();
                string2 = string3.substring(string3.indexOf("[") + 1, string3.indexOf("]"));
                string = string3.substring(string3.indexOf("{") + 1, string3.indexOf("}"));
                tagInfo = new TagInfo(n, matcher.start(), n, matcher.start() + string.length() - 1);
                tagInfo.setText(string);
                tagInfo.setId(Integer.parseInt(string2));
                arrayList.add(tagInfo);
                n2 = n2.replace(string3, string);
            } while (matcher.find());
            arrayList2.add(n2);
            ++n;
        }
        stringArray = arrayList2.toArray(new String[arrayList2.size()]);
        String string4 = "/\\*AST\\[(\\-|\\+)?([0-9])+\\]\\{([^}])*\\}\\*/".substring(0, "/\\*AST\\[(\\-|\\+)?([0-9])+\\]\\{([^}])*\\}\\*/".indexOf("{") + 1);
        int n2 = n = 0;
        do {
            String string5 = stringArray[n];
            while (n < stringArray.length) {
                Matcher matcher2 = Pattern.compile(string4).matcher(string5);
                if (!matcher2.find()) {
                    ++n;
                } else {
                    n2 = n;
                    while (++n < stringArray.length) {
                        string5 = string5 + "\n" + stringArray[n];
                        matcher = Pattern.compile("/\\*AST\\[(\\-|\\+)?([0-9])+\\]\\{([^}])*\\}\\*/").matcher(string5);
                        if (matcher.find()) {
                            string3 = matcher.group();
                            string2 = string3.substring(string3.indexOf("[") + 1, string3.indexOf("]"));
                            string = string3.substring(string3.indexOf("{") + 1, string3.indexOf("}"));
                            tagInfo = new TagInfo(n2, matcher2.start(), n, stringArray[n].indexOf("}*/") - 1);
                            tagInfo.setText(string);
                            tagInfo.setId(Integer.parseInt(string2));
                            arrayList.add(tagInfo);
                            string5 = string5.replace(string3, string);
                        }
                        if (!matcher.find()) continue;
                    }
                }
                if (matcher2.find()) continue;
            }
        } while (n < stringArray.length);
        return arrayList;
    }

    private void matchCommentsToTemplateTree() {
        if (this.m_commentList.isEmpty()) {
            return;
        }
        ArrayList<AST> arrayList = this.getTokens();
        int n = this.m_commentList.size();
        Comment comment = null;
        for (int i = 0; i < n; ++i) {
            comment = this.m_commentList.get(i);
            this.matchCommentToTemplateToken(comment, arrayList);
        }
    }

    private void matchCommentToTemplateToken(Comment comment, ArrayList<AST> arrayList) {
        AST aST = arrayList.get(arrayList.size() - 1);
        Iterator<AST> iterator = arrayList.iterator();
        iterator = arrayList.iterator();
        AST[] aSTArray = this.getNearestTokens(iterator, comment);
        ExtAST extAST = (ExtAST)aSTArray[0];
        ExtAST extAST2 = (ExtAST)aSTArray[1];
        if (extAST == null && extAST2 != null) {
            this.attachPreCommentToStatement((AST)extAST2, comment);
        } else if (extAST2 == null && extAST != null) {
            this.attachPostCommentToStatement((AST)extAST, comment, this.isSQLObjectDef((AST)extAST) ? "postCommentInternal" : "postComment");
        } else if (extAST2 != null && extAST2.getLine() == comment.getLine()) {
            if (extAST != null) {
                if (this.isFirstTokenCloser(extAST, extAST2, comment)) {
                    this.attachPostCommentToAST(extAST, comment);
                } else {
                    this.attachPreCommentToAST((AST)extAST2, comment);
                }
            }
        } else if (extAST != null && extAST.getLine() == comment.getLine()) {
            this.attachComment((AST)extAST, comment, (AST)extAST2);
        } else if (this.areStringTemplatesRelated(this.getTemplate((AST)extAST), this.getTemplate((AST)extAST2), false)) {
            this.attachPreCommentToAST((AST)extAST2, comment);
        } else {
            this.attachPreCommentToStatement((AST)extAST2, comment);
        }
    }

    private boolean isStringTemplateNestedSQLStatement(StringTemplate stringTemplate) {
        StringTemplate stringTemplate2;
        StringTemplate stringTemplate3 = this.getSQLStatement(stringTemplate);
        return stringTemplate3 != null && (stringTemplate2 = this.getSQLStatement(stringTemplate3.getEnclosingInstance())) != null;
    }

    private void attachPostCommentToAST(ExtAST extAST, Comment comment) {
        this.attachCommentToAST((AST)extAST, comment, false);
    }

    private boolean isFirstTokenCloser(ExtAST extAST, ExtAST extAST2, Comment comment) {
        int n;
        int n2;
        int n3;
        int n4 = comment.getIndex();
        int n5 = n4 - (n3 = extAST.getIndex());
        return n5 < (n2 = (n = extAST2.getIndex()) - n4);
    }

    private boolean isSQLObjectDef(AST aST) {
        for (StringTemplate stringTemplate = this.getTemplate(aST); stringTemplate != null; stringTemplate = stringTemplate.getEnclosingInstance()) {
            if (!stringTemplate.getName().equals("viewDefinition")) continue;
            return true;
        }
        return false;
    }

    private void attachPreCommentToAST(AST aST, Comment comment) {
        this.attachCommentToAST(aST, comment, true);
    }

    private void attachPreCommentToStatement(AST aST, Comment comment) {
        StringTemplate stringTemplate = this.getTemplate(aST);
        while (!this.hasPostComment(stringTemplate)) {
            if ((stringTemplate = stringTemplate.getEnclosingInstance()) != null) continue;
            stringTemplate = this.getTemplate(aST);
            break;
        }
        if (this.hasPostComment(stringTemplate)) {
            if (stringTemplate.toString().trim().toUpperCase().startsWith("CREATE ")) {
                this.attachCommentToAST(aST, comment, false);
            } else {
                stringTemplate.setAttribute("preComment", (Object)comment.getText());
            }
        } else {
            this.attachCommentToAST(aST, comment, false);
        }
    }

    private void attachComment(AST aST, Comment comment, AST aST2) {
        try {
            StringTemplate stringTemplate = this.getTemplate(aST);
            StringTemplate stringTemplate2 = this.getTemplate(aST2);
            boolean bl = false;
            bl = !this.areStringTemplatesRelated(stringTemplate, stringTemplate2, true);
            if (aST2.getText().equalsIgnoreCase("BEGIN")) {
                this.attachCommentToAST(aST2, comment, true);
            } else if (bl) {
                if (comment.isSingleLineComment()) {
                    this.attachPostCommentToStatement(aST, comment, "postComment");
                } else {
                    this.attachPostCommentToStatementForSure(aST, comment, "postCommentNextLine");
                }
            } else {
                this.attachCommentToAST(aST, comment, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean areStringTemplatesRelated(StringTemplate stringTemplate, StringTemplate stringTemplate2, boolean bl) {
        if (stringTemplate == stringTemplate2) {
            return true;
        }
        ArrayList<StringTemplate> arrayList = null;
        ArrayList<StringTemplate> arrayList2 = null;
        if (bl) {
            arrayList = this.getAncestors(stringTemplate, "sqlStatement");
            arrayList2 = this.getAncestors(stringTemplate2);
        } else {
            arrayList = this.getAncestors(stringTemplate);
            arrayList2 = this.getAncestors(stringTemplate2, "sqlStatement");
        }
        StringTemplate stringTemplate3 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList2.contains(arrayList.get(i))) continue;
            stringTemplate3 = arrayList.get(i);
            break;
        }
        if (stringTemplate3 == null) {
            return false;
        }
        if (this.getSQLStatementBeforeBlock(stringTemplate3) == null) {
            return false;
        }
        return !stringTemplate3.getName().equals("commaSeparator");
    }

    private ArrayList<StringTemplate> getAncestors(StringTemplate stringTemplate, String string) {
        ArrayList<StringTemplate> arrayList = new ArrayList<StringTemplate>();
        for (StringTemplate stringTemplate2 = stringTemplate; stringTemplate2 != null && !stringTemplate2.getName().equals(string); stringTemplate2 = stringTemplate2.getEnclosingInstance()) {
            arrayList.add(stringTemplate2);
        }
        return arrayList;
    }

    private ArrayList<StringTemplate> getAncestors(StringTemplate stringTemplate) {
        ArrayList<StringTemplate> arrayList = new ArrayList<StringTemplate>();
        for (StringTemplate stringTemplate2 = stringTemplate; stringTemplate2 != null; stringTemplate2 = stringTemplate2.getEnclosingInstance()) {
            arrayList.add(stringTemplate2);
        }
        return arrayList;
    }

    private StringTemplate getTemplate(AST aST) {
        ASTDescriptor aSTDescriptor = this.m_astDescriptors.get(aST.hashCode());
        List<TemplateDescriptor> list = aSTDescriptor.getTemplateDescriptors();
        TemplateDescriptor templateDescriptor = list.get(0);
        return templateDescriptor.getTemplate();
    }

    private void attachPostCommentToStatement(AST aST, Comment comment, String string) {
        if (aST.getLine() == comment.getLine()) {
            StringTemplate stringTemplate = this.getStmtTemplate(aST);
            ArrayList<AST> arrayList = this.getTokens();
            if (arrayList.size() == arrayList.indexOf(aST) + 1) {
                if (aST.getLine() == comment.getLine()) {
                    this.attachCommentToAST(aST, comment, false);
                } else {
                    this.attachPostCommentToStatementForSure(aST, comment, string);
                }
            } else {
                AST aST2 = arrayList.get(arrayList.indexOf(aST) + 1);
                StringTemplate stringTemplate2 = this.getStmtTemplate(aST2);
                if (stringTemplate == stringTemplate2) {
                    this.attachCommentToAST(aST, comment, false);
                } else if (comment.isSingleLineComment()) {
                    this.attachPostCommentToStatementForSure(aST, comment, string);
                } else {
                    this.attachPostCommentToStatementForSure(aST, comment, string);
                }
            }
        } else {
            this.attachPostCommentToStatementForSure(aST, comment, string);
        }
    }

    private StringTemplate getStmtTemplate(AST aST) {
        StringTemplate stringTemplate;
        for (stringTemplate = this.getTemplate(aST); stringTemplate != null && !this.m_statementNames.contains(stringTemplate.getName()); stringTemplate = stringTemplate.getEnclosingInstance()) {
        }
        return stringTemplate;
    }

    private void attachPostCommentToStatementForSure(AST aST, Comment comment, String string) {
        StringTemplate stringTemplate = this.getTemplate(aST);
        while (!this.hasAttribute(stringTemplate, string)) {
            if ((stringTemplate = stringTemplate.getEnclosingInstance()) != null) continue;
            stringTemplate = this.getTemplate(aST);
            break;
        }
        if (this.hasAttribute(stringTemplate, string)) {
            stringTemplate.setAttribute(string, (Object)comment.getText());
        } else {
            this.attachCommentToAST(aST, comment, false);
        }
    }

    private boolean hasAttribute(StringTemplate stringTemplate, String string) {
        if (stringTemplate == null || string == null) {
            return false;
        }
        return stringTemplate.getFormalArguments() != null && stringTemplate.getFormalArguments().containsKey(string);
    }

    private boolean hasPostComment(StringTemplate stringTemplate) {
        return stringTemplate.getFormalArguments() != null && stringTemplate.getFormalArguments().containsKey("postComment");
    }

    private boolean isStatement(StringTemplate stringTemplate) {
        return stringTemplate.getName().toLowerCase().indexOf("statement") != -1 || stringTemplate.getName().toLowerCase().indexOf("stmt") != -1;
    }

    private void attachCommentToStmtTemplate(AST aST, Comment comment, boolean bl) {
        StringTemplate stringTemplate = this.getSQLStatement(aST.getSt());
        if (stringTemplate == null) {
            return;
        }
        stringTemplate.setAttribute("postComment", (Object)comment.getText());
    }

    private StringTemplate getSQLStatement(StringTemplate stringTemplate) {
        if (stringTemplate == null) {
            return stringTemplate;
        }
        if (stringTemplate.getName().equals("sqlStatement")) {
            return stringTemplate;
        }
        return this.getSQLStatement(stringTemplate.getEnclosingInstance());
    }

    private StringTemplate getSQLStatementBeforeBlock(StringTemplate stringTemplate) {
        if (stringTemplate == null) {
            return stringTemplate;
        }
        if (stringTemplate.getName().equals("statementBlock")) {
            return null;
        }
        if (stringTemplate.getName().equals("sqlStatement")) {
            return stringTemplate;
        }
        return this.getSQLStatementBeforeBlock(stringTemplate.getEnclosingInstance());
    }

    private AST[] getNearestTokens(Iterator<AST> iterator, Comment comment) {
        AST[] aSTArray;
        AST[] aSTArray2 = null;
        AST[] aSTArray3 = null;
        Object var5_5 = null;
        while (iterator.hasNext()) {
            aSTArray = iterator.next();
            if (aSTArray.getLine() <= comment.getLine()) {
                if (aSTArray.getLine() == comment.getLine() && aSTArray.getColumn() > comment.getColumn()) {
                    aSTArray3 = aSTArray;
                    break;
                }
                aSTArray2 = aSTArray;
                continue;
            }
            aSTArray3 = aSTArray;
            break;
        }
        aSTArray = new AST[]{aSTArray2, aSTArray3};
        return aSTArray;
    }

    private void attachToLastToken(AST aST, Comment comment) {
        if (aST != null) {
            ASTDescriptor aSTDescriptor = this.m_astDescriptors.get(aST.hashCode());
            TemplateDescriptor templateDescriptor = aSTDescriptor.getTemplateDescriptors().get(0);
            this.attachCommentToAST(aST, comment, templateDescriptor.getStartLine() != 0);
        }
    }

    private void removeEarlyTokens(Iterator<AST> iterator, Comment comment) {
        AST aST;
        while (iterator.hasNext() && (aST = iterator.next()).getLine() < comment.getLine()) {
            iterator.remove();
        }
    }

    private ArrayList<AST> getTokens() {
        ArrayList<AST> arrayList = new ArrayList<AST>();
        for (ASTDescriptor aSTDescriptor : this.m_astDescriptors.values()) {
            arrayList.add(aSTDescriptor.getAST());
        }
        Collections.sort(arrayList, new ASTComparator());
        Iterator<ASTDescriptor> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ASTDescriptor aSTDescriptor;
            aSTDescriptor = (AST)iterator.next();
            if (this.m_astDescriptors.get(aSTDescriptor.hashCode()).isRendered() && (aSTDescriptor.getLine() != -1 || aSTDescriptor.getColumn() != -1)) continue;
            iterator.remove();
        }
        return arrayList;
    }

    private void attachCommentToAST(AST aST, Comment comment, boolean bl) {
        if (bl) {
            ((ExtAST)aST).addPrefixComment(comment);
        } else if (this.isSeparatorItem(aST)) {
            comment.shouldTag(false);
            comment.setText(COMMA_SEPARATOR_COMMENT + comment.getText());
            ((ExtAST)aST).addSuffixComment(comment);
        } else {
            ((ExtAST)aST).addSuffixComment(comment);
        }
    }

    private boolean isSeparatorItem(AST aST) {
        StringTemplate stringTemplate;
        for (stringTemplate = this.getTemplate(aST); stringTemplate != null && !stringTemplate.getName().equals("commaSeparator"); stringTemplate = stringTemplate.getEnclosingInstance()) {
        }
        if (stringTemplate != null) {
            Map map = stringTemplate.getArgumentContext();
            Object v = map.get("selectList");
            if (!(v instanceof StringTemplate.STAttributeList)) {
                return false;
            }
            StringTemplate.STAttributeList sTAttributeList = (StringTemplate.STAttributeList)map.get("selectList");
            if (sTAttributeList.size() < 2) {
                return false;
            }
            StringTemplate stringTemplate2 = this.getTemplate(aST, "selectItem");
            if (stringTemplate2 == null) {
                return false;
            }
            int n = sTAttributeList.indexOf((Object)stringTemplate2);
            if (n != sTAttributeList.size() - 1) {
                ArrayList<AST> arrayList = this.getTokens();
                if (arrayList.size() < arrayList.indexOf(aST)) {
                    return true;
                }
                AST aST2 = arrayList.get(arrayList.indexOf(aST) + 1);
                StringTemplate stringTemplate3 = this.getTemplate(aST2, "selectItem");
                return stringTemplate2 != stringTemplate3;
            }
            return false;
        }
        return false;
    }

    private StringTemplate getTemplate(AST aST, String string) {
        StringTemplate stringTemplate;
        for (stringTemplate = this.getTemplate(aST); stringTemplate != null && !stringTemplate.getName().equals(string); stringTemplate = stringTemplate.getEnclosingInstance()) {
        }
        return stringTemplate;
    }

    public String getTranslatedTextWithComment(StringTemplate stringTemplate, Block block) {
        try {
            this.removeLookaheadComments();
            this.processNestedComments();
            this.setStringTemplate(stringTemplate);
            this.setTopBlock(block);
            this.buildDescriptors();
            this.groupRelatedComments();
            this.matchCommentsToTemplateTree();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.postProcessing(this.m_outputTemplate.toString());
    }

    private void removeLookaheadComments() {
    }

    private void processNestedComments() {
        StringBuffer stringBuffer = null;
        for (Comment comment : this.m_commentList) {
            if (comment.isSingleLineComment()) continue;
            stringBuffer = new StringBuffer(comment.getText());
            int n = 0;
            int n2 = 0;
            while (true) {
                int n3 = stringBuffer.indexOf("/*", n2);
                int n4 = stringBuffer.indexOf(COMMENT_END_MARKER, n2);
                if (n4 == -1) break;
                if (n3 < n4 && n3 != -1) {
                    if (++n > 1) {
                        stringBuffer.replace(n3, n3 + 2, "--");
                    }
                    n2 = n3 + 1;
                    continue;
                }
                if (n > 1) {
                    stringBuffer.replace(n4, n4 + 2, "--");
                }
                --n;
                n2 = n4 + 1;
            }
            comment.setText(stringBuffer.toString());
        }
    }

    private String postProcessing(String string) {
        string = string.replaceAll("\r\n", "\n");
        StringBuffer stringBuffer = new StringBuffer(string);
        this.resolveCommaSeparator(stringBuffer);
        this.endOfStringRemove(stringBuffer);
        return stringBuffer.toString();
    }

    private void endOfStringRemove(StringBuffer stringBuffer) {
        while (stringBuffer.indexOf("<SLC>") != -1) {
            int n = stringBuffer.indexOf("<SLC>");
            int n2 = stringBuffer.indexOf("</SLC>", n);
            String string = stringBuffer.substring(n + "<SLC>".length(), n2);
            int n3 = stringBuffer.indexOf("\n", n);
            stringBuffer.insert(n3, string);
            stringBuffer.delete(n, n2 + "</SLC>".length());
        }
    }

    private void resolveCommaSeparator(StringBuffer stringBuffer) {
        if (stringBuffer.indexOf(COMMA_SEPARATOR_COMMENT) != -1) {
            while (stringBuffer.indexOf(COMMA_SEPARATOR_COMMENT) != -1) {
                int n;
                int n2;
                int n3;
                int n4 = n3 = stringBuffer.indexOf(COMMA_SEPARATOR_COMMENT);
                StringBuffer stringBuffer2 = new StringBuffer();
                if (stringBuffer.length() > n3 + COMMA_SEPARATOR_COMMENT.length()) {
                    n2 = stringBuffer.charAt(n3 + COMMA_SEPARATOR_COMMENT.length());
                    if (n2 == 47) {
                        n = stringBuffer.indexOf(COMMENT_END_MARKER, n4);
                        stringBuffer2 = new StringBuffer(stringBuffer.substring(n3, n + 2));
                        n4 = n + 2;
                    } else {
                        while (stringBuffer.charAt(n4) != '\n') {
                            stringBuffer2.append(stringBuffer.charAt(n4));
                            ++n4;
                        }
                        stringBuffer2.append("\n");
                    }
                }
                n2 = n4;
                while (stringBuffer.charAt(n2) != ',') {
                    ++n2;
                }
                stringBuffer.delete(n3, n4);
                stringBuffer.insert((n2 -= n4 - n3) + 1, stringBuffer2.toString().substring(COMMA_SEPARATOR_COMMENT.length()));
                n = n2 - 1;
                while (Character.isWhitespace(stringBuffer.charAt(n))) {
                    --n;
                }
                if (n >= n2 - 1) continue;
                stringBuffer.delete(n + 1, n2 - 1);
            }
        }
    }

    class ASTComparator
    implements Comparator<AST> {
        ASTComparator() {
        }

        @Override
        public int compare(AST aST, AST aST2) {
            int n = 0;
            n = aST.getLine() > aST2.getLine() ? 1 : (aST.getLine() == aST2.getLine() ? (aST.getColumn() == aST2.getColumn() ? 0 : (aST.getColumn() > aST2.getColumn() ? 1 : -1)) : -1);
            return n;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof ASTComparator;
        }
    }
}

