/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.helper;

import antlr.ASTPair;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.migration.parser.analysis.action.TSQLMetaDataAnalysisAction;
import oracle.dbtools.migration.parser.ext.ExtAST;
import oracle.dbtools.migration.parser.helper.TranslationHelper;
import oracle.dbtools.migration.parser.internalapi.IVisitor;
import oracle.dbtools.migration.parser.internalapi.IVisitorResult;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.ITranslationManager;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.components.Table;
import oracle.dbtools.migration.translation.api.components.TranslationParameter;
import oracle.dbtools.migration.translation.api.exceptions.TranslationObjectNotFoundException;
import oracle.dbtools.migration.translation.api.objects.TranslationColumn;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;
import oracle.dbtools.migration.translation.util.ASTUtil;

public class DependencyManager {
    private TranslationHelper m_translationHelper = null;
    public static final String TRANSLATABLE = "TRANSLATABLE";
    public static final String EMULATIONFNC = "EMULATIONFNC";
    public static final String UNKNOWN = "UNKNOWN";

    public DependencyManager(TranslationHelper translationHelper) {
        this.m_translationHelper = translationHelper;
    }

    public TranslationDBObjectReference getDBObjectReference(String string, String string2, String string3, String string4, String string5, TranslationObjectType translationObjectType, String string6, String string7) {
        TranslationDBObjectReference translationDBObjectReference = new TranslationDBObjectReference(string, string2, string3, string4, string5, translationObjectType != null ? translationObjectType : TranslationObjectType.UNKNOWN_TYPE, string6, string7);
        if (translationObjectType != TranslationObjectType.UNKNOWN_TYPE && translationObjectType != TranslationObjectType.EMULATION_TYPE && translationObjectType != TranslationObjectType.TEMP_TABLE_TYPE && translationObjectType != TranslationObjectType.TEMP_TABLE_TYPE_REF && this.isManagerAvailable()) {
            try {
                this.getTranslationContext().completeSourceObject(translationDBObjectReference, this.getTranslationHelper().getSourceDBObject().getOMWBObj());
            }
            catch (TranslationObjectNotFoundException translationObjectNotFoundException) {
                // empty catch block
            }
        }
        return translationDBObjectReference;
    }

    public TranslationDBObjectReference getDBObjectReference(AST aST, AST aST2, AST aST3, AST aST4, AST aST5, TranslationObjectType translationObjectType) {
        return this.getDBObjectReference(aST, aST2, aST3, aST4, aST5, translationObjectType, null);
    }

    public TranslationDBObjectReference getDBObjectReference(AST aST, AST aST2, AST aST3, AST aST4, AST aST5, TranslationObjectType translationObjectType, AST aST6) {
        Block block;
        Block block2;
        String string = null;
        if (translationObjectType != null && translationObjectType == TranslationObjectType.COLUMN_TYPE && aST4 != null && aST4.getText() != null && (aST4.getText().equalsIgnoreCase("DELETED") || aST4.getText().equalsIgnoreCase("INSERTED"))) {
            return new TranslationDBObjectReference(ASTUtil.toString(aST), ASTUtil.toString(aST2), ASTUtil.toString(aST3), string == null ? ASTUtil.toString(aST4) : string, ASTUtil.toString(aST5), translationObjectType, ASTUtil.toString(aST6), string != null ? ASTUtil.toString(aST4) : null);
        }
        if (aST6 != null) {
            aST6 = aST6.getFirstChild();
        }
        if (aST5 != null && aST4 != null && (block2 = this.getTranslationHelper().getCodeBlockManager().findEnclosingDMLStatmentBlock(aST4)) != null && (block = block2.getDescendentBlock("CLAUSEBLOCK", "FROM")) != null) {
            List<Block> list = block.getAllDescendentBlock("OPERATIONBLOCK", "ALIAS");
            for (Block block3 : list) {
                ExtAST extAST;
                ExtAST extAST2;
                TranslationDBObjectReference translationDBObjectReference;
                ExtAST extAST3 = (ExtAST)block3.getAST().getFirstChild();
                if (!ASTUtil.toString((AST)extAST3).equalsIgnoreCase(ASTUtil.toString(aST4)) || (translationDBObjectReference = (TranslationDBObjectReference)(extAST2 = (ExtAST)(extAST = (ExtAST)((Object)((ExtAST)block3.getAST()).getExtraInfo("PARENT"))).getFirstChild()).getExtraInfo((Object)TranslationDBObjectReference.ModelType.SOURCE_REF)) == null) continue;
                string = translationDBObjectReference.getObjName();
            }
        }
        return this.getDBObjectReference(ASTUtil.toString(aST), ASTUtil.toString(aST2), ASTUtil.toString(aST3), string == null ? ASTUtil.toString(aST4) : string, ASTUtil.toString(aST5), translationObjectType, ASTUtil.toString(aST6), string != null ? ASTUtil.toString(aST4) : null);
    }

    public void handleSourceReference(TranslationDBObjectReference translationDBObjectReference, String string) {
        if (translationDBObjectReference == null || string == null || !this.isManagerAvailable()) {
            return;
        }
        this.saveSourceDependency(translationDBObjectReference);
        if (string == TRANSLATABLE && translationDBObjectReference.getType() != TranslationObjectType.TABLE_TYPE) {
            if (!this.isManagerAvailable()) {
                return;
            }
            this.handleReferenceForTranslating(translationDBObjectReference);
        }
    }

    public void handleTargetReference(TranslationDBObjectReference translationDBObjectReference, String string) {
        if (translationDBObjectReference == null || string == null || !this.isManagerAvailable()) {
            return;
        }
        this.saveTargetDependency(translationDBObjectReference);
    }

    public ArrayList<TranslationParameter> getTargetParameters(TranslationDBObjectReference translationDBObjectReference) {
        if (!this.isManagerAvailable()) {
            return null;
        }
        ArrayList<TranslationParameter> arrayList = null;
        this.translateIfRequired(translationDBObjectReference);
        try {
            TranslationDBObjectReference translationDBObjectReference2 = this.getTranslationContext().getTargetDBObjectReference(translationDBObjectReference, this.getTranslationHelper().getSourceDBObject().getOMWBObj());
            arrayList = this.isTranslating(translationDBObjectReference) ? this.getTranslationContext().getSourceParameters(translationDBObjectReference) : this.getTranslationContext().getTargetParameters(translationDBObjectReference2);
        }
        catch (TranslationObjectNotFoundException translationObjectNotFoundException) {
            // empty catch block
        }
        return arrayList;
    }

    public void handleEmulationFunc(String string) {
        if (string != null && this.isManagerAvailable()) {
            TranslationDBObjectReference translationDBObjectReference = this.getDBObjectReference(null, null, null, string, null, TranslationObjectType.EMULATION_TYPE, null, null);
            this.handleTargetReference(translationDBObjectReference, EMULATIONFNC);
        }
    }

    public void handleTempTableRef(String string, String string2) {
        if (string != null && this.isManagerAvailable()) {
            TranslationObjectType translationObjectType = TranslationObjectType.TEMP_TABLE_TYPE_REF;
            TranslationDBObjectReference translationDBObjectReference = this.getDBObjectReference(null, null, null, string, null, translationObjectType, null, null);
            this.handleSourceReference(translationDBObjectReference, UNKNOWN);
            TranslationDBObjectReference translationDBObjectReference2 = this.getDBObjectReference(null, null, null, string2, null, translationObjectType, null, null);
            this.handleTargetReference(translationDBObjectReference2, UNKNOWN);
        }
    }

    public void handleCreateTempTable(String string, String string2) {
        if (string != null && this.isManagerAvailable()) {
            TranslationObjectType translationObjectType = TranslationObjectType.TEMP_TABLE_TYPE;
            TranslationDBObjectReference translationDBObjectReference = this.getDBObjectReference(null, null, null, string, null, translationObjectType, null, null);
            this.handleSourceReference(translationDBObjectReference, UNKNOWN);
            TranslationDBObjectReference translationDBObjectReference2 = this.getDBObjectReference(null, null, null, string2, null, translationObjectType, null, null);
            this.handleTargetReference(translationDBObjectReference2, UNKNOWN);
        }
    }

    private void saveSourceDependency(TranslationDBObjectReference translationDBObjectReference) {
        if (translationDBObjectReference != null && this.isManagerAvailable()) {
            this.getTranslationHelper();
            TranslationHelper.getLogging().saveSourceDependency(this.getTranslationHelper().getSourceDBObject(), translationDBObjectReference);
        }
    }

    private void saveTargetDependency(TranslationDBObjectReference translationDBObjectReference) {
        if (translationDBObjectReference != null && this.isManagerAvailable()) {
            this.getTranslationHelper();
            TranslationHelper.getLogging().saveTargetDependency(this.getTranslationHelper().getTargetDBObjectReference(), translationDBObjectReference);
        }
    }

    private boolean isTranslated(TranslationDBObjectReference translationDBObjectReference) {
        if (!this.isManagerAvailable()) {
            return true;
        }
        return this.getTranslationManager().isTranslated(translationDBObjectReference.getOMWBObj());
    }

    private boolean isTranslating(TranslationDBObjectReference translationDBObjectReference) {
        if (!this.isManagerAvailable()) {
            return false;
        }
        return this.getTranslationManager().isTranslating(translationDBObjectReference.getOMWBObj());
    }

    private void translate(TranslationDBObjectReference translationDBObjectReference) {
        if (!this.isManagerAvailable()) {
            return;
        }
        this.getTranslationManager().translate(translationDBObjectReference.getOMWBObj(), this.getTranslationHelper().getTranslationContext());
    }

    private void translateIfRequired(TranslationDBObjectReference translationDBObjectReference) {
        if (!this.isManagerAvailable()) {
            return;
        }
        if (!this.isTranslated(translationDBObjectReference) && !this.isTranslating(translationDBObjectReference) && this.getTranslationManager() != null) {
            this.translate(translationDBObjectReference);
        }
    }

    private void handleReferenceForTranslating(TranslationDBObjectReference translationDBObjectReference) {
        if (!this.isManagerAvailable()) {
            return;
        }
        try {
            this.getTranslationContext().completeSourceObject(translationDBObjectReference, this.getOMWBObj());
        }
        catch (TranslationObjectNotFoundException translationObjectNotFoundException) {
            // empty catch block
        }
        if (this.isTranslatable(translationDBObjectReference)) {
            this.translateIfRequired(translationDBObjectReference);
        }
    }

    private Object getOMWBObj() {
        return this.getTranslationHelper().getSourceDBObject().getOMWBObj();
    }

    private boolean isTranslatable(TranslationDBObjectReference translationDBObjectReference) {
        if (translationDBObjectReference.getObjName() == null || translationDBObjectReference.getType() == null) {
            return false;
        }
        return translationDBObjectReference.getType().equals(TranslationObjectType.FUNCTION_TYPE) || translationDBObjectReference.getType().equals(TranslationObjectType.PROCEDURE_OR_FUNCTION_TYPE) || translationDBObjectReference.getType().equals(TranslationObjectType.PROCEDURE_TYPE) || translationDBObjectReference.getType().equals(TranslationObjectType.VIEW_TYPE) || translationDBObjectReference.getType().equals(TranslationObjectType.TRIGGER_TYPE) || translationDBObjectReference.getType().equals(TranslationObjectType.CONSTRAINT_TYPE);
    }

    private ITranslationContext getTranslationContext() {
        return this.getTranslationHelper().getTranslationContext();
    }

    private ITranslationManager getTranslationManager() {
        return this.getTranslationHelper().getTranslationManager();
    }

    private TranslationHelper getTranslationHelper() {
        return this.m_translationHelper;
    }

    private boolean isManagerAvailable() {
        return this.getTranslationManager() != null && this.getTranslationHelper() != null && this.getTranslationContext() != null;
    }

    public TranslationDBObjectReference identifyTargetColumn(AST aST, TranslationDBObjectReference translationDBObjectReference, AST aST2, AST aST3, AST aST4) {
        return this.identifyTargetColumn(aST, translationDBObjectReference, aST2, aST3, aST4, -1);
    }

    public TranslationDBObjectReference identifyTargetColumn(AST aST, TranslationDBObjectReference translationDBObjectReference, AST aST2, AST aST3, AST aST4, int n) {
        String string;
        Object object;
        String string2 = null;
        ArrayList<Table> arrayList = new ArrayList<Table>();
        Object object2 = this.getTableRef(aST4, aST);
        if (n != -1 && ((ArrayList)object2).size() > n) {
            object = new ArrayList();
            for (int i = 0; i < n; ++i) {
                ((ArrayList)object).add(((ArrayList)object2).get(i));
            }
            object2 = object;
        }
        arrayList.addAll(this.getAllTablesInfo((ArrayList<TranslationDBObjectReference>)object2));
        object = null;
        if (aST2 != null) {
            object = aST2.toString();
        }
        if ((string2 = this.getRelatedTable(arrayList, (String)object, string = aST3.toString())) != null) {
            try {
                translationDBObjectReference.setObjName(string2);
                return this.getTranslationContext().getTargetDBObjectReference(translationDBObjectReference, this.m_translationHelper.getSourceDBObject().getOMWBObj());
            }
            catch (TranslationObjectNotFoundException translationObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getRelatedTable(ArrayList<Table> arrayList, String string, String string2) {
        for (Table table : arrayList) {
            for (TranslationColumn translationColumn : table.getColumns()) {
                if (!translationColumn.getColumnName().equals(string2)) continue;
                return table.getName();
            }
        }
        return null;
    }

    private ArrayList<Table> getInlineViewsInfo(AST aST) {
        return null;
    }

    private ArrayList<Table> getAllTablesInfo(ArrayList<TranslationDBObjectReference> arrayList) {
        ArrayList<Table> arrayList2 = new ArrayList<Table>();
        for (TranslationDBObjectReference translationDBObjectReference : arrayList) {
            String string = translationDBObjectReference.getObjName();
            ArrayList<TranslationColumn> arrayList3 = null;
            try {
                arrayList3 = this.getTranslationHelper().getTranslationContext().getSourceColumns(translationDBObjectReference);
                Table table = new Table(null, null, string);
                table.addColumns(arrayList3);
                arrayList2.add(table);
            }
            catch (TranslationObjectNotFoundException translationObjectNotFoundException) {}
        }
        return arrayList2;
    }

    private ArrayList<TranslationDBObjectReference> getTableRef(AST aST, AST aST2) {
        ArrayList<TranslationDBObjectReference> arrayList = new ArrayList<TranslationDBObjectReference>();
        ASTTypeMatcher aSTTypeMatcher = new ASTTypeMatcher(aST2.getType());
        ASTUtil.walkAntlrTree((ExtAST)aST, aSTTypeMatcher);
        for (AST aST3 : aSTTypeMatcher.listMatches()) {
            TranslationDBObjectReference translationDBObjectReference = (TranslationDBObjectReference)((ExtAST)aST3).getExtraInfo((Object)TranslationDBObjectReference.ModelType.SOURCE_REF);
            arrayList.add(translationDBObjectReference);
        }
        return arrayList;
    }

    public String getIdentityID(ASTPair aSTPair) {
        try {
            Block block = ((ExtAST)aSTPair.root).getBlock();
            Block block2 = block.getEnclosingBlockByType("STMTBLOCK");
            List<Block> list = block2.getAllDescendentBlock("CLAUSEBLOCK", "INTO");
            if (list != null && list.size() > 0) {
                Block block3 = list.get(0);
                ExtAST extAST = (ExtAST)block3.getAST();
                ExtAST extAST2 = (ExtAST)extAST.getFirstChild();
                String string = TSQLMetaDataAnalysisAction.getDBObjectFullName((AST)extAST2);
                if (string == null || string.startsWith("#")) {
                    // empty if block
                }
                return this.getTranslationHelper().getTranslationContext().getExistingDynamicName(string, this.getTranslationHelper().getTargetDBObjectRef());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown";
    }

    public class ASTTypeMatcher
    implements IVisitor {
        int m_type = -1;
        ArrayList<AST> m_matchedASTs = new ArrayList();

        public ASTTypeMatcher(int n) {
            this.m_type = n;
        }

        @Override
        public IVisitorResult returnResult(IVisitorResult iVisitorResult, IVisitorResult iVisitorResult2) {
            return null;
        }

        @Override
        public IVisitorResult visit(ExtAST extAST) {
            if (extAST.getType() == this.m_type) {
                this.m_matchedASTs.add((AST)extAST);
            }
            return null;
        }

        public ArrayList<AST> listMatches() {
            return this.m_matchedASTs;
        }
    }
}

