/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.translation.api.components;

import antlr.collections.AST;
import java.util.ArrayList;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.components.CursorScope;

public class Cursor {
    private boolean m_dynamic;
    private boolean m_isParam;
    private AST m_tree;
    private String m_name;
    private Block m_programBlock;
    private ArrayList<AST> m_cursorDeclTrees;
    private ArrayList<CursorScope> m_usageValidScope;
    private String m_selectStmt;
    private ArrayList<String> m_updateableColumns;
    private String m_selectStmtVar;

    public Cursor(AST aST, Block block, String string, boolean bl) {
        this(aST, block, string);
        this.m_dynamic = bl;
    }

    public Cursor(AST aST, Block block, String string) {
        this.m_tree = aST;
        this.m_programBlock = block;
        this.m_name = string;
        this.m_cursorDeclTrees = new ArrayList();
        this.m_cursorDeclTrees.add(aST);
        this.m_usageValidScope = new ArrayList();
        this.m_updateableColumns = new ArrayList();
    }

    public AST getTree() {
        return this.m_dynamic && this.m_cursorDeclTrees.size() == 2 ? this.m_cursorDeclTrees.get(1) : this.m_tree;
    }

    public String getName() {
        return this.m_name;
    }

    public String getTargetName() {
        return this.m_name;
    }

    public Block getBlock() {
        return this.m_programBlock;
    }

    public boolean isDynamic() {
        return this.m_dynamic;
    }

    public void setDynamic(boolean bl) {
        this.m_dynamic = bl;
    }

    public boolean isParameter() {
        return this.m_isParam;
    }

    public void setParameter(boolean bl) {
        this.m_isParam = bl;
    }

    public void addCursorDeclaration(AST aST) {
        this.m_cursorDeclTrees.add(aST);
    }

    public boolean hasMultipleDeclarations() {
        return this.m_dynamic && (this.m_cursorDeclTrees.size() > 2 || this.m_cursorDeclTrees.size() == 1) || !this.m_dynamic && this.m_cursorDeclTrees.size() > 1;
    }

    public boolean hasUsageValidScope() {
        return !this.m_usageValidScope.isEmpty();
    }

    public void setUsageValidScopeStart(AST aST) {
        this.setUsageValidScopeEnd(aST);
        this.m_usageValidScope.add(new CursorScope(aST));
    }

    public void setUsageValidScopeEnd(AST aST) {
        for (CursorScope cursorScope : this.m_usageValidScope) {
            if (cursorScope.getScopeEnd() != null) continue;
            cursorScope.setScopeEnd(aST);
        }
    }

    public CursorScope findCursorScope(AST aST) {
        CursorScope cursorScope = null;
        for (CursorScope cursorScope2 : this.m_usageValidScope) {
            if (!cursorScope2.isInScope(aST) || cursorScope2.compareScope(cursorScope) >= 0) continue;
            cursorScope = cursorScope2;
        }
        return cursorScope;
    }

    public CursorScope[] getCursorScopes() {
        return this.m_usageValidScope.toArray(new CursorScope[this.m_usageValidScope.size()]);
    }

    public boolean equals(Block block, String string) {
        return this.m_programBlock == block && this.m_name.equalsIgnoreCase(string);
    }

    public void setSelectStatement(String string) {
        this.m_selectStmt = string;
    }

    public String getSelectStatement() {
        return this.m_selectStmt;
    }

    public void addUpdateColumn(String string) {
        this.m_updateableColumns.add(string);
    }

    public String[] getUpdateColumns() {
        return this.m_updateableColumns.toArray(new String[this.m_updateableColumns.size()]);
    }

    public void setSelectStatementVar(String string) {
        this.m_selectStmtVar = string;
    }

    public String getSelectStatementVar() {
        return this.m_selectStmtVar;
    }
}

