/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.Component;
import java.awt.Window;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.TriggerController;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.algorithm.directory.DirectoryCompareContributor;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;
import oracle.javatools.compare.algorithm.directory.DirectoryList;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.compare.BinaryCompareContributor;
import oracle.jdeveloper.compare.TextNodeContributor;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.CompareEditor;
import oracle.jdevimpl.compare.CompareIdeViewer;
import oracle.jdevimpl.compare.CompareUtil;
import oracle.jdevimpl.resource.CompareArb;

public class CompareFileController
implements TriggerController {
    private final NodeListener _listener = new CompareNodeListener();

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == CompareAddin._eachOtherAction) {
            Locatable[] selection = VCSManager.getVCSManager().getContextLocatables(context);
            if (selection != null && selection.length == 2) {
                if (selection[0] instanceof Locatable && selection[1] instanceof Locatable) {
                    action.setEnabled(CompareUtil.isValidCompareURL(selection[0].getURL()) && CompareUtil.isValidCompareURL(selection[1].getURL()) && URLFileSystem.isDirectoryPath((URL)selection[0].getURL()) == URLFileSystem.isDirectoryPath((URL)selection[1].getURL()) && FileTypesRecognizer.getNonNullContentTypeForExtension((String)URLFileSystem.getSuffix((URL)selection[0].getURL())) == FileTypesRecognizer.getNonNullContentTypeForExtension((String)URLFileSystem.getSuffix((URL)selection[1].getURL())));
                    return true;
                }
                if (selection[0] instanceof RelativeDirectoryContextFolder && selection[1] instanceof RelativeDirectoryContextFolder) {
                    action.setEnabled(CompareUtil.isValidCompareURL(this.getDirectoryCompareURL((RelativeDirectoryContextFolder)selection[0])) && CompareUtil.isValidCompareURL(this.getDirectoryCompareURL((RelativeDirectoryContextFolder)selection[1])));
                    return true;
                }
            }
            action.setEnabled(false);
            return true;
        }
        if (cmdId == CompareAddin._otherFileAction) {
            Locatable[] selection = VCSManager.getVCSManager().getContextLocatables(context);
            if (selection != null) {
                if (selection.length == 0) {
                    action.setEnabled(context.getNode() != null && CompareUtil.isValidCompareURL(context.getNode().getURL()));
                    return true;
                }
                if (selection.length != 1) {
                    action.setEnabled(false);
                    return true;
                }
                if (selection[0] instanceof Locatable) {
                    action.setEnabled(CompareUtil.isValidCompareURL(selection[0].getURL()));
                    return true;
                }
                if (selection[0] instanceof RelativeDirectoryContextFolder) {
                    action.setEnabled(CompareUtil.isValidCompareURL(this.getDirectoryCompareURL((RelativeDirectoryContextFolder)selection[0])));
                    return true;
                }
                if (context.getNode() != null) {
                    action.setEnabled(CompareUtil.isValidCompareURL(context.getNode().getURL()));
                    return true;
                }
            }
            action.setEnabled(false);
            return true;
        }
        if (cmdId == CompareAddin._savedFileAction) {
            Locatable[] selection = VCSManager.getVCSManager().getContextLocatables(context);
            if (selection != null) {
                if (selection.length == 0) {
                    Node node = context.getNode();
                    action.setEnabled(node instanceof TextNode && (node.isDirty() || URLFileSystem.lastModified((URL)node.getURL()) != node.getUnmodifiedTimestamp()) && CompareUtil.isValidCompareURL(node.getURL()));
                    return true;
                }
                if (selection.length == 1 && selection[0] instanceof TextNode && CompareUtil.isValidCompareURL(((TextNode)selection[0]).getURL())) {
                    action.setEnabled(this.isDifferent((Node)((TextNode)selection[0])));
                    return true;
                }
                action.setEnabled(false);
                return true;
            }
            action.setEnabled(false);
            return true;
        }
        return false;
    }

    private final boolean isDifferent(Node node) {
        if (node == null) {
            return false;
        }
        return node.isDirty() || URLFileSystem.lastModified((URL)node.getURL()) != node.getUnmodifiedTimestamp();
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        try {
            if (cmdId == CompareAddin._otherFileAction) {
                this.compareOtherFile(context);
                return true;
            }
            if (cmdId == CompareAddin._savedFileAction) {
                this.compareSavedFile(context);
                return true;
            }
            if (cmdId == CompareAddin._eachOtherAction) {
                this.compareEachOther(context);
                return true;
            }
        }
        catch (Exception ioe) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ioe);
        }
        return false;
    }

    private URL getDirectoryCompareURL(RelativeDirectoryContextFolder selection) {
        RelativeDirectoryContextFolder directoryContextFolder = selection;
        URLPath rootDirectoryPath = directoryContextFolder.getRootDirectories();
        Iterator itr = rootDirectoryPath.iterator();
        if (itr.hasNext()) {
            return URLFactory.newDirURL((URL)((URL)itr.next()), (String)directoryContextFolder.getRelativePath());
        }
        return null;
    }

    public Object getInvalidStateMessage(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == CompareAddin._eachOtherAction) {
            Locatable[] selection = VCSManager.getVCSManager().getContextLocatables(context);
            if (selection != null && selection.length == 2) {
                if (selection[0] instanceof Locatable && selection[1] instanceof Locatable && (!CompareUtil.isValidCompareURL(selection[0].getURL()) || !CompareUtil.isValidCompareURL(selection[1].getURL()) || URLFileSystem.isDirectoryPath((URL)selection[0].getURL()) != URLFileSystem.isDirectoryPath((URL)selection[1].getURL()) || FileTypesRecognizer.getNonNullContentTypeForExtension((String)URLFileSystem.getSuffix((URL)selection[0].getURL())) != FileTypesRecognizer.getNonNullContentTypeForExtension((String)URLFileSystem.getSuffix((URL)selection[1].getURL())))) {
                    return CompareArb.get("ISM_FILES_ARE_NOT_COMPARABLE");
                }
                if (selection[0] instanceof RelativeDirectoryContextFolder && selection[1] instanceof RelativeDirectoryContextFolder && (!CompareUtil.isValidCompareURL(this.getDirectoryCompareURL((RelativeDirectoryContextFolder)selection[0])) || !CompareUtil.isValidCompareURL(this.getDirectoryCompareURL((RelativeDirectoryContextFolder)selection[1])))) {
                    return CompareArb.get("ISM_DIRECTORIES_ARE_NOT_COMPARABLE");
                }
            }
            return CompareArb.get("ISM_MUST_SELECT_TWO_FILES");
        }
        if (cmdId == CompareAddin._otherFileAction) {
            Locatable[] selection = VCSManager.getVCSManager().getContextLocatables(context);
            if (selection != null) {
                if (!(selection.length != 0 || context.getNode() != null && CompareUtil.isValidCompareURL(context.getNode().getURL()))) {
                    return CompareArb.get("ISM_FILE_IS_NOT_COMPARABLE");
                }
                if (selection.length != 1) {
                    return CompareArb.get("ISM_MUST_SELECT_ONE_FILE_TO_COMPARE_OTHER");
                }
                if (selection[0] instanceof Locatable && !CompareUtil.isValidCompareURL(selection[0].getURL())) {
                    return CompareArb.get("ISM_FILE_IS_NOT_COMPARABLE");
                }
                if (selection[0] instanceof RelativeDirectoryContextFolder && !CompareUtil.isValidCompareURL(this.getDirectoryCompareURL((RelativeDirectoryContextFolder)selection[0]))) {
                    return CompareArb.get("ISM_DIRECTORY_IS_NOT_COMPARABLE");
                }
                if (context.getNode() != null && !CompareUtil.isValidCompareURL(context.getNode().getURL())) {
                    return CompareArb.get("ISM_FILE_IS_NOT_COMPARABLE");
                }
            }
            return CompareArb.get("ISM_MUST_SELECT_ONE_FILE_TO_COMPARE_OTHER");
        }
        if (cmdId == CompareAddin._savedFileAction) {
            Locatable[] selection = VCSManager.getVCSManager().getContextLocatables(context);
            if (selection != null) {
                Node node;
                if (!(selection.length != 0 || (node = context.getNode()) instanceof TextNode && (node.isDirty() || URLFileSystem.lastModified((URL)node.getURL()) != node.getUnmodifiedTimestamp()) && CompareUtil.isValidCompareURL(node.getURL()))) {
                    return CompareArb.get("ISM_FILE_IS_NOT_COMPARABLE_OR_UNMODIFIED");
                }
                if (!(selection.length != 1 || selection[0] instanceof TextNode && CompareUtil.isValidCompareURL(((TextNode)selection[0]).getURL()))) {
                    return CompareArb.get("ISM_FILE_IS_NOT_COMPARABLE_OR_UNMODIFIED");
                }
                return CompareArb.get("ISM_MUST_SELECT_ONE_FILE_TO_COMPARE_FILE_ON_DISK");
            }
            return CompareArb.get("ISM_MUST_SELECT_ONE_FILE_TO_COMPARE_FILE_ON_DISK");
        }
        return CompareArb.get("ISM_FILES_ARE_NOT_COMPARABLE");
    }

    private void compareOtherFile(Context context) throws Exception {
        int result;
        CompareContributor right = null;
        URL url = null;
        Locatable[] selection = VCSManager.getVCSManager().getContextLocatables(context);
        Node contextNode = null;
        try {
            if (selection.length == 1) {
                url = this.getSelectionURL(selection[0]);
                if (url != null) {
                    right = this.createContributorFromURL(url);
                }
                contextNode = (Element)selection[0];
            } else {
                url = context.getNode().getURL();
                right = this.createContributorFromURL(url);
                contextNode = context.getNode();
            }
        }
        catch (IOException ex) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareArb.format("ERROR_CANNOT_READ_CONTENT", URLFileSystem.getName((URL)url)), (String)CompareArb.get("ERROR_CANNOT_READ_CONTENT_TITLE"), null);
            return;
        }
        URLChooser chooser = DialogUtil.newURLChooser((Context)context);
        chooser.setSelectionMode(0);
        chooser.setSelectionScope(url == null || !URLFileSystem.isDirectoryPath((URL)url) ? 0 : 1);
        if (url != null) {
            chooser.setSelectedURL(url);
        }
        if ((result = chooser.showOpenDialog((Component)Ide.getMainWindow(), CompareArb.get("SELECT_FILE"))) == 0) {
            URL otherUrl = chooser.getSelectedURL();
            if (URLFileSystem.isDirectoryPath((URL)url) != URLFileSystem.isDirectoryPath((URL)otherUrl)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareArb.get("COMPARE_DIRECTORY_MESSAGE"), (String)CompareArb.get("COMPARE_DIRECTORY_TITLE"), null);
            } else if (otherUrl != null && otherUrl.equals(url)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareArb.get("COMPARE_SELF_MESSAGE"), (String)CompareArb.get("COMPARE_SELF_TITLE"), null);
            } else if (!URLFileSystem.exists((URL)otherUrl)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareArb.get("COMPARE_OTHER_MESSAGE"), (String)CompareArb.get("COMPARE_OTHER_TITLE"), null);
            } else {
                CompareContributor left = this.createContributorFromURL(otherUrl);
                CompareIdeViewer.getCompareIdeViewer().show(left, right, (Element)contextNode);
            }
        }
    }

    private void compareSavedFile(Context context) throws Exception {
        URLContributor left = null;
        TextNodeContributor right = null;
        Locatable[] selection = VCSManager.getVCSManager().getContextLocatables(context);
        Node contextNode = null;
        if (selection.length == 0 && context.getNode() != null) {
            left = new URLContributor(context.getNode().getURL());
            right = new TextNodeContributor((TextNode)context.getNode());
            contextNode = context.getNode();
        }
        if (selection.length > 0) {
            if (selection[0] instanceof TextNode) {
                left = new URLContributor(((TextNode)selection[0]).getURL());
                right = new TextNodeContributor((TextNode)selection[0]);
            } else {
                left = new URLContributor(context.getNode().getURL());
                right = new TextNodeContributor((TextNode)context.getNode());
            }
            contextNode = (Element)selection[0];
        }
        if (left == null) {
            Assert.fail();
            return;
        }
        CompareIdeViewer.getCompareIdeViewer().show((CompareContributor)left, (CompareContributor)right, (Element)contextNode);
        ((Node)contextNode).addNodeListener(this._listener);
    }

    private void compareEachOther(Context context) throws Exception {
        Locatable[] selection = VCSManager.getVCSManager().getContextLocatables(context);
        URL url = this.getSelectionURL(selection[0]);
        CompareContributor left = this.createContributorFromURL(url);
        url = this.getSelectionURL(selection[1]);
        CompareContributor right = this.createContributorFromURL(url);
        CompareIdeViewer.getCompareIdeViewer().show(left, right, (Element)selection[0]);
    }

    private URL getSelectionURL(Object selection) {
        if (selection instanceof RelativeDirectoryContextFolder) {
            return this.getDirectoryCompareURL((RelativeDirectoryContextFolder)selection);
        }
        if (selection instanceof Locatable) {
            return ((Locatable)selection).getURL();
        }
        return null;
    }

    private final CompareContributor createContributorFromURL(URL url) throws IOException {
        if (CompareUtil.isContentTypeBinary(url)) {
            return new BinaryCompareContributor(url);
        }
        return URLFileSystem.isDirectoryPath((URL)url) ? this.createDirectoryContributor(url) : new URLContributor(url);
    }

    private CompareContributor createDirectoryContributor(URL directoryUrl) {
        DirectoryCompareContributor contrib = new DirectoryCompareContributor(){};
        contrib.setShortLabel(URLFileSystem.getFileName((URL)directoryUrl));
        contrib.setLongLabel(URLFileSystem.getPlatformPathName((URL)directoryUrl));
        DirectoryList directoryList = new DirectoryList();
        for (final URLFileSystem.FileInfo info : URLFileSystem.ls((URL)directoryUrl)) {
            directoryList.appendFile(new DirectoryFile(info.isDirectory(), URLFileSystem.getFileName((URL)info.getURL()), info.isDirectory() ? "" : Long.toString(this.computeChecksum(info.getURL()))){

                public CompareContributor createCompareContributor() throws Exception {
                    URL url = info.getURL();
                    return CompareFileController.this.createContributorFromURL(url);
                }
            });
        }
        directoryList.clearModified();
        contrib.setDirectoryList(directoryList);
        return contrib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long computeChecksum(URL url) {
        CheckedInputStream cis = null;
        try {
            cis = new CheckedInputStream(URLFileSystem.openInputStream((URL)url), new Adler32());
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return 0L;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return 0L;
        }
        try {
            byte[] tempBuf = new byte[128];
            while (cis.read(tempBuf) >= 0) {
            }
            long l = cis.getChecksum().getValue();
            return l;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            long l = 0L;
            return l;
        }
        finally {
            try {
                cis.close();
            }
            catch (IOException ioe) {}
        }
    }

    private class CompareNodeListener
    extends NodeListener {
        private CompareNodeListener() {
        }

        public void nodeClosed(NodeEvent e) {
            ArrayList<Editor> closeEditors = new ArrayList<Editor>();
            List info = EditorManager.getEditorManager().getEditorsInfo();
            for (EditorInfo eInfo : info) {
                Node node;
                String path;
                Editor edit = eInfo._getEditor();
                if (!(edit instanceof CompareEditor) || !(path = URLFileSystem.getPath((URL)(node = edit.getContext().getNode()).getURL())).contains(e.getNodeURL().getPath())) continue;
                closeEditors.add(edit);
            }
            e.getNode().removeNodeListener(CompareFileController.this._listener);
            EditorManager.getEditorManager().closeEditors(closeEditors);
        }
    }
}

