/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.macros;

import java.io.File;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.macros.MacroValueProvider;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;

public class IdeMacroValueProvider
implements MacroValueProvider {
    private static final String M_ORACLE_HOME = "oracle.home";
    private static final String M_PROJECT_DIR = "project.dir";
    private static final String M_WORKSPACE_DIR = "workspace.dir";

    @Override
    public String getValue(Context context, String name) {
        if (M_ORACLE_HOME.equals(name = name.replaceFirst("ide", ""))) {
            return this.adjustToViewRelativePath(Ide.getOracleHomeDirectory());
        }
        if (M_WORKSPACE_DIR.equals(name)) {
            IdeMacroValueProvider.requireContext(context);
            Workspace w = context.getWorkspace();
            if (w != null) {
                String jwsAsString = w.getURL().toExternalForm();
                if (jwsAsString.indexOf(File.separatorChar) != -1) {
                    return jwsAsString.substring(0, jwsAsString.lastIndexOf(File.separatorChar) + 1);
                }
                return jwsAsString;
            }
            return null;
        }
        if (M_PROJECT_DIR.equals(name)) {
            IdeMacroValueProvider.requireContext(context);
            Project p = context.getProject();
            if (p != null) {
                String jprAsString = p.getURL().toExternalForm();
                if (jprAsString.indexOf(File.separatorChar) != -1) {
                    return jprAsString.substring(0, jprAsString.lastIndexOf(File.separatorChar) + 1);
                }
                return jprAsString;
            }
            return null;
        }
        return null;
    }

    private static void requireContext(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
    }

    private String adjustToViewRelativePath(String input) {
        String viewRoot = System.getenv("ADE_VIEW_ROOT");
        if (viewRoot == null) {
            return input;
        }
        String viewName = viewRoot.substring(viewRoot.lastIndexOf(File.separator) + 1);
        if (input.contains(viewName)) {
            String output = viewRoot + input.substring(input.indexOf(viewName) + viewName.length());
            return output;
        }
        return input;
    }
}

