/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.macros;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.macros.MacroHandler;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ideimpl.macros.MacroDefinition;
import oracle.ideimpl.macros.MacroDefinitions;
import oracle.ideimpl.macros.MacroUtils;
import oracle.ideimpl.macros.MacrosArb;
import oracle.ideimpl.macros.Scope;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class UserMacroHandler
implements MacroHandler {
    private static UserMacroHandler instance = new UserMacroHandler();
    private String lruProject;
    private String lruWorkspace;
    private static Map<String, MacroDefinition> currentlyVisibleMacros = new HashMap<String, MacroDefinition>();

    private UserMacroHandler() {
    }

    public static UserMacroHandler getInstance() {
        if (instance == null) {
            instance = new UserMacroHandler();
            UserMacroHandler.loadGlobalMacros();
        }
        return instance;
    }

    @Override
    public String getDescription(Context context, String name) {
        this.loadVisibleMacrosForContext(context);
        if (currentlyVisibleMacros.containsKey(name)) {
            return currentlyVisibleMacros.get(name).getDescription();
        }
        return MacrosArb.format("MACRO_UNDEFINED_OR_NOT_VISIBLE_MESSAGE", name);
    }

    @Override
    public String getValue(Context context, String name) {
        this.loadVisibleMacrosForContext(context);
        if (currentlyVisibleMacros.containsKey(name)) {
            return currentlyVisibleMacros.get(name).getValue();
        }
        return null;
    }

    public void add(MacroDefinition def) {
        currentlyVisibleMacros.put(def.getName(), def);
    }

    public void remove(String name) {
        currentlyVisibleMacros.remove((Object)currentlyVisibleMacros.get(name));
    }

    @Override
    public List<String> getNames(Context context) {
        this.loadVisibleMacrosForContext(context);
        return new ArrayList<String>(currentlyVisibleMacros.keySet());
    }

    private void loadVisibleMacrosForContext(Context context) {
        if (context == null) {
            return;
        }
        if (context.getProject() != null) {
            context.getProject();
            if (!Project.getDefaultName().equals(this.lruProject)) {
                this.loadProjectMacros(context.getProject());
            }
        }
        if (context.getWorkspace() != null && !context.getWorkspace().getLongLabel().equals(this.lruWorkspace)) {
            this.loadWorkspaceMacros(context.getWorkspace());
        }
    }

    @Override
    public List<String> getPathMacroNames(Context context) {
        this.loadVisibleMacrosForContext(context);
        ArrayList<String> result = new ArrayList<String>();
        for (MacroDefinition def : currentlyVisibleMacros.values()) {
            if (!def.isLocation()) continue;
            result.add(def.getName());
        }
        return result;
    }

    @Override
    public String getQualifier() {
        return "user";
    }

    @Override
    public String getQualifierDescription() {
        return MacrosArb.get("USER_DEFINED_MACROS");
    }

    private void loadProjectMacros(Project project) {
        if (project.getLongLabel().equals(this.lruProject)) {
            return;
        }
        Iterator<MacroDefinition> iter = currentlyVisibleMacros.values().iterator();
        while (iter.hasNext()) {
            MacroDefinition def = iter.next();
            if (def.getScope() != Scope.PROJECT) continue;
            iter.remove();
        }
        MacroDefinitions projectMacros = MacroDefinitions.getInstance((PropertyStorage)project);
        ListStructure list = projectMacros.getMacroDefinitionList();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                MacroDefinition def = new MacroDefinition((HashStructure)list.get(i));
                currentlyVisibleMacros.put(def.getName(), def);
            }
        }
        this.lruProject = project.getLongLabel();
    }

    private void loadWorkspaceMacros(Workspace workspace) {
        if (workspace.getLongLabel().equals(this.lruWorkspace)) {
            return;
        }
        Iterator<MacroDefinition> iter = currentlyVisibleMacros.values().iterator();
        while (iter.hasNext()) {
            MacroDefinition def = iter.next();
            if (def.getScope() != Scope.WORKSPACE) continue;
            iter.remove();
        }
        MacroDefinitions workspaceMacros = MacroDefinitions.getInstance((PropertyStorage)workspace);
        ListStructure list = workspaceMacros.getMacroDefinitionList();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                MacroDefinition def = new MacroDefinition((HashStructure)list.get(i));
                currentlyVisibleMacros.put(def.getName(), def);
            }
        }
        this.lruWorkspace = workspace.getLongLabel();
    }

    private static void loadGlobalMacros() {
        Iterator<MacroDefinition> iter = currentlyVisibleMacros.values().iterator();
        while (iter.hasNext()) {
            MacroDefinition def = iter.next();
            if (def.getScope() != Scope.GLOBAL) continue;
            iter.remove();
        }
        MacroDefinitions globalMacros = MacroDefinitions.getInstance((PropertyStorage)Preferences.getPreferences());
        ListStructure list = globalMacros.getMacroDefinitionList();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                MacroDefinition def = new MacroDefinition((HashStructure)list.get(i));
                currentlyVisibleMacros.put(def.getName(), def);
            }
        }
    }

    public ListStructure getProjectMacros(Project project) {
        return MacroDefinitions.getInstance((PropertyStorage)project).getMacroDefinitionList();
    }

    public ListStructure getWorkspaceMacros(Workspace workspace) {
        return MacroDefinitions.getInstance((PropertyStorage)workspace).getMacroDefinitionList();
    }

    public ListStructure getGlobalMacros() {
        return MacroDefinitions.getInstance((PropertyStorage)Preferences.getPreferences()).getMacroDefinitionList();
    }

    public void setProjectMacros(Project project, ListStructure macros) {
        MacroDefinitions definitions = MacroDefinitions.getInstance((PropertyStorage)project);
        definitions.setMacroDefinitionList(macros);
        if (project.getLongLabel().equals(this.lruProject)) {
            this.lruProject = null;
        }
    }

    public void setWorkspaceMacros(Workspace workspace, ListStructure macros) {
        MacroDefinitions definitions = MacroDefinitions.getInstance((PropertyStorage)workspace);
        definitions.setMacroDefinitionList(macros);
        if (workspace.getLongLabel().equals(this.lruWorkspace)) {
            this.lruWorkspace = null;
        }
    }

    public void setGlobalMacros(ListStructure macros) {
        MacroDefinitions definitions = MacroDefinitions.getInstance((PropertyStorage)Preferences.getPreferences());
        definitions.setMacroDefinitionList(macros);
        UserMacroHandler.loadGlobalMacros();
    }

    @Override
    public boolean requiresContext(String name) {
        return false;
    }

    public static void main(String[] args) {
        Context c = new Context();
        UserMacroHandler handler = new UserMacroHandler();
        MacroDefinition unamedef = new MacroDefinition();
        unamedef.setQualifier("user");
        unamedef.setName("user.name");
        unamedef.setDescription("The user's name");
        unamedef.setValue("Mike");
        handler.add(unamedef);
        MacroDefinition udirdef = new MacroDefinition();
        udirdef.setQualifier("user");
        udirdef.setName("user.dir");
        udirdef.setDescription("The user's home directory");
        udirdef.setValue("/home/myawn");
        handler.add(udirdef);
        String input = "${user:user.name}'s home directory is ${user:user.dir}";
        String expectedOutput = "Mike's home directory is /home/myawn";
        String actualOutput = MacroUtils.expand(null, input);
        System.out.println(actualOutput);
        System.out.println(actualOutput.equals(expectedOutput) ? "OK" : "FAIL");
    }
}

