/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.macros.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.macros.MacroHandler;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.macros.MacroUtils;
import oracle.ideimpl.macros.MacrosArb;
import oracle.ideimpl.macros.ui.MacroDialogOptions;

public class MacroSelectionDialog {
    private static String selection = null;
    private static JEWTDialog dlg;
    private static List<MacroHandler> initialMacroHandlerSet;
    private static List<MacroHandler> selectedMacroHandlerSet;
    private static DefaultListModel macrosToSelectFrom;
    private static JList macroList;
    private static String filterString;
    private static boolean showOnlyLocationMacros;
    private static boolean excludeContextDependentMacros;

    public static String getSelection() {
        return "${" + selection + "}";
    }

    public static boolean showDialog(MacroDialogOptions options, final Context context) {
        selection = null;
        JPanel panel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(5);
        panel.setLayout(borderLayout);
        if (options.isRestrictToLocationMacros()) {
            showOnlyLocationMacros = true;
        }
        if (options.getExcludeContextDependentMacros()) {
            excludeContextDependentMacros = true;
        }
        if (options.isEnableFiltering()) {
            JPanel filterPanel = new JPanel(new BorderLayout());
            JLabel filterLabel = new JLabel();
            filterPanel.add((Component)filterLabel, "West");
            final JTextField filterField = new JTextField();
            ResourceUtils.resLabel((JLabel)filterLabel, (Component)filterField, (String)MacrosArb.get("MACRO_SELECTION_FILTER_LABEL"));
            filterField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    filterString = filterField.getText();
                    MacroSelectionDialog.refreshMacroList(context);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    filterString = filterField.getText();
                    MacroSelectionDialog.refreshMacroList(context);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    filterString = filterField.getText();
                    MacroSelectionDialog.refreshMacroList(context);
                }
            });
            filterPanel.add((Component)filterField, "Center");
            panel.add((Component)filterPanel, "North");
            JPanel qualifierSelectionPanel = new JPanel();
            qualifierSelectionPanel.setLayout(new BoxLayout(qualifierSelectionPanel, 3));
            initialMacroHandlerSet = MacroUtils.getMacroHandlers(context);
            if (options.getSupportedQualifiers() != null && options.getSupportedQualifiers().size() > 0) {
                Iterator<MacroHandler> iter = initialMacroHandlerSet.iterator();
                while (iter.hasNext()) {
                    MacroHandler h = iter.next();
                    if (options.getSupportedQualifiers().contains(h.getQualifier())) continue;
                    iter.remove();
                }
            }
            selectedMacroHandlerSet = initialMacroHandlerSet;
            ArrayList<JCheckBox> selectionCBs = new ArrayList<JCheckBox>();
            for (MacroHandler handler : initialMacroHandlerSet) {
                JCheckBox cb = new JCheckBox(handler.getQualifierDescription());
                selectionCBs.add(cb);
                cb.putClientProperty("handler", handler);
                cb.setSelected(true);
                cb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JCheckBox cb = (JCheckBox)e.getSource();
                        MacroHandler handler = (MacroHandler)cb.getClientProperty("handler");
                        if (cb.isSelected()) {
                            selectedMacroHandlerSet.add(handler);
                            MacroSelectionDialog.refreshMacroList(context);
                        } else {
                            selectedMacroHandlerSet.remove(handler);
                            MacroSelectionDialog.refreshMacroList(context);
                        }
                    }
                });
                qualifierSelectionPanel.add(cb);
            }
            MacroSelectionDialog.fixMnemonics(selectionCBs.toArray(new JCheckBox[selectionCBs.size()]));
            filterPanel.add((Component)qualifierSelectionPanel, "South");
        }
        JPanel macrosPanel = new JPanel(new BorderLayout());
        panel.add((Component)macrosPanel, "Center");
        macrosToSelectFrom = new DefaultListModel();
        macroList = new JList(macrosToSelectFrom){

            @Override
            public String getToolTipText(MouseEvent event) {
                int index = this.locationToIndex(event.getPoint());
                String item = (String)macrosToSelectFrom.getElementAt(index);
                return MacroUtils.getDescription(context, item);
            }
        };
        macroList.setSelectionMode(0);
        macroList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                dlg.setOKButtonEnabled(true);
            }
        });
        MacroSelectionDialog.refreshMacroList(context);
        JScrollPane scroller = new JScrollPane(macroList);
        scroller.setHorizontalScrollBarPolicy(30);
        scroller.setVerticalScrollBarPolicy(20);
        macrosPanel.add((Component)scroller, "Center");
        String title = options.getDialogTitle();
        dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)macroList, (String)title);
        dlg.setResizable(true);
        dlg.setOKButtonEnabled(false);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_macroselectiondialog_html");
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            selection = (String)macroList.getSelectedValue();
            return true;
        }
        return false;
    }

    private static void refreshMacroList(Context context) {
        macrosToSelectFrom.clear();
        for (MacroHandler handler : selectedMacroHandlerSet) {
            List<String> macrosForHandler = showOnlyLocationMacros ? handler.getPathMacroNames(context) : handler.getNames(context);
            for (String macroName : macrosForHandler) {
                String qualifiedName = handler.getQualifier() + ":" + macroName;
                if (excludeContextDependentMacros && handler.requiresContext(macroName) || filterString != null && filterString.length() > 0 && !qualifiedName.contains(filterString)) continue;
                macrosToSelectFrom.addElement(qualifiedName);
            }
        }
        macroList.setModel(macrosToSelectFrom);
    }

    private static void fixMnemonics(JCheckBox[] items) {
        String filterLabel;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Integer> mnemonics = new ArrayList<Integer>();
        for (JCheckBox item : items) {
            if (item == null) continue;
            String name = item.getText();
            Integer mkey = item.getMnemonic();
            if (name == null) continue;
            names.add(name);
            mnemonics.add(mkey);
        }
        int size = names.size() + 2;
        String[] nameArray = names.toArray(new String[size]);
        int[] mArray = new int[size];
        boolean[] fixedArray = new boolean[size];
        for (int i = 0; i < names.size(); ++i) {
            Integer ival = (Integer)mnemonics.get(i);
            mArray[i] = ival == null ? 0 : ival;
        }
        nameArray[size - 2] = filterLabel = MacrosArb.get("MACRO_SELECTION_FILTER_LABEL");
        mArray[size - 2] = filterLabel.charAt(filterLabel.indexOf(38) + 1);
        fixedArray[size - 2] = true;
        mArray[size - 1] = 72;
        fixedArray[size - 1] = true;
        MnemonicSolver solver = new MnemonicSolver(nameArray, mArray, fixedArray);
        Collection solution = solver.solve();
        HashMap<String, Integer> mmap = new HashMap<String, Integer>();
        for (MnemonicSolver.MenuLabel label : solution) {
            mmap.put(label.getText(), label.getMnemonic());
        }
        for (int i = 0; i < items.length; ++i) {
            String nameKey;
            if (items[i] == null || (nameKey = items[i].getText()) == null) continue;
            try {
                items[i].setMnemonic((Integer)mmap.get(nameKey));
                continue;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }

    static {
        showOnlyLocationMacros = false;
        excludeContextDependentMacros = false;
    }
}

