/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.macros.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.macros.MacroDefinition;
import oracle.ideimpl.macros.MacrosArb;
import oracle.ideimpl.macros.Scope;
import oracle.ideimpl.macros.UserMacroHandler;
import oracle.ideimpl.macros.ui.MacroCompletionProvider;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.completion.CompletionPopupHandler;
import oracle.javatools.ui.completion.CompletionProvider;
import oracle.javatools.ui.completion.CompletionTextField;

public class UserDefinedMacrosPanel
extends DefaultTraversablePanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private DefaultTableModel macrosModel;
    private List<MacroDefinition> profilesMacros;
    private List<String> macroNames;
    private JTable macrosTable;
    private JButton editButton;
    private JButton newButton;
    private JButton deleteButton;
    private Context context;
    private Map<String, MacroDefinition> definedMacros;
    private MacroTableCellEditor cellEditor;

    public UserDefinedMacrosPanel() {
        this.setHelpID("f1_editrun_user_var_html");
        JLabel macrosLabel = new JLabel();
        this.macrosModel = new DefaultTableModel();
        this.macrosModel.setColumnCount(3);
        this.profilesMacros = new ArrayList<MacroDefinition>();
        this.definedMacros = new HashMap<String, MacroDefinition>();
        this.macroNames = new ArrayList<String>();
        this.macrosTable = new JTable(this.macrosModel);
        this.macrosTable.setTableHeader(null);
        this.macrosTable.setSelectionMode(0);
        this.macrosTable.setShowGrid(false);
        this.cellEditor = new MacroTableCellEditor();
        this.macrosTable.getColumnModel().getColumn(0).setCellEditor(this.cellEditor);
        JScrollPane macrosScrollPane = new JScrollPane(this.macrosTable);
        JViewport viewport = macrosScrollPane.getViewport();
        macrosScrollPane.setOpaque(true);
        viewport.setOpaque(true);
        macrosScrollPane.setBackground(this.macrosTable.getBackground());
        viewport.setBackground(this.macrosTable.getBackground());
        Border border = macrosScrollPane.getBorder();
        if (border == null || border instanceof UIResource) {
            macrosScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        }
        macrosScrollPane.setCorner("LOWER_RIGHT_CORNER", new JPanel());
        this.editButton = new JButton();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        ResourceUtils.resLabel((JLabel)macrosLabel, (Component)this.macrosTable, (String)MacrosArb.get("USER_DEFINED_MACROS"));
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)MacrosArb.get("MACRO_DEFINITIONS_EDIT_BUTTON"));
        ResourceUtils.resButton((AbstractButton)this.newButton, (String)MacrosArb.get("MACRO_DEFINITIONS_NEW_BUTTON"));
        ResourceUtils.resButton((AbstractButton)this.deleteButton, (String)MacrosArb.get("MACRO_DEFINITIONS_DELETE_BUTTON"));
        this.macrosTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                UserDefinedMacrosPanel.this.updateButtons();
            }
        });
        this.editButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.add(macrosLabel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add(macrosScrollPane, new GridBagConstraints(0, 1, 1, 0, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.editButton, new GridBagConstraints(1, 1, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.newButton, new GridBagConstraints(1, 2, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.deleteButton, new GridBagConstraints(1, 3, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
    }

    public void onEntry(TraversableContext tc) {
        ListStructure globalMacros;
        ListStructure workspaceMacros;
        ListStructure projectMacros;
        Object runConfiguration = tc.find("run-configuration");
        Class<?> rcClass = runConfiguration.getClass();
        try {
            Method getContextMethod = rcClass.getMethod("getContext", new Class[0]);
            this.context = (Context)getContextMethod.invoke(runConfiguration, new Object[0]);
        }
        catch (Exception e) {
            System.out.println("UserDefinedMacrosPanel: Error getting context " + e.getMessage());
        }
        if (this.context == null) {
            this.context = Context.newIdeContext();
        }
        if ((projectMacros = UserMacroHandler.getInstance().getProjectMacros(this.context.getProject())) != null) {
            this.loadFrom(projectMacros, true);
        }
        if ((workspaceMacros = UserMacroHandler.getInstance().getWorkspaceMacros(this.context.getWorkspace())) != null) {
            this.loadFrom(workspaceMacros, false);
        }
        if ((globalMacros = UserMacroHandler.getInstance().getGlobalMacros()) != null) {
            this.loadFrom(globalMacros, false);
        }
        this.updateButtons();
    }

    public void onExit(TraversableContext tc) {
        this.cellEditor.cancelCellEditing();
        this.commitTo(tc);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.cellEditor.cancelCellEditing();
        Object source = e.getSource();
        if (source == this.editButton) {
            this.editMacro();
        } else if (source == this.newButton) {
            this.newMacro();
        } else if (source == this.deleteButton) {
            this.deleteMacro();
        }
    }

    private void loadFrom(ListStructure definitionList, boolean clear) {
        int i;
        if (clear) {
            this.profilesMacros.clear();
            this.macroNames.clear();
            for (i = this.macrosModel.getRowCount() - 1; i >= 0; --i) {
                this.macrosModel.removeRow(i);
            }
        }
        for (i = 0; i < definitionList.size(); ++i) {
            MacroDefinition def = new MacroDefinition((HashStructure)definitionList.get(i));
            String name = def.getName();
            this.macrosModel.addRow(new Object[]{def.getName(), def.getDescription(), def.getValue()});
            this.profilesMacros.add(def);
            this.definedMacros.put(name, def);
            this.macroNames.add(name);
        }
    }

    private void commitTo(TraversableContext tc) {
        int size = this.macrosTable.getRowCount();
        MacroDefinition[] macroDefs = this.profilesMacros.toArray(new MacroDefinition[size]);
        ListStructure projectScopedMacros = ListStructure.newInstance();
        ListStructure workspaceScopedMacros = ListStructure.newInstance();
        ListStructure globallyScopedMacros = ListStructure.newInstance();
        block4: for (int i = 0; i < this.macrosModel.getRowCount(); ++i) {
            macroDefs[i].setName((String)this.macrosModel.getValueAt(i, 0));
            macroDefs[i].setDescription((String)this.macrosModel.getValueAt(i, 1));
            macroDefs[i].setValue((String)this.macrosModel.getValueAt(i, 2));
            switch (macroDefs[i].getScope()) {
                default: {
                    projectScopedMacros.add((Object)macroDefs[i].getHash());
                    continue block4;
                }
                case WORKSPACE: {
                    workspaceScopedMacros.add((Object)macroDefs[i].getHash());
                    continue block4;
                }
                case GLOBAL: {
                    globallyScopedMacros.add((Object)macroDefs[i].getHash());
                }
            }
        }
        if (projectScopedMacros.size() > 0) {
            UserMacroHandler.getInstance().setProjectMacros(this.context.getProject(), projectScopedMacros);
        }
        if (workspaceScopedMacros.size() > 0) {
            UserMacroHandler.getInstance().setWorkspaceMacros(this.context.getWorkspace(), workspaceScopedMacros);
        }
        if (globallyScopedMacros.size() > 0) {
            UserMacroHandler.getInstance().setGlobalMacros(globallyScopedMacros);
        }
    }

    private MacroDefinition getSelectedMacro() {
        int index = this.macrosTable.getSelectionModel().getMinSelectionIndex();
        if (index >= 0 && index < this.profilesMacros.size()) {
            return this.profilesMacros.get(index);
        }
        return null;
    }

    private void updateButtons() {
        MacroDefinition macroDefinition = this.getSelectedMacro();
        boolean macroSelected = macroDefinition != null;
        this.editButton.setEnabled(macroSelected);
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)MacrosArb.get("MACRO_DEFINITIONS_EDIT_BUTTON"));
        this.deleteButton.setEnabled(macroSelected);
    }

    private void editMacro() {
        MacroDefinition selected = this.getSelectedMacro();
        if (selected != null) {
            this.editMacroDefinition(selected);
            this.updateButtons();
        }
    }

    private void editMacroDefinition(MacroDefinition macroDefinition) {
        TreeSet<String> usedNames = new TreeSet<String>();
        usedNames.addAll(this.definedMacros.keySet());
        for (int i = this.macroNames.size() - 1; i >= 0; --i) {
            usedNames.add(this.macroNames.get(i));
        }
        MacroDefinitionDialog editMacroDialog = new MacroDefinitionDialog(macroDefinition.getName(), usedNames);
        editMacroDialog.showEditDialog(macroDefinition);
    }

    private void newMacro() {
        TreeSet<String> usedNames = new TreeSet<String>();
        usedNames.addAll(this.definedMacros.keySet());
        for (int i = this.macroNames.size() - 1; i >= 0; --i) {
            usedNames.add(this.macroNames.get(i));
        }
        MacroDefinition macroDefinition = this.getSelectedMacro();
        String name = macroDefinition != null ? macroDefinition.getName() : null;
        MacroDefinitionDialog newDialog = new MacroDefinitionDialog(name, usedNames);
        if ((name = newDialog.showNewDialog()) != null) {
            String profileName;
            int insertRow;
            MacroDefinition newMacroDefinition = new MacroDefinition(name);
            newMacroDefinition.setQualifier("user");
            newMacroDefinition.setDescription(newDialog.getDescription());
            newMacroDefinition.setValue(newDialog.getValue());
            newMacroDefinition.setScope(newDialog.getScope());
            newMacroDefinition.setIsLocation(newDialog.getIsLocation());
            name = newMacroDefinition.getName();
            for (insertRow = 0; insertRow < this.macroNames.size() && (profileName = this.macroNames.get(insertRow)).compareTo(name) <= 0; ++insertRow) {
            }
            if (insertRow < this.macroNames.size()) {
                this.macrosModel.insertRow(insertRow, new Object[]{newMacroDefinition.getName(), newMacroDefinition.getDescription(), newMacroDefinition.getValue()});
                this.profilesMacros.add(insertRow, newMacroDefinition);
                this.macroNames.add(insertRow, newMacroDefinition.getName());
            } else {
                this.macrosModel.addRow(new Object[]{newMacroDefinition.getName(), newMacroDefinition.getDescription(), newMacroDefinition.getValue()});
                this.profilesMacros.add(newMacroDefinition);
                this.macroNames.add(newMacroDefinition.getName());
            }
            this.macrosTable.getSelectionModel().setSelectionInterval(insertRow, insertRow);
            this.updateButtons();
        }
    }

    private void deleteMacro() {
        int index = this.macrosTable.getSelectionModel().getMinSelectionIndex();
        if (index != -1) {
            String name = (String)this.macrosModel.getValueAt(index, 0);
            this.macrosModel.removeRow(index);
            this.profilesMacros.remove(index);
            this.definedMacros.remove(name);
            this.macroNames.remove(index);
            if (index >= this.macrosModel.getRowCount()) {
                --index;
            }
            this.macrosTable.getSelectionModel().setSelectionInterval(index, index);
            this.updateButtons();
        }
    }

    private class MacroTableCellEditor
    extends DefaultCellEditor {
        private Object currentValue;
        private boolean editing;

        MacroTableCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentValue = value;
            this.editing = true;
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            if (!this.editing) {
                return true;
            }
            String newValue = this.getCellEditorValue().toString().trim();
            if (newValue.length() > 0 && (newValue.equals(this.currentValue.toString()) || !UserDefinedMacrosPanel.this.macroNames.contains(newValue))) {
                this.editing = false;
                UserDefinedMacrosPanel.this.macroNames.remove(this.currentValue.toString());
                UserDefinedMacrosPanel.this.macroNames.add(newValue);
                MacroDefinition currentMacro = UserDefinedMacrosPanel.this.getSelectedMacro();
                if (currentMacro != null) {
                    currentMacro.setName(newValue);
                }
                return super.stopCellEditing();
            }
            return false;
        }

        @Override
        public void cancelCellEditing() {
            if (this.editing) {
                this.editing = false;
                super.cancelCellEditing();
            }
        }
    }

    class MacroDefinitionDialog
    extends JPanel
    implements DocumentListener {
        private JTextField nameTextField;
        private JTextField descriptionTextField;
        private CompletionTextField valueTextField;
        private JComboBox scopeCombo;
        private JCheckBox isLocation;
        private JEWTDialog dlg;
        private Set usedNames;

        MacroDefinitionDialog(String name, Set usedNames) {
            super(new GridBagLayout());
            this.usedNames = usedNames;
            if (name != null && this.usedNames.contains(name)) {
                this.usedNames.remove(name);
            }
            JLabel nameLabel = new JLabel();
            this.nameTextField = new JTextField();
            JLabel descriptionLabel = new JLabel();
            this.descriptionTextField = new JTextField();
            JLabel valueLabel = new JLabel();
            this.valueTextField = new CompletionTextField();
            CompletionPopupHandler popupHandler = this.valueTextField.getPopupHandler();
            Context context = Context.newIdeContext();
            MacroCompletionProvider macroCompletionProvider = new MacroCompletionProvider(context);
            popupHandler.registerInsightProvider((CompletionProvider)macroCompletionProvider);
            JLabel scopeLabel = new JLabel();
            this.scopeCombo = new JComboBox();
            this.scopeCombo.addItem(MacrosArb.get("MACRO_SCOPE_PROJECT"));
            this.scopeCombo.addItem(MacrosArb.get("MACRO_SCOPE_WORKSPACE"));
            this.scopeCombo.addItem(MacrosArb.get("MACRO_SCOPE_GLOBAL"));
            this.scopeCombo.setSelectedIndex(0);
            this.isLocation = new JCheckBox();
            ResourceUtils.resLabel((JLabel)nameLabel, (Component)this.nameTextField, (String)MacrosArb.get("EDIT_MACRO_DEF_NAME_LABEL"));
            ResourceUtils.resLabel((JLabel)descriptionLabel, (Component)this.descriptionTextField, (String)MacrosArb.get("EDIT_MACRO_DEF_DESCRIPTION_LABEL"));
            ResourceUtils.resLabel((JLabel)valueLabel, (Component)this.valueTextField, (String)MacrosArb.get("EDIT_MACRO_DEF_VALUE_LABEL"));
            ResourceUtils.resLabel((JLabel)scopeLabel, (Component)this.scopeCombo, (String)MacrosArb.get("EDIT_MACRO_DEF_SCOPE_LABEL"));
            ResourceUtils.resButton((AbstractButton)this.isLocation, (String)MacrosArb.get("MACRO_PATH_EXPRESSION_CHECKBOX_LABEL"));
            this.nameTextField.getDocument().addDocumentListener(this);
            this.descriptionTextField.getDocument().addDocumentListener(this);
            this.valueTextField.getDocument().addDocumentListener(this);
            int y = 0;
            this.add((Component)nameLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.nameTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)descriptionLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.descriptionTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)valueLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.valueTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)scopeLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.scopeCombo, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)this.isLocation, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        String showNewDialog() {
            String title = MacrosArb.get("NEW_MACRO_DIALOG_TITLE");
            JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.nameTextField, (String)title);
            this.setJEWTDialog(dlg);
            dlg.setOKButtonEnabled(this.canOk());
            UserDefinedMacrosPanel.this.setHelpID("f1_editrun_new_userdef_macro_html");
            if (WizardLauncher.runDialog((JDialog)dlg)) {
                return this.getNewName();
            }
            return null;
        }

        void showEditDialog(MacroDefinition macroDef) {
            String title = MacrosArb.get("EDIT_MACRO_DIALOG_TITLE");
            JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.nameTextField, (String)title);
            this.setJEWTDialog(dlg);
            UserDefinedMacrosPanel.this.setHelpID("f1_editrun_edit_userdef_macro_html");
            this.nameTextField.setText(macroDef.getName());
            this.descriptionTextField.setText(macroDef.getDescription());
            this.valueTextField.setText(macroDef.getValue());
            switch (macroDef.getScope()) {
                case PROJECT: {
                    this.scopeCombo.setSelectedItem(MacrosArb.get("MACRO_SCOPE_PROJECT"));
                    break;
                }
                case WORKSPACE: {
                    this.scopeCombo.setSelectedItem(MacrosArb.get("MACRO_SCOPE_WORKSPACE"));
                    break;
                }
                case GLOBAL: {
                    this.scopeCombo.setSelectedItem(MacrosArb.get("MACRO_SCOPE_GLOBAL"));
                }
            }
            this.isLocation.setSelected(macroDef.isLocation());
            dlg.setOKButtonEnabled(this.canOk());
            if (WizardLauncher.runDialog((JDialog)dlg)) {
                macroDef.setName(this.nameTextField.getText());
                macroDef.setDescription(this.descriptionTextField.getText());
                macroDef.setValue(this.valueTextField.getText());
                macroDef.setScope(this.getScope());
                macroDef.setIsLocation(this.isLocation.isSelected());
                return;
            }
        }

        String getDescription() {
            return this.descriptionTextField.getText();
        }

        String getValue() {
            return this.valueTextField.getText();
        }

        boolean getIsLocation() {
            return this.isLocation.isSelected();
        }

        Scope getScope() {
            if (this.scopeCombo.getSelectedItem().equals(MacrosArb.get("MACRO_SCOPE_PROJECT"))) {
                return Scope.PROJECT;
            }
            if (this.scopeCombo.getSelectedItem().equals(MacrosArb.get("MACRO_SCOPE_WORKSPACE"))) {
                return Scope.WORKSPACE;
            }
            if (this.scopeCombo.getSelectedItem().equals(MacrosArb.get("MACRO_SCOPE_GLOBAL"))) {
                return Scope.GLOBAL;
            }
            return Scope.PROJECT;
        }

        private void setJEWTDialog(JEWTDialog dlg) {
            this.dlg = dlg;
            dlg.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && MacroDefinitionDialog.this.veto()) {
                        throw new PropertyVetoException("no", evt);
                    }
                }
            });
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            this.dlg.setOKButtonEnabled(this.canOk());
        }

        private boolean canOk() {
            return this.nameTextField.getText().length() > 0 && this.descriptionTextField.getText().length() > 0 && this.valueTextField.getText().length() > 0;
        }

        private boolean veto() {
            String name = this.nameTextField.getText();
            if (this.usedNames.contains(name)) {
                MessageDialog.error((Component)this, (Object)MacrosArb.format("NEW_MACRO_NAME_DUPLICATE_MESSAGE", name), (String)MacrosArb.format("NEW_MACRO_NAME_DUPLICATE_TITLE", this.dlg.getTitle()), null);
                return true;
            }
            return false;
        }

        private String getNewName() {
            return this.nameTextField.getText();
        }
    }
}

