/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.AbstractIdeContextPlugin;
import oracle.diagram.core.editor.Diagram;
import oracle.diagram.framework.editor.IdeDiagramEditor;
import oracle.diagram.framework.graphic.DiagramRenderingHints;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.EditorContextMenuProvider;
import oracle.dmt.dataminer.controls.ClipboardImp;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.RefreshController;
import oracle.dmt.dataminer.navigator.RefreshInterface;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.repository.WorkflowJob;
import oracle.dmt.dataminer.repository.WorkflowJobNode;
import oracle.dmt.dataminer.runner.RunManager;
import oracle.dmt.dataminer.runner.RunManagerEvent;
import oracle.dmt.dataminer.runner.RunManagerListener;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;

public abstract class DataMinerDiagramEditor
extends IdeDiagramEditor
implements EditorContextMenuProvider,
RunManagerListener,
RefreshInterface {
    private static final Logger theLogger = Logger.getLogger(DataMinerDiagramEditor.class.getName());
    public static final float IMAGE_INSET = 20.0f;
    private boolean needsRefresh = false;
    private String nodeId = "";
    private String workflowId = "";
    private boolean cancelRefresh = false;
    private BaseTreeNode _projectFolder = null;
    private BaseTreeNode _connectionFolder = null;
    private BaseTreeNode _connectionsFolder = null;
    private WorkflowNode _wfNode = null;
    private BaseTreeNode _selfNode = null;

    public DataMinerDiagramEditor(Diagram diagram) {
        super(diagram);
        RefreshController.getInstance().registerListener(this);
    }

    @Override
    public void setParentNodeId(String string) {
        this.nodeId = string;
    }

    @Override
    public String getParentNodeId() {
        return this.nodeId;
    }

    @Override
    public void setWorkflowId(String string) {
        this.workflowId = string;
    }

    @Override
    public String getWorkflowId() {
        return this.workflowId;
    }

    @Override
    public boolean getCancelRefresh() {
        return this.cancelRefresh;
    }

    @Override
    public void setCancelRefresh(boolean bl) {
        this.cancelRefresh = bl;
    }

    @Override
    public void setNeedsRefresh(boolean bl) {
        this.needsRefresh = bl;
    }

    @Override
    public void jobChanged(RunManagerEvent runManagerEvent) {
    }

    @Override
    public void jobRemoved(RunManagerEvent runManagerEvent) {
    }

    @Override
    public void jobAdded(RunManagerEvent runManagerEvent) {
    }

    @Override
    public void jobFinished(RunManagerEvent runManagerEvent) {
        WorkflowJob workflowJob = runManagerEvent.getJob();
        WorkflowJobNode.SubNode subNode = this.getJobSubNode(workflowJob);
        if (subNode != null && subNode.getStatus().equals("SUCCEEDED")) {
            this.verifyRefresh(true);
        }
    }

    @Override
    public void jobsListenerInitialized() {
    }

    @Override
    public void connectionLost(RunManagerEvent runManagerEvent) {
    }

    @Override
    public void connectionReestablished(RunManagerEvent runManagerEvent) {
    }

    private WorkflowJobNode.SubNode getJobSubNode(WorkflowJob workflowJob) {
        Object object;
        WorkflowJobNode workflowJobNode;
        BaseTreeNode baseTreeNode;
        String string;
        Node node = this._context.getNode();
        WorkflowJobNode.SubNode subNode = null;
        if (node instanceof BaseTreeNode && (string = DataMinerEditor.getBuildNodeId(baseTreeNode = (BaseTreeNode)node)) != null && (workflowJobNode = workflowJob.getNodes().get(string)) != null && (object = baseTreeNode.getRepositoryData()) instanceof ModelType) {
            ModelType modelType = (ModelType)object;
            subNode = workflowJobNode.getSubNode(modelType.getId());
        }
        return subNode;
    }

    @Override
    public void setEditorDirty() {
        this.needsRefresh = true;
    }

    protected void shownImpl(boolean bl) {
        Node node;
        super.shownImpl(bl);
        if (this.getContext() != null && this.getContext().getNode() != null && (node = this.getContext().getNode()) instanceof BaseTreeNode) {
            BaseTreeNode baseTreeNode = (BaseTreeNode)node;
            String string = DataMinerEditor.getBuildNodeId(baseTreeNode);
            if (string != null) {
                this.setParentNodeId(string);
            }
            if (baseTreeNode.getRepositoryData() instanceof Workflow) {
                Workflow workflow = (Workflow)baseTreeNode.getRepositoryData();
                this.setWorkflowId(workflow.getId().toString());
            }
        }
        if (this.needsRefresh) {
            this.refresh();
        }
    }

    @Override
    public boolean verifyRefresh(boolean bl) {
        boolean bl2 = false;
        if (bl) {
            this.needsRefresh = true;
        }
        this.setCancelRefresh(false);
        if (this.getGUI() != null && this.getGUI().isShowing()) {
            this.refresh();
            bl2 = true;
            if (!this.getCancelRefresh()) {
                RefreshController.getInstance().forceRefreshInAllViewers(this.getWorkflowId());
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        WorkflowNode workflowNode = WorkflowNode.findParentWorkflowNode(this.getContext());
        Object object = workflowNode.getRepositoryDataReadLock();
        synchronized (object) {
            this.needsRefresh = false;
        }
    }

    public static void CopyEditorToClipboard(IlvManagerView ilvManagerView) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IlvManager ilvManager = ilvManagerView.getManager();
            IlvRect ilvRect = DataMinerDiagramEditor.getViewExtent(ilvManagerView);
            ilvRect.expand(1.0f);
            ilvRect.x = (float)Math.floor((double)ilvRect.x + 0.5);
            ilvRect.y = (float)Math.floor((double)ilvRect.y + 0.5);
            ilvRect.width = (float)Math.floor((double)ilvRect.width + 0.5);
            ilvRect.height = (float)Math.floor((double)ilvRect.height + 0.5);
            DataMinerDiagramEditor.doImageIO(ilvManagerView, byteArrayOutputStream, ilvRect);
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            ClipboardImp clipboardImp = new ClipboardImp(bufferedImage);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void closeImpl(boolean bl) {
        super.closeImpl(bl);
        BaseTreeNode baseTreeNode = (BaseTreeNode)this.getContext().getNode();
        try {
            baseTreeNode.close();
        }
        catch (IOException iOException) {
            theLogger.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        AddinManager addinManager = AddinManager.getAddinManager();
        RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        String string = connectionFolder.getConnectionName();
        runManager.removeListener(this, string);
        RefreshController.getInstance().unregisterListener(this);
        this.attach(false);
    }

    public void openImpl(boolean bl) throws OpenAbortedException {
        super.openImpl(bl);
        BaseTreeNode baseTreeNode = (BaseTreeNode)this.getContext().getNode();
        if (baseTreeNode != null && !baseTreeNode.isOpen() && baseTreeNode instanceof WorkflowNode) {
            baseTreeNode.ensureOpen();
        }
        if (!(this instanceof WorkflowEditor)) {
            AddinManager addinManager = AddinManager.getAddinManager();
            RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
            String string = connectionFolder.getConnectionName();
            runManager.addListener(this, string);
        }
        this.attach(true);
    }

    private void attach(boolean bl) {
        Context context = this.getContext();
        if (bl) {
            this._selfNode = (BaseTreeNode)context.getNode();
            TNode tNode = this._selfNode.getParent();
            this._wfNode = (WorkflowNode)tNode.getAncestor(WorkflowNode.class);
            this._projectFolder = (BaseTreeNode)tNode.getAncestor(ProjectFolder.class, true);
            this._connectionFolder = (BaseTreeNode)tNode.getAncestor(ConnectionFolder.class, true);
            this._connectionsFolder = (BaseTreeNode)tNode.getAncestor(Connections.class, true);
            this._selfNode.attach((Observer)this);
            if (this._wfNode != null) {
                this._wfNode.attach((Observer)this);
            }
            this._projectFolder.attach((Observer)this);
            this._connectionFolder.attach((Observer)this);
            this._connectionsFolder.attach((Observer)this);
        } else {
            if (this._selfNode != null) {
                this._selfNode.detach((Observer)this);
                this._selfNode = null;
            }
            if (this._wfNode != null) {
                this._wfNode.detach((Observer)this);
                this._wfNode = null;
            }
            if (this._projectFolder != null) {
                this._projectFolder.detach((Observer)this);
                this._projectFolder = null;
            }
            if (this._connectionFolder != null) {
                this._connectionFolder.detach((Observer)this);
                this._connectionFolder = null;
            }
            if (this._connectionsFolder != null) {
                this._connectionsFolder.detach((Observer)this);
                this._connectionsFolder = null;
            }
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        Context context = this.getContext();
        if (updateMessage.getMessageID() == UpdateMessage.CHILD_REMOVED) {
            List list = updateMessage.getRemoveObjects();
            if (list.contains(this._wfNode) || list.contains(this._selfNode) || list.contains(this._connectionFolder) || list.contains(this._projectFolder) || list.contains(this._connectionsFolder)) {
                this.closeEditor();
            }
        } else if (updateMessage.getMessageID() == UpdateMessage.OBJECT_CLOSED) {
            if (object == this._connectionFolder) {
                this.closeEditor();
            }
        } else if (updateMessage.getMessageID() == UpdateMessage.CONTENT_MODIFIED) {
            if (object != context.getNode()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataMinerDiagramEditor.this.refresh();
                }
            });
        }
    }

    public void closeEditor() {
        DataMinerDiagramEditor dataMinerDiagramEditor = this;
        SwingUtilities.invokeLater(new Runnable((Editor)dataMinerDiagramEditor){
            final /* synthetic */ Editor val$thisEditor;
            {
                this.val$thisEditor = editor;
            }

            @Override
            public void run() {
                EditorManager editorManager = EditorManager.getEditorManager();
                editorManager.closeEditors(Collections.singletonList(this.val$thisEditor));
            }
        });
    }

    protected void abortOpen(Node node, String string) {
        this.abortOpen(node, string, null);
    }

    protected void abortOpen(Node node, Exception exception) {
        this.abortOpen(node, null, exception);
    }

    protected void abortOpen(Node node) {
        this.abortOpen(node, null, null);
    }

    private void abortOpen(Node node, String string, Exception exception) throws OpenAbortedException {
        try {
            node.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (exception != null) {
            throw new OpenAbortedException(exception.getMessage(), exception.getCause());
        }
        if (string != null) {
            throw new OpenAbortedException(string);
        }
        throw new OpenAbortedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doImageIO(IlvManagerView ilvManagerView, OutputStream outputStream, IlvRect ilvRect) throws Exception {
        IlvRect ilvRect2 = new IlvRect(0.0f, 0.0f, (float)ilvRect.widthFloor() + 40.0f, (float)ilvRect.heightFloor() + 40.0f);
        BufferedImage bufferedImage = new BufferedImage(ilvRect2.widthFloor(), ilvRect2.heightFloor(), 4);
        try {
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics().create();
            HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
            hashMap.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            hashMap.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            hashMap.put(DiagramRenderingHints.PUBLISH_RENDERING_HINT, Boolean.TRUE);
            graphics2D.setRenderingHints(new RenderingHints(hashMap));
            graphics2D.setColor(Color.white);
            graphics2D.fill((Shape)ilvRect2);
            graphics2D.translate(-1.0f * ilvRect.x + 20.0f, -1.0f * ilvRect.y + 20.0f);
            graphics2D.setClip((Shape)ilvRect);
            IlvManager ilvManager = ilvManagerView.getManager();
            ilvManager.initReDraws();
            int n = ilvManagerView.getRedrawMode();
            try {
                ilvManager.invalidateRegion(ilvRect);
            }
            finally {
                try {
                    ilvManagerView.setRedrawMode(1);
                    ilvManager.reDrawViews();
                }
                finally {
                    ilvManagerView.setRedrawMode(n);
                }
            }
            ilvManagerView.paint((Graphics)graphics2D);
            graphics2D.dispose();
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedImage != null) {
                bufferedImage.flush();
            }
        }
        return true;
    }

    private static IlvRect getViewExtent(IlvManagerView ilvManagerView) {
        IlvRect ilvRect = null;
        IlvManager ilvManager = ilvManagerView.getManager();
        IlvTransformer ilvTransformer = ilvManager.getDrawingTransformer(ilvManagerView);
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getObjects();
        IlvGraphic ilvGraphic = null;
        while (ilvGraphicEnumeration.hasMoreElements()) {
            ilvGraphic = ilvGraphicEnumeration.nextElement();
            if (!ilvGraphic.isVisible()) continue;
            IlvRect ilvRect2 = ilvGraphic.boundingBox();
            if (ilvRect == null) {
                ilvRect = ilvRect2;
                continue;
            }
            ilvRect.add(ilvRect2);
        }
        if (ilvRect == null) {
            ilvRect = new IlvRect();
        }
        if (ilvTransformer != null && !ilvRect.isEmpty()) {
            ilvTransformer.apply(ilvRect);
        }
        return ilvRect;
    }

    public class DiagramIdeContextPlugin
    extends AbstractIdeContextPlugin {
        Context context;

        public DiagramIdeContextPlugin(Context context) {
            this.context = context;
        }

        public Context getContext() {
            return this.context;
        }
    }
}

