/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.aeditor.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.aeditor.dialog.DialogState;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.ide.Ide;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public abstract class BaseDialogPanel
extends JPanel {
    private JDialog _parentDlg;
    private TraversableContext _trvContext;

    public BaseDialogPanel(TraversableContext traversableContext) {
        this._trvContext = traversableContext;
    }

    public abstract void processInput();

    public void getIgnoredSettingsList() {
    }

    protected TraversableContext getTraversableContext() {
        return this._trvContext;
    }

    protected DialogState getDialogState() {
        if (this._trvContext == null) {
            return null;
        }
        return (DialogState)this._trvContext.get("dialogBoxState");
    }

    protected final void setLoaded(boolean bl) {
        if (this._trvContext == null) {
            return;
        }
        this._trvContext.put("dialogStateLoaded", (Object)bl);
    }

    public boolean isLoaded() {
        if (this._trvContext == null) {
            return false;
        }
        Boolean bl = (Boolean)this._trvContext.get("dialogStateLoaded");
        return bl;
    }

    public void initializeFromState(DialogState dialogState) {
    }

    public void tabSelected() {
    }

    protected boolean isNewDataInput(boolean bl) throws ValidationException {
        return false;
    }

    protected LoadingStatusPanel createLoadingStatusPanel() {
        return new LoadingStatusPanel();
    }

    public void setParentDlg(JDialog jDialog) {
        this._parentDlg = jDialog;
    }

    public JDialog getParentDlg() {
        return this._parentDlg;
    }

    protected class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        private String _errorLoadingTitle;
        private String _errorLoadingMsg;

        public LoadUI(String string, String string2) {
            this._errorLoadingTitle = string;
            this._errorLoadingMsg = string2;
        }

        protected Object doInBackground() throws Exception {
            DialogState dialogState = BaseDialogPanel.this.getDialogState();
            try {
                dialogState.load();
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return dialogState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            block6: {
                super.done();
                try {
                    if (this._success && this._ex == null) {
                        BaseDialogPanel.this.initializeFromState(BaseDialogPanel.this.getDialogState());
                        BaseDialogPanel.this.setLoaded(true);
                        break block6;
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)this._errorLoadingTitle, (String)this._errorLoadingMsg, null);
                        break block6;
                    }
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)this._errorLoadingMsg, (String)this._errorLoadingTitle, null);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)this._errorLoadingTitle, (String)this._errorLoadingMsg, null);
                }
            }
        }
    }

    protected class LoadingStatusPanel
    extends JPanel {
        private LoadingStatusPanel() {
            JLabel jLabel = new JLabel();
            jLabel.setHorizontalAlignment(0);
            ResourceUtils.resLabel((JLabel)jLabel, null, (String)DialogsLrb.get("LOADING_STATUS"));
            this.setLayout(new BorderLayout());
            this.add((Component)jLabel, "Center");
        }
    }
}

