/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.aeditor.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.aeditor.dialog.BaseDialogPanel;
import oracle.dmt.dataminer.aeditor.dialog.CompareTestResultsFlatState;
import oracle.dmt.dataminer.aeditor.dialog.DialogState;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.CheckBoxTableListener;
import oracle.dmt.dataminer.controls.CheckedItemData;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.renderers.DateCellRenderer2;
import oracle.dmt.dataminer.controls.renderers.LabeledCheckBoxRenderer;
import oracle.dmt.dataminer.repository.Result;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.ui.ColorIcon;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class CompareTestResultsFlatPanel
extends BaseDialogPanel
implements ActionListener {
    private CompareTestResultsFlatState state;
    private JLabel jLblCompareTo;
    private JLabel jLblSelResultName;
    private JPanel jPanelResults;
    private JScrollPane jScrollPaneResults;
    private JScrollPane jScrollPaneTitle;
    private DataMinerTable resultsTable;
    private JMultiLineLabel jDescription = new JMultiLineLabel();
    private CheckBoxRenderer tableCellRenderer = new CheckBoxRenderer();
    private CheckListener tableListener = new CheckListener(this.tableCellRenderer);
    private BaseDialogPanel.LoadingStatusPanel loadingPanel;
    private static final int COLUMN_COUNT = 2;
    private static final int _RESULT_NAME = 0;
    private static final int _BUILT_ON = 1;
    private static String[] columnNames = new String[]{DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TABLE_COL_MODEL"), DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TABLE_COL_BUILT_ON")};

    public CompareTestResultsFlatPanel(TraversableContext traversableContext) {
        super(traversableContext);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jScrollPaneTitle = new JScrollPane();
        this.jLblCompareTo = new JLabel();
        this.jLblSelResultName = new JLabel();
        this.jPanelResults = new JPanel();
        this.jScrollPaneResults = new JScrollPane();
        this.resultsTable = new DataMinerTable();
        this.jScrollPaneTitle.setBorder(null);
        this.jScrollPaneTitle.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneTitle.setVerticalScrollBarPolicy(21);
        this.jLblCompareTo.setText("Compare results relative to:");
        this.jLblSelResultName.setText("Selected Result Name");
        this.resultsTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPaneResults.setViewportView((Component)((Object)this.resultsTable));
        GroupLayout groupLayout = new GroupLayout(this.jPanelResults);
        this.jPanelResults.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneResults, -1, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneResults, -1, 150, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneTitle, -1, 410, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jLblCompareTo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLblSelResultName, -2, 102, -2).addGap(11, 11, 11)))).addGroup(groupLayout2.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jPanelResults, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -1, 43, Short.MAX_VALUE).addGap(15, 15, 15).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblCompareTo).addComponent(this.jLblSelResultName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelResults, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void setComponentsVisible(boolean bl) {
        this.jLblCompareTo.setVisible(bl);
        this.jLblSelResultName.setVisible(bl);
        this.jDescription.setVisible(bl);
        if (!bl) {
            this.loadingPanel = this.createLoadingStatusPanel();
            GroupLayout groupLayout = new GroupLayout(this.jPanelResults);
            this.jPanelResults.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loadingPanel, GroupLayout.Alignment.TRAILING, -1, 342, Short.MAX_VALUE));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loadingPanel, GroupLayout.Alignment.TRAILING, -1, 184, Short.MAX_VALUE));
        } else {
            GroupLayout groupLayout = new GroupLayout(this.jPanelResults);
            this.jPanelResults.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneResults, GroupLayout.Alignment.TRAILING, -1, 342, Short.MAX_VALUE));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneResults, GroupLayout.Alignment.TRAILING, -1, 184, Short.MAX_VALUE));
        }
        this.loadingPanel.setVisible(!bl);
        this.jScrollPaneResults.setVisible(bl);
    }

    private void loadDescription() {
        this.jDescription.setText(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_HEADER_DESCRIPTION"));
        this.jScrollPaneTitle.getViewport().add((Component)this.jDescription);
    }

    private void initRes() {
        this.loadDescription();
        ResourceUtils.resLabel((JLabel)this.jLblCompareTo, null, (String)DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_COMPARE_TO"));
    }

    private void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"edit_test_selection_compare");
        this.setComponentsVisible(false);
        BaseDialogPanel.LoadUI loadUI = new BaseDialogPanel.LoadUI(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_ERROR_LOADING_TITLE"), DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_ERROR_LOADING_MSG"));
        loadUI.execute();
    }

    @Override
    public void initializeFromState(DialogState dialogState) {
        this.state = this.getState();
        this.initTable(this.state);
        this.setComponentsVisible(true);
        if (this.state.isInitialMultipleSelection()) {
            this.jLblCompareTo.setVisible(false);
            this.jLblSelResultName.setVisible(false);
        } else {
            ResourceUtils.resLabel((JLabel)this.jLblSelResultName, null, (String)this.getState().getSelectedResultName());
        }
    }

    private void setupTable(ModelTestResults modelTestResults) {
        this.resultsTable.setModel((TableModel)((Object)modelTestResults));
        this.resultsTable.setSorted(true);
        this.resultsTable.setUpdateSelectionOnSort(true);
        this.resultsTable.getTableHeader().setReorderingAllowed(false);
        TableColumn tableColumn = this.resultsTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(this.tableCellRenderer);
        tableColumn = this.resultsTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new DateCellRenderer2());
    }

    private void initTable(CompareTestResultsFlatState compareTestResultsFlatState) {
        ModelTestResults modelTestResults = new ModelTestResults(compareTestResultsFlatState.getLatestCompatiableTestResults());
        this.resultsTable.addMouseListener(this.tableListener);
        this.resultsTable.addKeyListener(this.tableListener);
        this.setupTable(modelTestResults);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JCheckBox) {
            ModelTestResults modelTestResults = new ModelTestResults(this.getState().getLatestCompatiableTestResults());
            this.setupTable(modelTestResults);
        }
    }

    protected final CompareTestResultsFlatState getState() {
        return (CompareTestResultsFlatState)super.getDialogState();
    }

    @Override
    public void processInput() {
        ModelTestResults modelTestResults = (ModelTestResults)((Object)this.resultsTable.getModel());
        List list = modelTestResults.getSelectedTestResults();
        if (list == null || list.isEmpty() || list.size() < 1) {
            this.getState().setValidationError(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_ERROR_MSG"));
        } else {
            this.getState().setSelectedTestResults(list);
        }
    }

    class CheckBoxRenderer
    extends LabeledCheckBoxRenderer {
        @Override
        protected Icon getCellIcon(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ColumnData columnData = (ColumnData)object;
            Result result = (Result)columnData.getData();
            Color color = CompareTestResultsFlatPanel.this.state.getParentTestViewerState().getTestResultGraphColor(result.getModelName());
            return new ColorIcon(color);
        }
    }

    class ModelTestResults
    extends GenericBaseTableModel {
        private List<ColumnData> data = new ArrayList<ColumnData>();

        private List<TestResult> getSelectedTestResults() {
            ArrayList<TestResult> arrayList = new ArrayList<TestResult>();
            for (ColumnData columnData : this.data) {
                TestResult testResult = (TestResult)columnData.getData();
                if (!CompareTestResultsFlatPanel.this.getState().isSelected(testResult)) continue;
                arrayList.add(testResult);
            }
            return arrayList;
        }

        private void determineState(List<TestResult> list) {
            for (TestResult testResult : list) {
                ColumnData columnData = new ColumnData(testResult);
                if (CompareTestResultsFlatPanel.this.getState().isSelected(testResult)) {
                    columnData.setCheckBoxState(TriStateBoolean.TRUE);
                }
                this.data.add(columnData);
            }
        }

        private ModelTestResults(List<TestResult> list) {
            this.determineState(list);
            this.setColumnIdentifiers(columnNames);
            this.setRowCount(this.data.size());
            this.setColumnCount(2);
        }

        public void reload(List<TestResult> list) {
            this.data.clear();
            this.determineState(list);
            this.setRowCount(this.data.size());
            this.fireTableDataChanged();
        }

        private TestResult getTestResult(int n) {
            ColumnData columnData = this.data.get(n);
            TestResult testResult = (TestResult)columnData.getData();
            return testResult;
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ColumnData columnData = this.data.get(n);
            Object object = null;
            TestResult testResult = (TestResult)columnData.getData();
            switch (n2) {
                case 0: {
                    object = columnData;
                    break;
                }
                case 1: {
                    object = testResult.getCreationTime();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }
    }

    private class CheckListener
    extends CheckBoxTableListener {
        public CheckListener(LabeledCheckBoxRenderer labeledCheckBoxRenderer) {
            super(labeledCheckBoxRenderer);
        }

        @Override
        protected void itemChecked(int n) {
            ModelTestResults modelTestResults = (ModelTestResults)((Object)CompareTestResultsFlatPanel.this.resultsTable.getModel());
            TestResult testResult = modelTestResults.getTestResult(n);
            CompareTestResultsFlatPanel.this.getState().selectTestResult(testResult, true);
        }

        @Override
        public void itemUnchecked(int n) {
            ModelTestResults modelTestResults = (ModelTestResults)((Object)CompareTestResultsFlatPanel.this.resultsTable.getModel());
            TestResult testResult = modelTestResults.getTestResult(n);
            CompareTestResultsFlatPanel.this.getState().selectTestResult(testResult, false);
        }
    }

    class ColumnData
    extends CheckedItemData {
        public ColumnData(TestResult testResult) {
            super(testResult);
        }

        @Override
        public String toString() {
            return ((TestResult)this.getData()).toString();
        }
    }
}

