/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.aeditor.dialog;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.aeditor.dialog.DialogState;
import oracle.dmt.dataminer.repository.Activity;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.ide.Context;

public class CompareTestResultsFlatState
implements DialogState {
    private Activity _activity;
    private Context _context;
    private String _validationError;
    private boolean _bLoaded;
    private SharedTestEditorState _parentTestViewerState;
    private final boolean _initialMultipleSelection;
    private List<TestResult> _checkedTestResults;
    private List<TestResult> _selectedTestResults;
    private Hashtable<String, Boolean> _selectedMap;
    private List<TestResult> _allComaptibleTestResults;
    private List<TestResult> _latestComaptibleTestResults;
    private String _selectedTargetName = null;

    public CompareTestResultsFlatState(SharedTestEditorState sharedTestEditorState, Context context, Activity activity, List<TestResult> list, List<TestResult> list2) {
        this._parentTestViewerState = sharedTestEditorState;
        this._context = context;
        this._activity = activity;
        this._checkedTestResults = list2;
        this._selectedMap = new Hashtable();
        for (TestResult testResult : this._checkedTestResults) {
            this._selectedMap.put(testResult.getResultName(), Boolean.TRUE);
        }
        this._initialMultipleSelection = this._checkedTestResults.size() > 1;
        this._allComaptibleTestResults = list;
        this._latestComaptibleTestResults = list;
    }

    void selectTestResult(TestResult testResult, boolean bl) {
        this._selectedMap.put(testResult.getResultName(), bl);
    }

    boolean isSelected(TestResult testResult) {
        Boolean bl = this._selectedMap.get(testResult.getResultName());
        return bl != null ? bl : false;
    }

    void setSelectedTestResults(List<TestResult> list) {
        this._selectedTestResults = list;
    }

    String getSelectedTargetName() {
        if (this._selectedTargetName == null) {
            this._selectedTargetName = this._checkedTestResults.get(0) != null ? this._checkedTestResults.get(0).getColumnName() : "";
        }
        return this._selectedTargetName;
    }

    String getSelectedResultName() {
        return this._checkedTestResults.get(0) != null ? this._checkedTestResults.get(0).getResultName() : "";
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    @Override
    public void validate() throws ValidationException {
        if (this._validationError != null) {
            throw new ValidationException(this._validationError);
        }
    }

    @Override
    public void clear() {
        this._validationError = null;
        if (this._selectedTestResults != null) {
            this._selectedTestResults.clear();
        }
    }

    void setValidationError(String string) {
        this._validationError = string;
    }

    @Override
    public boolean isModified() {
        return true;
    }

    @Override
    public Object getUserObject() {
        return this._selectedTestResults;
    }

    @Override
    public boolean confirm(Component component) {
        return true;
    }

    @Override
    public void finish() {
    }

    List<TestResult> getArchievedTestResults() {
        assert (this._bLoaded) : "Accesing state prior to loading.";
        return this._allComaptibleTestResults;
    }

    @Override
    public void load() throws Exception {
    }

    boolean isInitialMultipleSelection() {
        return this._initialMultipleSelection;
    }

    List<TestResult> getLatestCompatiableTestResults() {
        if (this._latestComaptibleTestResults == null) {
            this._latestComaptibleTestResults = new ArrayList<TestResult>();
            List<TestResult> list = this._activity.getLatestTestResults();
            for (TestResult testResult : list) {
                String string = testResult.getColumnName();
                if (0 != string.compareTo(this.getSelectedTargetName())) continue;
                this._latestComaptibleTestResults.add(testResult);
            }
        }
        return this._latestComaptibleTestResults;
    }

    public SharedTestEditorState getParentTestViewerState() {
        return this._parentTestViewerState;
    }
}

