/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClipboardImp
implements ClipboardOwner {
    private static final Logger theLogger = Logger.getLogger(ClipboardImp.class.getName());

    public ClipboardImp(Image image) {
        try {
            TransferableImage transferableImage = new TransferableImage(image);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(transferableImage, this);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public ClipboardImp(String string) {
        try {
            TransferableHTML transferableHTML = new TransferableHTML(string);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(transferableHTML, this);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        theLogger.log(Level.FINE, "Lost Clipboard Ownership");
    }

    private class TransferableHTML
    implements Transferable {
        String html;

        public TransferableHTML(String string) {
            this.html = string;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[3];
            try {
                dataFlavorArray[0] = new DataFlavor("text/html;class=java.lang.String");
                dataFlavorArray[1] = new DataFlavor("text/html;class=java.io.Reader");
                dataFlavorArray[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavor.equals(dataFlavorArray[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return this.html;
        }
    }

    private class TransferableImage
    implements Transferable {
        Image i;

        public TransferableImage(Image image) {
            this.i = image;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(DataFlavor.imageFlavor) && this.i != null) {
                return this.i;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.imageFlavor};
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavor.equals(dataFlavorArray[i])) continue;
                return true;
            }
            return false;
        }
    }
}

