/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.utils.CommentValidator;
import oracle.ide.Context;
import oracle.javatools.ui.ExtendedTextField;

public class CommentTextFieldEditor
extends DefaultCellEditor {
    private static int MAX_LENGTH = 4000;
    private transient TextFieldLimit txtDoc = new TextFieldLimit(MAX_LENGTH);
    private transient ExtendedTextField tf;
    private transient Context context;
    private boolean requireValidation = true;
    private boolean validated;

    public CommentTextFieldEditor(Context context) {
        super((JTextField)new ExtendedTextField());
        this.context = context;
        this.tf = (ExtendedTextField)this.getComponent();
        this.tf.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent jComponent) {
                ExtendedTextField extendedTextField = (ExtendedTextField)jComponent;
                if (!CommentTextFieldEditor.this.validated && CommentTextFieldEditor.this.validate(extendedTextField.getText())) {
                    CommentTextFieldEditor.this.validated = true;
                    CommentTextFieldEditor.this.stopCellEditing();
                    return true;
                }
                return false;
            }
        });
    }

    private boolean validate(String string) {
        return CommentValidator.validateComment(string, this.context, true);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.tf.setText((String)object);
        this.validated = false;
        return this.tf;
    }

    private boolean isRequireValidation() {
        return this.requireValidation;
    }

    public void setRequireValidation(boolean bl) {
        this.requireValidation = bl;
    }

    @Override
    public boolean stopCellEditing() {
        if (!this.validated) {
            if (!this.validate((String)this.getCellEditorValue())) {
                return false;
            }
            this.validated = true;
        }
        return super.stopCellEditing();
    }
}

