/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.text.Document;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.ide.Context;

public class DBObjectNameEditor
extends DefaultCellEditor {
    private Context context;
    private static int MAX_LENGTH = 32;
    private transient JTextField _tf;
    private boolean _requireValidation;
    private boolean _validated;

    public DBObjectNameEditor(Context context) {
        super(new JTextField());
        this.context = context;
        this._requireValidation = true;
        this._tf = (JTextField)this.getComponent();
        TextFieldLimit textFieldLimit = new TextFieldLimit(MAX_LENGTH);
        this._tf.setDocument(textFieldLimit);
        this._tf.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent jComponent) {
                JTextField jTextField = (JTextField)jComponent;
                if (!DBObjectNameEditor.this._validated && DBObjectNameEditor.this.validate(jTextField.getText())) {
                    DBObjectNameEditor.this._validated = true;
                    DBObjectNameEditor.this.stopCellEditing();
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object instanceof String) {
            String string = (String)object;
            if (!StringUtils.isValidNonQuotedDBObjectName(string)) {
                string = StringUtils.addDoubleQuotes(string);
            }
            this._tf.setText(string);
        } else if (object == null) {
            this._tf.setText("");
        }
        this._validated = false;
        return this._tf;
    }

    private boolean validate(String string) {
        boolean bl = StringUtils.checkDataLossWithMsg(this.context, string, DialogsLrb.get("ERROR_TITLE"));
        if (bl) {
            this._tf.setText("");
        }
        return !bl;
    }

    @Override
    public Object getCellEditorValue() {
        return this._tf.getText();
    }

    @Override
    public boolean stopCellEditing() {
        if (!this._validated) {
            if (!this.validate((String)this.getCellEditorValue())) {
                return false;
            }
            this._validated = true;
        }
        return super.stopCellEditing();
    }

    public void setDocument(Document document) {
        this._tf.setDocument(document);
    }
}

