/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.javatools.ui.table.GenericTable;

public class DataMinerTable
extends GenericTable {
    private static final String COPY_COMMAND = "Copy";
    private boolean tooltipEnable;
    private DataMinerTable main;
    private DataMinerTable fixed;
    private int fixedColumns;
    private int[] defaultSize;
    private Format[] formatters;

    public DataMinerTable() {
        this.setupCopyPasteSupport();
        this.setColumnSelectorAvailable(false);
    }

    public DataMinerTable(TableModel tableModel) {
        super(tableModel);
        this.setupCopyPasteSupport();
    }

    public void setTooltipEnable(boolean bl) {
        this.tooltipEnable = bl;
    }

    public boolean getTooltipEnable() {
        return this.tooltipEnable;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.tooltipEnable) {
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            Object object = this.getValueAt(n, n2);
            String string = this.formatValue(object, n2);
            return string;
        }
        return super.getToolTipText(mouseEvent);
    }

    public void setFixedColumns(int n, int ... nArray) {
        this.fixedColumns = n;
        this.defaultSize = nArray;
        this.setAutoResizeMode(0);
    }

    public TableColumnModel getFullColumnModel() {
        if (this.fixed != null) {
            return new FixedColumnTableColumnModel(super.getColumnModel(), this.fixed.getColumnModel());
        }
        return super.getColumnModel();
    }

    public void setModel(TableModel tableModel) {
        boolean bl = false;
        if (tableModel != this.getModel()) {
            super.setModel(tableModel);
            bl = true;
        }
        if (this.fixedColumns > 0 && this.fixed == null) {
            this.setFixedColumns(this.fixedColumns, (JScrollPane)this.getParent().getParent());
        } else if (this.fixed != null && this != this.fixed && bl) {
            this.redoFixed();
        }
    }

    public void addFormatter(int n, Format format) {
        if (this.formatters == null) {
            this.formatters = new Format[this.getColumnCount()];
        }
        this.formatters[n] = format;
    }

    protected String formatValue(Object object, int n) {
        Format format;
        if (object == null) {
            return "";
        }
        if (this.formatters != null && (format = this.formatters[n]) != null) {
            return format.format(object);
        }
        if (object instanceof Double) {
            return NumericFormat.format((Double)object, true, 3);
        }
        if (object instanceof Date) {
            return DateFormat.getDateTimeInstance(3, 2).format((Date)object);
        }
        return object.toString();
    }

    public void autoSizeColumnsToFit() {
        if (this.fixed != null) {
            TableColumnModel tableColumnModel = this.getFullColumnModel();
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                int n = this.getColumnHeaderWidth(i);
                int n2 = this.getColumnDataWidth(i);
                int n3 = Math.max(n, n2) + 15;
                tableColumn.setPreferredWidth(n3);
                if (i >= this.fixedColumns) continue;
                this.fixed.setPreferredScrollableViewportSize(this.fixed.getPreferredSize());
            }
        } else {
            super.autoSizeColumnsToFit();
        }
    }

    private int getColumnHeaderWidth(int n) {
        DataMinerTable dataMinerTable;
        TableColumn tableColumn = this.getFullColumnModel().getColumn(n);
        Object object = tableColumn.getHeaderValue();
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (n < this.fixedColumns) {
            dataMinerTable = this.fixed;
        } else {
            n -= this.fixedColumns;
            dataMinerTable = this;
        }
        if (tableCellRenderer == null) {
            tableCellRenderer = ((JTable)((Object)dataMinerTable)).getTableHeader().getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent((JTable)((Object)this), object, false, false, -1, n);
        return component.getPreferredSize().width;
    }

    private int getColumnDataWidth(int n) {
        DataMinerTable dataMinerTable;
        int n2 = 0;
        int n3 = this.getFullColumnModel().getColumn(n).getMaxWidth();
        if (n < this.fixedColumns) {
            dataMinerTable = this.fixed;
        } else {
            n -= this.fixedColumns;
            dataMinerTable = this;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            TableCellRenderer tableCellRenderer = ((JTable)((Object)dataMinerTable)).getCellRenderer(i, n);
            Component component = ((JTable)((Object)dataMinerTable)).prepareRenderer(tableCellRenderer, i, n);
            int n4 = component.getPreferredSize().width + ((JTable)((Object)dataMinerTable)).getIntercellSpacing().width;
            if ((n2 = Math.max(n2, n4)) >= n3) break;
        }
        return n2;
    }

    protected void copySelectionToClipBoard() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray = this.getSelectedRows();
        String string = "\t";
        String string2 = "\n";
        int n2 = this.getFullColumnModel().getColumnCount();
        for (n = 0; n < n2; ++n) {
            stringBuilder.append(this.getModel().getColumnName(n));
            stringBuilder.append(string);
        }
        stringBuilder.append(string2);
        for (n = 0; n < nArray.length; ++n) {
            for (int i = 0; i < n2; ++i) {
                int n3 = this.convertRowIndexToModel(nArray[n]);
                Object object = this.getModel().getValueAt(n3, i);
                String string3 = this.formatValue(object, i);
                stringBuilder.append(string3);
                stringBuilder.append(string);
            }
            stringBuilder.append(string2);
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuilder.toString());
        clipboard.setContents(stringSelection, stringSelection);
    }

    protected void setFixedColumns(int n, final JScrollPane jScrollPane) {
        int n2;
        this.main = this;
        this.main = (DataMinerTable)((Object)jScrollPane.getViewport().getView());
        this.main.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("selectionModel".equals(string)) {
                    DataMinerTable.this.fixed.setSelectionModel(DataMinerTable.this.main.getSelectionModel());
                } else if ("model".equals(string)) {
                    DataMinerTable.this.fixed.setModel(DataMinerTable.this.main.getModel());
                } else if ("sorter".equals(string)) {
                    DataMinerTable.this.fixed.setRowSorter(DataMinerTable.this.main.getRowSorter());
                } else if ("rowHeight".equals(string)) {
                    DataMinerTable.this.fixed.setRowHeight(DataMinerTable.this.main.getRowHeight());
                }
            }
        });
        this.fixed = new DataMinerTable();
        this.fixed.setAutoCreateColumnsFromModel(false);
        this.fixed.setModel(this.main.getModel());
        this.fixed.setRowSorter(this.main.getRowSorter());
        this.fixed.setRowHeight(this.main.getRowHeight());
        this.main.setUpdateSelectionOnSort(true);
        this.fixed.setUpdateSelectionOnSort(false);
        this.fixed.setSelectionModel(this.main.getSelectionModel());
        MouseListener[] mouseListenerArray = this.fixed.getMouseListeners();
        MouseListener[] mouseListenerArray2 = this.main.getMouseListeners();
        if (mouseListenerArray.length < mouseListenerArray2.length) {
            for (n2 = mouseListenerArray.length; n2 < mouseListenerArray2.length; ++n2) {
                this.fixed.addMouseListener(mouseListenerArray2[n2]);
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            TableColumn tableColumn = this.columnModel.getColumn(0);
            this.columnModel.removeColumn(tableColumn);
            this.fixed.getColumnModel().addColumn(tableColumn);
            if (this.defaultSize.length <= n2) continue;
            tableColumn.setPreferredWidth(this.defaultSize[n2]);
        }
        this.fixed.setPreferredScrollableViewportSize(this.fixed.getPreferredSize());
        this.fixed.setAutoResizeMode(0);
        this.fixed.getTableHeader().addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                DataMinerTable.this.fixed.setPreferredScrollableViewportSize(DataMinerTable.this.fixed.getPreferredSize());
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
            }
        });
        jScrollPane.setRowHeaderView((Component)((Object)this.fixed));
        jScrollPane.setCorner("UPPER_LEFT_CORNER", this.fixed.getTableHeader());
        jScrollPane.getRowHeader().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JViewport jViewport = (JViewport)changeEvent.getSource();
                jScrollPane.getVerticalScrollBar().setValue(jViewport.getViewPosition().y);
            }
        });
    }

    protected void redoFixed() {
        for (int i = 0; i < this.fixedColumns; ++i) {
            TableColumn tableColumn = this.columnModel.getColumn(0);
            this.columnModel.removeColumn(tableColumn);
        }
    }

    protected void setupCopyPasteSupport() {
        this.setDragEnabled(true);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(67, 2, false);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals(DataMinerTable.COPY_COMMAND)) {
                    DataMinerTable.this.copySelectionToClipBoard();
                }
            }
        }, COPY_COMMAND, keyStroke, 0);
    }

    class FixedColumnTableColumnModel
    implements TableColumnModel {
        private TableColumnModel mainModel;
        private TableColumnModel fixedModel;

        public FixedColumnTableColumnModel(TableColumnModel tableColumnModel, TableColumnModel tableColumnModel2) {
            this.mainModel = tableColumnModel;
            this.fixedModel = tableColumnModel2;
        }

        @Override
        public void addColumn(TableColumn tableColumn) {
            this.mainModel.addColumn(tableColumn);
        }

        @Override
        public void removeColumn(TableColumn tableColumn) {
            this.mainModel.removeColumn(tableColumn);
        }

        @Override
        public void moveColumn(int n, int n2) {
            this.mainModel.moveColumn(n, n2);
        }

        @Override
        public void setColumnMargin(int n) {
            this.mainModel.setColumnMargin(n);
            this.fixedModel.setColumnMargin(n);
        }

        @Override
        public int getColumnCount() {
            return this.mainModel.getColumnCount() + this.fixedModel.getColumnCount();
        }

        @Override
        public Enumeration<TableColumn> getColumns() {
            return this.mainModel.getColumns();
        }

        @Override
        public int getColumnIndex(Object object) {
            int n = -1;
            try {
                n = this.mainModel.getColumnIndex(object) + DataMinerTable.this.fixedColumns;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (n >= 0) {
                return n;
            }
            return this.fixedModel.getColumnIndex(object);
        }

        @Override
        public TableColumn getColumn(int n) {
            if (n < DataMinerTable.this.fixedColumns) {
                return this.fixedModel.getColumn(n);
            }
            return this.mainModel.getColumn(n - DataMinerTable.this.fixedColumns);
        }

        @Override
        public int getColumnMargin() {
            return this.mainModel.getColumnMargin();
        }

        @Override
        public int getColumnIndexAtX(int n) {
            if (n < DataMinerTable.this.fixedColumns) {
                return this.fixedModel.getColumnIndexAtX(n);
            }
            return this.mainModel.getColumnIndexAtX(n);
        }

        @Override
        public int getTotalColumnWidth() {
            return this.mainModel.getTotalColumnWidth();
        }

        @Override
        public void setColumnSelectionAllowed(boolean bl) {
            this.mainModel.setColumnSelectionAllowed(bl);
            this.fixedModel.setColumnSelectionAllowed(bl);
        }

        @Override
        public boolean getColumnSelectionAllowed() {
            return this.mainModel.getColumnSelectionAllowed();
        }

        @Override
        public int[] getSelectedColumns() {
            return this.mainModel.getSelectedColumns();
        }

        @Override
        public int getSelectedColumnCount() {
            return this.mainModel.getSelectedColumnCount();
        }

        @Override
        public void setSelectionModel(ListSelectionModel listSelectionModel) {
            this.mainModel.setSelectionModel(listSelectionModel);
            this.fixedModel.setSelectionModel(listSelectionModel);
        }

        @Override
        public ListSelectionModel getSelectionModel() {
            return this.mainModel.getSelectionModel();
        }

        @Override
        public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            this.mainModel.addColumnModelListener(tableColumnModelListener);
        }

        @Override
        public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            this.mainModel.removeColumnModelListener(tableColumnModelListener);
        }
    }
}

