/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dss.graph.gui.GraphStandardStyles;

public class DefaultGraphDataModel
implements GraphDataModel {
    public static final String HISTOGRAM_DEFAULT_STYLE_PATH = ControlsLrb.get("HISTOGRAM_NAUTICAL_STYLE_PATH");
    public static final String DEFAULT_GRAPH_STYLE = ControlsLrb.get("HISTOGRAM_NAUTICAL_STYLE_PATH");
    private static final Color[] EMPTY_COLOR_ARRAY = new Color[0];
    private String _title;
    private String comment;
    private ArrayList<Object> _columnLabels = new ArrayList();
    private ArrayList<Object> _rowLabels = new ArrayList();
    private List<Color> _rowColors = new ArrayList<Color>();
    private ArrayList<Object> _rowMarkerShapes = new ArrayList();
    private ArrayList<Object> _rowMarkerTypes = new ArrayList();
    private ArrayList<Object[]> _graphData = new ArrayList();
    private Integer _graphType;
    private String _x1Title = null;
    private String _y1Title = null;
    private Object _x1MinValue = 0.0;
    private Object _y1MinValue = 0.0;
    private Object _x1MaxValue = null;
    private Object _y1MaxValue = null;
    private boolean _scatterDataLineDisplayed = true;
    private Date[][] _timePoints;
    private Color[][] _rowColors2;
    private boolean _borderTransparent = true;
    private boolean _legendVisible = false;
    private Integer legendSeriesCount;
    private Integer legendSeriesStart;
    private Integer depthRadius = 0;
    private String styleSelection;
    private boolean lineDataLineDisplayed = true;
    public static final HashMap<String, String> GRAPH_STYLES = new HashMap();

    public DefaultGraphDataModel(String string, Integer n, Object[] objectArray, Object[] objectArray2, Object[] objectArray3, Object[][] objectArray4) {
        this(string, n, objectArray, objectArray2, objectArray4);
        if (objectArray3 != null) {
            this._rowMarkerShapes.addAll(Arrays.asList(objectArray3));
        }
    }

    public DefaultGraphDataModel(String string, Integer n, Object[] objectArray, Object[] objectArray2, Object[][] objectArray3) {
        this._title = string;
        this._graphType = n;
        if (objectArray != null) {
            this._columnLabels.addAll(Arrays.asList(objectArray));
        }
        if (objectArray2 != null) {
            this._rowLabels.addAll(Arrays.asList(objectArray2));
        }
        if (objectArray3 != null) {
            this._graphData.addAll(Arrays.asList(objectArray3));
        }
    }

    public DefaultGraphDataModel(String string, Integer n, Object[] objectArray, List<Color> list, Date[][] dateArray, Object[][] objectArray2, String string2, String string3, Object object, Object object2, Object object3, Object object4) {
        this._title = string;
        this._graphType = n;
        if (objectArray != null) {
            this._rowLabels.addAll(Arrays.asList(objectArray));
        }
        if (objectArray2 != null) {
            this._graphData.addAll(Arrays.asList(objectArray2));
        }
        this._rowColors = list;
        this._timePoints = dateArray;
        this._x1MinValue = object;
        this._x1MaxValue = object2;
        this._y1MinValue = object3;
        this._y1MaxValue = object4;
        this._x1Title = string2;
        this._y1Title = string3;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public Object[] getColumnLabels() {
        return this._columnLabels.toArray();
    }

    @Override
    public Object[] getRowLabels() {
        return this._rowLabels.toArray();
    }

    @Override
    public Object[] getRowMarkerShapes() {
        return this._rowMarkerShapes.toArray();
    }

    @Override
    public Object[] getRowMarkerTypes() {
        return this._rowMarkerTypes.toArray();
    }

    @Override
    public Object[][] getGraphData() {
        Object[][] objectArray = new Object[this._graphData.size()][];
        int n = 0;
        for (Object[] objectArray2 : this._graphData) {
            objectArray[n++] = objectArray2;
        }
        return objectArray;
    }

    @Override
    public Integer getGraphType() {
        return this._graphType;
    }

    @Override
    public void setTitle(String string) {
        this._title = string;
    }

    @Override
    public void addColumnLabels(Object[] objectArray) {
        this._columnLabels.addAll(Arrays.asList(objectArray));
    }

    @Override
    public void addRowLabels(Object[] objectArray) {
        this._rowLabels.addAll(Arrays.asList(objectArray));
    }

    @Override
    public void addRowMarkerShapes(Object[] objectArray) {
        this._rowMarkerShapes.addAll(Arrays.asList(objectArray));
    }

    @Override
    public void addRowMarkerTypes(Object[] objectArray) {
        this._rowMarkerTypes.addAll(Arrays.asList(objectArray));
    }

    @Override
    public void addGraphData(Object[][] objectArray) {
        this._graphData.addAll(Arrays.asList(objectArray));
    }

    @Override
    public void setGraphType(Integer n) {
        this._graphType = n;
    }

    @Override
    public String getX1Title() {
        return this._x1Title;
    }

    @Override
    public String getY1Title() {
        return this._y1Title;
    }

    @Override
    public Object maxX1Value() {
        return this._x1MaxValue;
    }

    @Override
    public Object maxY1Value() {
        return this._y1MaxValue;
    }

    @Override
    public Object minX1Value() {
        return this._x1MinValue;
    }

    @Override
    public Object minY1Value() {
        return this._y1MinValue;
    }

    @Override
    public void setX1(String string, Object object) {
        this._x1Title = string;
        this._x1MaxValue = object;
    }

    @Override
    public void setY1(String string, Object object) {
        this._y1Title = string;
        this._y1MaxValue = object;
    }

    @Override
    public void setX1(String string, Object object, Object object2) {
        this._x1Title = string;
        this._x1MinValue = object;
        this._x1MaxValue = object2;
    }

    @Override
    public void setY1(String string, Object object, Object object2) {
        this._y1Title = string;
        this._y1MinValue = object;
        this._y1MaxValue = object2;
    }

    @Override
    public void setScatterDataLineDisplayed(boolean bl) {
        this._scatterDataLineDisplayed = bl;
    }

    @Override
    public void clear() {
        this.clearColumnLabels();
        this.clearRowLabels();
        this.clearRowColors();
        this.clearGraphData();
        this.clearRowMarkerShapes();
    }

    public void clearColumnLabels() {
        this._columnLabels.clear();
    }

    public void clearRowLabels() {
        this._rowLabels.clear();
    }

    public void clearRowColors() {
        this._rowColors.clear();
    }

    public void clearGraphData() {
        this._graphData.clear();
    }

    public void clearRowMarkerShapes() {
        this._rowMarkerShapes.clear();
    }

    @Override
    public Color[] getRowColors() {
        return this._rowColors.toArray(EMPTY_COLOR_ARRAY);
    }

    @Override
    public void addRowColors(Color[] colorArray) {
        this._rowColors.addAll(Arrays.asList(colorArray));
    }

    @Override
    public Color[][] getRowColors2() {
        return this._rowColors2;
    }

    @Override
    public void addRowColors2(Color[][] colorArray) {
        this._rowColors2 = colorArray;
    }

    @Override
    public boolean isScatterDataLineDisplayed() {
        return this._scatterDataLineDisplayed;
    }

    @Override
    public Date[][] getTimePoints() {
        return this._timePoints;
    }

    public void setTimePoints(Date[][] dateArray) {
        this._timePoints = dateArray;
    }

    @Override
    public void setBorderTransparent(boolean bl) {
        this._borderTransparent = bl;
    }

    @Override
    public boolean isBorderTransparent() {
        return this._borderTransparent;
    }

    @Override
    public void setLegendVisible(boolean bl) {
        this._legendVisible = bl;
    }

    @Override
    public boolean isLegendVisible() {
        return this._legendVisible;
    }

    @Override
    public void setLegendSeriesCount(Integer n) {
        this.legendSeriesCount = n;
    }

    @Override
    public Integer getLegendSeriesCount() {
        return this.legendSeriesCount;
    }

    @Override
    public void setDepthRadius(Integer n) {
        this.depthRadius = n;
    }

    @Override
    public Integer getDepthRadius() {
        return this.depthRadius;
    }

    @Override
    public void setStyleSelection(String string) {
        this.styleSelection = string;
    }

    @Override
    public String getStyleSelection() {
        return this.styleSelection;
    }

    @Override
    public String getStyle() {
        String string = null;
        if (this.styleSelection != null) {
            string = GRAPH_STYLES.get(this.styleSelection);
        }
        return string != null ? string : GraphStandardStyles.DEFAULT_STYLE_PATH;
    }

    @Override
    public void setLineDataLineDisplayed(boolean bl) {
        this.lineDataLineDisplayed = bl;
    }

    @Override
    public boolean isLineDataLineDisplayed() {
        return this.lineDataLineDisplayed;
    }

    @Override
    public void setLegendSeriesStart(Integer n) {
        this.legendSeriesStart = n;
    }

    @Override
    public Integer getLegendSeriesStart() {
        return this.legendSeriesStart;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "";
    }

    static {
        GRAPH_STYLES.put(ControlsLrb.get("HISTOGRAM_DEFAULT_STYLE_PATH"), GraphStandardStyles.DEFAULT_STYLE_PATH);
        GRAPH_STYLES.put(ControlsLrb.get("HISTOGRAM_BLACKWHITE_STYLE_PATH"), "/oracle/dss/graph/styles/blackwhite.xml");
        GRAPH_STYLES.put(ControlsLrb.get("HISTOGRAM_REGATTA_STYLE_PATH"), "/oracle/dss/graph/styles/regatta_simple.xml");
        GRAPH_STYLES.put(ControlsLrb.get("HISTOGRAM_AUTUMN_STYLE_PATH"), "/oracle/dss/graph/styles/autumn_simple.xml");
        GRAPH_STYLES.put(ControlsLrb.get("HISTOGRAM_FINANCIAL_STYLE_PATH"), "/oracle/dss/graph/styles/financial.xml");
        GRAPH_STYLES.put(ControlsLrb.get("HISTOGRAM_CORPORATE_STYLE_PATH"), "/oracle/dss/graph/styles/executive.xml");
        GRAPH_STYLES.put(ControlsLrb.get("HISTOGRAM_EXECUTIVE_STYLE_PATH"), "/oracle/dss/graph/styles/executive.xml");
        GRAPH_STYLES.put(ControlsLrb.get("HISTOGRAM_EARTH_STYLE_PATH"), "/oracle/dss/graph/styles/earth.xml");
        GRAPH_STYLES.put(ControlsLrb.get("HISTOGRAM_PROJECTION_STYLE_PATH"), "/oracle/dss/graph/styles/projection.xml");
        GRAPH_STYLES.put(ControlsLrb.get("HISTOGRAM_APRIL_STYLE_PATH"), "/oracle/dss/graph/styles/april.xml");
        GRAPH_STYLES.put(ControlsLrb.get("HISTOGRAM_COMET_STYLE_PATH"), "/oracle/dss/graph/styles/comet.xml");
        GRAPH_STYLES.put(ControlsLrb.get("HISTOGRAM_CONFETTI_STYLE_PATH"), "/oracle/dss/graph/styles/confetti.xml");
        GRAPH_STYLES.put(ControlsLrb.get("HISTOGRAM_SOUTHWEST_STYLE_PATH"), "/oracle/dss/graph/styles/confetti.xml");
        GRAPH_STYLES.put(ControlsLrb.get("HISTOGRAM_NAUTICAL_STYLE_PATH"), "/oracle/dss/graph/styles/nautical.xml");
        GRAPH_STYLES.put(ControlsLrb.get("HISTOGRAM_GLASS_STYLE_PATH"), "/oracle/dss/graph/styles/glass.xml");
        GRAPH_STYLES.put(ControlsLrb.get("HISTOGRAM_TRANSPARENT_STYLE_PATH"), "/oracle/dss/graph/styles/transparent.xml");
    }
}

