/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.GraphDataDisplay;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphExporter;
import oracle.dmt.dataminer.controls.GraphPopupClickListener;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.teditor.graph.GraphDataDialog;
import oracle.dmt.dataminer.teditor.graph.OdmrGraph;
import oracle.dss.graph.ExceptionalRiser;
import oracle.dss.graph.Graph;
import oracle.dss.graph.Series;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.SeriesOutOfRangeException;
import oracle.ide.Ide;
import oracle.javatools.ui.ControlBar;

public class GraphPanel
extends JPanel
implements GraphDataDisplay {
    GraphDataModel _dataModel;
    GraphExporter _exporter;
    OdmrGraph _graph;
    private ControlBar cbar;
    public static final JTextArea LOADING_GRAPH = new JTextArea(ControlsLrb.get("CHART_LOADING"));
    private static final Logger theLogger = Logger.getLogger(GraphPanel.class.getName());

    public GraphPanel(GraphDataModel graphDataModel, GraphExporter graphExporter) {
        this(graphDataModel);
    }

    public GraphPanel(GraphDataModel graphDataModel) {
        this._dataModel = graphDataModel;
        DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
        defaultErrorHandler.setDebugMode(2);
        this._graph = new OdmrGraph((ErrorHandler)defaultErrorHandler);
        this._graph.addMouseListener(new GraphPopupClickListener(this, (Object)this._graph));
        this._graph.setLocale(Locale.getDefault());
        this.setLayout(new BorderLayout());
        this.setAutoscrolls(true);
        this.add((Component)((Object)this._graph), "Center");
        if (this._graph.getParent() != null) {
            this._graph.getGraphBackground().setBackground(this._graph.getParent().getBackground());
        }
    }

    public GraphPanel(GraphDataDisplay graphDataDisplay, GraphDataModel graphDataModel) {
        this._dataModel = graphDataModel;
        DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
        defaultErrorHandler.setDebugMode(2);
        this._graph = new OdmrGraph((ErrorHandler)defaultErrorHandler);
        this._graph.addMouseListener(new GraphPopupClickListener(graphDataDisplay, (Object)this._graph));
        this._graph.setLocale(Locale.getDefault());
        this.setLayout(new BorderLayout());
        this.setAutoscrolls(true);
        this.add((Component)((Object)this._graph), "Center");
        if (this._graph.getParent() != null) {
            this._graph.getGraphBackground().setBackground(this._graph.getParent().getBackground());
        }
    }

    public Graph getGraph() {
        return this._graph;
    }

    public GraphExporter getExporter() {
        return this._exporter;
    }

    public GraphDataModel getGraphDataModel() {
        return this._dataModel;
    }

    public void initGraph(GraphDataModel graphDataModel) {
        this._dataModel = graphDataModel;
        this.initGraph();
    }

    public void setLoadingStyle(String string) {
        if (this._dataModel == null || this._dataModel.getRowLabels().length < 1) {
            return;
        }
        this._graph.getTitle().setText(string);
        Series series = this._graph.getSeries();
        for (int i = 0; i < this._dataModel.getRowLabels().length; ++i) {
            try {
                series.setColor(Color.lightGray, i);
                continue;
            }
            catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                theLogger.log(Level.SEVERE, seriesOutOfRangeException.getMessage(), seriesOutOfRangeException);
                assert (false) : seriesOutOfRangeException;
                continue;
            }
        }
    }

    public void setDepthRadius() {
        this._graph.setDepthRadius(this._dataModel.getDepthRadius());
        this._graph.updateUI();
    }

    public void updateGraphStyle() {
        this.setGraphStyle(this._dataModel.getStyle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGraphStyle(String string) {
        if (string == null) {
            if (this._graph.getParent() != null) {
                this._graph.getGraphBackground().setBackground(this._graph.getParent().getBackground());
            }
            return;
        }
        try {
            this._graph.setStylePath(string);
            if (this._graph.getParent() != null) {
                this._graph.getGraphBackground().setBackground(this._graph.getParent().getBackground());
            }
            this._graph.updateUI();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    @Override
    public void showData(Object object) {
        if (!(object instanceof OdmrGraph)) {
            return;
        }
        OdmrGraph odmrGraph = (OdmrGraph)((Object)object);
        Object[] objectArray = odmrGraph.rowLabels;
        Object[] objectArray2 = odmrGraph.columnLabels;
        Object[][] objectArray3 = odmrGraph.data;
        Object[] objectArray4 = null;
        GraphDataDialog graphDataDialog = new GraphDataDialog((Frame)Ide.getMainWindow(), true);
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (int i = 0; i < objectArray2.length; ++i) {
            for (int j = 0; j < objectArray.length; ++j) {
                Object object2 = objectArray3[i][j];
                if (objectArray.length > 1) {
                    String[] stringArray = null;
                    if (odmrGraph.getTitle() != null) {
                        stringArray = odmrGraph.getTitle().getText().split(DataProfileStatisticsLrb.get("TITLE_HISTOGRAM_BY"));
                    }
                    objectArray4 = new Object[]{stringArray != null ? stringArray[0] : "", objectArray2[i], stringArray != null && stringArray.length > 1 ? stringArray[1] : "", objectArray[j], objectArray3[i][j]};
                } else {
                    objectArray4 = new Object[]{odmrGraph.getTitle().getText(), objectArray2[i], objectArray3[i][j]};
                }
                arrayList.add(objectArray4);
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(DataProfileStatisticsLrb.get("ATTRIBUTE_NAME"));
        arrayList2.add(DataProfileStatisticsLrb.get("ATTRIBUTE_VALUE"));
        if (objectArray.length > 1) {
            arrayList2.add(DataProfileStatisticsLrb.get("GROUPING_ATTRIBUTE_NAME"));
            arrayList2.add(DataProfileStatisticsLrb.get("GROUPING_ATTRIBUTE_VALUE"));
        }
        arrayList2.add(DataProfileStatisticsLrb.get("ATTRIBUTE_PERCENT"));
        graphDataDialog.setData(arrayList, arrayList2);
        graphDataDialog.setVisible(true);
    }

    public void initGraph() {
        if (this._dataModel != null) {
            int n;
            int n2;
            Color[][] colorArray;
            Object object;
            Integer n3;
            this.setMinimumSize(new Dimension(0, 0));
            this._graph.setGridData(this._dataModel.getColumnLabels(), this._dataModel.getRowLabels(), this._dataModel.getGraphData());
            Object[] objectArray = this._dataModel.getColumnLabels();
            Object[] objectArray2 = this._dataModel.getRowLabels();
            Object[][] objectArray3 = this._dataModel.getGraphData();
            this._graph.setMinimumSize(new Dimension(0, 0));
            String string = this._dataModel.getTitle();
            this._graph.setPreferredSize(new Dimension(100, 200));
            this._graph.setDepthRadius(this._dataModel.getDepthRadius());
            Integer n4 = this._dataModel.getLegendSeriesStart();
            if (n4 != null) {
                this._graph.setLegendSeriesStart(n4);
            }
            if ((n3 = this._dataModel.getLegendSeriesCount()) != null) {
                this._graph.setLegendSeriesCount(n3);
            }
            this._graph.getLegendArea().setVisible(this._dataModel.isLegendVisible());
            this._graph.setLegendScrollbarPresence(0);
            this._graph.getLegendArea().setAutomaticPlacement(0);
            this._graph.getLegendArea().setPosition(1);
            String string2 = this._dataModel.getStyle();
            this._graph.setLineDataLineDisplayed(this._dataModel.isLineDataLineDisplayed());
            this._graph.setMarkerDisplayed(this._dataModel.isLineDataLineDisplayed());
            if (string != null) {
                object = this._graph.getTitle();
                object.setVisible(true);
                object.setText(this._dataModel.getTitle());
            } else {
                this._graph.getTitle().setVisible(false);
            }
            object = this._dataModel.getGraphType();
            if (object != null) {
                this._graph.setGraphType((Integer)object);
                if ((Integer)object == 61) {
                    this._graph.setScatterDataLineDisplayed(this._dataModel.isScatterDataLineDisplayed());
                }
            }
            String string3 = this._dataModel.getX1Title();
            Double d = (Double)this._dataModel.maxX1Value();
            Double d2 = (Double)this._dataModel.minX1Value();
            if (string3 != null) {
                this._graph.getX1Title().setText(string3);
                this._graph.getX1Title().setVisible(true);
            }
            if (d == null) {
                this._graph.getX1Axis().setAxisMaxAutoScaled(true);
            } else {
                this._graph.getX1Axis().setAxisMinValue(d2.doubleValue());
                this._graph.getX1Axis().setAxisMaxValue(d.doubleValue());
                this._graph.getX1Axis().setAxisMinAutoScaled(false);
                this._graph.getX1Axis().setAxisMaxAutoScaled(false);
            }
            String string4 = this._dataModel.getY1Title();
            Double d3 = (Double)this._dataModel.maxY1Value();
            Double d4 = (Double)this._dataModel.minY1Value();
            if (string4 != null) {
                this._graph.getY1Title().setText(string4);
                this._graph.getY1Title().setVisible(true);
            }
            this._graph.getY2Axis().setVisible(false);
            if (d3 == null) {
                this._graph.getY1Axis().setAxisMaxAutoScaled(true);
            } else {
                this._graph.getY1Axis().setAxisMinValue(d4.doubleValue());
                this._graph.getY1Axis().setAxisMaxValue(d3.doubleValue());
                this._graph.getY1Axis().setAxisMinAutoScaled(d3 - d4 > 10000.0);
                this._graph.getY1Axis().setAxisMaxAutoScaled(d3 - d4 > 10000.0);
            }
            Color[] colorArray2 = this._dataModel.getRowColors();
            if (colorArray2 != null && colorArray2.length == this._dataModel.getRowLabels().length) {
                colorArray = this._graph.getSeries();
                for (n2 = 0; n2 < colorArray2.length; ++n2) {
                    try {
                        colorArray.setColor(colorArray2[n2], n2);
                        n = 2;
                        colorArray.setLineWidth(n, n2);
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        theLogger.log(Level.SEVERE, seriesOutOfRangeException.getMessage(), seriesOutOfRangeException);
                        assert (false) : seriesOutOfRangeException;
                        continue;
                    }
                }
            }
            if (this._dataModel.getRowMarkerShapes().length > 0) {
                for (int i = 0; i < this._dataModel.getRowMarkerShapes().length; ++i) {
                    try {
                        Object object2 = this._dataModel.getRowMarkerShapes()[i];
                        this._graph.getSeries().setMarkerShape(((Integer)object2).intValue(), i);
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        theLogger.log(Level.SEVERE, seriesOutOfRangeException.getMessage(), seriesOutOfRangeException);
                        assert (false) : seriesOutOfRangeException;
                        continue;
                    }
                }
            }
            if (this._dataModel.getRowMarkerTypes().length > 0) {
                for (int i = 0; i < this._dataModel.getRowMarkerTypes().length; ++i) {
                    try {
                        Object object3 = this._dataModel.getRowMarkerTypes()[i];
                        this._graph.getSeries().setMarkerType(((Integer)object3).intValue(), i);
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        theLogger.log(Level.SEVERE, seriesOutOfRangeException.getMessage(), seriesOutOfRangeException);
                        assert (false) : seriesOutOfRangeException;
                        continue;
                    }
                }
            }
            if ((colorArray = this._dataModel.getRowColors2()) != null) {
                for (n2 = 0; n2 < colorArray.length; ++n2) {
                    for (n = 0; n < colorArray[n2].length; ++n) {
                        Color color = colorArray[n2][n];
                        ExceptionalRiser exceptionalRiser = this._graph.createExceptionalRiser(n, n2);
                        if (exceptionalRiser == null) continue;
                        exceptionalRiser.getSFX().setFillType(1);
                        exceptionalRiser.setFillColor(color);
                    }
                }
            }
            this._graph.setLineDataLineDisplayed(false);
        }
    }

    public void refreshGraph() {
        if (this._dataModel != null) {
            this._graph.setGridData(this._dataModel.getColumnLabels(), this._dataModel.getRowLabels(), this._dataModel.getGraphData());
            Color[] colorArray = this._dataModel.getRowColors();
            if (colorArray != null && colorArray.length == this._dataModel.getRowLabels().length) {
                Series series = this._graph.getSeries();
                for (int i = 0; i < colorArray.length; ++i) {
                    try {
                        series.setColor(colorArray[i], i);
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        theLogger.log(Level.SEVERE, seriesOutOfRangeException.getMessage(), seriesOutOfRangeException);
                        assert (false) : seriesOutOfRangeException;
                        continue;
                    }
                }
            }
        }
    }

    static {
        LOADING_GRAPH.setEditable(false);
    }
}

