/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dmt.dataminer.controls.RowColumnValue;

public class Matrix {
    private Hashtable<Integer, Object> _rowMap = new Hashtable();
    private Hashtable<Integer, Object> _colMap = new Hashtable();
    private TreeMap<Object, TreeMap<Object, BigDecimal>> _matrixMap = new TreeMap();

    protected Matrix() {
    }

    public boolean isEmpty() {
        return this._matrixMap.isEmpty();
    }

    protected RowColumnValue getRowColumnValue(int n, int n2) {
        Object object = this._rowMap.get(n);
        if (object == null) {
            return null;
        }
        TreeMap<Object, BigDecimal> treeMap = this._matrixMap.get(object);
        if (treeMap == null) {
            return null;
        }
        Object object2 = this._colMap.get(n2);
        if (object2 == null) {
            return null;
        }
        BigDecimal bigDecimal = treeMap.get(object2);
        return new RowColumnValue(object, object2, bigDecimal);
    }

    protected BigDecimal getValue(int n, int n2) {
        Object object = this._rowMap.get(n);
        if (object == null) {
            return null;
        }
        TreeMap<Object, BigDecimal> treeMap = this._matrixMap.get(object);
        if (treeMap == null) {
            return null;
        }
        Object object2 = this._colMap.get(n2);
        if (object2 == null) {
            return null;
        }
        BigDecimal bigDecimal = treeMap.get(object2);
        return bigDecimal;
    }

    protected void setValue(int n, int n2, BigDecimal bigDecimal) {
        Object object = this._rowMap.get(n);
        if (object == null) {
            return;
        }
        TreeMap<Object, BigDecimal> treeMap = this._matrixMap.get(object);
        if (treeMap == null) {
            return;
        }
        Object object2 = this._colMap.get(n2);
        if (object2 == null) {
            return;
        }
        this.addCol(object2, treeMap, bigDecimal);
    }

    protected void addValue(Object object, Object object2, BigDecimal bigDecimal) {
        TreeMap<Object, BigDecimal> treeMap = this._matrixMap.get(object);
        if (treeMap == null) {
            treeMap = new TreeMap();
            this.addRow(object, treeMap);
        }
        this.addCol(object2, treeMap, bigDecimal);
    }

    protected Matrix(Matrix matrix) {
        Set<Object> set = matrix._matrixMap.keySet();
        for (Object object : set) {
            TreeMap<Object, BigDecimal> treeMap = matrix._matrixMap.get(object);
            TreeMap<Object, BigDecimal> treeMap2 = new TreeMap<Object, BigDecimal>();
            this.addRow(object, treeMap2);
            Set<Object> set2 = treeMap.keySet();
            for (Object object2 : set2) {
                BigDecimal bigDecimal = treeMap.get(object2);
                this.addCol(object2, treeMap2, new BigDecimal(bigDecimal.toString()));
            }
        }
    }

    protected boolean equals(Matrix matrix) {
        if (matrix == null) {
            return false;
        }
        if (this._matrixMap.size() != matrix._matrixMap.size()) {
            return false;
        }
        boolean bl = true;
        Set<Object> set = matrix._matrixMap.keySet();
        Iterator<Object> iterator = set.iterator();
        block0: while (iterator.hasNext() && bl) {
            Object object = iterator.next();
            TreeMap<Object, BigDecimal> treeMap = matrix._matrixMap.get(object);
            TreeMap<Object, BigDecimal> treeMap2 = this._matrixMap.get(object);
            if (treeMap2 == null) {
                bl = false;
                break;
            }
            Set<Object> set2 = treeMap.keySet();
            for (Object object2 : set2) {
                BigDecimal bigDecimal = treeMap.get(object2);
                BigDecimal bigDecimal2 = treeMap2.get(object2);
                if (bigDecimal2 == null) {
                    bl = false;
                    continue block0;
                }
                if (bigDecimal.equals(bigDecimal2)) continue;
                bl = false;
                continue block0;
            }
        }
        return bl;
    }

    protected void addRow(Object object, TreeMap<Object, BigDecimal> treeMap) {
        this._matrixMap.put(object, treeMap);
        this.rebuildRowIndexes();
    }

    protected void rebuildRowIndexes() {
        this._rowMap.clear();
        Set<Object> set = this._matrixMap.keySet();
        Iterator<Object> iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            this._rowMap.put(n++, object);
        }
    }

    protected void addCol(Object object, TreeMap<Object, BigDecimal> treeMap, BigDecimal bigDecimal) {
        treeMap.put(object, bigDecimal);
        this.rebuildColumnIndexes(treeMap);
    }

    protected void rebuildColumnIndexes(TreeMap<Object, BigDecimal> treeMap) {
        this._colMap.clear();
        Set<Object> set = treeMap.keySet();
        Iterator<Object> iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            this._colMap.put(n++, object);
        }
    }

    protected Object[] getRowKeys() {
        if (this._matrixMap != null && !this._matrixMap.isEmpty()) {
            return this._matrixMap.keySet().toArray(new String[this._matrixMap.size()]);
        }
        return null;
    }

    protected int getRowCount() {
        return this._rowMap.size();
    }

    protected int geColumnCount() {
        return this._colMap.size();
    }

    protected void clear() {
        this._matrixMap.clear();
        this._rowMap.clear();
        this._colMap.clear();
    }

    protected Vector<Vector<BigDecimal>> toVector() {
        if (this._matrixMap == null) {
            return null;
        }
        Collection<TreeMap<Object, BigDecimal>> collection = this._matrixMap.values();
        if (collection == null) {
            return null;
        }
        Vector<Vector<BigDecimal>> vector = new Vector<Vector<BigDecimal>>();
        for (TreeMap<Object, BigDecimal> treeMap : collection) {
            Collection<BigDecimal> collection2 = treeMap.values();
            Vector<BigDecimal> vector2 = new Vector<BigDecimal>(collection2);
            vector.add(vector.size(), vector2);
        }
        return vector;
    }

    protected void updateColumn(Object object, BigDecimal bigDecimal) {
        if (this._matrixMap == null) {
            return;
        }
        Set<Object> set = this._matrixMap.keySet();
        for (Object object2 : set) {
            if (object2.equals(object)) continue;
            TreeMap<Object, BigDecimal> treeMap = this._matrixMap.get(object2);
            treeMap.put(object, bigDecimal);
        }
    }

    protected void updateRow(Object object, BigDecimal bigDecimal) {
        if (this._matrixMap == null) {
            return;
        }
        TreeMap<Object, BigDecimal> treeMap = this._matrixMap.get(object);
        if (treeMap == null) {
            return;
        }
        Set<Object> set = treeMap.keySet();
        for (Object object2 : set) {
            if (object.equals(object2)) continue;
            this.addCol(object2, treeMap, bigDecimal);
        }
    }
}

