/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.SchemaChooserTableModel;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.TableChooserPreferenceSettings;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;

public class SchemaChooserPane
extends JPanel
implements DataminerGUIPanel {
    private Connection _dbConn;
    private Context _context;
    private SchemaChooserTableModel _selectedSchemaModel;
    private ListStructure _listFromPreferences;
    private JEWTDialog _dlg;
    private String _connectionName;
    private TableChooserPreferenceSettings _tableChooserPrefenceSettings = TableChooserPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private DataMinerTablePanel availableTablePanel;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private DataMinerTablePanel selectedTablePanel;

    public SchemaChooserPane(Context context) {
        assert (context != null) : "Context must not be null";
        this._context = context;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.availableTablePanel = new DataMinerTablePanel();
        this.selectedTablePanel = new DataMinerTablePanel();
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.availableTablePanel, -1, 277, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectedTablePanel, -1, 288, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(52, 52, 52).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn).addContainerGap(112, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.selectedTablePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.availableTablePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
    }

    @Override
    public void initRes() {
        this.availableTablePanel.setTitle(ControlsLrb.get("SCHEMA_CHOOSER_AVAILABLE_SCHEMAS"));
        this.selectedTablePanel.setTitle(ControlsLrb.get("SCHEMA_CHOOSER_SELECTED_SCHEMAS"));
        this.jSelectBtn.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("SCHEMA_CHOOSER_SELECT_ADA"));
        this.jSelectAllBtn.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("SCHEMA_CHOOSER_SELECT_ALL_ADA"));
        this.jRemoveBtn.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("SCHEMA_CHOOSER_REMOVE_ADA"));
        this.jRemoveAllBtn.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("SCHEMA_CHOOSER_REMOVE_ALL_ADA"));
        this.jSelectBtn.setToolTipText(ControlsLrb.get("SCHEMA_CHOOSER_SELECT_ADA"));
        this.jSelectAllBtn.setToolTipText(ControlsLrb.get("SCHEMA_CHOOSER_SELECT_ALL_ADA"));
        this.jRemoveBtn.setToolTipText(ControlsLrb.get("SCHEMA_CHOOSER_REMOVE_ADA"));
        this.jRemoveAllBtn.setToolTipText(ControlsLrb.get("SCHEMA_CHOOSER_REMOVE_ALL_ADA"));
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        this.jSelectBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_RIGHT));
        this.jSelectAllBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_RIGHTALL));
        this.jRemoveBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_LEFT));
        this.jRemoveAllBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_LEFTALL));
    }

    @Override
    public void initUI() {
        try {
            this._dbConn = Connections.getSharedConnection(this._context);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_TITLE"), (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_MESSAGE"), null);
            return;
        }
        this._connectionName = Connections.getConnectionName(this._context);
        HelpUtils.setHelpID((JComponent)this, (String)"schema_selection_dialog");
        SchemaChooserTableModel schemaChooserTableModel = new SchemaChooserTableModel();
        schemaChooserTableModel.setLoadingStatus();
        SchemaChooserTableModel schemaChooserTableModel2 = new SchemaChooserTableModel();
        schemaChooserTableModel2.setLoadingStatus();
        this.availableTablePanel.getTable().setModel((TableModel)((Object)schemaChooserTableModel2));
        this.selectedTablePanel.getTable().setModel((TableModel)((Object)schemaChooserTableModel));
        this.enableControls(false);
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchemaChooserPane.this.moveItems(SchemaChooserPane.this.availableTablePanel.getTable(), SchemaChooserPane.this.selectedTablePanel.getTable());
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchemaChooserPane.this.availableTablePanel.getTable().selectAll();
                SchemaChooserPane.this.moveItems(SchemaChooserPane.this.availableTablePanel.getTable(), SchemaChooserPane.this.selectedTablePanel.getTable());
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchemaChooserPane.this.moveItems(SchemaChooserPane.this.selectedTablePanel.getTable(), SchemaChooserPane.this.availableTablePanel.getTable());
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchemaChooserPane.this.selectedTablePanel.getTable().selectAll();
                SchemaChooserPane.this.moveItems(SchemaChooserPane.this.selectedTablePanel.getTable(), SchemaChooserPane.this.availableTablePanel.getTable());
            }
        });
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void setupTables(SchemaChooserTableModel schemaChooserTableModel, SchemaChooserTableModel schemaChooserTableModel2) {
        this.availableTablePanel.setup((TableModel)((Object)schemaChooserTableModel), ControlsLrb.get("SCHEMA_CHOOSER_AVAILABLE_SCHEMAS"), 0);
        this.selectedTablePanel.setup((TableModel)((Object)schemaChooserTableModel2), ControlsLrb.get("SCHEMA_CHOOSER_SELECTED_SCHEMAS"), 0);
    }

    private void enableControls(boolean bl) {
        this.jRemoveAllBtn.setEnabled(bl);
        this.jRemoveBtn.setEnabled(bl);
        this.jSelectAllBtn.setEnabled(bl);
        this.jSelectBtn.setEnabled(bl);
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2) {
        int[] nArray = genericTable.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        List list = ((SchemaChooserTableModel)((Object)genericTable.getModel())).getSrcData();
        List list2 = ((SchemaChooserTableModel)((Object)genericTable2.getModel())).getSrcData();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = (String)list.get(nArray[i]);
            arrayList.add(string);
        }
        ((SchemaChooserTableModel)((Object)genericTable2.getModel())).addRows(arrayList);
        ((SchemaChooserTableModel)((Object)genericTable.getModel())).removeRows(arrayList);
        int[] nArray2 = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            int n = list2.indexOf(arrayList.get(i));
            assert (n != -1) : "Unexpected state - added item should be present and must have an index";
            nArray2[i] = n;
        }
        genericTable2.setSelectedRowsInModel(nArray2);
    }

    public boolean invokeDialog(Dialog dialog) {
        boolean bl = false;
        try {
            this._dlg = new JEWTDialog(dialog, ControlsLrb.get("SCHEMA_CHOOSER_DLG_TITLE"), 7);
            this._dlg.setContent((Component)this);
            this._dlg.setResizable(true);
            this._dlg.setOKButtonEnabled(false);
            this._dlg.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object) && !SchemaChooserPane.this.doWork()) {
                        throw new PropertyVetoException("panel", propertyChangeEvent);
                    }
                }
            });
            if (this._dlg != null) {
                bl = WizardLauncher.runDialog((JDialog)this._dlg);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_TITLE"), (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_MESSAGE"), null);
        }
        return bl;
    }

    private boolean doWork() {
        this._listFromPreferences.clear();
        List list = this._selectedSchemaModel.getSrcData();
        for (String string : list) {
            this._listFromPreferences.add((Object)string);
        }
        this._tableChooserPrefenceSettings.setIncludedSchemaList(this._connectionName, this._listFromPreferences);
        return true;
    }

    private class LoadUI
    extends SwingWorker {
        private Exception _ex = null;
        private boolean _success = false;
        private SchemaChooserTableModel _availableSchemaModel;

        protected Object doInBackground() throws Exception {
            try {
                this._availableSchemaModel = new SchemaChooserTableModel();
                SchemaChooserPane.this._listFromPreferences = SchemaChooserPane.this._tableChooserPrefenceSettings.getIncludedSchemaList(SchemaChooserPane.this._connectionName);
                Iterator iterator = SchemaChooserPane.this._listFromPreferences.iterator();
                Vector<String> vector = new Vector<String>();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    vector.add(string);
                }
                SchemaChooserPane.this._selectedSchemaModel = new SchemaChooserTableModel(vector);
                this._availableSchemaModel.load(SchemaChooserPane.this._dbConn, Connections.getUserAccountName(SchemaChooserPane.this._context));
                this._availableSchemaModel.removeDuplicateRows(SchemaChooserPane.this._selectedSchemaModel.getSrcData());
            }
            catch (Exception exception) {
                this._ex = exception;
            }
            this._success = true;
            return this._success;
        }

        @Override
        protected void done() {
            if (this._success && this._ex == null) {
                this._availableSchemaModel.fireTableDataChanged();
                SchemaChooserPane.this.setupTables(this._availableSchemaModel, SchemaChooserPane.this._selectedSchemaModel);
                SchemaChooserPane.this._dlg.setOKButtonEnabled(true);
            } else {
                SchemaChooserTableModel schemaChooserTableModel = new SchemaChooserTableModel();
                schemaChooserTableModel.setFailedStatus();
                SchemaChooserPane.this.setupTables(schemaChooserTableModel, SchemaChooserPane.this._selectedSchemaModel);
                if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_TITLE"), (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_MESSAGE"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_MESSAGE"), (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_TITLE"), null);
                }
            }
            SchemaChooserPane.this.enableControls(true);
        }
    }
}

