/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.jdbc.OraclePreparedStatement;

public class SchemaChooserTableModel
extends ODMrTableModel<String> {
    public static final int SCHEMA_NAME = 0;
    private static final String[] COLUMN_NAMES = new String[]{ControlsLrb.get("SCHEMA_CHOOSER_SCHEMA_NAME")};
    private static final String SQL_QUERY = "select SCHEMA FROM (\nselect DISTINCT(OWNER) SCHEMA from all_tables\n where OWNER NOT IN (:owner_schema_param)\nUNION \nselect DISTINCT(OWNER) SCHEMA from all_views\n where OWNER NOT IN (:owner_schema_param))\n ORDER BY SCHEMA";

    public SchemaChooserTableModel() {
        super(COLUMN_NAMES);
    }

    public SchemaChooserTableModel(Vector<String> vector) {
        super(COLUMN_NAMES, vector);
    }

    public void removeDuplicateRows(List<String> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : list) {
            hashMap.put(string, string);
        }
        Iterator<String> iterator = this.srcData.iterator();
        while (iterator.hasNext()) {
            String string;
            string = iterator.next();
            String string2 = (String)hashMap.get(string);
            if (string2 == null) continue;
            iterator.remove();
        }
        this.fireTableDataChanged();
    }

    public void setFailedStatus() {
        String string = ControlsLrb.get("TABLE_CHOOSER_FAILED_TO_LOAD");
        this.srcData.clear();
        this.srcData.add(string);
        this.fireTableDataChanged();
    }

    public void setLoadingStatus() {
        String string = CommonLrb.get("COMMON_LOADING");
        this.srcData.clear();
        this.srcData.add(string);
        this.fireTableDataChanged();
    }

    public void load(Connection connection, String string) throws Exception {
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(SQL_QUERY);
            sQLHelper.opstmt.setStringAtName("owner_schema_param", string);
            sQLHelper.opstmt.setFetchSize(100);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            String string2 = null;
            while (sQLHelper.rs.next()) {
                string2 = sQLHelper.rs.getString("SCHEMA");
                this.srcData.add(string2);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        switch (n2) {
            case 0: {
                return this.srcData.get(n);
            }
        }
        assert (false) : "Out of bounds column when accessing list of schemas";
        return null;
    }
}

