/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.TableChooserPreferenceSettings;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class TableChooserModel
extends ODMrTableModel<TableRow> {
    private static final String[] COLUMN_NAMES = new String[]{ControlsLrb.get("TABLE_CHOOSER_TABLES_LIST_NAME"), ControlsLrb.get("TABLE_CHOOSER_TABLES_LIST_TYPE")};
    static final int SCHEMA_TABLE_NAME = 0;
    static final int TYPE = 1;
    static final int SCHEMA = 2;
    static final int TABLE_NAME = 3;
    private String _ownerSchema = null;
    private Context _context = null;
    private boolean tablesOnly = false;
    private boolean _ownerOnly = true;
    private String _connectionName = null;
    private TableChooserPreferenceSettings _tableChooserPrefenceSettings = TableChooserPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());

    public TableChooserModel(String string, Context context) {
        super(COLUMN_NAMES);
        assert (string != null) : "Can not pass a null ownerSchema in to the constructor";
        assert (context != null) : "Can not pass a null context in to the constructor";
        this._context = context;
        this._ownerSchema = string;
        this._connectionName = Connections.getConnectionName(this._context);
    }

    public int selectRow(String string, String string2) {
        int n = -1;
        for (int i = 0; i < this.srcData.size(); ++i) {
            TableRow tableRow = (TableRow)this.srcData.get(i);
            if (!tableRow.getSchema().equals(string) || !tableRow.getTableName().equals(string2)) continue;
            n = i;
            break;
        }
        return n;
    }

    public TableRow getRow(int n) {
        return (TableRow)this.srcData.get(n);
    }

    public void setFailedStatus() {
        TableRow tableRow = new TableRow(ControlsLrb.get("TABLE_CHOOSER_FAILED_TO_LOAD"), "", "");
        this.srcData.clear();
        this.srcData.add(tableRow);
        this.fireTableDataChanged();
    }

    public void load(Connection connection) throws Exception {
        this.srcData.clear();
        if (this._ownerOnly) {
            this.loadOwnerTablesAndViews(connection);
        } else {
            this.loadAccessableTablesAndViews(connection);
        }
        assert (this.srcData != null) : "failed to load accessible tables, received a null collection";
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                TableChooserModel.this.fireTableDataChanged();
            }
        });
    }

    private void loadAccessableTablesAndViews(Connection connection) throws Exception {
        SQLHelper sQLHelper = new SQLHelper();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select OWNER, TABLE_NAME, TYPE from ( select OWNER, TABLE_NAME, 'TABLE' as TYPE from ALL_TABLES where <LIST_OF_SCHEMAS> ");
            stringBuilder.append("TABLE_NAME NOT LIKE 'BIN$%'AND TABLE_NAME NOT LIKE 'DM$%'AND TABLE_NAME NOT LIKE 'DM4J$%'AND TABLE_NAME NOT LIKE 'DR$%'AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@' ");
            stringBuilder.append(" ");
            if (!this.tablesOnly) {
                stringBuilder.append("union all select OWNER, VIEW_NAME as TABLE_NAME, 'VIEW' as TYPE from ALL_VIEWS where <LIST_OF_SCHEMAS> ");
                stringBuilder.append("VIEW_NAME NOT LIKE 'DM$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'DR$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND VIEW_NAME NOT LIKE 'DM4J$%'  ESCAPE '@' ");
            }
            stringBuilder.append(" ) order by Owner, TABLE_NAME ");
            ListStructure listStructure = this._tableChooserPrefenceSettings.getIncludedSchemaList(this._connectionName);
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = listStructure.iterator();
            String string = "";
            boolean bl = false;
            int n = 0;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer.append("'" + StringUtils.escapeSingleQuotesForSQL(string) + "'");
                ++n;
                if (iterator.hasNext()) {
                    stringBuffer.append(",");
                }
                if (string.compareTo(this._ownerSchema) != 0) continue;
                bl = true;
            }
            if (!bl) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("'" + StringUtils.escapeSingleQuotesForSQL(this._ownerSchema) + "'");
                ++n;
            }
            String string2 = " ";
            if (n > 0) {
                string2 = " OWNER IN ( " + stringBuffer.toString() + " ) AND ";
            }
            String string3 = StringUtils.getReplacedString(stringBuilder.toString(), "<LIST_OF_SCHEMAS>", string2);
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            TableRow tableRow = null;
            while (sQLHelper.rs.next()) {
                tableRow = new TableRow(sQLHelper.rs.getString("OWNER"), sQLHelper.rs.getString("TABLE_NAME"), sQLHelper.rs.getString("TYPE"));
                this.srcData.add(tableRow);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
    }

    private void loadOwnerTablesAndViews(Connection connection) throws Exception {
        SQLHelper sQLHelper = new SQLHelper();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select TABLE_NAME, TYPE from ( select TABLE_NAME, 'TABLE' as TYPE from USER_TABLES where ");
            stringBuilder.append("TABLE_NAME NOT LIKE 'BIN$%'AND TABLE_NAME NOT LIKE 'DM$%'AND TABLE_NAME NOT LIKE 'DM4J$%'AND TABLE_NAME NOT LIKE 'DR$%'AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@' ");
            stringBuilder.append(" ");
            if (!this.tablesOnly) {
                stringBuilder.append("union all select VIEW_NAME as TABLE_NAME, 'VIEW' as TYPE from USER_VIEWS where ");
                stringBuilder.append("VIEW_NAME NOT LIKE 'DM$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'DR$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND VIEW_NAME NOT LIKE 'DM4J$%'  ESCAPE '@' ");
            }
            stringBuilder.append(" ) order by TABLE_NAME ");
            sQLHelper.pstmt = connection.prepareStatement(stringBuilder.toString());
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            TableRow tableRow = null;
            while (sQLHelper.rs.next()) {
                tableRow = new TableRow(this._ownerSchema, sQLHelper.rs.getString("TABLE_NAME"), sQLHelper.rs.getString("TYPE"));
                this.srcData.add(tableRow);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!" + n + ", of " + this.getRowCount();
        TableRow tableRow = (TableRow)this.srcData.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                if (this.isOwnerOnly()) {
                    if (this._ownerSchema != null) {
                        if (this._ownerSchema.equals(tableRow._schema)) {
                            string = tableRow.getTableName();
                            break;
                        }
                        string = tableRow.getSchemaTableName();
                        break;
                    }
                    string = tableRow.getTableName();
                    break;
                }
                string = tableRow.getSchemaTableName();
                break;
            }
            case 2: {
                string = tableRow.getSchema();
                break;
            }
            case 1: {
                string = tableRow.getType();
                break;
            }
            case 3: {
                string = tableRow.getTableName();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing list of tables";
                break;
            }
        }
        return string;
    }

    public void setOwnerOnly(boolean bl) {
        this._ownerOnly = bl;
    }

    public boolean isOwnerOnly() {
        return this._ownerOnly;
    }

    public String getOwnerSchema() {
        return this._ownerSchema;
    }

    public void setTablesOnly(boolean bl) {
        this.tablesOnly = bl;
    }

    public boolean isTablesOnly() {
        return this.tablesOnly;
    }

    public static class TableRow {
        private String _schema;
        private String _tableName;
        private String _type;

        public TableRow(String string, String string2, String string3) {
            this._schema = string;
            this._tableName = string2;
            this._type = string3;
        }

        public void setSchema(String string) {
            this._schema = string;
        }

        public String getSchema() {
            return this._schema;
        }

        public void setTableName(String string) {
            this._tableName = string;
        }

        public String getTableName() {
            return this._tableName;
        }

        public void setType(String string) {
            this._type = string;
        }

        public String getType() {
            return this._type;
        }

        public String getSchemaTableName() {
            return this.getSchema() + "." + this.getTableName();
        }

        public String getMungedSchemaTableName() {
            return this.getSchema() + this.getTableName();
        }

        public boolean equals(Object object) {
            if (object instanceof TableRow) {
                boolean bl = false;
                TableRow tableRow = (TableRow)object;
                if ((tableRow._schema == null && this._schema == null || tableRow._schema != null && tableRow._schema.equals(this._schema)) && (tableRow._tableName == null && this._tableName == null || tableRow._tableName != null && tableRow._tableName.equals(this._tableName)) && (tableRow._type == null && this._type == null || tableRow._type != null && tableRow._type.equals(this._type))) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public int hashCode() {
            int n = 7;
            n += this._schema != null ? this._schema.hashCode() : 0;
            n += this._tableName != null ? this._tableName.hashCode() : 0;
            return n += this._type != null ? this._type.hashCode() : 0;
        }
    }
}

