/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls.renderers;

import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;

public class IconCellRenderer
extends DefaultTableCellRenderer {
    private IconChooser chooser;
    private boolean toString;

    public IconCellRenderer(IconChooser iconChooser) {
        this(iconChooser, true);
    }

    public IconCellRenderer(IconChooser iconChooser, boolean bl) {
        this.chooser = iconChooser;
        this.toString = bl;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (!this.toString) {
            this.setText("");
        }
        this.setIcon(this.chooser.getIconFor(jTable, object, bl, bl2, n, n2));
        return component;
    }

    public static Icon getIconForPIStatus(ModelStatusType modelStatusType) {
        if (modelStatusType == ModelStatusType.COMPLETE) {
            return DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_BUILT);
        }
        if (modelStatusType == ModelStatusType.READY) {
            return DataMinerIcons.get(Icons.INCOMPLETE);
        }
        if (modelStatusType == ModelStatusType.FAILURE) {
            return DataMinerIcons.get(Icons.ERROR_STATUS);
        }
        return DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_INVALID);
    }

    public static Icon getIconForAttrStatus(List list, Object object) {
        boolean bl = false;
        for (Object e : list) {
            AttributeType attributeType = (AttributeType)e;
            if (!attributeType.getName().equals(object.toString()) || !attributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
            bl = true;
            break;
        }
        return bl ? DataMinerIcons.get(Icons.ATTRIBUTE) : DataMinerIcons.get(Icons.USAGE_ATTR_INVALID);
    }

    public static interface IconChooser {
        public Icon getIconFor(JTable var1, Object var2, boolean var3, boolean var4, int var5, int var6);
    }
}

