/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.dprofiler;

import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsModel;
import oracle.dmt.dataminer.generated.server.OdmrHistogramPoint;
import oracle.dmt.dataminer.generated.server.OdmrHistogramPointEx;
import oracle.dmt.dataminer.generated.server.OdmrHistograms;
import oracle.dmt.dataminer.generated.server.OdmrHistogramsEx;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.DataProfilePhysicalNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.ExploreHistogramElement;
import oracle.dmt.dataminer.utils.ConverterHelper;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.workflow.dialog.data.StatisticsSelectionObject;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.StatsSelection;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.jdbc.OracleResultSet;
import oracle.sql.TIMESTAMPTZ;

public class DataProfileStatisticsState
implements GraphModelProvider {
    private boolean _loaded;
    private Context _context;
    private DataProfilePhysicalNode _profileNode;
    private DataProfileStatisticsModel _tableModel;
    private GraphDataModel _graphDataModel;
    private boolean showNulls;
    private String styleSelection = DefaultGraphDataModel.DEFAULT_GRAPH_STYLE;
    private int depthRadius = _DEPTH_RADIUS;
    private static int _DEPTH_RADIUS = 50;
    public static final Color _BASE_CHART_COLOR = new Color(255, 255, 153);
    static String _NONE_ATTRIBUTE = DataProfileStatisticsLrb.get("ATTRIBUTE_NONE");
    private static int _LEGEND_SERIES_COUNT = 20;
    private static Color[] _RESERVED_COLORS = new Color[]{Color.yellow, Color.red, Color.green, Color.blue, Color.cyan, Color.magenta, Color.orange, Color.pink, Color.black, Color.gray};
    private static Color[][] _EXTRA_COLORS = new Color[][]{{new Color(255, 226, 122), new Color(255, 122, 122), new Color(122, 255, 122), new Color(122, 122, 255), new Color(122, 255, 255), new Color(255, 122, 255), new Color(255, 226, 122), new Color(255, 51, 51), new Color(51, 26, 0), Color.lightGray}, {new Color(255, 213, 61), new Color(255, 61, 61), new Color(61, 255, 61), new Color(61, 61, 255), new Color(61, 255, 255), new Color(255, 61, 255), new Color(255, 213, 61), new Color(255, 112, 112), new Color(112, 112, 0), Color.darkGray}};
    private String groupingAttributName = _NO_GROUPING;
    private static String _comma = ", ";
    private static String _NO_GROUPING = "_NO_GROUPING";
    private static StringBuffer _listBuffer = new StringBuffer();
    private String _attr_list_token = "<attribute_list>";
    private String _table_name_token = "<table_name>";
    private static String _QUERY;
    private StatsSelection statsSelection;
    private boolean histogramAvalable = true;
    private HashMap<String, AttributeHistogramArray> histograms = new HashMap();
    private HashMap<String, DataProfileStatisticsData> dataPoints = new HashMap();

    public boolean isHistogramAvalable() {
        return this.histogramAvalable;
    }

    public String getGroupingAttributName() {
        return this.groupingAttributName;
    }

    public boolean isGroupingBy() {
        return !this.groupingAttributName.equals(_NO_GROUPING);
    }

    public void setStyleSelection(String string) {
        this.styleSelection = string;
    }

    public void setDepthRadius(int n) {
        this.depthRadius = n;
    }

    public void setShowNulls(boolean bl) {
        this.showNulls = bl;
    }

    public DataProfileStatisticsState(Context context, GraphicalPreferencesSettings graphicalPreferencesSettings, boolean bl) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
        this.showNulls = bl;
        this.styleSelection = graphicalPreferencesSettings.getGraphStyle();
        this.depthRadius = graphicalPreferencesSettings.getRadiusDepthValue();
        Node node = this._context.getNode();
        assert (node != null);
        assert (node instanceof DataProfilePhysicalNode);
        this._profileNode = (DataProfilePhysicalNode)node;
        DataNodeType dataNodeType = (DataNodeType)this._profileNode.getRepositoryData();
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)dataNodeType;
        this.statsSelection = dataProfileNodeType.getStatsSelection();
        if (this.statsSelection == null) {
            this.statsSelection = StatisticsSelectionObject.createDefaultStatsSelection();
        }
        this.histogramAvalable = this.statsSelection.isHistogram();
        AttributeType attributeType = dataProfileNodeType.getDataProfileInput().getGroupByAttribute();
        if (attributeType != null) {
            this.groupingAttributName = attributeType.getAlias() != null ? attributeType.getAlias() : attributeType.getName();
            this.groupingAttributName = StringUtils.addDoubleQuotes(this.groupingAttributName);
        } else {
            this.groupingAttributName = _NO_GROUPING;
        }
        if (this.groupingAttributName == null) {
            this.groupingAttributName = _NO_GROUPING;
        }
        this.initGraphModel();
    }

    private void initGraphModel() {
        this._graphDataModel = new DefaultGraphDataModel(null, 18, null, null, null);
        this._graphDataModel.setX1(DataProfileStatisticsLrb.get("HISTOGRAM_X_AXIS"), null);
        this._graphDataModel.setY1(DataProfileStatisticsLrb.get("HISTOGRAM_Y_AXIS"), null);
    }

    public GraphDataModel getDefaultGraphDataModel() {
        return this._graphDataModel;
    }

    public String getStatisticalTable() {
        return this._profileNode.getStatsTableName();
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void close() {
    }

    public void load() throws Exception {
        String string = this._profileNode.getStatsTableName();
        if (string == null) {
            this._loaded = false;
            return;
        }
        this._tableModel = new DataProfileStatisticsModel(this.loadStatistics(string), this.statsSelection);
        if (this.groupingAttributName.equals(_NO_GROUPING)) {
            this.createAllGraphDataModelsTotalPopulation();
        } else {
            this.createAllGraphDataModelsGroupBy(this.groupingAttributName);
        }
        this._loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataProfileStatisticsData> loadStatistics(String string) throws Exception {
        List<DataProfileStatisticsData> list = null;
        String string2 = null;
        Connection connection = null;
        SQLHelper sQLHelper = new SQLHelper();
        boolean bl = SQLHelper.isExtendedTypeEnabled(this._context);
        try {
            connection = Connections.getUniqueConnection(this._context);
            string2 = StringUtils.getReplacedString(_QUERY, this._attr_list_token, _listBuffer.toString());
            string2 = StringUtils.getReplacedString(string2, this._table_name_token, string);
            sQLHelper.pstmt = connection.prepareStatement(string2);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Cloneable cloneable;
                Object object6;
                Timestamp timestamp;
                Object object7;
                String string3 = sQLHelper.rs.getString("ATTR");
                String string4 = sQLHelper.rs.getString("DATA_TYPE");
                Object object8 = sQLHelper.rs.getObject("NULL_PERCENT");
                Object object9 = sQLHelper.rs.getObject("DISTINCT_CNT");
                Object object10 = sQLHelper.rs.getObject("DISTINCT_PERCENT");
                String string5 = sQLHelper.rs.getString("MODE_VALUE");
                Object object11 = sQLHelper.rs.getObject("AVG");
                Timestamp timestamp2 = sQLHelper.rs.getTimestamp("AVG_DATE");
                TIMESTAMPTZ tIMESTAMPTZ = ((OracleResultSet)sQLHelper.rs).getTIMESTAMPTZ("AVG_TS_TZ");
                GregorianCalendar gregorianCalendar = null;
                if (tIMESTAMPTZ != null) {
                    object7 = tIMESTAMPTZ.toBytes();
                    timestamp = tIMESTAMPTZ.timestampValue(connection);
                    gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(timestamp);
                    object6 = TimeUtils.GMT + TimeUtils.getRegionName(object7);
                    cloneable = TimeUtils.toTimeZoneFromZoneId((String)object6);
                    gregorianCalendar.setTimeZone((TimeZone)cloneable);
                }
                object7 = sQLHelper.rs.getObject("MEDIAN_VAL");
                timestamp = sQLHelper.rs.getTimestamp("MEDIAN_DATE");
                object6 = ((OracleResultSet)sQLHelper.rs).getTIMESTAMPTZ("MEDIAN_TS_TZ");
                cloneable = null;
                if (object6 != null) {
                    object5 = object6.toBytes();
                    object4 = object6.timestampValue(connection);
                    cloneable = new GregorianCalendar();
                    ((Calendar)cloneable).setTime((Date)object4);
                    object3 = TimeUtils.GMT + TimeUtils.getRegionName(object5);
                    object2 = TimeUtils.toTimeZoneFromZoneId((String)object3);
                    ((GregorianCalendar)cloneable).setTimeZone((TimeZone)object2);
                }
                object5 = sQLHelper.rs.getString("MIN");
                object4 = sQLHelper.rs.getString("MAX");
                object3 = sQLHelper.rs.getObject("STD");
                object2 = sQLHelper.rs.getObject("VAR");
                Object object12 = sQLHelper.rs.getObject("SKEWNESS");
                Object object13 = sQLHelper.rs.getObject("KURTOSIS");
                List<ExploreHistogramElement> list2 = null;
                if (bl) {
                    object = (OdmrHistogramsEx)((OracleResultSet)sQLHelper.rs).getORAData("HISTOGRAMS", OdmrHistogramsEx.getORADataFactory());
                    list2 = this.createHistogramsFromOdmrHistogramsEx((OdmrHistogramsEx)object);
                } else {
                    object = (OdmrHistograms)((OracleResultSet)sQLHelper.rs).getORAData("HISTOGRAMS", OdmrHistograms.getORADataFactory());
                    list2 = this.createHistogramsFromOdmrHistograms((OdmrHistograms)object);
                }
                object = object8 == null ? null : Double.valueOf(((BigDecimal)object8).doubleValue());
                Integer n = object9 == null ? null : Integer.valueOf(((BigDecimal)object9).intValue());
                Double d = object10 == null ? null : Double.valueOf(((BigDecimal)object10).doubleValue());
                Double d2 = object11 == null ? null : Double.valueOf(((BigDecimal)object11).doubleValue());
                Date date = null;
                if (timestamp2 != null) {
                    if (DatabaseMetadataUtils.isTimestamp(string4)) {
                        date = new Timestamp(timestamp2.getTime());
                    } else if (string4.equals("DATE")) {
                        date = new Date(timestamp2.getTime());
                    }
                }
                Double d3 = object7 == null ? null : Double.valueOf(((BigDecimal)object7).doubleValue());
                Date date2 = null;
                if (timestamp != null) {
                    if (DatabaseMetadataUtils.isTimestamp(string4)) {
                        date2 = new Timestamp(timestamp.getTime());
                    } else if (string4.equals("DATE")) {
                        date2 = new Date(timestamp.getTime());
                    }
                }
                Comparable<Double> comparable = null;
                if (d2 != null) {
                    comparable = d2;
                } else if (date != null) {
                    comparable = date;
                } else if (gregorianCalendar != null) {
                    comparable = gregorianCalendar;
                }
                Object object14 = null;
                if (d3 != null) {
                    object14 = d3;
                } else if (date2 != null) {
                    object14 = date2;
                } else if (cloneable != null) {
                    object14 = cloneable;
                }
                Double d4 = object3 == null ? null : Double.valueOf(((BigDecimal)object3).doubleValue());
                Double d5 = object2 == null ? null : Double.valueOf(((BigDecimal)object2).doubleValue());
                Double d6 = object12 == null ? null : Double.valueOf(((BigDecimal)object12).doubleValue());
                Double d7 = object13 == null ? null : Double.valueOf(((BigDecimal)object13).doubleValue());
                this.addPoint(string3, string4, (Double)object, n, d, string5, comparable, object14, (String)object5, (String)object4, d4, d5, d6, d7, list2);
            }
            list = this.getPoints();
        }
        finally {
            sQLHelper.close();
            SQLHelper.close(connection);
        }
        return list;
    }

    private List<ExploreHistogramElement> createHistogramsFromOdmrHistograms(OdmrHistograms odmrHistograms) throws Exception {
        ArrayList<ExploreHistogramElement> arrayList = new ArrayList<ExploreHistogramElement>();
        if (odmrHistograms != null) {
            for (int i = 0; i < odmrHistograms.length(); ++i) {
                OdmrHistogramPoint odmrHistogramPoint = odmrHistograms.getElement(i);
                if (!this.showNulls && odmrHistogramPoint.getAttributeValue().equals("'Null bin'")) continue;
                ExploreHistogramElement exploreHistogramElement = new ExploreHistogramElement(odmrHistogramPoint);
                arrayList.add(exploreHistogramElement);
            }
        }
        return arrayList;
    }

    private List<ExploreHistogramElement> createHistogramsFromOdmrHistogramsEx(OdmrHistogramsEx odmrHistogramsEx) throws Exception {
        ArrayList<ExploreHistogramElement> arrayList = new ArrayList<ExploreHistogramElement>();
        if (odmrHistogramsEx != null) {
            for (int i = 0; i < odmrHistogramsEx.length(); ++i) {
                OdmrHistogramPointEx odmrHistogramPointEx = odmrHistogramsEx.getElement(i);
                if (!this.showNulls && odmrHistogramPointEx.getAttributeValue().equals("'Null bin'")) continue;
                ExploreHistogramElement exploreHistogramElement = new ExploreHistogramElement(odmrHistogramPointEx);
                arrayList.add(exploreHistogramElement);
            }
        }
        return arrayList;
    }

    public DataProfileStatisticsModel getTableModel() {
        return this._tableModel;
    }

    @Override
    public GraphDataModel getGraphDataModel(int n) {
        if (this._tableModel == null) {
            return null;
        }
        Vector<DataProfileStatisticsData> vector = this._tableModel.getDataVector();
        DataProfileStatisticsData dataProfileStatisticsData = vector.get(n);
        GraphDataModel graphDataModel = dataProfileStatisticsData.getGraphDataModel();
        return graphDataModel;
    }

    @Override
    public String getStyleSelection() {
        return this.styleSelection;
    }

    public int getDepthRadius() {
        return this.depthRadius;
    }

    public GraphDataModel createDetailedGraphModel(String string) {
        this._graphDataModel = this.groupingAttributName == null || this.groupingAttributName.equals(_NO_GROUPING) || string.equals(this.groupingAttributName) ? this.createGraphDataModelTotalPopulation(string) : this.createGraphDataModelGroupBy(this.groupingAttributName, string);
        return this._graphDataModel;
    }

    private void createAllGraphDataModelsTotalPopulation() {
        Vector<DataProfileStatisticsData> vector = this._tableModel.getDataVector();
        for (DataProfileStatisticsData dataProfileStatisticsData : vector) {
            String string = dataProfileStatisticsData.getName();
            GraphDataModel graphDataModel = this.createGraphDataModelTotalPopulationGeneric(null, string);
            graphDataModel.setTitle(null);
            graphDataModel.setLegendVisible(false);
            graphDataModel.setDepthRadius(0);
            graphDataModel.setLineDataLineDisplayed(false);
            dataProfileStatisticsData.setGraphDataModel(graphDataModel);
        }
    }

    GraphDataModel createGraphDataModelTotalPopulation(String string) {
        this.createGraphDataModelTotalPopulationGeneric(this._graphDataModel, string);
        return this._graphDataModel;
    }

    GraphDataModel createGraphDataModelGroupBy(String string, String string2) {
        return this.createGraphDataModelGroupByGeneric(this._graphDataModel, string, string2);
    }

    GraphDataModel createGraphDataModelTotalPopulationGeneric(GraphDataModel graphDataModel, String string) {
        boolean bl;
        if (graphDataModel == null) {
            graphDataModel = new DefaultGraphDataModel(null, 18, null, null, null);
            bl = false;
        } else {
            graphDataModel.clear();
            bl = true;
        }
        AttributeHistogramArray attributeHistogramArray = this.getHistogram(string);
        if (attributeHistogramArray == null || attributeHistogramArray.isEmpty()) {
            return graphDataModel;
        }
        ArrayList<String> arrayList = attributeHistogramArray.getBarTitles();
        if (arrayList == null || arrayList.isEmpty()) {
            return graphDataModel;
        }
        int n = arrayList.size();
        int n2 = 1;
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray3[i] = bl ? DataProfileStatisticsLrb.get("HISTOGRAM_Y_AXIS") : "";
            for (int j = 0; j < n; ++j) {
                String string2 = arrayList.get(j);
                ArrayList<NameValuePair> arrayList2 = attributeHistogramArray.getBarArray(string2.toString());
                NameValuePair nameValuePair = arrayList2.get(0);
                Object object = nameValuePair.getValue();
                assert (object instanceof Number) : "Wrong data for this graph";
                objectArray[j][i] = Float.valueOf(((Float)nameValuePair.getValue()).floatValue());
                objectArray2[j] = bl ? string2 : "";
            }
        }
        graphDataModel.addColumnLabels(objectArray2);
        graphDataModel.addRowLabels(objectArray3);
        graphDataModel.addRowColors(new Color[]{_BASE_CHART_COLOR});
        graphDataModel.addGraphData(objectArray);
        if (bl) {
            graphDataModel.setTitle(StringUtils.trimDoubleQuotes(string));
            graphDataModel.setDepthRadius(this.depthRadius);
        }
        graphDataModel.setLegendVisible(false);
        return graphDataModel;
    }

    private void createAllGraphDataModelsGroupBy(String string) {
        Vector<DataProfileStatisticsData> vector = this._tableModel.getDataVector();
        for (DataProfileStatisticsData dataProfileStatisticsData : vector) {
            String string2 = dataProfileStatisticsData.getName();
            GraphDataModel graphDataModel = string2.equals(string) ? this.createGraphDataModelTotalPopulationGeneric(null, string2) : this.createAggregatedGraphDataModelGroupByGeneric(null, string, string2);
            graphDataModel.setTitle(null);
            graphDataModel.setLegendVisible(false);
            graphDataModel.setDepthRadius(0);
            graphDataModel.setLineDataLineDisplayed(false);
            dataProfileStatisticsData.setGraphDataModel(graphDataModel);
        }
    }

    private GraphDataModel createGraphDataModelGroupByGeneric(GraphDataModel graphDataModel, String string, String string2) {
        int n;
        boolean bl;
        if (graphDataModel == null) {
            graphDataModel = new DefaultGraphDataModel(null, 18, null, null, null);
            bl = false;
        } else {
            graphDataModel.clear();
            bl = true;
        }
        AttributeHistogramArray attributeHistogramArray = this.getHistogram(string2);
        if (attributeHistogramArray == null || attributeHistogramArray.isEmpty()) {
            return graphDataModel;
        }
        ArrayList<String> arrayList = attributeHistogramArray.getBarTitles();
        int n2 = arrayList.size();
        AttributeHistogramArray attributeHistogramArray2 = this.getHistogram(string);
        ArrayList<String> arrayList2 = null;
        arrayList2 = attributeHistogramArray2 == null || attributeHistogramArray2.isEmpty() ? attributeHistogramArray.getGroupingBarTitles() : attributeHistogramArray2.getBarTitles();
        int n3 = arrayList2.size();
        Object[][] objectArray = new Object[n2][n3];
        Object[] objectArray2 = new Object[n2];
        Object[] objectArray3 = new String[n3];
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                objectArray[n][i] = Float.valueOf(0.0f);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            String string3 = arrayList.get(n);
            objectArray2[n] = bl ? string3 : "";
            ArrayList<NameValuePair> arrayList3 = attributeHistogramArray.getBarArray(string3.toString());
            for (int i = 0; i < arrayList3.size(); ++i) {
                NameValuePair nameValuePair = arrayList3.get(i);
                int n4 = arrayList2.indexOf("'" + nameValuePair.getName() + "'");
                if (n4 == -1) {
                    n4 = arrayList2.indexOf(nameValuePair.getName());
                }
                if (n4 == -1) continue;
                objectArray[n][n4] = Float.valueOf(((Float)nameValuePair.getValue()).floatValue());
            }
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            objectArray3[n] = bl ? arrayList2.get(n).toString() : "";
        }
        Color[] colorArray = this.generateColors(objectArray3.length);
        graphDataModel.addColumnLabels(objectArray2);
        graphDataModel.addRowLabels(objectArray3);
        graphDataModel.addRowColors(colorArray);
        graphDataModel.addGraphData(objectArray);
        if (bl) {
            graphDataModel.setTitle(StringUtils.trimDoubleQuotes(string2) + " " + DataProfileStatisticsLrb.get("TITLE_HISTOGRAM_BY") + " " + StringUtils.trimDoubleQuotes(string));
            graphDataModel.setLegendVisible(true);
            graphDataModel.setLegendSeriesCount(_LEGEND_SERIES_COUNT);
            graphDataModel.setDepthRadius(this.depthRadius);
        }
        return graphDataModel;
    }

    private GraphDataModel createAggregatedGraphDataModelGroupByGeneric(GraphDataModel graphDataModel, String string, String string2) {
        int n;
        if (graphDataModel == null) {
            graphDataModel = new DefaultGraphDataModel(null, 18, null, null, null);
        } else {
            graphDataModel.clear();
        }
        AttributeHistogramArray attributeHistogramArray = this.getHistogram(string2);
        if (attributeHistogramArray == null || attributeHistogramArray.isEmpty()) {
            return graphDataModel;
        }
        ArrayList<String> arrayList = attributeHistogramArray.getBarTitles();
        int n2 = arrayList.size();
        AttributeHistogramArray attributeHistogramArray2 = this.getHistogram(string);
        ArrayList<String> arrayList2 = null;
        arrayList2 = attributeHistogramArray2 == null || attributeHistogramArray2.isEmpty() ? attributeHistogramArray.getGroupingBarTitles() : attributeHistogramArray2.getBarTitles();
        Object[][] objectArray = new Object[n2][1];
        Object[] objectArray2 = new Object[n2];
        Object[] objectArray3 = new String[1];
        for (n = 0; n < n2; ++n) {
            objectArray[n][0] = 0.0;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            String string3 = arrayList.get(n);
            ArrayList<NameValuePair> arrayList3 = attributeHistogramArray.getBarArray(string3.toString());
            Float f = Float.valueOf(0.0f);
            for (int i = 0; i < arrayList3.size(); ++i) {
                NameValuePair nameValuePair = arrayList3.get(i);
                int n3 = arrayList2.indexOf("'" + nameValuePair.getName() + "'");
                if (n3 == -1) {
                    n3 = arrayList2.indexOf(nameValuePair.getName());
                }
                if (n3 == -1) continue;
                f = Float.valueOf(f.floatValue() + ((Float)nameValuePair.getValue()).floatValue());
            }
            objectArray[n][0] = Float.valueOf(f.floatValue());
        }
        for (n = 0; n < n2; ++n) {
            objectArray2[n] = "";
        }
        graphDataModel.addColumnLabels(objectArray2);
        graphDataModel.addRowLabels(objectArray3);
        graphDataModel.addGraphData(objectArray);
        graphDataModel.addRowColors(new Color[]{_BASE_CHART_COLOR});
        return graphDataModel;
    }

    public void clear() {
        if (this.histograms != null) {
            this.histograms.clear();
        }
        if (this.dataPoints != null) {
            this.dataPoints.clear();
        }
    }

    public DataProfileStatisticsData getDataPoint(String string) {
        if (null == this.dataPoints) {
            return null;
        }
        return this.dataPoints.get(string);
    }

    public List<DataProfileStatisticsData> getPoints() {
        if (null == this.dataPoints) {
            return null;
        }
        ArrayList<DataProfileStatisticsData> arrayList = new ArrayList<DataProfileStatisticsData>();
        arrayList.addAll(this.dataPoints.values());
        return arrayList;
    }

    public void addPoint(String string, String string2, Double d, Integer n, Double d2, String string3, Object object, Object object2, String string4, String string5, Double d3, Double d4, Double d5, Double d6, List<ExploreHistogramElement> list) {
        AttributeHistogramArray attributeHistogramArray;
        if (null == this.dataPoints.get(string)) {
            this.dataPoints.put(string, new DataProfileStatisticsData(string, string2, d, n, d2, string3, object, object2, string4, string5, d3, d4, d5, d6));
        }
        if ((attributeHistogramArray = this.histograms.get(string)) == null) {
            attributeHistogramArray = new AttributeHistogramArray();
            this.histograms.put(string, attributeHistogramArray);
        }
        for (ExploreHistogramElement exploreHistogramElement : list) {
            if (null == exploreHistogramElement.getGroupingAttributeValue()) {
                exploreHistogramElement.setGroupingAttributeValue(_NO_GROUPING);
            }
            attributeHistogramArray.addPoint(exploreHistogramElement.getAttributeValue(), exploreHistogramElement.getGroupingAttributeValue(), Float.valueOf(exploreHistogramElement.getAttributePercent().floatValue()));
        }
    }

    AttributeHistogramArray getHistogram(String string) {
        if (this.histograms == null) {
            return null;
        }
        return this.histograms.get(string);
    }

    private Color[] generateColors(int n) {
        int n2 = _RESERVED_COLORS.length + _EXTRA_COLORS[0].length * 2;
        if (n > n2) {
            return this.generateRandomColors(n);
        }
        Color[] colorArray = new Color[n];
        if (n <= _RESERVED_COLORS.length) {
            System.arraycopy(_RESERVED_COLORS, 0, colorArray, 0, n);
            return colorArray;
        }
        System.arraycopy(_RESERVED_COLORS, 0, colorArray, 0, _RESERVED_COLORS.length);
        int n3 = _RESERVED_COLORS.length;
        int n4 = n - n3;
        if (n4 < _EXTRA_COLORS[0].length) {
            System.arraycopy(_EXTRA_COLORS[0], 0, colorArray, n3, n4);
            return colorArray;
        }
        System.arraycopy(_EXTRA_COLORS[0], 0, colorArray, n3, _EXTRA_COLORS[0].length);
        n4 = n - (n3 += _EXTRA_COLORS[0].length);
        System.arraycopy(_EXTRA_COLORS[1], 0, colorArray, n3, n4);
        return colorArray;
    }

    private Color[] generateRandomColors(int n) {
        Color[] colorArray = new Color[n];
        int n2 = 2;
        while (!(Math.pow(++n2, 3.0) >= (double)n)) {
        }
        int n3 = 255 / n2;
        int n4 = 0;
        block1: for (int i = 255; i >= 0; i -= n3) {
            for (int j = 0; j <= 255; j += n3) {
                for (int k = 255; k >= 0; k -= n3) {
                    colorArray[n4++] = new Color(i, j, k);
                    if (n4 != n - 1) continue;
                    colorArray[n4] = colorArray[0];
                    break block1;
                }
            }
        }
        return colorArray;
    }

    static {
        _listBuffer.append("ATTR");
        _listBuffer.append(_comma);
        _listBuffer.append("DATA_TYPE");
        _listBuffer.append(_comma);
        _listBuffer.append("NULL_PERCENT");
        _listBuffer.append(_comma);
        _listBuffer.append("DISTINCT_CNT");
        _listBuffer.append(_comma);
        _listBuffer.append("DISTINCT_PERCENT");
        _listBuffer.append(_comma);
        _listBuffer.append("MODE_VALUE");
        _listBuffer.append(_comma);
        _listBuffer.append("AVG");
        _listBuffer.append(_comma);
        _listBuffer.append("AVG_DATE");
        _listBuffer.append(_comma);
        _listBuffer.append("AVG_TS_TZ");
        _listBuffer.append(_comma);
        _listBuffer.append("MEDIAN_VAL");
        _listBuffer.append(_comma);
        _listBuffer.append("MEDIAN_DATE");
        _listBuffer.append(_comma);
        _listBuffer.append("MEDIAN_TS_TZ");
        _listBuffer.append(_comma);
        _listBuffer.append("MIN");
        _listBuffer.append(_comma);
        _listBuffer.append("MAX");
        _listBuffer.append(_comma);
        _listBuffer.append("STD");
        _listBuffer.append(_comma);
        _listBuffer.append("VAR");
        _listBuffer.append(_comma);
        _listBuffer.append("SKEWNESS");
        _listBuffer.append(_comma);
        _listBuffer.append("KURTOSIS");
        _listBuffer.append(_comma);
        _listBuffer.append("HISTOGRAMS");
        _QUERY = "SELECT <attribute_list> from <table_name>";
    }

    private class AttributeHistogramArray {
        ArrayList<NameValuePair> attributeValuesBars = new ArrayList();

        private AttributeHistogramArray() {
        }

        boolean isEmpty() {
            return this.attributeValuesBars.isEmpty();
        }

        ArrayList<String> getGroupingBarTitles() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (NameValuePair nameValuePair : this.attributeValuesBars) {
                ArrayList<NameValuePair> arrayList2 = ConverterHelper.objectToNameValuePairList(nameValuePair.getValue());
                for (NameValuePair nameValuePair2 : arrayList2) {
                    if (null != hashMap.get(nameValuePair2.getName())) continue;
                    arrayList.add(nameValuePair2.getName());
                    hashMap.put(nameValuePair2.getName(), nameValuePair2.getName());
                }
            }
            return arrayList;
        }

        ArrayList<String> getBarTitles() {
            ArrayList<String> arrayList = new ArrayList<String>(this.attributeValuesBars.size());
            for (int i = 0; i < this.attributeValuesBars.size(); ++i) {
                NameValuePair nameValuePair = this.attributeValuesBars.get(i);
                arrayList.add(nameValuePair.getName());
            }
            return arrayList;
        }

        ArrayList<NameValuePair> getBarArray(String string) {
            ArrayList<NameValuePair> arrayList = null;
            for (int i = 0; i < this.attributeValuesBars.size(); ++i) {
                NameValuePair nameValuePair = this.attributeValuesBars.get(i);
                if (!string.equals(nameValuePair.getName())) continue;
                arrayList = ConverterHelper.objectToNameValuePairList(nameValuePair.getValue());
            }
            return arrayList;
        }

        void addPoint(Object object, String string, Float f) {
            boolean bl = false;
            for (int i = 0; i < this.attributeValuesBars.size(); ++i) {
                NameValuePair nameValuePair = this.attributeValuesBars.get(i);
                if (object != null && object.toString().equals(nameValuePair.getName())) {
                    ArrayList<NameValuePair> arrayList = ConverterHelper.objectToNameValuePairList(nameValuePair.getValue());
                    arrayList.add(new NameValuePair(string, f));
                    bl = true;
                    continue;
                }
                if (object != null) continue;
                for (NameValuePair nameValuePair2 : this.attributeValuesBars) {
                    if (!nameValuePair2.getName().equals("Null")) continue;
                    ArrayList<NameValuePair> arrayList = ConverterHelper.objectToNameValuePairList(nameValuePair2.getValue());
                    arrayList.add(new NameValuePair(string, f));
                    bl = true;
                }
            }
            if (!bl) {
                ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
                arrayList.add(new NameValuePair(string, f));
                this.attributeValuesBars.add(new NameValuePair(object != null ? object.toString() : "Null", arrayList));
            }
        }
    }
}

