/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.dprofiler;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dmt.dataminer.dprofiler.DataProfileViewPanel;
import oracle.dmt.dataminer.teditor.AbstractDataEditor;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.BlockingComponent;

public class DataProfilerEditor
extends AbstractDataEditor
implements Controller {
    private static final Logger theLogger = Logger.getLogger(DataProfilerEditor.class.getName());
    private JLabel filterLabel;
    private JTextField filter;
    private static final String DEFAULT_FILTER_TEXT = DataLrb.get("DATA_VIEWER_FILTER_WHERE_CLAUSE");
    private BlockingComponent overLayPanel = null;

    public DataProfilerEditor() throws Exception {
        this._context = this.getContext();
        this.createActions();
        this.filterLabel = new JLabel();
        this.filter = new JTextField(DEFAULT_FILTER_TEXT);
        this.filter.setForeground(this.filter.getDisabledTextColor());
        ResourceUtils.resLabel((JLabel)this.filterLabel, (Component)this.filter, (String)DataLrb.get("DATA_VIEWER_FILTER_LABEL"));
        this.filterLabel.getAccessibleContext().setAccessibleDescription(DataLrb.get("DATA_VIEWER_FILTER_LABEL_ADA"));
        this.filterLabel.setToolTipText(DataLrb.get("DATA_VIEWER_FILTER_LABEL_ADA"));
        this.filter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (DataProfilerEditor.this.filter.getText().trim().toUpperCase().equals(DEFAULT_FILTER_TEXT.toUpperCase())) {
                    DataProfilerEditor.this.filter.setText("");
                    DataProfilerEditor.this.filter.setForeground(DataProfilerEditor.this.filter.getCaretColor());
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (DataProfilerEditor.this.filter.getText().equals("")) {
                    DataProfilerEditor.this.filter.setText(DEFAULT_FILTER_TEXT);
                    DataProfilerEditor.this.filter.setForeground(DataProfilerEditor.this.filter.getDisabledTextColor());
                }
            }
        });
    }

    @Override
    public ContextMenuListener getContextMenuListener() {
        return null;
    }

    @Override
    public Component getGUI() {
        try {
            if (this._gui == null) {
                this._gui = new DataProfileViewPanel(this, this.getContext());
                if (this.overLayPanel == null) {
                    this.overLayPanel = new BlockingComponent((JComponent)this._gui);
                    this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
                    this.overLayPanel.setMessage(BlockingComponent.Message.LOADING);
                    ((DataProfileViewPanel)this._gui).setBlockingComponent(this.overLayPanel);
                }
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return this.overLayPanel.getBlockingComponent();
    }

    public void initialize() {
        this._context = this.getContext();
    }

    private void createActions() {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    @Override
    public void refresh() {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        super.refresh();
        if (this._gui != null) {
            ((DataProfileViewPanel)this._gui).reload();
        }
    }

    public HelpInfo getHelpInfo() {
        assert (this._gui != null) : "getHelpInfo can not be called if _gui has not been loaded.";
        return new HelpInfo("data_profile_viewer_statistics");
    }

    @Override
    public void close() {
        if (this._gui != null) {
            ((DataProfileViewPanel)this._gui).clear();
        }
    }
}

