/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.expressionbuilder;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dmt.dataminer.expressionbuilder.AbstractExpressionBuilderContext;
import oracle.dmt.dataminer.expressionbuilder.AggregateContext;
import oracle.dmt.dataminer.expressionbuilder.AggregateMainGroupBy;
import oracle.dmt.dataminer.expressionbuilder.ComputeFieldContext;
import oracle.dmt.dataminer.expressionbuilder.DialogsLrb;
import oracle.dmt.dataminer.expressionbuilder.ExpressionBuilderDialog;
import oracle.dmt.dataminer.expressionbuilder.Filter2DContext;
import oracle.dmt.dataminer.expressionbuilder.FilterJoinContext;
import oracle.dmt.dataminer.expressionbuilder.GriddedPanel;
import oracle.dmt.dataminer.expressionbuilder.PartitionExpressionBuilderContext;
import oracle.dmt.dataminer.expressionbuilder.SQLExpressionItemData;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.comparator.ColumnInfoComparator;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateEditExpressionPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DBHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.partition.PartitionLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.JoinNode;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;

public class ExpressionBuilderMainPanel
extends GriddedPanel {
    private static final Logger theLogger = Logger.getLogger(ExpressionBuilderMainPanel.class.getName());
    private static final String newAttributeQuery = "SELECT {0} AS {1} FROM \"{2}\".\"{3}\"";
    private static final String aggregateQuery = "SELECT {0} FROM \"{1}\".\"{2}\"";
    private static final String dynamicQuery1 = "SELECT {0} FROM \"{1}\".\"{2}\"";
    private static final String dynamicQuery2 = "SELECT {0} FROM ( {1} )";
    private static final String filter2DQuery = "SELECT * FROM \"{0}\".\"{1}\" WHERE {2}";
    private static final String newAttributeQuery2 = "SELECT {0} AS {1} FROM ( {2} )";
    private static final String aggregateQuery2 = "SELECT {0} FROM ( {1} )";
    private static final String filter2DQuery2 = "SELECT * FROM ( {0} ) WHERE {1}";
    private static final int ATTRIBUTE_NAME_LENGTH_MAX = 30;
    private AbstractExpressionBuilderContext m_ebc = null;
    private ExpressionBuilderDialog m_parent = null;
    private boolean m_expressionDirty = false;
    private Context m_context = null;
    private String m_origAttribName = null;
    private String m_expressionDataType = "UNKNOWN";
    private JTabbedPane m_tpExprAssist = new JTabbedPane();
    private JTree m_treeAttributeList = new JTree();
    private JTree m_treeFunctionList = new JTree();
    private JTextField m_txtAttributeName = null;
    private BasicEditorPane m_taExpressionEditor = EditorFactory.createIdeEditorPane();
    private JTextArea m_taValidationResults = new JTextArea();
    private JButton m_btnValidate = new JButton();
    private JLabel m_attrDatatype = new JLabel();
    private final JButton[] btnFunctions = new JButton[]{new JButton("<"), new JButton(">"), new JButton("<="), new JButton(">="), new JButton("!="), new JButton("="), new JButton("Or"), new JButton("And"), new JButton("("), new JButton(")"), new JButton("||"), new JButton("+"), new JButton("-"), new JButton("*"), new JButton("/"), new JButton("%")};

    public ExpressionBuilderMainPanel(Context context, AbstractExpressionBuilderContext abstractExpressionBuilderContext, ExpressionBuilderDialog expressionBuilderDialog) {
        try {
            this.m_context = context;
            this.m_ebc = abstractExpressionBuilderContext;
            this.m_parent = expressionBuilderDialog;
            if (abstractExpressionBuilderContext instanceof ComputeFieldContext) {
                this.m_origAttribName = ((ComputeFieldContext)abstractExpressionBuilderContext).getAttributeName();
            }
            this.jbInit();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void enableOutputName(boolean bl) {
        if (this.m_txtAttributeName != null) {
            this.m_txtAttributeName.setEnabled(bl);
        }
    }

    private void jbInit() throws Exception {
        JComponent jComponent;
        String string;
        Object object;
        int n = 0;
        this.loadAttributeList();
        this.loadFunctionList();
        JScrollPane jScrollPane = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane.getViewport().add(this.m_treeAttributeList);
        jScrollPane2.getViewport().add(this.m_treeFunctionList);
        jScrollPane.setMinimumSize(new Dimension(250, 50));
        jScrollPane2.setMinimumSize(new Dimension(250, 50));
        this.m_tpExprAssist.add(DialogsLrb.get("EXPBLDR_TAB_ATTRIBUTES"), jScrollPane);
        this.m_tpExprAssist.add(DialogsLrb.get("EXPBLDR_TAB_FUNCTIONS"), jScrollPane2);
        this.addFilledComponent(this.m_tpExprAssist, TOPLABELITEMINSETS, n, 0, 1, 8, 1);
        this.addFilledComponent(this.m_attrDatatype, LASTINGROUP, n + 8, 0, 1, 1, 2);
        JLabel jLabel = new JLabel(DialogsLrb.get("EXPBLDR_PANEL_EXPRESSION"));
        if (this.m_ebc instanceof ComputeFieldContext) {
            object = (ComputeFieldContext)this.m_ebc;
            string = ((ComputeFieldContext)object).getAttributeName();
            this.m_txtAttributeName = new JTextField(string);
            jComponent = new JLabel(DialogsLrb.get("EXPBLDR_PANEL_COLUMN_NAME"));
            ((JLabel)jComponent).setLabelFor(this.m_txtAttributeName);
            this.addFilledComponent(jComponent, TOPLABELITEMINSETS, n, 1, 1, 1, 2);
            this.addFilledComponent(this.m_txtAttributeName, TOPLABELITEMINSETS, n++, 2, 2, 1, 2);
            this.addFilledComponent(jLabel, TOPLABELITEMINSETS, n++, 1, 3, 1, 2);
        } else {
            this.addFilledComponent(jLabel, TOPLABELITEMINSETS, n++, 1, 3, 1, 2);
        }
        this.m_taExpressionEditor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ExpressionBuilderMainPanel.this.setExpressionDirty(true);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ExpressionBuilderMainPanel.this.setExpressionDirty(true);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ExpressionBuilderMainPanel.this.setExpressionDirty(true);
            }
        });
        object = new JScrollPane();
        ((JScrollPane)object).setViewportView((Component)this.m_taExpressionEditor);
        this.m_taExpressionEditor.setDocument((Document)new BasicDocument("foo.plsql"));
        this.m_taExpressionEditor.setText(this.m_ebc.getExpression());
        string = new HighlightEditorPlugin();
        this.m_taExpressionEditor.installPlugin((EditorPlugin)string);
        this.addFilledComponent((JComponent)object, MIDLABELITEMINSETS, n, 1, 4, 2, 1);
        n += 2;
        jComponent = new JPanel();
        GridLayout gridLayout = new GridLayout(2, 8);
        gridLayout.setHgap(2);
        gridLayout.setVgap(2);
        jComponent.setLayout(gridLayout);
        jComponent.setMinimumSize(new Dimension(500, 50));
        jComponent.setPreferredSize(new Dimension(500, 50));
        jComponent.setMaximumSize(new Dimension(500, 50));
        for (int i = 0; i < this.btnFunctions.length; ++i) {
            this.btnFunctions[i].setMinimumSize(new Dimension(50, 30));
            jComponent.add(this.btnFunctions[i]);
            final int n2 = i;
            this.btnFunctions[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ExpressionBuilderMainPanel.this.m_taExpressionEditor.getCaretPosition();
                    String string = " " + ExpressionBuilderMainPanel.this.btnFunctions[n2].getText() + " ";
                    try {
                        ExpressionBuilderMainPanel.this.m_taExpressionEditor.insertString(n, string, null);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    ExpressionBuilderMainPanel.this.m_taExpressionEditor.setCaretPosition(n + string.length());
                    ExpressionBuilderMainPanel.this.m_taExpressionEditor.requestFocusInWindow();
                }
            });
        }
        this.addFilledComponent(jComponent, TOPLABELITEMINSETS, n++, 1, 4, 1, 0);
        JLabel jLabel2 = new JLabel(DialogsLrb.get("EXPBLDR_PANEL_VALIDATION_RESULTS"));
        this.addFilledComponent(jLabel2, TOPLABELITEMINSETS, n++, 1, 3, 1, 2);
        this.m_taValidationResults.setEditable(false);
        this.m_taValidationResults.setLineWrap(true);
        this.m_taValidationResults.setWrapStyleWord(true);
        JScrollPane jScrollPane3 = new JScrollPane();
        jScrollPane3.getViewport().add(this.m_taValidationResults);
        this.addFilledComponent(jScrollPane3, MIDLABELITEMINSETS, n, 1, 3, 2, 1);
        this.addFilledComponent(this.m_btnValidate, MIDLABELITEMINSETS, n, 4, 2);
        this.m_btnValidate.setText(DialogsLrb.get("EXPBLDR_PANEL_VALIDATE"));
        this.m_btnValidate.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionBuilderMainPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    if (ExpressionBuilderMainPanel.this.validateExpression()) {
                        if (StringUtils.checkDataLossWithMsg(ExpressionBuilderMainPanel.this.m_context, ExpressionBuilderMainPanel.this.getExpression(), oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb.get("ERROR_TITLE"))) {
                            ExpressionBuilderMainPanel.this.setExpressionDirty(true);
                        } else {
                            ExpressionBuilderMainPanel.this.setValidationAreaText(DialogsLrb.get("EXPBLDR_PANEL_VALIDATE_SUCCESS"));
                            ExpressionBuilderMainPanel.this.setExpressionDirty(false);
                        }
                    } else {
                        ExpressionBuilderMainPanel.this.setExpressionDirty(false);
                    }
                }
                catch (Exception exception) {
                    boolean bl = ExpressionBuilderMainPanel.this.m_ebc instanceof AggregateMainGroupBy;
                    if (ExpressionBuilderMainPanel.this.m_ebc.getNode().validateCompleteChain(bl)) {
                        ExpressionBuilderMainPanel.this.setValidationAreaText(exception.getLocalizedMessage());
                        ExpressionBuilderMainPanel.this.setExpressionDirty(true);
                    } else {
                        ExpressionBuilderMainPanel.this.showMessageInfo(DialogsLrb.get("EXPBLDR_PANEL_VALIDATE_RUN_PARENT"));
                    }
                }
                finally {
                    ExpressionBuilderMainPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        HelpUtils.setHelpID((JComponent)this, (String)"expression_builder");
    }

    public Vector getSourceAttributeNames() {
        Vector<String> vector = new Vector<String>();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.m_treeAttributeList.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            vector.add(defaultMutableTreeNode2.getUserObject().toString());
        }
        return vector;
    }

    private void loadAttributeList() {
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(null);
        this.m_treeAttributeList.setCellRenderer(defaultTreeCellRenderer);
        this.m_treeAttributeList.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)ExpressionBuilderMainPanel.this.m_treeAttributeList.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                Object object2 = defaultMutableTreeNode.getUserObject();
                String string = "";
                if (object2 instanceof AttrObject) {
                    object = (AttrObject)object2;
                    string = ((AttrObject)object).toDataType();
                }
                object = MessageFormat.format(DialogsLrb.get("EXPBLDR_TAB_ATTRIBUTES_TYPE"), string);
                ExpressionBuilderMainPanel.this.m_attrDatatype.setText((String)object);
            }
        });
        this.m_treeAttributeList.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(DialogsLrb.get("EXPBLDR_TAB_LOADING"))));
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void loadFunctionList() {
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(null);
        this.m_treeFunctionList.setCellRenderer(defaultTreeCellRenderer);
        this.m_treeFunctionList.setRootVisible(false);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(DialogsLrb.get("EXPBLDR_TAB_FUNCTIONS"));
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(DialogsLrb.get("EXPBLDR_TAB_FUNCTIONS_CHARACTER"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(DialogsLrb.get("EXPBLDR_TAB_FUNCTIONS_CONVERSION"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(DialogsLrb.get("EXPBLDR_TAB_FUNCTIONS_DATE"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(DialogsLrb.get("EXPBLDR_TAB_FUNCTIONS_NUMERIC"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(DialogsLrb.get("EXPBLDR_TAB_FUNCTIONS_ANALYTICAL"));
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(DialogsLrb.get("EXPBLDR_TAB_FUNCTIONS_AGGREGATE"));
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(DialogsLrb.get("EXPBLDR_TAB_FUNCTIONS_NVS"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        if (this.m_ebc instanceof ComputeFieldContext) {
            defaultMutableTreeNode.add(defaultMutableTreeNode6);
        } else if (this.m_ebc instanceof AggregateContext) {
            defaultMutableTreeNode.add(defaultMutableTreeNode7);
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode8);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        Vector vector = null;
        vector = SQLExpressionItemData.getCharacterFunctions();
        this.loadFunctionTreeNode(defaultMutableTreeNode2, vector);
        vector = SQLExpressionItemData.getConversionFunctions();
        this.loadFunctionTreeNode(defaultMutableTreeNode3, vector);
        vector = SQLExpressionItemData.getDateFunctions();
        this.loadFunctionTreeNode(defaultMutableTreeNode4, vector);
        vector = SQLExpressionItemData.getNumericFunctions();
        this.loadFunctionTreeNode(defaultMutableTreeNode5, vector);
        if (this.m_ebc instanceof ComputeFieldContext) {
            vector = SQLExpressionItemData.getAnalyticalFunctions();
            this.loadFunctionTreeNode(defaultMutableTreeNode6, vector);
        } else if (this.m_ebc instanceof AggregateContext) {
            vector = SQLExpressionItemData.getAggregateFunctions();
            this.loadFunctionTreeNode(defaultMutableTreeNode7, vector);
        }
        vector = SQLExpressionItemData.getNullValueSubstitutionFunctions();
        this.loadFunctionTreeNode(defaultMutableTreeNode8, vector);
        this.m_treeFunctionList.setModel(defaultTreeModel);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    TreePath treePath = ExpressionBuilderMainPanel.this.m_treeFunctionList.getSelectionPath();
                    if (treePath != null) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        if (ExpressionBuilderMainPanel.this.m_treeAttributeList.getModel().isLeaf(defaultMutableTreeNode)) {
                            Object object = defaultMutableTreeNode.getUserObject();
                            if (object instanceof SQLExpressionItemData) {
                                SQLExpressionItemData sQLExpressionItemData = (SQLExpressionItemData)object;
                                String string = ExpressionBuilderMainPanel.this.getSqlTemplate(sQLExpressionItemData);
                                ExpressionBuilderMainPanel.this.insertText(ExpressionBuilderMainPanel.this.m_taExpressionEditor, string);
                            }
                        } else if (ExpressionBuilderMainPanel.this.m_treeAttributeList.isExpanded(treePath)) {
                            ExpressionBuilderMainPanel.this.m_treeFunctionList.collapsePath(treePath);
                        } else {
                            ExpressionBuilderMainPanel.this.m_treeFunctionList.expandPath(treePath);
                        }
                        keyEvent.consume();
                    }
                } else {
                    super.keyPressed(keyEvent);
                }
            }
        };
        this.m_treeFunctionList.addKeyListener(keyAdapter);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                Object object;
                int n = ExpressionBuilderMainPanel.this.m_treeFunctionList.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = ExpressionBuilderMainPanel.this.m_treeFunctionList.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 2 && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof SQLExpressionItemData) {
                    SQLExpressionItemData sQLExpressionItemData = (SQLExpressionItemData)object;
                    String string = ExpressionBuilderMainPanel.this.getSqlTemplate(sQLExpressionItemData);
                    ExpressionBuilderMainPanel.this.insertText(ExpressionBuilderMainPanel.this.m_taExpressionEditor, string);
                }
            }
        };
        this.m_treeFunctionList.addMouseListener(mouseAdapter);
    }

    private String getSqlTemplate(SQLExpressionItemData sQLExpressionItemData) {
        return sQLExpressionItemData.getTemplate();
    }

    private void insertText(BasicEditorPane basicEditorPane, String string) {
        int n;
        int n2 = basicEditorPane.getCaretPosition();
        int n3 = basicEditorPane.getSelectionStart();
        if (n3 < (n = basicEditorPane.getSelectionEnd())) {
            basicEditorPane.replaceSelection(string);
            basicEditorPane.setCaretPosition(n3 + string.length());
        } else {
            try {
                basicEditorPane.insertString(n2, string, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            basicEditorPane.setCaretPosition(n2 + string.length());
        }
        basicEditorPane.requestFocusInWindow();
    }

    private void loadFunctionTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SQLExpressionItemData sQLExpressionItemData = (SQLExpressionItemData)enumeration.nextElement();
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(sQLExpressionItemData));
        }
    }

    public String getAttributeName() {
        return this.m_txtAttributeName.getText();
    }

    public String getExpression() {
        return this.m_taExpressionEditor.getText();
    }

    public void setExpression(String string) {
        this.m_taExpressionEditor.setText(string);
    }

    public void setValidationAreaText(String string) {
        this.m_taValidationResults.setText(string);
    }

    private void setExpressionDirty(boolean bl) {
        this.m_expressionDirty = bl;
    }

    public boolean isExpressionDirty() {
        return this.m_expressionDirty;
    }

    public String getExpressionDataType() {
        return this.m_expressionDataType;
    }

    public boolean doWork() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.m_ebc instanceof ComputeFieldContext) {
            try {
                if (!this.validateAttributeName()) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return false;
                }
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        if (this.isExpressionDirty() || this.m_ebc instanceof PartitionExpressionBuilderContext) {
            boolean bl;
            block10: {
                bl = false;
                try {
                    if (this.validateExpression()) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    boolean bl2 = this.m_ebc instanceof AggregateMainGroupBy;
                    if (this.m_ebc.getNode().validateCompleteChain(bl2)) {
                        this.setValidationAreaText(exception.getLocalizedMessage());
                    }
                    if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("EXPBLDR_PANEL_VALIDATE_RUN_PARENT_CONFIRM"), (String)DialogsLrb.get("WARNING_TITLE"), null)) break block10;
                    bl = true;
                }
            }
            if (!bl) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                return false;
            }
        }
        return !StringUtils.checkDataLossWithMsg(this.m_context, this.getExpression(), DialogsLrb.get("ERROR_TITLE"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateAttributeName() throws Exception {
        Object object;
        String string = this.getAttributeName();
        String string2 = null;
        if (!(this.m_ebc instanceof ComputeFieldContext)) {
            throw new Exception("Unexpected usage context.");
        }
        ComputeFieldContext computeFieldContext = (ComputeFieldContext)this.m_ebc;
        if (null == string || string.equalsIgnoreCase("")) {
            string2 = DialogsLrb.get("EXPBLDR_ERROR_ATTRIBUTE_EMPTY");
            this.showMessage(string2);
            return false;
        }
        if (!StringUtils.checkStringLength(string, 30)) {
            string2 = DialogsLrb.get("EXPBLDR_ERROR_ATTRIBUTE_TOOLONG");
            this.showMessage(string2);
            return false;
        }
        if (StringUtils.isEqualToROWID(string)) {
            string2 = DialogsLrb.get("EXPBLDR_ERROR_ATTRIBUTE_NAME_RESERVED");
            this.showMessage(string2);
            return false;
        }
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(this.m_context);
            if (StringUtils.isGreater32BytesInDB(string, connection)) {
                string2 = DialogsLrb.get("EXPBLDR_ERROR_ATTRIBUTE_32");
                this.showMessage(string2);
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            SQLHelper.close(connection);
        }
        Vector vector = this.getSourceAttributeNames();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!string.equals(object) || string.equals(this.m_origAttribName)) continue;
            string2 = DialogsLrb.get("EXPBLDR_ERROR_ATTRIBUTE_EXISTS_IN_SOURCE");
            this.showMessage(string2);
            return false;
        }
        object = computeFieldContext.getDefinedFieldNames();
        if (object != null) {
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (!string.equals(object[i]) || string.equals(this.m_origAttribName)) continue;
                string2 = DialogsLrb.get("EXPBLDR_ERROR_ATTRIBUTE_NOT_UNIQUE");
                this.showMessage(string2);
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean validateExpression() throws Exception {
        Object object;
        Object object2;
        String string = this.getExpression();
        String string2 = null;
        if (null == string || string.equalsIgnoreCase("")) {
            string2 = DialogsLrb.get("EXPBLDR_ERROR_EXPRESSION_EMPTY");
            this.showMessage(string2);
            return false;
        }
        if (string.length() > 4000) {
            string2 = DialogsLrb.get("EXPBLDR_ERROR_EXPRESSION_EXCEED_MAX");
            this.showMessage(string2);
            return false;
        }
        if (this.m_ebc instanceof FilterJoinContext) {
            object2 = (FilterJoinContext)this.m_ebc;
            for (String string3 : ((FilterJoinContext)object2).getSourceQueries()) {
                AggregateEditExpressionPanel.executeSQL(this.m_context, string3);
            }
        } else {
            AggregateEditExpressionPanel.executeSQL(this.m_context, this.m_ebc.getQuery());
        }
        object2 = new StringBuffer(32000);
        if (this.m_ebc instanceof ComputeFieldContext) {
            ((StringBuffer)object2).append(this.formNewAttributeQuery());
        } else if (this.m_ebc instanceof AggregateContext) {
            ((StringBuffer)object2).append(this.formAggregateQuery());
        } else if (this.m_ebc instanceof Filter2DContext) {
            ((StringBuffer)object2).append(this.formFilter2DQuery());
        } else if (this.m_ebc instanceof FilterJoinContext) {
            object = (JoinNode)this.m_ebc.getNode();
            String string4 = ((JoinNode)object).getSQLExpressionForValidate(string);
            if (string4 == null) {
                string2 = oracle.dmt.dataminer.workflow.dialog.join.DialogsLrb.get("JOIN_FILTER_NO_JOIN_DEFINED");
                this.showMessage(string2);
                return false;
            }
            ((StringBuffer)object2).append(((JoinNode)object).getSQLExpressionForValidate(string));
        } else if (this.m_ebc instanceof AggregateMainGroupBy) {
            ((StringBuffer)object2).append(this.formAggregateMainGroupBy());
        } else {
            if (!(this.m_ebc instanceof PartitionExpressionBuilderContext)) throw new Exception("Unexpected ExpressionBuilderContext type encountered");
            ((StringBuffer)object2).append(this.formDynamicQuery());
            this.m_expressionDataType = DBHelper.getSQLExpressionDataType(this.m_context, ((StringBuffer)object2).toString());
            if (!DatabaseMetadataUtils.isKeyDataTypeSupported(this.m_expressionDataType)) {
                string2 = PartitionLrb.get("PARTITION_UNSUPPORTED_DATA_TYPE_ERROR");
                this.showMessage(string2);
                return false;
            }
        }
        if (object2 == null) return true;
        if (((StringBuffer)object2).length() <= 0) return true;
        object = this.m_ebc.getNode();
        if (object instanceof TransformationNode) {
            DBHelper.clientValidate(this.m_context, (StringBuffer)object2);
            return true;
        }
        AggregateEditExpressionPanel.executeSQL(this.m_context, ((StringBuffer)object2).toString());
        return true;
    }

    private String formNewAttributeQuery() {
        String string = this.getAttributeName();
        if (!string.startsWith("\"") || !string.endsWith("\"")) {
            string = "\"" + string + "\"";
        }
        if (this.m_ebc.getQuery() != null) {
            Object[] objectArray = new Object[]{this.getExpression(), this.getAttributeName(), this.m_ebc.getQuery()};
            return MessageFormat.format(newAttributeQuery2, objectArray);
        }
        Object[] objectArray = new Object[]{this.getExpression(), this.getAttributeName(), this.m_ebc.getSchemaName(), this.m_ebc.getTableName()};
        return MessageFormat.format(newAttributeQuery, objectArray);
    }

    private String formAggregateMainGroupBy() {
        String string = "SELECT {0} FROM ( {1} )";
        AggregateMainGroupBy aggregateMainGroupBy = (AggregateMainGroupBy)this.m_ebc;
        if (this.m_ebc.getQuery() != null) {
            Object[] objectArray = new Object[]{this.getExpression(), aggregateMainGroupBy.getQuery()};
            string = MessageFormat.format("SELECT {0} FROM ( {1} )", objectArray);
        }
        return string;
    }

    private String formAggregateQuery() {
        String string = "SELECT {0} FROM \"{1}\".\"{2}\"";
        AggregateContext aggregateContext = (AggregateContext)this.m_ebc;
        String string2 = null;
        String string3 = null;
        if (aggregateContext.isGroupBy()) {
            string2 = this.getExpression();
            string3 = aggregateContext.getHavingExpression();
        } else {
            string2 = aggregateContext.getGroupByExpression();
            string3 = this.getExpression();
        }
        boolean bl = false;
        boolean bl2 = false;
        if (null != string2 && string2.length() > 0) {
            bl = true;
        }
        if (null != string3 && string3.length() > 0) {
            bl2 = true;
        }
        if (this.m_ebc.getQuery() != null) {
            Object[] objectArray = new Object[]{aggregateContext.getSelectClause(), aggregateContext.getQuery()};
            string = MessageFormat.format("SELECT {0} FROM ( {1} )", objectArray);
        } else {
            Object[] objectArray = new Object[]{aggregateContext.getSelectClause(), aggregateContext.getSchemaName(), aggregateContext.getTableName()};
            string = MessageFormat.format("SELECT {0} FROM \"{1}\".\"{2}\"", objectArray);
        }
        if (bl) {
            string = string + " GROUP BY " + string2;
        }
        if (bl2) {
            string = string + " HAVING " + string3;
        }
        return string;
    }

    private String formDynamicQuery() {
        Object[] objectArray = null;
        PartitionExpressionBuilderContext partitionExpressionBuilderContext = (PartitionExpressionBuilderContext)this.m_ebc;
        if (this.m_ebc.getQuery() != null) {
            objectArray = new Object[]{this.getExpression(), partitionExpressionBuilderContext.getQuery()};
            return MessageFormat.format("SELECT {0} FROM ( {1} )", objectArray);
        }
        objectArray = new Object[]{this.getExpression(), partitionExpressionBuilderContext.getSchemaName(), partitionExpressionBuilderContext.getTableName()};
        return MessageFormat.format("SELECT {0} FROM \"{1}\".\"{2}\"", objectArray);
    }

    private String formFilter2DQuery() {
        if (this.m_ebc.getQuery() != null) {
            Filter2DContext filter2DContext = (Filter2DContext)this.m_ebc;
            Object[] objectArray = new Object[]{filter2DContext.getQuery(), this.getExpression()};
            return MessageFormat.format(filter2DQuery2, objectArray);
        }
        Filter2DContext filter2DContext = (Filter2DContext)this.m_ebc;
        Object[] objectArray = new Object[]{filter2DContext.getSchemaName(), filter2DContext.getTableName(), this.getExpression()};
        return MessageFormat.format(filter2DQuery, objectArray);
    }

    private void showMessage(String string) {
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)DialogsLrb.get("ERROR_TITLE"), null);
    }

    private void showMessageInfo(String string) {
        MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)DialogsLrb.get("WARNING_TITLE"), null);
    }

    class AttrObject {
        Vector _columnInfo;

        AttrObject(Vector vector) {
            this._columnInfo = vector;
        }

        public String toString() {
            return this._columnInfo.get(0).toString();
        }

        public String toDataType() {
            return this._columnInfo.get(1).toString();
        }
    }

    private class LoadUI
    extends SwingWorker {
        private DefaultTreeModel _model = null;
        Exception _ex = null;
        boolean _success = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = Connections.getUniqueConnection(ExpressionBuilderMainPanel.this.m_context);
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                if (ExpressionBuilderMainPanel.this.m_ebc instanceof FilterJoinContext) {
                    FilterJoinContext filterJoinContext = (FilterJoinContext)ExpressionBuilderMainPanel.this.m_ebc;
                    AbstractNode[] abstractNodeArray = filterJoinContext.getSourceNodes();
                    defaultMutableTreeNode = new DefaultMutableTreeNode("Nodes");
                    for (AbstractNode abstractNode : abstractNodeArray) {
                        if (!(abstractNode instanceof AbstractDataNode)) continue;
                        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(abstractNode.getData().getName());
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                        AbstractDataNode abstractDataNode = (AbstractDataNode)abstractNode;
                        List list = abstractDataNode.getAttributes().getAttribute();
                        for (AttributeType attributeType : list) {
                            Vector<String> vector = new Vector<String>(3);
                            String string = attributeType.getAlias() != null && !attributeType.getAlias().trim().isEmpty() ? attributeType.getAlias() : attributeType.getName();
                            vector.add(string);
                            vector.add(attributeType.getDataType());
                            vector.add(DatabaseMetadataUtils.getDefaultMiningType(attributeType.getDataType()));
                            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(string);
                            defaultMutableTreeNode3.setUserObject(new AttrObject(vector));
                            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                        }
                    }
                } else {
                    Object object;
                    List list;
                    Object object2;
                    Vector<Object> vector = null;
                    AbstractNode abstractNode = null;
                    if (ExpressionBuilderMainPanel.this.m_ebc.getTableName() == null && (abstractNode = ExpressionBuilderMainPanel.this.m_ebc instanceof Filter2DContext ? ((Filter2DContext)ExpressionBuilderMainPanel.this.m_ebc).getSourceNode() : ExpressionBuilderMainPanel.this.m_ebc.getNode()) instanceof AbstractDataNode) {
                        object2 = (AbstractDataNode)abstractNode;
                        list = null;
                        list = object2 instanceof TransformationNode ? ((TransformationNode)object2).getNonTransformedAttributes().getAttribute() : object2.getAttributes().getAttribute();
                        vector = new Vector<Object>();
                        object = null;
                        for (AttributeType attributeType : list) {
                            if (!DatabaseMetadataUtils.isKeyDataTypeSupported(attributeType.getDataType())) continue;
                            String string = DatabaseMetadataUtils.getDefaultMiningType(attributeType.getDataType());
                            object = new Vector(3);
                            ((Vector)object).add(attributeType.getAlias() != null && !attributeType.getAlias().trim().isEmpty() ? attributeType.getAlias() : attributeType.getName());
                            ((Vector)object).add(attributeType.getDataType());
                            ((Vector)object).add(string);
                            vector.add(object);
                        }
                        if (!vector.isEmpty()) {
                            Collections.sort(vector, ColumnInfoComparator.getComparator());
                        }
                    }
                    defaultMutableTreeNode = new DefaultMutableTreeNode("Node");
                    object2 = vector.elements();
                    while (object2.hasMoreElements()) {
                        list = (Vector)object2.nextElement();
                        object = (String)((Vector)list).get(0);
                        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(object);
                        defaultMutableTreeNode4.setUserObject(new AttrObject((Vector)list));
                        defaultMutableTreeNode.add(defaultMutableTreeNode4);
                    }
                }
                this._model = new DefaultTreeModel(defaultMutableTreeNode);
                this._success = true;
            }
            catch (Exception exception) {
                try {
                    this._ex = exception;
                    this._success = false;
                }
                catch (Throwable throwable) {
                    SQLHelper.close(connection);
                    throw throwable;
                }
                SQLHelper.close(connection);
            }
            SQLHelper.close(connection);
            return this;
        }

        @Override
        protected void done() {
            super.done();
            try {
                if (this._success) {
                    ExpressionBuilderMainPanel.this.m_treeAttributeList.setModel(this._model);
                    KeyAdapter keyAdapter = new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent keyEvent) {
                            if (keyEvent.getKeyCode() == 10) {
                                TreePath treePath = ExpressionBuilderMainPanel.this.m_treeAttributeList.getSelectionPath();
                                if (treePath != null) {
                                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                                    if (ExpressionBuilderMainPanel.this.m_treeAttributeList.getModel().isLeaf(defaultMutableTreeNode)) {
                                        Object object = defaultMutableTreeNode.getUserObject();
                                        String string = null;
                                        string = ExpressionBuilderMainPanel.this.m_ebc instanceof FilterJoinContext ? "\"" + defaultMutableTreeNode.getParent().toString() + "\".\"" + object.toString() + "\" " : "\"" + object.toString() + "\" ";
                                        ExpressionBuilderMainPanel.this.insertText(ExpressionBuilderMainPanel.this.m_taExpressionEditor, string);
                                    }
                                    keyEvent.consume();
                                }
                            } else {
                                super.keyPressed(keyEvent);
                            }
                        }
                    };
                    ExpressionBuilderMainPanel.this.m_treeAttributeList.addKeyListener(keyAdapter);
                    MouseAdapter mouseAdapter = new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent mouseEvent) {
                            int n = ExpressionBuilderMainPanel.this.m_treeAttributeList.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                            TreePath treePath = ExpressionBuilderMainPanel.this.m_treeAttributeList.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                            if (n != -1 && mouseEvent.getClickCount() == 2) {
                                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                                if (ExpressionBuilderMainPanel.this.m_treeAttributeList.getModel().isLeaf(defaultMutableTreeNode)) {
                                    Object object = defaultMutableTreeNode.getUserObject();
                                    String string = null;
                                    string = ExpressionBuilderMainPanel.this.m_ebc instanceof FilterJoinContext ? "\"" + defaultMutableTreeNode.getParent().toString() + "\".\"" + object.toString() + "\" " : "\"" + object.toString() + "\" ";
                                    ExpressionBuilderMainPanel.this.insertText(ExpressionBuilderMainPanel.this.m_taExpressionEditor, string);
                                }
                            }
                        }
                    };
                    ExpressionBuilderMainPanel.this.m_treeAttributeList.addMouseListener(mouseAdapter);
                } else {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("UNABLE_TO_CREATE_VIEW"), null);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("UNABLE_TO_CREATE_VIEW"), null);
            }
        }
    }
}

