/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.legend;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.dmt.dataminer.legend.Legend;
import oracle.dmt.dataminer.legend.LegendConsumer;
import oracle.dmt.dataminer.legend.LegendDockableFactory;
import oracle.dmt.dataminer.legend.LegendWindow;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.javaxide.Util;
import oracle.ide.layout.ViewId;
import oracle.javatools.jndi.Names;

public class LegendManager
implements Controller,
Addin {
    private static Icon _icon;
    protected static final String LEGEND_MANAGER_NAME = "dataminer/legend-manager";
    public static final int VIEW_LEGEND_ID;
    Legend legend = Legend.getInstance();
    LegendWindow legendWindow;
    private ArrayList<MetaClass> metaConsumers;

    public Legend getLegend() {
        return this.legend;
    }

    public static LegendManager getLegendManager() {
        LegendManager legendManager = (LegendManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)LEGEND_MANAGER_NAME);
        return legendManager;
    }

    public LegendWindow getLegendWindow() {
        if (this.legendWindow == null) {
            this.legendWindow = LegendWindow.getInstance();
        }
        return this.legendWindow;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == VIEW_LEGEND_ID) {
            DockStation dockStation = DockStation.getDockStation();
            ViewId viewId = new ViewId("DATAMININGLEGENDFACTORY", "LEGEND");
            Dockable dockable = dockStation.findDockable(viewId);
            dockStation.activateDockable(dockable);
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    public void initialize() {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)LEGEND_MANAGER_NAME, (Object)this);
        this.createActions();
        DockStation dockStation = DockStation.getDockStation();
        dockStation.registerDockableFactory("DATAMININGLEGENDFACTORY", (DockableFactory)LegendDockableFactory.getInstance());
    }

    private void createActions() {
        IdeAction ideAction = IdeAction.get((int)VIEW_LEGEND_ID, (String)null, (String)"Legend", (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)null, (Icon)DataMinerIcons.get(Icons.LEGEND), null, (boolean)true);
        ideAction.addController((Controller)this);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction);
        MenuManager.getJMenu((String)"View").add(jMenuItem);
    }

    public void addLegendConsumerClass(MetaClass metaClass) {
        if (this.metaConsumers == null) {
            this.metaConsumers = new ArrayList();
        }
        this.metaConsumers.add(metaClass);
    }

    public void removeLegendConsumerClass(MetaClass metaClass) {
        this.metaConsumers.remove(metaClass);
    }

    protected List<LegendConsumer> getLegendConsumers() {
        if (this.metaConsumers != null) {
            ArrayList<LegendConsumer> arrayList = new ArrayList<LegendConsumer>();
            for (MetaClass metaClass : this.metaConsumers) {
                LegendConsumer legendConsumer;
                try {
                    legendConsumer = (LegendConsumer)Util.createInstance((MetaClass)metaClass, LegendConsumer.class);
                }
                catch (Exception exception) {
                    legendConsumer = null;
                }
                if (legendConsumer == null) continue;
                arrayList.add(legendConsumer);
            }
            return Collections.unmodifiableList(arrayList);
        }
        return null;
    }

    static {
        VIEW_LEGEND_ID = Ide.createCmdID((String)"dataminer.legendViewLegend");
    }
}

