/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer;

import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.ClipboardImp;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.TreeRulesSettings;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusTreeRule;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeLink;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeNode;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusterTreeSDMModel;
import oracle.dmt.dataminer.mviewer.dtree.DTTreeRule;
import oracle.dmt.dataminer.mviewer.dtree.model.DTTreeLink;
import oracle.dmt.dataminer.mviewer.dtree.model.DTTreeNode;
import oracle.dmt.dataminer.mviewer.dtree.model.DecisionTreeSDMModel;
import oracle.dmt.dataminer.navigator.modelnodes.ClusteringModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Node;
import oracle.javatools.data.PropertyStorage;

public class TreeRulesPanel
extends JPanel
implements DataminerGUIPanel {
    private static final Logger theLogger = Logger.getLogger(TreeRulesPanel.class.getName());
    private static Preferences _p = Preferences.getPreferences();
    private TreeRulesSettings treeRulesSettings = TreeRulesSettings.getInstance((PropertyStorage)_p);
    private ButtonGroup OptionButtonGroup;
    private JSeparator jSeparator1;
    private JCheckBox leavesOnlyCheck;
    private JRadioButton saveToClipboarOption;
    private JRadioButton saveToFileOption;

    public TreeRulesPanel() {
        this.initComponents();
        this.initRes();
    }

    private void initComponents() {
        this.OptionButtonGroup = new ButtonGroup();
        this.leavesOnlyCheck = new JCheckBox();
        this.saveToClipboarOption = new JRadioButton();
        this.saveToFileOption = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.leavesOnlyCheck.setSelected(true);
        this.leavesOnlyCheck.setText("Leaves Only");
        this.OptionButtonGroup.add(this.saveToClipboarOption);
        this.saveToClipboarOption.setSelected(true);
        this.saveToClipboarOption.setText("Save to Clipboard");
        this.OptionButtonGroup.add(this.saveToFileOption);
        this.saveToFileOption.setText("Save to File");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1)).addGroup(groupLayout.createSequentialGroup().addGap(19, 19, 19).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.saveToClipboarOption).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.saveToFileOption)).addGap(25, 25, 25).addComponent(this.leavesOnlyCheck).addGap(9, 9, 9))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.saveToClipboarOption).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveToFileOption, -2, 23, -2).addComponent(this.leavesOnlyCheck)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2)));
    }

    @Override
    public void initRes() {
        this.leavesOnlyCheck.setText(ModelViewerLrb.get("TREE_RULES_LEAVES_CHK"));
        this.saveToClipboarOption.setText(ModelViewerLrb.get("TREE_RULES_SAVE_CLIPBOARD"));
        this.saveToFileOption.setText(ModelViewerLrb.get("TREE_RULES_SAVE_FILE"));
    }

    @Override
    public void initUI() {
    }

    public boolean invoke(final Node node) {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 3;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, "", n);
        final TreeRulesPanel treeRulesPanel = new TreeRulesPanel();
        jEWTDialog.setContent((Component)treeRulesPanel);
        jEWTDialog.setResizable(false);
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getNewValue();
                if (string.equals("closed") && Boolean.TRUE.equals(object) && !treeRulesPanel.doWork(node)) {
                    throw new PropertyVetoException("panel", propertyChangeEvent);
                }
            }
        });
        jEWTDialog.setTitle(ModelViewerLrb.get("TREE_RULES_DIALOG_TITLE"));
        WizardLauncher.runDialog((JDialog)jEWTDialog);
        return true;
    }

    public boolean doWork(Node node) {
        try {
            if (this.saveToClipboarOption.isSelected()) {
                if (node instanceof ClusteringModelNode) {
                    this.copyClusterRules(node, this.leavesOnlyCheck.isSelected());
                } else if (node instanceof DTModelNode) {
                    this.copyDTRules(node, this.leavesOnlyCheck.isSelected());
                }
            } else if (this.saveToFileOption.isSelected()) {
                Object object;
                if (node instanceof ClusteringModelNode) {
                    object = this.getHTMLClusterRules(node, this.leavesOnlyCheck.isSelected());
                    String string = ((ClusteringModelNode)node).getOdmModel().getModelName() + "_Rules";
                    this.saveRuleFiles(string, (String)object);
                } else if (node instanceof DTModelNode) {
                    object = this.getHTMLDTRues(node, this.leavesOnlyCheck.isSelected());
                    String string = ((DTModelNode)node).getOdmModel().getModelName() + "_Rules";
                    this.saveRuleFiles(string, (String)object);
                }
                object = new JFileChooser();
            }
            return true;
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            return false;
        }
    }

    public boolean isLeave(IlvSDMNode ilvSDMNode) {
        if (ilvSDMNode instanceof ClusTreeNode) {
            return ((ClusTreeNode)ilvSDMNode).getData().getChild().size() == 0;
        }
        return false;
    }

    public void copyDTRules(Node node, boolean bl) {
        try {
            String string = this.getHTMLDTRues(node, bl);
            new ClipboardImp(string);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public String getHTMLDTRues(Node node, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("<html>");
        if (node instanceof DTModelNode) {
            String string = ((DTModelNode)node).getOdmModel().getModelName();
            stringBuilder.append("<p><strong>" + ModelViewerLrb.get("TREE_RULES_MODEL_NAME") + ": " + string + "</strong></p>");
            DecisionTreeSDMModel decisionTreeSDMModel = (DecisionTreeSDMModel)((DTModelNode)node).getSDMModel();
            LinkedHashMap<String, IlvSDMNode> linkedHashMap = decisionTreeSDMModel.getNodeStore();
            Set<String> set = linkedHashMap.keySet();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2;
                IlvSDMNode ilvSDMNode = linkedHashMap.get(iterator.next());
                if (ilvSDMNode instanceof DTTreeLink || !(ilvSDMNode instanceof DTTreeNode)) continue;
                DTTreeNode dTTreeNode = (DTTreeNode)ilvSDMNode;
                if (bl) {
                    string2 = ilvSDMNode.getID();
                    List<DTTreeLink> list = decisionTreeSDMModel.findLinksFromNode(ilvSDMNode);
                    if (list.size() != 0) continue;
                    String string3 = String.valueOf(dTTreeNode.getData().getId());
                    stringBuilder.append("<br><p><strong> " + ModelViewerLrb.get("TREE_RULES_NODE") + ": " + string3 + "</strong></p><br>");
                    stringBuilder.append(DTTreeRule.getRulesHtml(dTTreeNode, true));
                    continue;
                }
                string2 = String.valueOf(dTTreeNode.getData().getId());
                stringBuilder.append("<br><p><strong>" + ModelViewerLrb.get("TREE_RULES_NODE") + ": " + string2 + "</strong></p><br>");
                stringBuilder.append(DTTreeRule.getRulesHtml(dTTreeNode, true));
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public String getHTMLClusterRules(Node node, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("<html>");
        if (node instanceof ClusteringModelNode) {
            String string = ((ClusteringModelNode)node).getOdmModel().getModelName();
            stringBuilder.append("<p><strong>" + ModelViewerLrb.get("TREE_RULES_MODEL_NAME") + ": " + string + "</strong></p>");
            ClusterTreeSDMModel clusterTreeSDMModel = (ClusterTreeSDMModel)((ClusteringModelNode)node).getSDMModel();
            LinkedHashMap<String, IlvSDMNode> linkedHashMap = clusterTreeSDMModel.getNodeStore();
            Set<String> set = linkedHashMap.keySet();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2;
                String string3;
                IlvSDMNode ilvSDMNode = linkedHashMap.get(iterator.next());
                if (ilvSDMNode instanceof ClusTreeLink || !(ilvSDMNode instanceof ClusTreeNode)) continue;
                ClusTreeNode clusTreeNode = (ClusTreeNode)ilvSDMNode;
                if (bl) {
                    if (!this.isLeave(ilvSDMNode)) continue;
                    string3 = clusTreeNode.getData().getCluster_id();
                    if (string3.equals(string2 = String.valueOf(clusTreeNode.getData().getId()))) {
                        stringBuilder.append("<br><p><strong> " + ModelViewerLrb.get("TREE_RULES_CLUSTER") + ": " + string3 + "</strong></p><br>");
                    } else {
                        stringBuilder.append("<br><p><strong>" + ModelViewerLrb.get("TREE_RULES_CLUSTER") + ": " + string3 + " (" + string2 + ")</strong></p><br>");
                    }
                    stringBuilder.append(ClusTreeRule.getRulesHtml(clusTreeNode, true, 10, true));
                    continue;
                }
                string3 = clusTreeNode.getData().getCluster_id();
                if (string3.equals(string2 = String.valueOf(clusTreeNode.getData().getId()))) {
                    stringBuilder.append("<br><p><strong> " + ModelViewerLrb.get("TREE_RULES_CLUSTER") + ": " + string3 + "</strong></p><br>");
                } else {
                    stringBuilder.append("<br><p><strong>" + ModelViewerLrb.get("TREE_RULES_CLUSTER") + ": " + string3 + " (" + string2 + ")</strong></p><br>");
                }
                stringBuilder.append(ClusTreeRule.getRulesHtml(clusTreeNode, true, 10, true));
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public void copyClusterRules(Node node, boolean bl) {
        try {
            String string = this.getHTMLClusterRules(node, bl);
            new ClipboardImp(string);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void saveRuleFiles(String string, String string2) {
        FileOutputStream fileOutputStream = null;
        Object var4_4 = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            File file;
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Html/Text files", "html", "txt", ".doc", "docx");
            URLFileChooser uRLFileChooser = new URLFileChooser();
            String string3 = this.getLastPath();
            if (string3 != null && !string3.equals("")) {
                file = new File(string3);
                if (file.isFile()) {
                    file = file.getParentFile();
                }
                if (file.exists()) {
                    uRLFileChooser.setCurrentDirectory(file);
                    string3 = file.getAbsolutePath();
                } else {
                    string3 = uRLFileChooser.getCurrentDirectory().getAbsolutePath();
                }
            }
            file = new File(string3 + File.separator + string + ".html");
            int n = 1;
            while (file.exists()) {
                String string4 = string + n;
                file = new File(string3 + File.separator + string4 + ".html");
                ++n;
            }
            uRLFileChooser.setSelectedFile(file);
            uRLFileChooser.setFileFilter((FileFilter)fileNameExtensionFilter);
            int n2 = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow());
            if (n2 == 0) {
                String string5 = uRLFileChooser.getSelectedFile().getAbsolutePath();
                this.treeRulesSettings.setLastPathUsedValue(uRLFileChooser.getSelectedFile().getParent());
                File file2 = new File(string5);
                fileOutputStream = new FileOutputStream(file2);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                outputStreamWriter.write(string2);
                ((Writer)outputStreamWriter).close();
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public String getLastPath() {
        return this.treeRulesSettings.getLastPathUsedValue();
    }
}

