/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.util.HashMap;
import oracle.dmt.dataminer.server.model.AssociationRules;
import oracle.ide.Context;

public class ARGlobalMetrics {
    private AssociationRules _model = null;
    private String _modelName;
    private String _userName;
    private Context _context;
    private int _total_rules_count;
    private int _total_itemset_count;
    private Double _maximum_lift_value;
    private boolean onlyOneColumnNameInModelItems = true;
    private boolean onlyOneSubColumnNameInModelItems = true;
    private boolean onlyOneConstantValueInModelItems = true;
    private boolean noSubNameColumnsInModelItems = false;
    private Integer totalNumberOfSingleOccuringItems = 1000;

    public ARGlobalMetrics(Context context, AssociationRules associationRules, String string, String string2) {
        assert (context != null) : "Context must not be null";
        assert (associationRules != null) : "Model must not be null";
        assert (string != null) : "UserName must not be null";
        assert (string2 != null) : "ModelName must not be null";
        this._context = context;
        this._model = associationRules;
        this._userName = string;
        this._modelName = string2;
    }

    public void loadGlobalMetrics() throws Exception {
        HashMap hashMap = this._model.getGlobalMetrics(this._context, this._userName, this._modelName);
        this._total_rules_count = (Integer)hashMap.get("TOTAL_RULES_COUNT");
        this._maximum_lift_value = (Double)hashMap.get("MAXIMUM_LIFT_VALUE");
        this._total_itemset_count = (Integer)hashMap.get("TOTAL_ITEMSET_COUNT");
        Integer n = (Integer)hashMap.get("SINGLE_ITEMSET_COUNT");
        Integer n2 = (Integer)hashMap.get("ATTRIBUTE_SUBNAME_COUNT");
        String string = (String)hashMap.get("MIN_ATTRIBUTE_NAME");
        String string2 = (String)hashMap.get("MAX_ATTRIBUTE_NAME");
        String string3 = (String)hashMap.get("MIN_ATTRIBUTE_SUBNAME");
        String string4 = (String)hashMap.get("MAX_ATTRIBUTE_SUBNAME");
        Object v = hashMap.get("MIN_ATTRIBUTE_VALUE");
        Object v2 = hashMap.get("MAX_ATTRIBUTE_VALUE");
        if (this._total_rules_count != 0) {
            this.onlyOneColumnNameInModelItems = string.compareTo(string2) == 0;
            this.onlyOneSubColumnNameInModelItems = string3 != null ? string3.compareTo(string4) == 0 : true;
            this.noSubNameColumnsInModelItems = n2 == 0;
            this.totalNumberOfSingleOccuringItems = n;
            if (v instanceof Number) {
                this.onlyOneConstantValueInModelItems = (Number)v == (Number)v2;
            } else if (v == null) {
                this.onlyOneConstantValueInModelItems = true;
            } else if (v instanceof String) {
                this.onlyOneConstantValueInModelItems = ((String)v).compareTo((String)v2) == 0;
            } else {
                throw new Exception("Unknown data type for attribute value in model.");
            }
        }
    }

    public boolean isOnlyOneColumnNameInModelItems() {
        return this.onlyOneColumnNameInModelItems;
    }

    public boolean isOnlyOneSubColumnNameInModelItems() {
        return this.onlyOneSubColumnNameInModelItems;
    }

    public boolean isOnlyOneConstantValueInModelItems() {
        return this.onlyOneConstantValueInModelItems;
    }

    public boolean isNoSubNameColumnsInModelItems() {
        return this.noSubNameColumnsInModelItems;
    }

    public Integer getTotalNumberOfSingleOccuringItems() {
        return this.totalNumberOfSingleOccuringItems;
    }

    public int getTotal_rules_count() {
        return this._total_rules_count;
    }

    public Double getMaximum_lift_value() {
        return this._maximum_lift_value;
    }

    public int getTotal_itemset_count() {
        return this._total_itemset_count;
    }
}

