/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.arrules.ARItemSetsMainPanel;
import oracle.dmt.dataminer.mviewer.arrules.ARItemSetsSettings;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.server.model.ItemSetsFilterSetting;
import oracle.dmt.dataminer.server.model.SortSpec;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.BlockingComponent;

public class ARItemSetsFilterPanel
extends JPanel {
    private boolean _loaded;
    private ARItemSetsMainPanel _mainPanel;
    private ItemSetsFilterSetting _filterSetting;
    private static final String SORT_BY_SUPPORT = ARRulesLrb.get("FILTER_ITEMSETS_SORT_BY_SUPPORT");
    private static final String SORT_BY_SIZE = ARRulesLrb.get("RULE_LENGTH_COLUMN");
    private static final String SORT_BY_ID = ARRulesLrb.get("ITEM_SETS_ID_COLUMN");
    private static final String[] ITEMSETS_SORT_COMBO_VALUES = new String[]{SORT_BY_SUPPORT, SORT_BY_SIZE, SORT_BY_ID};
    private static final String ORDER_BY_DESCENDING = ARRulesLrb.get("DESCENDING");
    private static final String ORDER_BY_ASCENDING = ARRulesLrb.get("ASCENDING");
    private static final String[] SORT_ORDER_COMBO_VALUES = new String[]{ORDER_BY_DESCENDING, ORDER_BY_ASCENDING};
    private boolean _filterExpanded = false;
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private ARItemSetsSettings _arItemSetsFilterSettings = ARItemSetsSettings.getInstance((PropertyStorage)_p);
    private BlockingComponent overLayPanel = null;
    private JButton _jApplyFilterButton;
    private JCheckBox _jChkBoxUseFilter;
    private JButton _jExpandButton;
    private JLabel _jFetchSizeLabel;
    private JSpinner _jFetchSizeValue;
    private JPanel _jFilterControlsPanel;
    private JLabel _jMaximumItems;
    private JSpinner _jMaximumItemsValue;
    private JLabel _jMinimumSupport;
    private JSpinner _jMinimumSupportValue;
    private JLabel _jSortByLabel1;
    private JComboBox _jSortCombo1;
    private JComboBox _jSortOrderCombo1;

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public ARItemSetsFilterPanel(ARItemSetsMainPanel aRItemSetsMainPanel, Context context) throws Exception {
        this._mainPanel = aRItemSetsMainPanel;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jSortByLabel1 = new JLabel();
        this._jSortCombo1 = new JComboBox();
        this._jSortOrderCombo1 = new JComboBox();
        this._jApplyFilterButton = new JButton();
        this._jChkBoxUseFilter = new JCheckBox();
        this._jFilterControlsPanel = new JPanel();
        this._jMinimumSupport = new JLabel();
        this._jMinimumSupportValue = new JSpinner();
        this._jMaximumItems = new JLabel();
        this._jMaximumItemsValue = new JSpinner();
        this._jFetchSizeLabel = new JLabel();
        this._jFetchSizeValue = new JSpinner();
        this._jExpandButton = new JButton();
        this._jSortByLabel1.setText("Sort by:");
        this._jApplyFilterButton.setText("Query");
        this._jApplyFilterButton.setMaximumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setMinimumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setPreferredSize(new Dimension(87, 23));
        this._jChkBoxUseFilter.setText("Use filter");
        this._jChkBoxUseFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._jChkBoxUseFilter.setMargin(new Insets(0, 0, 0, 0));
        this._jFilterControlsPanel.setBorder(BorderFactory.createTitledBorder("Filter"));
        this._jMinimumSupport.setText("Minimum Support (%):");
        this._jMaximumItems.setText("Maximum Items Per Set:");
        GroupLayout groupLayout = new GroupLayout(this._jFilterControlsPanel);
        this._jFilterControlsPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jMaximumItems, -1, 155, Short.MAX_VALUE).addComponent(this._jMinimumSupport, GroupLayout.Alignment.TRAILING, -1, 155, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jMaximumItemsValue).addComponent(this._jMinimumSupportValue, -1, 53, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jMinimumSupport).addComponent(this._jMinimumSupportValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jMaximumItems).addComponent(this._jMaximumItemsValue, -2, -1, -2)).addContainerGap()));
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jExpandButton.setText("More");
        this._jExpandButton.setMaximumSize(new Dimension(87, 23));
        this._jExpandButton.setMinimumSize(new Dimension(87, 23));
        this._jExpandButton.setPreferredSize(new Dimension(87, 23));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jFetchSizeLabel, -1, -1, Short.MAX_VALUE).addComponent(this._jSortByLabel1, -1, 101, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout2.createSequentialGroup().addGap(2, 2, 2).addComponent(this._jSortCombo1, -2, 117, -2)).addComponent(this._jFetchSizeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jSortOrderCombo1, -2, 123, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 107, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this._jExpandButton, -1, -1, Short.MAX_VALUE).addComponent(this._jApplyFilterButton, -1, 119, Short.MAX_VALUE)).addContainerGap()).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this._jChkBoxUseFilter, -1, 78, Short.MAX_VALUE).addGap(201, 201, 201)).addGroup(groupLayout2.createSequentialGroup().addGap(17, 17, 17).addComponent(this._jFilterControlsPanel, -2, -1, -2))).addGap(327, 327, 327)))));
        groupLayout2.linkSize(0, this._jFetchSizeValue, this._jSortCombo1);
        groupLayout2.linkSize(0, this._jFetchSizeLabel, this._jSortByLabel1);
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jSortByLabel1).addComponent(this._jApplyFilterButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jExpandButton, -2, -1, -2).addComponent(this._jFetchSizeLabel, -2, 14, -2))).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jSortCombo1, -2, -1, -2).addComponent(this._jSortOrderCombo1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jFetchSizeValue, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jChkBoxUseFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jFilterControlsPanel, -2, -1, -2).addContainerGap()));
    }

    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)ARRulesLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(ARRulesLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(DataMinerIcons.get(Icons.QUERY));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSizeValue, (String)ARRulesLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(ARRulesLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSizeValue.setToolTipText(ARRulesLrb.get("FETCH_SIZE_ADA") + "\n" + ARRulesLrb.get("FETCH_SIZE_RANGE"));
        ResourceUtils.resLabel((JLabel)this._jMaximumItems, (Component)this._jMaximumItemsValue, (String)ARRulesLrb.get("FILTER_ITEMSETS_MAXIMUM_ITEMS"));
        this._jMaximumItems.getAccessibleContext().setAccessibleName(ARRulesLrb.get("FILTER_ITEMSETS_MAXIMUM_ITEMS"));
        this._jMaximumItems.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("FILTER_ITEMSETS_MAXIMUM_ITEMS_ADA"));
        this._jMaximumItemsValue.setToolTipText(ARRulesLrb.get("FILTER_ITEMSETS_MAXIMUM_ITEMS_ADA"));
        ResourceUtils.resLabel((JLabel)this._jMinimumSupport, (Component)this._jMinimumSupportValue, (String)ARRulesLrb.get("MINIMUM_SUPPORT"));
        this._jMinimumSupport.getAccessibleContext().setAccessibleName(ARRulesLrb.get("MINIMUM_SUPPORT"));
        this._jMinimumSupport.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("MINIMUM_SUPPORT_ADA"));
        this._jMinimumSupportValue.setToolTipText(ARRulesLrb.get("MINIMUM_SUPPORT_ADA"));
        ResourceUtils.resLabel((JLabel)this._jSortByLabel1, (Component)this._jSortCombo1, (String)ARRulesLrb.get("SORT_BY"));
        this._jSortByLabel1.getAccessibleContext().setAccessibleName(ARRulesLrb.get("SORT_BY"));
        this._jSortByLabel1.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("SORT_BY_ADA"));
        this._jSortCombo1.setModel(new DefaultComboBoxModel<String>(ITEMSETS_SORT_COMBO_VALUES));
        this._jSortCombo1.setSelectedItem(SORT_BY_SUPPORT);
        this._jSortCombo1.setToolTipText(ARRulesLrb.get("SORT_BY_ADA"));
        this._jSortOrderCombo1.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ORDER"));
        this._jSortOrderCombo1.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("ORDER_ADA"));
        this._jSortOrderCombo1.setModel(new DefaultComboBoxModel<String>(SORT_ORDER_COMBO_VALUES));
        this._jSortOrderCombo1.setSelectedItem(ORDER_BY_DESCENDING);
        this._jSortOrderCombo1.setToolTipText(ARRulesLrb.get("ORDER_ADA"));
        ResourceUtils.resButton((AbstractButton)this._jExpandButton, (String)ARRulesLrb.get("MORE"));
        this._jExpandButton.setIcon(DataMinerIcons.get(Icons.EXPAND));
        this._jExpandButton.getAccessibleContext().setAccessibleName(ARRulesLrb.get("MORE"));
        this._jExpandButton.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("MORE_ADA"));
        this._jExpandButton.setHorizontalTextPosition(10);
        this._jFetchSizeValue.setModel(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 100));
        this._jMaximumItemsValue.setModel(new SpinnerNumberModel(4, 1, Integer.MAX_VALUE, 1));
        this._jMinimumSupportValue.setModel(new SpinnerNumberModel(1.0, 1.0E-5, 100.0, 1.0));
        this._jMinimumSupportValue.setEditor(new JSpinner.NumberEditor(this._jMinimumSupportValue, "#,##0.######;(#)"));
        ResourceUtils.resButton((AbstractButton)this._jChkBoxUseFilter, (String)ARRulesLrb.get("FILTER_USE_FILTER"));
        this._jChkBoxUseFilter.getAccessibleContext().setAccessibleName("FILTER_USE_FILTER");
        this._jChkBoxUseFilter.getAccessibleContext().setAccessibleDescription("FILTER_USE_FILTER_ADA");
        TitledBorder titledBorder = (TitledBorder)this._jFilterControlsPanel.getBorder();
        titledBorder.setTitle(ARRulesLrb.get("FILTER_BORDER_TITLE"));
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    private void setNumber(JSpinner jSpinner, Number number) {
        jSpinner.setValue(number);
    }

    public void initUI() throws Exception {
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ARItemSetsFilterPanel.this._jApplyFilterButton_actionPerformed(actionEvent);
            }
        });
        this._jExpandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ARItemSetsFilterPanel.this._jExpandButton_actionPerformed(actionEvent);
            }
        });
        this._jChkBoxUseFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ARItemSetsFilterPanel.this._jChkBoxUseFilter_actionPerformed(actionEvent);
            }
        });
        this.enableAllControls(true);
        this.showExtraFilterControls(false);
        this.enableAdvFilterControls(false);
        ((GroupLayout)this.getLayout()).invalidateLayout(this);
        this._filterSetting = new ItemSetsFilterSetting();
        this.loadStateAttributes();
    }

    private void _jChkBoxUseFilter_actionPerformed(ActionEvent actionEvent) {
        boolean bl = this._jChkBoxUseFilter.isSelected();
        this.enableAdvFilterControls(bl);
        this._filterSetting.setUseFilterSpecification(bl);
    }

    private void enableAdvFilterControls(boolean bl) {
        this._jMaximumItems.setEnabled(bl);
        this._jMaximumItemsValue.setEnabled(bl);
        this._jMinimumSupport.setEnabled(bl);
        this._jMinimumSupportValue.setEnabled(bl);
    }

    private void loadStateAttributes() {
        this.setNumber(this._jFetchSizeValue, this._modelViewerPrefenceSettings.getFetchSizeARModel());
        this.setNumber(this._jMaximumItemsValue, this._filterSetting.getMaxItemSetLength());
        this.setNumber(this._jMinimumSupportValue, this._filterSetting.getMinSupport() * 100.0);
        this._jSortCombo1.setSelectedItem(this.getSortState(0));
        this._jSortOrderCombo1.setSelectedItem(this.getSortOrderState(0));
    }

    private void setLoaded(boolean bl) {
        this._loaded = bl;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    protected void _jExpandButton_actionPerformed(ActionEvent actionEvent) {
        if (this._filterExpanded) {
            this._filterExpanded = false;
            this.showExtraFilterControls(this._filterExpanded);
            ResourceUtils.resButton((AbstractButton)this._jExpandButton, (String)ARRulesLrb.get("MORE"));
            this._jExpandButton.setIcon(DataMinerIcons.get(Icons.EXPAND));
            this._jExpandButton.getAccessibleContext().setAccessibleName(ARRulesLrb.get("MORE"));
            this._jExpandButton.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("MORE_ADA"));
            this._jExpandButton.setHorizontalTextPosition(10);
        } else {
            this._filterExpanded = true;
            this.showExtraFilterControls(this._filterExpanded);
            ResourceUtils.resButton((AbstractButton)this._jExpandButton, (String)ARRulesLrb.get("HIDE"));
            this._jExpandButton.setIcon(DataMinerIcons.get(Icons.COLLAPSE));
            this._jExpandButton.getAccessibleContext().setAccessibleName(ARRulesLrb.get("HIDE"));
            this._jExpandButton.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("HIDE_ADA"));
            this._jExpandButton.setHorizontalTextPosition(10);
        }
    }

    private void showExtraFilterControls(boolean bl) {
        this._jFilterControlsPanel.setVisible(bl);
        this._jChkBoxUseFilter.setVisible(bl);
    }

    private void enableAllControls(boolean bl) {
        this._jApplyFilterButton.setEnabled(bl);
        this._jFetchSizeValue.setEnabled(bl);
        this._jFetchSizeLabel.setEnabled(bl);
        if (this._jChkBoxUseFilter.isSelected()) {
            this.enableAdvFilterControls(bl);
        }
        this._jSortByLabel1.setEnabled(bl);
        this._jSortCombo1.setEnabled(bl);
        this._jSortOrderCombo1.setEnabled(bl);
        this._jChkBoxUseFilter.setEnabled(bl);
        this._jFetchSizeValue.setEnabled(bl);
    }

    private String getSortState(int n) {
        String string = "";
        SortSpec sortSpec = this._filterSetting.getSortSpecification().get(n);
        if ("SUPPORT".equals(sortSpec.getAttributeName())) {
            string = SORT_BY_SUPPORT;
        } else if ("NUMBER_OF_ITEMS".equals(sortSpec.getAttributeName())) {
            string = SORT_BY_SIZE;
        } else if ("ITEMSET_ID".equals(sortSpec.getAttributeName())) {
            string = SORT_BY_ID;
        } else {
            throw new IllegalArgumentException("Unrecognized sorting attribute selection");
        }
        return string;
    }

    private String getSortOrderState(int n) {
        String string = "";
        SortSpec sortSpec = this._filterSetting.getSortSpecification().get(n);
        if (sortSpec.getSortDirection() == SortSpec.SortDirection.DESCENDING) {
            string = ORDER_BY_DESCENDING;
        } else if (sortSpec.getSortDirection() == SortSpec.SortDirection.ASCENDING) {
            string = ORDER_BY_ASCENDING;
        } else {
            assert (false) : "Unrecognized sort order selection";
            string = "Unrecognized";
        }
        return string;
    }

    private void setSortState(int n, boolean bl, String string, String string2) {
        SortSpec sortSpec = this._filterSetting.getSortSpecification().get(n);
        sortSpec.setUseIt(bl);
        if (SORT_BY_SUPPORT.equals(string)) {
            sortSpec.setAttributeName("SUPPORT");
        } else if (SORT_BY_SIZE.equals(string)) {
            sortSpec.setAttributeName("NUMBER_OF_ITEMS");
        } else if (SORT_BY_ID.equals(string)) {
            sortSpec.setAttributeName("ITEMSET_ID");
        } else {
            throw new IllegalArgumentException("Unrecognized sort value selection: " + string);
        }
        if (ORDER_BY_DESCENDING.equals(string2)) {
            sortSpec.setSortDirection(SortSpec.SortDirection.DESCENDING);
        } else if (ORDER_BY_ASCENDING.equals(string2)) {
            sortSpec.setSortDirection(SortSpec.SortDirection.ASCENDING);
        } else {
            throw new IllegalArgumentException("Unrecognized sort order selection: " + string2);
        }
    }

    protected void _jApplyFilterButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
            }
            this.enableAllControls(false);
            this._arItemSetsFilterSettings.setMaximumItems(this.getNumber(this._jMaximumItemsValue).intValue());
            this._arItemSetsFilterSettings.setMinimumSupport(this.getNumber(this._jMinimumSupportValue).doubleValue() / 100.0);
            Number number = this.getNumber(this._jFetchSizeValue);
            this._filterSetting.setFetchSize(number.intValue());
            this._filterSetting.setMaxItemSetLength(this.getNumber(this._jMaximumItemsValue).intValue());
            this._filterSetting.setMinSupport(this.getNumber(this._jMinimumSupportValue).doubleValue() / 100.0);
            this.setSortState(0, true, (String)this._jSortCombo1.getSelectedItem(), (String)this._jSortOrderCombo1.getSelectedItem());
            this._mainPanel.setFilterState(this._filterSetting);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ARRulesLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)ARRulesLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
        }
    }

    public void setLoading(boolean bl) {
        this.enableAllControls(!bl);
    }

    public void setupUI(ItemSetsFilterSetting itemSetsFilterSetting) {
        this._filterSetting = itemSetsFilterSetting;
        this.loadStateAttributes();
        this.enableAllControls(true);
        this.setLoaded(true);
    }
}

