/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.server.model.ItemSet;
import oracle.dmt.dataminer.server.model.RuleContentOption;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class ARItemSetsTableModel
extends GenericBaseTableModel {
    private Vector<ItemSet> _data = new Vector(1000, 500);
    private static final int COLUMN_COUNT = 4;
    public static final int ITEMSETS_ID = 0;
    public static final int ITEMS = 1;
    public static final int SUPPORT = 2;
    public static final int SIZE = 3;
    private RuleContentOption _itemsetContentOption = RuleContentOption.SUBNAME_VALUE;
    private String[] _columnNames = new String[]{ARRulesLrb.get("ITEM_SETS_ID_COLUMN"), ARRulesLrb.get("ITEM_SETS_ITEMS_COLUMN"), ARRulesLrb.get("ITEM_SETS_SUPPORT_COLUMN"), ARRulesLrb.get("ITEM_SETS_SIZE_COLUMN")};

    public ARItemSetsTableModel() {
        this.setColumnIdentifiers(this._columnNames);
        this.setRowCount(0);
        this.setColumnCount(4);
    }

    public ARItemSetsTableModel(Vector<ItemSet> vector) {
        this.setColumnIdentifiers(this._columnNames);
        this._data = vector;
        this.setRowCount(vector.size());
        this.setColumnCount(4);
    }

    public ARItemSetsTableModel getFilteredItemSets(String string, int n) throws Exception {
        Vector<ItemSet> vector = null;
        Object object = this.getDataVector();
        vector = new Vector<ItemSet>(1000, 500);
        Iterator<ItemSet> iterator = ((Vector)object).iterator();
        ItemSet itemSet = null;
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            itemSet = iterator.next();
            if (bl) {
                bl2 = true;
            } else {
                SearchMatcher searchMatcher;
                String string2 = itemSet.getItemSetString();
                switch (n) {
                    case 0: {
                        searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
                        break;
                    }
                    case 1: {
                        searchMatcher = SearchMatcher.getPrefixMatcher((CharSequence)string, (boolean)true, (boolean)false);
                        break;
                    }
                    case 2: {
                        searchMatcher = SearchMatcher.getPrefixMatcher((CharSequence)string, (boolean)true, (boolean)true);
                        break;
                    }
                    default: {
                        assert (false) : "Invalid rule filter category.";
                        searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
                    }
                }
                bl2 = searchMatcher.matches((CharSequence)string2);
            }
            if (!bl2) continue;
            vector.add(itemSet);
        }
        object = new ARItemSetsTableModel(vector);
        ((ARItemSetsTableModel)((Object)object)).setItemsetContentOption(this._itemsetContentOption);
        return object;
    }

    public void addRows(Vector<ItemSet> vector) {
        for (ItemSet itemSet : vector) {
            this.getDataVector().add(itemSet);
        }
    }

    public int getRowCount() {
        if (this._data == null) {
            return 0;
        }
        return this._data.size();
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public ItemSet getRow(int n) {
        return this._data.get(n);
    }

    public void addSelection(ARItemSetsTableModel aRItemSetsTableModel, int[] nArray) {
        Vector<ItemSet> vector = aRItemSetsTableModel.getDataVector();
        ItemSet itemSet = null;
        for (int i = 0; i < nArray.length; ++i) {
            itemSet = vector.elementAt(nArray[i]);
            this._data.add(itemSet);
        }
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public Vector<ItemSet> getDataVector() {
        return this._data;
    }

    public void removeSelectedRows(int[] nArray) {
        Vector<ItemSet> vector = new Vector<ItemSet>();
        ItemSet itemSet = null;
        for (int i = 0; i < nArray.length; ++i) {
            itemSet = this._data.elementAt(nArray[i]);
            vector.add(itemSet);
        }
        this._data.removeAll(vector);
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        ItemSet itemSet = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = itemSet.getItemsets_id();
                break;
            }
            case 1: {
                object = itemSet.getItemSetString(this._itemsetContentOption, false);
                break;
            }
            case 2: {
                if (itemSet.getSupport() != null) {
                    object = itemSet.getSupport() * 100.0;
                    break;
                }
                object = itemSet.getSupport();
                break;
            }
            case 3: {
                object = itemSet.getNumber_of_items();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing itemsets";
                break;
            }
        }
        return object;
    }

    public void addRow(ItemSet itemSet) {
        this._data.add(itemSet);
    }

    public void setItemsetContentOption(RuleContentOption ruleContentOption) {
        this._itemsetContentOption = ruleContentOption;
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    public RuleContentOption getItemsetContentOption() {
        return this._itemsetContentOption;
    }
}

