/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.arrules.ARItemSetsDetailViewer;
import oracle.dmt.dataminer.mviewer.arrules.ARItemSetsMainPanel;
import oracle.dmt.dataminer.mviewer.arrules.ARItemSetsTableModel;
import oracle.dmt.dataminer.mviewer.arrules.ARItemSetsViewerState;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesViewerTableModel;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.ItemSet;
import oracle.dmt.dataminer.server.model.ItemSetsFilterSetting;
import oracle.dmt.dataminer.server.model.RuleContentOption;
import oracle.dmt.dataminer.utils.FileHelper;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;

public class ARItemSetsViewer
extends JPanel {
    private static final Logger theLogger = Logger.getLogger(ARItemSetsViewer.class.getName());
    ARItemSetsViewerState _state;
    ARItemSetsMainPanel _mainPanel;
    ARItemSetsDetailViewer _detailPanel;
    Context _context;
    public static final int ITEMSETS_FILTER_ITEMS_SUBSTRING = 0;
    public static final int ITEMSETS_FILTER_ITEMS_PREFIX_AND = 1;
    public static final int ITEMSETS_FILTER_ITEMS_PREFIX_OR = 2;
    String ITEMSET_ID_LABEL = "[ITEMSET_ID_LABEL]";
    String ITEMSET_ID_VALUE = "[ITEMSET_ID_VALUE]";
    String ITEMSET_DETAIL = "[ITEMSET_DETAIL]";
    String SUPPORT_LABEL = "[SUPPORT_LABEL]";
    String SUPPORT_VALUE = "[SUPPORT_VALUE]";
    String LENGTH_LABEL = "[LENGTH_LABEL]";
    String LENGTH_VALUE = "[LENGTH_VALUE]";
    String ITEM_LIST_LABEL = "[ITEM_LIST_LABEL]";
    private SearchField _jFilterCtl;
    private boolean _loadedFilterSetting = false;
    private boolean _modelEmpty = false;
    private int _currentSearchCategory = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(ARRulesLrb.get("ITEM_SETS_FILTER_CATEGORY_ITEMS_SUBSTRING"));
    private RuleContentOption _currentItemsetContentOption = RuleContentOption.SUBNAME;
    private String _htmlHeader = "<html>\n<body>";
    private String _htmlFooter = "</body>\n</html>";
    private StringBuffer _itemsetHTMLTemplate = new StringBuffer();
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private NumberFormat _labelFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private HistogramBarRenderer _barRenderer = new HistogramBarRenderer(100L, true, this._labelFormat);
    JLabel _jRowsOutOfTotalLabel = new JLabel();
    private GenericTable _jItemsetsGenericTable = new DataMinerTable();
    JScrollPane jScrollPane1;
    private JComponent _findPane;
    private String _jSelectSingleItemsetMesg;
    private BlockingComponent overLayPanel = null;
    private ComponentWithTitlebar<JComponent> _jItemsetViewerComponent;
    private JLabel _jShowItemsetContent;
    private JComboBox _jShowItemsetContentValue;
    private JSeparator jSeparator1;

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public ARItemSetsViewer(ARItemSetsMainPanel aRItemSetsMainPanel, Context context, ARItemSetsDetailViewer aRItemSetsDetailViewer) throws Exception {
        this._mainPanel = aRItemSetsMainPanel;
        this._context = context;
        this._detailPanel = aRItemSetsDetailViewer;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jShowItemsetContent = new JLabel();
        this._jShowItemsetContentValue = new JComboBox();
        this._jItemsetViewerComponent = new ComponentWithTitlebar();
        this.jSeparator1 = new JSeparator();
        this._jShowItemsetContent.setText("Itemset Content:");
        this._jShowItemsetContentValue.setModel(new DefaultComboBoxModel<String>(new String[]{"Name,Subname,Value", "Subname,Value", "Name,Subname", "Subname"}));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jItemsetViewerComponent, GroupLayout.Alignment.TRAILING, -1, 687, Short.MAX_VALUE).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 687, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this._jShowItemsetContent, -2, 155, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this._jShowItemsetContentValue, -2, 137, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jShowItemsetContent).addComponent(this._jShowItemsetContentValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this._jItemsetViewerComponent, -1, 231, Short.MAX_VALUE).addContainerGap()));
    }

    public void initRes() throws Exception {
        ResourceUtils.resLabel((JLabel)this._jShowItemsetContent, (Component)this._jShowItemsetContentValue, (String)ARRulesLrb.get("SHOW_ITEMSET_CONTENT"));
        this._jShowItemsetContent.getAccessibleContext().setAccessibleName(ARRulesLrb.get("SHOW_ITEMSET_CONTENT"));
        this._jShowItemsetContent.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("SHOW_ITEMSET_CONTENT_ADA"));
        this._jShowItemsetContentValue.setModel(new DefaultComboBoxModel<RuleContentOption>(RuleContentOption.values()));
        this._jShowItemsetContentValue.setSelectedItem((Object)this._currentItemsetContentOption);
        this._jShowItemsetContentValue.setToolTipText(ARRulesLrb.get("SHOW_ITEMSET_CONTENT_ADA"));
        this._jSelectSingleItemsetMesg = ARRulesLrb.get("SELECT_SINGLE_ITEMSET");
        this.loadItemsetHTMLTemplate();
    }

    public void initUI() throws Exception {
        this.loadEmptyRulesTable(ItemSetQueryMessages.LOADING);
        this._detailPanel.setItemsetDisplay(ARRulesLrb.get("NO_ITEM_SET_TO_DISPLAY"));
        this.jScrollPane1 = new JScrollPane((Component)this._jItemsetsGenericTable);
        this._jItemsetsGenericTable.setFillsViewportHeight(true);
        this._jItemsetViewerComponent.setComponent((JComponent)this.jScrollPane1);
        this._jItemsetViewerComponent.setLabel(this._jRowsOutOfTotalLabel);
        ControlBar controlBar = new ControlBar();
        this.setupFilterControl(controlBar);
        this._jItemsetViewerComponent.setControlBar(controlBar);
        this.initializeControls();
        this.addListeners();
        this._jItemsetsGenericTable.setSelectionMode(2);
        this._jItemsetsGenericTable.getSelectionModel().addListSelectionListener(new ItemSetTableSelectionHandler());
        this._jItemsetsGenericTable.setUseTransferHandler(true);
        this._jItemsetsGenericTable.setShowToolTips(true);
        this._jItemsetsGenericTable.setShowGrid(true);
        this._jItemsetsGenericTable.setShowHorizontalLines(true);
        this._jItemsetsGenericTable.setShowVerticalLines(true);
        this.setLoading(true);
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void setupFilterControl(ControlBar controlBar) {
        this._findPane = new Box(2);
        this._jFilterCtl = this.searchField();
        this._jFilterCtl.setStyle(SearchField.Style.FILTER);
        this._currentSearchCategory = 0;
        this._jFilterCtl.addCategory(this._defaultSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(ARRulesLrb.get("ITEM_SETS_FILTER_CATEGORY_ITEMS_PREFIX_AND")));
        this._jFilterCtl.addCategory(new SearchCategory(ARRulesLrb.get("ITEM_SETS_FILTER_CATEGORY_ITEMS_PREFIX_OR")));
        this._jFilterCtl.setSelectedCategory(this._defaultSearchCategory);
        this._findPane.setName("Find");
        this._findPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this._findPane.add((Component)this._jFilterCtl);
        Dimension dimension = this._findPane.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 145);
        Dimension dimension3 = this.derive(dimension, 80);
        this._findPane.setPreferredSize(dimension2);
        this._findPane.setMaximumSize(dimension2);
        this._findPane.setMinimumSize(dimension3);
        controlBar.add((Component)this._findPane);
    }

    private SearchField searchField() {
        SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        return searchField;
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private void loadItemsetHTMLTemplate() {
        String string = "/oracle/dmt/dataminer/mviewer/res/ARItemsetTemplate.html";
        try {
            this._itemsetHTMLTemplate = FileHelper.loadFile(string);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void addListeners() {
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                ARItemSetsViewer.this.translateSearchCategoryToConstant(ARItemSetsViewer.this._jFilterCtl.getSelectedCategory());
                ARItemSetsViewer.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                ARItemSetsViewer.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                ARItemSetsViewer.this.processFilter(string);
            }
        });
        this._jShowItemsetContentValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RuleContentOption ruleContentOption = (RuleContentOption)((Object)ARItemSetsViewer.this._jShowItemsetContentValue.getSelectedItem());
                if (ARItemSetsViewer.this._currentItemsetContentOption != ruleContentOption) {
                    ARItemSetsViewer.this._currentItemsetContentOption = ruleContentOption;
                    ARItemSetsViewer.this._state.setItemsetContentOption(ARItemSetsViewer.this._currentItemsetContentOption);
                    if (ARItemSetsViewer.this._jItemsetsGenericTable.getModel() instanceof ARItemSetsTableModel && !((Object)((Object)ARItemSetsViewer.this._state.getTableModel())).equals(ARItemSetsViewer.this._jItemsetsGenericTable.getModel())) {
                        ((ARRulesViewerTableModel)((Object)ARItemSetsViewer.this._jItemsetsGenericTable.getModel())).setRuleContentOption(ARItemSetsViewer.this._currentItemsetContentOption);
                    }
                    ARItemSetsViewer.this.valueChangedImpl(ARItemSetsViewer.this._jItemsetsGenericTable.getSelectionModel());
                }
            }
        });
    }

    private void processFilter(String string) {
        try {
            ARItemSetsTableModel aRItemSetsTableModel = this._state.getFilteredItemSets(string, this._currentSearchCategory);
            this.setupTable(aRItemSetsTableModel, true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ARRulesLrb.get("RULE_VIEWER_FAILURE_TITLE"), (String)ARRulesLrb.get("RULE_VIEWER_FAILURE_MESG"), null);
        }
    }

    private void setupTable(ARItemSetsTableModel aRItemSetsTableModel, boolean bl) {
        if (aRItemSetsTableModel.getRowCount() == 0 && !bl) {
            if (this._modelEmpty) {
                this.loadEmptyRulesTable(ItemSetQueryMessages.NO_ITEMSETS_IN_MODEL);
            } else {
                this.loadEmptyRulesTable(ItemSetQueryMessages.NO_RESULTS_RETURNED);
            }
            return;
        }
        this._jItemsetsGenericTable.setModel((TableModel)((Object)aRItemSetsTableModel));
        this._jItemsetsGenericTable.setSorted(true);
        this._jItemsetsGenericTable.setAutoResizeMode(4);
        TableColumnModel tableColumnModel = this._jItemsetsGenericTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(65);
        tableColumnModel.getColumn(1).setPreferredWidth(300);
        tableColumnModel.getColumn(2).setPreferredWidth(180);
        tableColumnModel.getColumn(2).setCellRenderer(this._barRenderer);
        tableColumnModel.getColumn(3).setPreferredWidth(120);
        this.loadRowsOutOfTotalLabel(this._state.getTableModel().getRowCount(), this._state.getTotalItemSetsCount());
        if (this._jItemsetsGenericTable.getModel().getRowCount() > 0) {
            this._jItemsetsGenericTable.setRowSelectionInterval(0, 0);
        } else {
            this._detailPanel.setItemsetDisplay("");
        }
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = 1;
        if (searchCategory.getLabel().equals(ARRulesLrb.get("ITEM_SETS_FILTER_CATEGORY_ITEMS_SUBSTRING"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(ARRulesLrb.get("ITEM_SETS_FILTER_CATEGORY_ITEMS_PREFIX_AND"))) {
            this._currentSearchCategory = 1;
        } else if (searchCategory.getLabel().equals(ARRulesLrb.get("ITEM_SETS_FILTER_CATEGORY_ITEMS_PREFIX_OR"))) {
            this._currentSearchCategory = 2;
        } else {
            n = -1;
            assert (false) : "Invalid Search Category Code";
        }
        return n;
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = ARRulesLrb.get("ITEMSET_ROWS_OUT_OF_TOTAL");
        String string2 = NumericFormat.format(n);
        String string3 = "Loading...";
        if (n2 != null) {
            string3 = NumericFormat.format(n2);
        }
        String string4 = MessageFormat.format(string, string2, string3);
        this._jRowsOutOfTotalLabel.setText(string4);
    }

    private void initializeControls() {
        this.enableControls(false);
    }

    private void setupDefaultItemSetContent() {
        RuleContentOption ruleContentOption = this._state.isOnlyOneColumnNameInModelItems() && !this._state.isNoSubNameColumnsInModelItems() && this._state.isOnlyOneConstantValueInModelItems() ? RuleContentOption.SUBNAME : (this._state.isOnlyOneColumnNameInModelItems() && !this._state.isNoSubNameColumnsInModelItems() && !this._state.isOnlyOneConstantValueInModelItems() ? RuleContentOption.SUBNAME_VALUE : (this._state.isNoSubNameColumnsInModelItems() && this._state.isOnlyOneConstantValueInModelItems() ? RuleContentOption.NAME_SUBNAME : RuleContentOption.NAME_SUBNAME_VALUE));
        this._jShowItemsetContentValue.setSelectedItem((Object)ruleContentOption);
        this._state.setItemsetContentOption(ruleContentOption);
    }

    private void enableControls(boolean bl) {
        this._jFilterCtl.setEnabled(bl);
        this._jShowItemsetContentValue.setEnabled(bl);
    }

    private void loadEmptyRulesTable(ItemSetQueryMessages itemSetQueryMessages) {
        String string = ARRulesLrb.get("LOADING_ITEM_SETS_HEADER");
        String string2 = "";
        switch (itemSetQueryMessages) {
            case ERROR: {
                string2 = ARRulesLrb.get("FAILURE_LOADING_ITEM_SETS_ROW");
                break;
            }
            case LOADING: {
                string2 = ARRulesLrb.get("LOADING_ITEM_SETS_ROW");
                break;
            }
            case NO_RESULTS_RETURNED: {
                string2 = ARRulesLrb.get("NO_ITEM_SETS_RETURNED_FROM_QUERY");
                break;
            }
            case NO_ITEMSETS_IN_MODEL: {
                string2 = ARRulesLrb.get("NO_ITEMS_SETS_IN_MODEL");
            }
        }
        this._jItemsetsGenericTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{string2}}, new String[]{string}));
        this._jItemsetsGenericTable.setAutoResizeMode(4);
    }

    public void setFilterState(ItemSetsFilterSetting itemSetsFilterSetting) {
        if (this.isLoading()) {
            return;
        }
        this._state.setFilterSetting(itemSetsFilterSetting);
        this.prepareReload();
    }

    public void prepareReload() {
        this.setLoading(true);
        this.prepareForNewQuery();
        LoadUI loadUI = new LoadUI(true);
        loadUI.execute();
    }

    private void prepareForNewQuery() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ARItemSetsViewer.this._detailPanel.setItemsetDisplay(ARRulesLrb.get("NO_ITEM_SET_TO_DISPLAY"));
            }
        });
        this._state.clearRows();
        this.loadEmptyRulesTable(ItemSetQueryMessages.LOADING);
        this.loadRowsOutOfTotalLabel(0, this._state.getTotalItemSetsCount());
        this.enableControls(false);
    }

    public void valueChangedImpl(ListSelectionModel listSelectionModel) {
        boolean bl = false;
        if (!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
            bl = true;
        }
        if (!(this._jItemsetsGenericTable.getModel() instanceof ARItemSetsTableModel)) {
            return;
        }
        if (!bl) {
            this._detailPanel.setItemsetDisplay(this._jSelectSingleItemsetMesg);
            return;
        }
        int[] nArray = this._jItemsetsGenericTable.getSelectedRowsInModel();
        ARItemSetsTableModel aRItemSetsTableModel = (ARItemSetsTableModel)((Object)this._jItemsetsGenericTable.getModel());
        Vector<ItemSet> vector = aRItemSetsTableModel.getDataVector();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._htmlHeader);
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append("<BR>");
            }
            stringBuffer.append(this.getDetailItemsetString(vector.get(nArray[i])));
        }
        stringBuffer.append(this._htmlFooter);
        this._detailPanel.setItemsetDisplay("");
        try {
            this._detailPanel.setItemsetDisplay(stringBuffer.toString());
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            this._detailPanel.setItemsetDisplay("Failed to Load Itemset");
        }
    }

    private String getDetailItemsetString(ItemSet itemSet) {
        assert (itemSet != null) : "Itemset can not be null";
        String string = this._itemsetHTMLTemplate.toString();
        String string2 = "<span style=\"font-weight: bold;\">" + ARRulesLrb.get("RULE_ID_COLUMN") + ":" + "</span>";
        string = StringUtils.getReplacedString(string, this.ITEMSET_ID_LABEL, string2);
        string = StringUtils.getReplacedString(string, this.ITEMSET_ID_VALUE, itemSet.getItemsets_id() + "");
        string = StringUtils.getReplacedString(string, this.ITEM_LIST_LABEL, ARRulesLrb.get("ITEM_LIST_LABEL"));
        string = StringUtils.getReplacedString(string, this.ITEMSET_DETAIL, itemSet.getItemSetString(this._currentItemsetContentOption, true));
        string = StringUtils.getReplacedString(string, this.SUPPORT_LABEL, ARRulesLrb.get("SUPPORT_COLUMN"));
        string = StringUtils.getReplacedString(string, this.SUPPORT_VALUE, NumericFormat.format(itemSet.getSupport() * 100.0, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()));
        string = StringUtils.getReplacedString(string, this.LENGTH_LABEL, ARRulesLrb.get("RULE_LENGTH_COLUMN"));
        string = StringUtils.getReplacedString(string, this.LENGTH_VALUE, itemSet.getNumber_of_items() + "");
        return string;
    }

    public ItemSetsFilterSetting getCachedFilterState() {
        return this._state.getCachedFilterSetting();
    }

    public void setCachedFilterState(ItemSetsFilterSetting itemSetsFilterSetting) {
        this._state.setCachedFilterSetting(itemSetsFilterSetting);
    }

    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    private void setLoading(boolean bl) {
        this._mainPanel.updateLoading(bl);
    }

    private void setLoaded(boolean bl) {
        if (!this._loadedFilterSetting) {
            this._mainPanel.setFilterPanelInitialState(this._state.getFilterSetting());
            this._loadedFilterSetting = true;
        }
        this._mainPanel.updateLoaded(bl);
    }

    private void setupGlobalMetrics() {
        NumberFormat numberFormat = NumericFormat.getInstance(true, 0, 0, 1);
        this.loadRowsOutOfTotalLabel(this._state.getTableModel().getRowCount(), this._state.getTotalItemSetsCount());
        if (this._state.getTotalItemSetsCount() == 0) {
            this.loadEmptyRulesTable(ItemSetQueryMessages.NO_ITEMSETS_IN_MODEL);
            this.enableControls(false);
            this._modelEmpty = true;
            return;
        }
        this._modelEmpty = false;
        if (this._state.getMaximumSupport() != null && this._state.getMaximumSupport() != 0.0) {
            Double d = this._state.getMaximumSupport() * 100.0;
            if (d.longValue() == 0L) {
                this._barRenderer.setMaximumValue(1L);
            } else {
                this._barRenderer.setMaximumValue(d.longValue());
            }
        } else {
            this._barRenderer.setMaximumValue(100L);
        }
        this._jItemsetsGenericTable.repaint();
    }

    public HelpInfo getHelpInfo() {
        return this._state.getHelpInfo();
    }

    private String formatValue(Object object) {
        String string = "";
        if (object == null) {
            string = null;
        } else if (object != null) {
            string = object instanceof Double ? NumericFormat.format((Double)object, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()) + "" : object.toString();
        }
        return string;
    }

    class ItemSetTableSelectionHandler
    implements ListSelectionListener {
        ItemSetTableSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            ARItemSetsViewer.this.valueChangedImpl(listSelectionModel);
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        protected Object doInBackground() throws Exception {
            try {
                if (this._reload) {
                    ARItemSetsViewer.this._state.reloadItemSets();
                } else {
                    ARItemSetsViewer.this._state = new ARItemSetsViewerState(ARItemSetsViewer.this._context);
                    ARItemSetsViewer.this._state.load();
                    ARItemSetsViewer.this.setupDefaultItemSetContent();
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return ARItemSetsViewer.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    if (ARItemSetsViewer.this._jFilterCtl.getText().trim().length() > 0) {
                        ARItemSetsViewer.this.setupTable(ARItemSetsViewer.this._state.getFilteredItemSets(ARItemSetsViewer.this._jFilterCtl.getText(), ARItemSetsViewer.this._currentSearchCategory), true);
                    } else {
                        ARItemSetsViewer.this.setupTable(ARItemSetsViewer.this._state.getTableModel(), false);
                    }
                    ARItemSetsViewer.this.enableControls(true);
                    ARItemSetsViewer.this._labelFormat.setMaximumFractionDigits(ARItemSetsViewer.this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
                    ARItemSetsViewer.this._labelFormat.setMinimumFractionDigits(ARItemSetsViewer.this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
                    ARItemSetsViewer.this._labelFormat.setMinimumIntegerDigits(1);
                    ARItemSetsViewer.this.setLoaded(true);
                    ARItemSetsViewer.this.loadRowsOutOfTotalLabel(ARItemSetsViewer.this._state.getTableModel().getRowCount(), ARItemSetsViewer.this._state.getTotalItemSetsCount());
                } else {
                    if (ARItemSetsViewer.this._state.getTableModel() != null) {
                        ARItemSetsViewer.this._state.clearRows();
                        ARItemSetsViewer.this.loadEmptyRulesTable(ItemSetQueryMessages.ERROR);
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)ARRulesLrb.get("ITEM_SETS_VIEWER_FAILURE_TITLE"), (String)ARRulesLrb.get("ITEM_SETS_VIEWER_FAILURE_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)ARRulesLrb.get("ITEM_SETS_VIEWER_FAILURE_MESG"), (String)ARRulesLrb.get("ITEM_SETS_VIEWER_FAILURE_TITLE"), null);
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ARRulesLrb.get("ITEM_SETS_VIEWER_FAILURE_TITLE"), (String)ARRulesLrb.get("ITEM_SETS_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                ARItemSetsViewer.this.setLoading(false);
                if (ARItemSetsViewer.this.overLayPanel != null) {
                    ARItemSetsViewer.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }

    private static enum ItemSetQueryMessages {
        ERROR,
        LOADING,
        NO_RESULTS_RETURNED,
        NO_ITEMSETS_IN_MODEL;

    }
}

