/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesDetailViewer;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesMainPanel;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesViewerState;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesViewerTableModel;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.ARRulesFilterSetting;
import oracle.dmt.dataminer.server.model.RuleContentOption;
import oracle.dmt.dataminer.server.model.RuleRowData;
import oracle.dmt.dataminer.utils.FileHelper;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;

public class ARRulesViewer
extends JPanel {
    private static final Logger theLogger = Logger.getLogger(ARRulesViewer.class.getName());
    private static final int FROZEN_COLUMNS = 1;
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private NumberFormat _labelFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    ARRulesViewerState _state;
    ARRulesMainPanel _mainPanel;
    ARRulesDetailViewer _detailPanel;
    Context _context;
    private HistogramBarRenderer _barRenderer = new HistogramBarRenderer(4L, true, this._labelFormat);
    private boolean _loadedFilterSetting = false;
    private RuleContentOption _currentRuleContentOption = RuleContentOption.SUBNAME;
    private String _htmlHeader = "<html>\n<body>";
    private String _htmlFooter = "</body>\n</html>";
    private StringBuffer _ruleHTMLTemplate = new StringBuffer();
    private String _jSelectSingleRuleMesg;
    String RULE_ID_LABEL = "[RULE_ID_LABEL]";
    String RULE_ID_VALUE = "[RULE_ID_VALUE]";
    String DETAIL_LABEL = "[DETAIL_LABEL]";
    String IF_LABEL = "[IF_LABEL]";
    String RULE_DETAIL = "[RULE_DETAIL]";
    String IF_DETAIL = "[IF_DETAIL]";
    String THEN_LABEL = "[THEN_LABEL]";
    String THEN_DETAIL = "[THEN_DETAIL]";
    String METRICS_LABEL = "[METRICS_LABEL]";
    String LIFT_LABEL = "[LIFT_LABEL]";
    String LIFT_VALUE = "[LIFT_VALUE]";
    String CONFIDENCE_LABEL = "[CONFIDENCE_LABEL]";
    String CONFIDENCE_VALUE = "[CONFIDENCE_VALUE]";
    String SUPPORT_LABEL = "[SUPPORT_LABEL]";
    String SUPPORT_VALUE = "[SUPPORT_VALUE]";
    String CONFIDENCE_SUPPORT_LABEL = "[CONFIDENCE_SUPPORT_LABEL]";
    String CONFIDENCE_SUPPORT_VALUE = "[CONFIDENCE_SUPPORT_VALUE]";
    String ASSOCIATION_SUPPORT_LABEL = "[ASSOCIATION_SUPPORT_LABEL]";
    String ASSOCIATION_SUPPORT_VALUE = "[ASSOCIATION_SUPPORT_VALUE]";
    String LENGTH_LABEL = "[LENGTH_LABEL]";
    String LENGTH_VALUE = "[LENGTH_VALUE]";
    private BlockingComponent overLayPanel = null;
    private JLabel _jShowRuleContent;
    private JComboBox _jShowRuleContentValue;
    private DataMinerTablePanel dataMinerTablePanel;
    private JSeparator jSeparator1;

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public ARRulesViewer(ARRulesMainPanel aRRulesMainPanel, Context context, ARRulesDetailViewer aRRulesDetailViewer) throws Exception {
        this._mainPanel = aRRulesMainPanel;
        this._context = context;
        this._detailPanel = aRRulesDetailViewer;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jShowRuleContent = new JLabel();
        this._jShowRuleContentValue = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this._jShowRuleContent.setText("Rule Content:");
        this._jShowRuleContentValue.setModel(new DefaultComboBoxModel<String>(new String[]{"Name,Subname,Value", "Subname,Value", "Name,Subname", "Subname"}));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.dataMinerTablePanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this._jShowRuleContent, -2, 112, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jShowRuleContentValue, -2, 143, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING, -1, 614, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jShowRuleContent).addComponent(this._jShowRuleContentValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataMinerTablePanel, -1, 280, Short.MAX_VALUE)));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jShowRuleContent, (Component)this._jShowRuleContentValue, (String)ARRulesLrb.get("SHOW_RULE_CONTENT"));
        this._jShowRuleContent.getAccessibleContext().setAccessibleName(ARRulesLrb.get("SHOW_RULE_CONTENT"));
        this._jShowRuleContent.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("SHOW_RULE_CONTENT_ADA"));
        this._jShowRuleContentValue.setModel(new DefaultComboBoxModel<RuleContentOption>(RuleContentOption.values()));
        this._jShowRuleContentValue.setSelectedItem((Object)this._currentRuleContentOption);
        this._jShowRuleContentValue.setToolTipText(ARRulesLrb.get("SHOW_RULE_CONTENT_ADA"));
        this._jSelectSingleRuleMesg = ARRulesLrb.get("SELECT_SINGLE_RULE");
        this.loadRuleHTMLTemplate();
    }

    private void loadRuleHTMLTemplate() {
        String string = "/oracle/dmt/dataminer/mviewer/res/ARRuleTemplate.html";
        try {
            this._ruleHTMLTemplate = FileHelper.loadFile(string);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void initUI() {
        this.loadEmptyRulesTable(RuleQueryMessages.LOADING);
        this._detailPanel.setRuleDisplay(ARRulesLrb.get("NO_RULE_TO_DISPLAY"));
        this.dataMinerTablePanel.getTable().setFillsViewportHeight(true);
        this.dataMinerTablePanel.getTable().setSelectionMode(2);
        this.dataMinerTablePanel.getTable().setShowGrid(true);
        this.dataMinerTablePanel.getTable().setShowHorizontalLines(true);
        this.dataMinerTablePanel.getTable().setShowVerticalLines(true);
        this.dataMinerTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ARRulesViewer.this.handleSelectionChanged(ARRulesViewer.this.dataMinerTablePanel.getTable().getSelectionModel());
            }
        });
        this.initializeControls();
        this.addListeners();
        this.setLoading(true);
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void setupGlobalMetrics() {
        this.loadRowsOutOfTotalLabel(0, this._state.getTotal_rules_count());
        if (this._state.getTotal_rules_count() == 0) {
            this.loadEmptyRulesTable(RuleQueryMessages.NO_RULES_IN_MODEL);
            this.enableControls(false);
            return;
        }
        if (this._state.getMaximum_lift_value() != null && this._state.getMaximum_lift_value() != 0.0) {
            Double d = (double)this._state.getMaximum_lift_value();
            if (d.longValue() == 0L) {
                this._barRenderer.setMaximumValue(1L);
            } else {
                this._barRenderer.setMaximumValue(d.longValue());
            }
        } else {
            this._barRenderer.setMaximumValue(100L);
        }
    }

    private void addListeners() {
        this._jShowRuleContentValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RuleContentOption ruleContentOption = (RuleContentOption)((Object)ARRulesViewer.this._jShowRuleContentValue.getSelectedItem());
                if (ARRulesViewer.this._currentRuleContentOption != ruleContentOption) {
                    ARRulesViewer.this._currentRuleContentOption = ruleContentOption;
                    ARRulesViewer.this._state.setRuleContentOption(ARRulesViewer.this._currentRuleContentOption);
                    if (ARRulesViewer.this.dataMinerTablePanel.getTable().getModel() instanceof ARRulesViewerTableModel && !((Object)((Object)ARRulesViewer.this._state.getTableModel())).equals(ARRulesViewer.this.dataMinerTablePanel.getTable().getModel())) {
                        ((ARRulesViewerTableModel)((Object)ARRulesViewer.this.dataMinerTablePanel.getTable().getModel())).setRuleContentOption(ARRulesViewer.this._currentRuleContentOption);
                    }
                    ARRulesViewer.this.handleSelectionChanged(ARRulesViewer.this.dataMinerTablePanel.getTable().getSelectionModel());
                }
            }
        });
    }

    private void setupTable(ARRulesViewerTableModel aRRulesViewerTableModel, boolean bl) {
        if (this._state.getTotal_rules_count() == 0) {
            this.loadEmptyRulesTable(RuleQueryMessages.NO_RULES_IN_MODEL);
            this.enableControls(false);
            return;
        }
        if (aRRulesViewerTableModel.getRowCount() == 0 && !bl) {
            this.loadEmptyRulesTable(RuleQueryMessages.NO_RESULTS_RETURNED);
            return;
        }
        this.dataMinerTablePanel.getTable().setFixedColumns(1, 65);
        this.dataMinerTablePanel.setup((TableModel)((Object)aRRulesViewerTableModel), null, new String[]{ARRulesViewerTableModel.COLUMN_NAMES[1], ARRulesViewerTableModel.COLUMN_NAMES[2]}, 0);
        this.dataMinerTablePanel.getTable().setAutoCreateRowSorter(true);
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getFullColumnModel();
        tableColumnModel.getColumn(1).setPreferredWidth(220);
        tableColumnModel.getColumn(2).setPreferredWidth(150);
        tableColumnModel.getColumn(3).setPreferredWidth(120);
        tableColumnModel.getColumn(4).setPreferredWidth(90);
        tableColumnModel.getColumn(5).setPreferredWidth(90);
        tableColumnModel.getColumn(8).setPreferredWidth(130);
        tableColumnModel.getColumn(7).setPreferredWidth(130);
        tableColumnModel.getColumn(6).setPreferredWidth(70);
        tableColumnModel.getColumn(3).setCellRenderer(this._barRenderer);
        tableColumnModel.getColumn(4).setCellRenderer(new NumberCellRenderer(NumberCellRenderer.FormatType.PERCENTAGE));
        tableColumnModel.getColumn(5).setCellRenderer(new NumberCellRenderer(NumberCellRenderer.FormatType.PERCENTAGE));
        tableColumnModel.getColumn(8).setCellRenderer(new NumberCellRenderer(NumberCellRenderer.FormatType.PERCENTAGE));
        tableColumnModel.getColumn(7).setCellRenderer(new NumberCellRenderer(NumberCellRenderer.FormatType.PERCENTAGE));
        this.loadRowsOutOfTotalLabel(this._state.getTableModel().getRowCount(), this._state.getTotal_rules_count());
        if (this.dataMinerTablePanel.getTable().getModel().getRowCount() > 0) {
            this.dataMinerTablePanel.getTable().setRowSelectionInterval(0, 0);
        } else {
            this._detailPanel.setRuleDisplay("");
        }
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = ARRulesLrb.get("RULES_ROWS_OUT_OF_TOTAL");
        String string2 = NumericFormat.format(n);
        String string3 = NumericFormat.format(n2);
        String string4 = MessageFormat.format(string, string2, string3);
        this.dataMinerTablePanel.setTitle(string4);
    }

    private void initializeControls() {
        this.enableControls(false);
    }

    private void enableControls(boolean bl) {
        this.dataMinerTablePanel.getSearchField().setEnabled(bl);
        this._jShowRuleContentValue.setEnabled(bl);
    }

    private void setupDefaultRuleContent() {
        RuleContentOption ruleContentOption = this._state.isOnlyOneColumnNameInModelItems() && !this._state.isNoSubNameColumnsInModelItems() && this._state.isOnlyOneConstantValueInModelItems() ? RuleContentOption.SUBNAME : (this._state.isOnlyOneColumnNameInModelItems() && !this._state.isNoSubNameColumnsInModelItems() && !this._state.isOnlyOneConstantValueInModelItems() ? RuleContentOption.SUBNAME_VALUE : (this._state.isNoSubNameColumnsInModelItems() && this._state.isOnlyOneConstantValueInModelItems() ? RuleContentOption.NAME_SUBNAME : RuleContentOption.NAME_SUBNAME_VALUE));
        this._jShowRuleContentValue.setSelectedItem((Object)ruleContentOption);
        this._state.setRuleContentOption(ruleContentOption);
    }

    private void setLoading(boolean bl) {
        this._mainPanel.updateLoading(bl);
        this.enableControls(!bl);
    }

    private void setLoaded(boolean bl) {
        if (!this._loadedFilterSetting) {
            this._mainPanel.setFilterPanelInitialState(this._state.getFilterSetting());
            this._loadedFilterSetting = true;
        }
        this._mainPanel.updateLoaded(bl);
    }

    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    public void setFilterState(ARRulesFilterSetting aRRulesFilterSetting) {
        if (this.isLoading()) {
            return;
        }
        this._state.setFilterSetting(aRRulesFilterSetting);
        this.prepareReload();
    }

    public ARRulesFilterSetting getFilterState() {
        return this._state.getFilterSetting();
    }

    public ARRulesFilterSetting getCachedFilterState() {
        return this._state.getCachedFilterSetting();
    }

    public void setCachedFilterState(ARRulesFilterSetting aRRulesFilterSetting) {
        this._state.setCachedFilterSetting(aRRulesFilterSetting);
    }

    public void prepareReload() {
        this.setLoading(true);
        this.prepareForNewQuery();
        LoadUI loadUI = new LoadUI(true);
        loadUI.execute();
    }

    private void prepareForNewQuery() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ARRulesViewer.this._detailPanel.setRuleDisplay(ARRulesLrb.get("NO_RULE_TO_DISPLAY"));
            }
        });
        this.loadEmptyRulesTable(RuleQueryMessages.LOADING);
        this.loadRowsOutOfTotalLabel(0, this._state.getTotal_rules_count());
        this.enableControls(false);
    }

    private void handleSelectionChanged(ListSelectionModel listSelectionModel) {
        boolean bl = false;
        if (!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
            bl = true;
        }
        if (!bl) {
            this._detailPanel.setRuleDisplay(this._jSelectSingleRuleMesg);
            return;
        }
        if (!(this.dataMinerTablePanel.getTable().getModel() instanceof ARRulesViewerTableModel)) {
            return;
        }
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        ARRulesViewerTableModel aRRulesViewerTableModel = (ARRulesViewerTableModel)((Object)this.dataMinerTablePanel.getTable().getModel());
        Vector<RuleRowData> vector = aRRulesViewerTableModel.getDataVector();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._htmlHeader);
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append("<BR>");
            }
            stringBuffer.append(this.getDetailRuleString(vector.get(nArray[i])));
        }
        stringBuffer.append(this._htmlFooter);
        this._detailPanel.setRuleDisplay("");
        try {
            this._detailPanel.setRuleDisplay(stringBuffer.toString());
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            this._detailPanel.setRuleDisplay("Failed to Load Rule");
        }
    }

    private String getDetailRuleString(RuleRowData ruleRowData) {
        assert (ruleRowData != null) : "Rule can not be null";
        String string = this._ruleHTMLTemplate.toString();
        String string2 = "<span style=\"font-weight: bold;\">" + ARRulesLrb.get("RULE_ID_COLUMN") + ":" + "</span>";
        string = StringUtils.getReplacedString(string, this.RULE_ID_LABEL, string2);
        string = StringUtils.getReplacedString(string, this.RULE_ID_VALUE, ruleRowData.getRule_id() + "");
        String string3 = "<span style=\"font-weight: bold;\">" + ARRulesLrb.get("IF") + "</span>";
        string = StringUtils.getReplacedString(string, this.IF_LABEL, string3);
        String string4 = ruleRowData.getFullAntecedent(this._currentRuleContentOption, true);
        string = StringUtils.getReplacedString(string, this.IF_DETAIL, string4);
        String string5 = "<span style=\"font-weight: bold;\">" + ARRulesLrb.get("THEN") + "</span>";
        string = StringUtils.getReplacedString(string, this.THEN_LABEL, string5);
        String string6 = ruleRowData.getFullConsequent(this._currentRuleContentOption, true);
        string = StringUtils.getReplacedString(string, this.THEN_DETAIL, string6);
        string = StringUtils.getReplacedString(string, this.LIFT_LABEL, ARRulesLrb.get("LIFT_COLUMN"));
        string = StringUtils.getReplacedString(string, this.LIFT_VALUE, NumericFormat.format(ruleRowData.getRule_lift(), true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()));
        string = StringUtils.getReplacedString(string, this.CONFIDENCE_LABEL, ARRulesLrb.get("CONFIDENCE_COLUMN"));
        string = StringUtils.getReplacedString(string, this.CONFIDENCE_VALUE, NumericFormat.format(ruleRowData.getRule_confidence() * 100.0, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()));
        string = StringUtils.getReplacedString(string, this.SUPPORT_LABEL, ARRulesLrb.get("SUPPORT_COLUMN"));
        string = StringUtils.getReplacedString(string, this.SUPPORT_VALUE, NumericFormat.format(ruleRowData.getRule_support() * 100.0, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()));
        string = StringUtils.getReplacedString(string, this.CONFIDENCE_SUPPORT_LABEL, ARRulesLrb.get("CONDITION_SUPPORT_COLUMN"));
        string = StringUtils.getReplacedString(string, this.CONFIDENCE_SUPPORT_VALUE, NumericFormat.format(ruleRowData.getConsequent_support() * 100.0, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()));
        string = StringUtils.getReplacedString(string, this.ASSOCIATION_SUPPORT_LABEL, ARRulesLrb.get("ASSOCIATION_SUPPORT_COLUMN"));
        string = StringUtils.getReplacedString(string, this.ASSOCIATION_SUPPORT_VALUE, NumericFormat.format(ruleRowData.getAntecedent_support() * 100.0, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()));
        string = StringUtils.getReplacedString(string, this.LENGTH_LABEL, ARRulesLrb.get("RULE_LENGTH_COLUMN"));
        string = StringUtils.getReplacedString(string, this.LENGTH_VALUE, ruleRowData.getNumber_of_items() + "");
        return string;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("ar_view_rules");
    }

    public void setState(ARRulesViewerState aRRulesViewerState) {
        this._state = aRRulesViewerState;
    }

    public ARRulesViewerState getState() {
        return this._state;
    }

    private void loadEmptyRulesTable(RuleQueryMessages ruleQueryMessages) {
        String string = ARRulesLrb.get("LOADING_RULES_HEADER");
        String string2 = "";
        switch (ruleQueryMessages) {
            case ERROR: {
                string2 = ARRulesLrb.get("FAILURE_LOADING_RULES_ROW");
                break;
            }
            case LOADING: {
                string2 = ARRulesLrb.get("LOADING_RULES_ROW");
                break;
            }
            case NO_RESULTS_RETURNED: {
                string2 = ARRulesLrb.get("NO_RULES_RETURNED_FROM_QUERY");
                break;
            }
            case NO_RULES_IN_MODEL: {
                string2 = ARRulesLrb.get("NO_RULES_IN_MODEL");
            }
        }
        this.dataMinerTablePanel.getTable().setFixedColumns(0, new int[0]);
        this.dataMinerTablePanel.getTable().setShowHorizontalLines(false);
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        protected Object doInBackground() throws Exception {
            try {
                if (this._reload) {
                    ARRulesViewer.this._state.reloadRules();
                } else {
                    ARRulesViewer.this._state = new ARRulesViewerState(ARRulesViewer.this._context);
                    ARRulesViewer.this._state.load();
                    ARRulesViewer.this.setupDefaultRuleContent();
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return ARRulesViewer.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    ARRulesViewer.this._state.loadModel();
                    if (!this._reload) {
                        ARRulesViewer.this.setupGlobalMetrics();
                    }
                    ARRulesViewer.this.setupTable(ARRulesViewer.this._state.getTableModel(), false);
                    ARRulesViewer.this.dataMinerTablePanel.trySearch();
                    ARRulesViewer.this.enableControls(true);
                    ARRulesViewer.this._labelFormat.setMaximumFractionDigits(ARRulesViewer.this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
                    ARRulesViewer.this._labelFormat.setMinimumFractionDigits(ARRulesViewer.this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
                    ARRulesViewer.this._labelFormat.setMinimumIntegerDigits(1);
                    if (ARRulesViewer.this.dataMinerTablePanel.getTable().getRowCount() > 0 && ARRulesViewer.this.dataMinerTablePanel.getTable().getModel() instanceof ARRulesViewerTableModel) {
                        ARRulesViewer.this.dataMinerTablePanel.getTable().setSelectedRowsInModel(new int[]{0});
                    }
                    ARRulesViewer.this.setLoaded(true);
                } else {
                    if (ARRulesViewer.this._state.getTableModel() != null) {
                        ARRulesViewer.this._state.clearRows();
                        ARRulesViewer.this.loadEmptyRulesTable(RuleQueryMessages.ERROR);
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)ARRulesLrb.get("RULE_VIEWER_FAILURE_TITLE"), (String)ARRulesLrb.get("RULE_VIEWER_FAILURE_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)ARRulesLrb.get("RULE_VIEWER_FAILURE_MESG"), (String)ARRulesLrb.get("RULE_VIEWER_FAILURE_TITLE"), null);
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ARRulesLrb.get("RULE_VIEWER_FAILURE_TITLE"), (String)ARRulesLrb.get("RULE_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                ARRulesViewer.this.setLoading(false);
                if (ARRulesViewer.this.overLayPanel != null) {
                    ARRulesViewer.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }

    private static enum RuleQueryMessages {
        ERROR,
        LOADING,
        NO_RESULTS_RETURNED,
        NO_RULES_IN_MODEL;

    }
}

