/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.sql.Connection;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.mviewer.arrules.ARGlobalMetrics;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesViewerTableModel;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.server.model.ARRulesFilterSetting;
import oracle.dmt.dataminer.server.model.AssociationRules;
import oracle.dmt.dataminer.server.model.RuleContentOption;
import oracle.dmt.dataminer.server.model.RuleRowData;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;

public class ARRulesViewerState {
    private static final Logger theLogger = Logger.getLogger(ARRulesViewerState.class.getName());
    private boolean _loaded;
    private ARRulesViewerTableModel _tableModel;
    private AssociationRules _model = null;
    private String _modelName;
    private String _userName;
    private Context _context;
    private ARRulesFilterSetting _filterSetting;
    private ARRulesFilterSetting _cachedFilterSetting;
    private ModelViewerState1 _modelViewerState1;
    private RuleContentOption _ruleContentOption;
    private ARGlobalMetrics _globalMetrics;
    private Vector<RuleRowData> reloadedData = null;

    public ARRulesViewerState(Context context) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
    }

    public ARRulesViewerState reloadRules() throws Exception {
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            this.loadRules(connection);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            SQLHelper.close(connection);
        }
        return this;
    }

    public boolean isOnlyOneSubColumnNameInModelItems() {
        return this._globalMetrics.isOnlyOneSubColumnNameInModelItems();
    }

    public ARRulesViewerState load() throws Exception {
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            this._modelViewerState1 = new ModelViewerState1(this._context);
            this._modelViewerState1.load(connection);
            if (!this._modelViewerState1.getOdmModel().getModelGeneralDescription().isAssociationRulesModel()) {
                throw new Exception(ARRulesLrb.get("RULE_VIEWER_UNRECOGNIZED_MODEL_TYPE"));
            }
            this._model = new AssociationRules(this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName());
            this._modelName = this._modelViewerState1.getModelName();
            this._userName = this._modelViewerState1.getUserName();
            this._filterSetting = new ARRulesFilterSetting(this);
            this._cachedFilterSetting = new ARRulesFilterSetting(this);
            Vector<RuleRowData> vector = new Vector<RuleRowData>();
            this._tableModel = new ARRulesViewerTableModel(vector);
            this._globalMetrics = new ARGlobalMetrics(this._context, this._model, this._userName, this._modelName);
            LoadGlobalMetrics loadGlobalMetrics = new LoadGlobalMetrics();
            loadGlobalMetrics.start();
            this.loadRules(connection);
            loadGlobalMetrics.join();
            if (loadGlobalMetrics.getException() != null) {
                throw loadGlobalMetrics.getException();
            }
            this._loaded = true;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            SQLHelper.close(connection);
        }
        return this;
    }

    public void loadModel() {
        this._tableModel.clearRows();
        this._tableModel.addRows(this.reloadedData);
    }

    private void loadRules(Connection connection) throws Exception {
        this.reloadedData = new Vector();
        this.reloadedData = this._model.getRules(connection, this._userName, this._modelName, this._filterSetting);
    }

    public HelpInfo getHelpInfo() {
        String string = "ar_rules_help";
        return new HelpInfo(string);
    }

    public void setFilterSetting(ARRulesFilterSetting aRRulesFilterSetting) {
        this._filterSetting = aRRulesFilterSetting;
    }

    public ARRulesFilterSetting getFilterSetting() {
        return this._filterSetting;
    }

    public ARRulesViewerTableModel getTableModel() {
        return this._tableModel;
    }

    public void clearRows() {
        this._tableModel.clearRows();
    }

    public void addRow(RuleRowData ruleRowData) {
        this._tableModel.addRow(ruleRowData);
    }

    public void setCachedFilterSetting(ARRulesFilterSetting aRRulesFilterSetting) {
        this._cachedFilterSetting = aRRulesFilterSetting;
    }

    public ARRulesFilterSetting getCachedFilterSetting() {
        return this._cachedFilterSetting;
    }

    public int getTotal_rules_count() {
        return this._globalMetrics.getTotal_rules_count();
    }

    public Double getMaximum_lift_value() {
        return this._globalMetrics.getMaximum_lift_value();
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void setModel(AssociationRules associationRules) {
        this._model = associationRules;
    }

    public AssociationRules getModel() {
        return this._model;
    }

    public void setRuleContentOption(RuleContentOption ruleContentOption) {
        this._ruleContentOption = ruleContentOption;
        this._tableModel.setRuleContentOption(ruleContentOption);
    }

    public RuleContentOption getRuleContentOption() {
        return this._ruleContentOption;
    }

    public boolean isOnlyOneColumnNameInModelItems() {
        return this._globalMetrics.isOnlyOneColumnNameInModelItems();
    }

    public boolean isOnlyOneConstantValueInModelItems() {
        return this._globalMetrics.isOnlyOneConstantValueInModelItems();
    }

    public boolean isNoSubNameColumnsInModelItems() {
        return this._globalMetrics.isNoSubNameColumnsInModelItems();
    }

    public Integer getTotalNumberOfSingleOccuringItems() {
        return this._globalMetrics.getTotalNumberOfSingleOccuringItems();
    }

    private class LoadGlobalMetrics
    extends Thread {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        @Override
        public void run() {
            try {
                ARRulesViewerState.this._globalMetrics.loadGlobalMetrics();
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
        }

        public boolean isSuccessful() {
            return this._success;
        }

        public Exception getException() {
            return this._ex;
        }
    }
}

