/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;
import oracle.dmt.dataminer.mviewer.clustering.SingleClusterMainPanel;
import oracle.dmt.dataminer.mviewer.clustering.SingleClusterViewerState;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.server.model.ClusteringDetailRowShort;
import oracle.dmt.dataminer.server.model.ClusteringFilterSetting;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;

public class ClusterFilterPanel
extends JPanel {
    private static Icon _icon;
    private static Icon _collapseIcon;
    private static Icon _expandIcon;
    SingleClusterMainPanel _mainPanel;
    SingleClusterViewerState _state;
    Context _context;
    private boolean _reloadingClusterCombo = false;
    private boolean _bCollapsed = true;
    private ClusteringFilterSetting _clusterFilterSetting;
    private static Preferences _p;
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private JButton _jApplyFilterButton;
    private JComboBox _jClusterCombo;
    private JLabel _jClusterComboLabel;
    private JSpinner _jFetchSize;
    private JLabel _jFetchSizeLabel;
    private JCheckBox _jLeafsOnlyCheckBox;

    public ClusterFilterPanel(SingleClusterMainPanel singleClusterMainPanel, Context context, SingleClusterViewerState singleClusterViewerState) {
        this._context = context;
        this._mainPanel = singleClusterMainPanel;
        this._state = singleClusterViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public SingleClusterViewerState getState() {
        return this._state;
    }

    private void initComponents() {
        this._jClusterComboLabel = new JLabel();
        this._jClusterCombo = new JComboBox();
        this._jFetchSizeLabel = new JLabel();
        this._jFetchSize = new JSpinner();
        this._jApplyFilterButton = new JButton();
        this._jLeafsOnlyCheckBox = new JCheckBox();
        this._jClusterComboLabel.setText("Cluster:");
        this._jClusterCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._jClusterCombo.setMaximumSize(new Dimension(150, 20));
        this._jClusterCombo.setMinimumSize(new Dimension(150, 20));
        this._jClusterCombo.setPreferredSize(new Dimension(150, 20));
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jFetchSizeLabel.setPreferredSize(new Dimension(60, 14));
        this._jFetchSize.setMaximumSize(new Dimension(87, 20));
        this._jFetchSize.setMinimumSize(new Dimension(87, 20));
        this._jFetchSize.setPreferredSize(new Dimension(87, 20));
        this._jApplyFilterButton.setText("Query");
        this._jApplyFilterButton.setHideActionText(true);
        this._jApplyFilterButton.setHorizontalAlignment(11);
        this._jApplyFilterButton.setMaximumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setMinimumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setPreferredSize(new Dimension(87, 23));
        this._jLeafsOnlyCheckBox.setText("Leafs Only");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jClusterComboLabel, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jClusterCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jLeafsOnlyCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 138, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jFetchSizeLabel, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jFetchSize, -1, -1, Short.MAX_VALUE).addComponent(this._jApplyFilterButton, -1, 106, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jClusterComboLabel).addComponent(this._jClusterCombo, -2, -1, -2).addComponent(this._jLeafsOnlyCheckBox)).addComponent(this._jApplyFilterButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jFetchSize, -2, -1, -2).addComponent(this._jFetchSizeLabel, -2, -1, -2)).addContainerGap()));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jClusterComboLabel, (Component)this._jClusterCombo, (String)ClusterLrb.get("DETAIL_CLUSTER"));
        this._jClusterComboLabel.getAccessibleContext().setAccessibleName(ClusterLrb.get("DETAIL_CLUSTER"));
        this._jClusterComboLabel.getAccessibleContext().setAccessibleDescription(ClusterLrb.get("DETAIL_CLUSTER_ADA"));
        this._jClusterComboLabel.setLabelFor(this._jClusterCombo);
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)ClusterLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(ClusterLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(ClusterLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(DataMinerIcons.get(Icons.QUERY));
        this._jApplyFilterButton.setToolTipText(ClusterLrb.get("QUERY_ADA"));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSize, (String)ClusterLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(ClusterLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(ClusterLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSizeLabel.setLabelFor(this._jFetchSize);
        this._jFetchSize.setToolTipText(ClusterLrb.get("FETCH_SIZE_ADA") + "\n" + ClusterLrb.get("FETCH_SIZE_RANGE"));
        this._jFetchSize.setModel(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 100));
        ResourceUtils.resButton((AbstractButton)this._jLeafsOnlyCheckBox, (String)ClusterLrb.get("LEAVES_ONLY"));
        this._jLeafsOnlyCheckBox.getAccessibleContext().setAccessibleName(ClusterLrb.get("LEAVES_ONLY"));
        this._jLeafsOnlyCheckBox.getAccessibleContext().setAccessibleDescription(ClusterLrb.get("LEAVES_ONLY_ADA"));
        this._jLeafsOnlyCheckBox.setToolTipText(ClusterLrb.get("LEAVES_ONLY_ADA"));
    }

    public void initUI() {
        this.setLocale(this._jFetchSize, Locale.getDefault());
        this._jLeafsOnlyCheckBox.setSelected(false);
        this._jLeafsOnlyCheckBox.setEnabled(false);
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusterFilterPanel.this._jApplyFilterButton_actionPerformed(actionEvent);
            }
        });
        this._jClusterCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusterFilterPanel.this._jClusterCombo_actionPerformed(actionEvent);
            }
        });
        this._jLeafsOnlyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusterFilterPanel.this._jLeafsOnlyCheckBox_actionPerformed(actionEvent);
            }
        });
        this._jClusterCombo.setModel(new DefaultComboBoxModel());
        this.enableControls(true);
        ((GroupLayout)this.getLayout()).invalidateLayout(this);
    }

    public void loadClusterCombo() {
        this._reloadingClusterCombo = true;
        this._jClusterCombo.setModel(new DefaultComboBoxModel<Object>(this._state.getClusterLabels()));
        this._jClusterCombo.setSelectedItem(this._state.getClusterLabel());
        this._reloadingClusterCombo = false;
    }

    public void setupClusterCombo() {
        this._reloadingClusterCombo = true;
        this._jClusterCombo.setModel(new DefaultComboBoxModel<Object>(this._state.getClusterLabels()));
        boolean bl = this._state.getClusterLabels().length > 1;
        this._jLeafsOnlyCheckBox.setEnabled(bl);
        this._jLeafsOnlyCheckBox.setSelected(bl);
        this._jClusterCombo.setSelectedItem(this._state.getClusterLabel());
        this._reloadingClusterCombo = false;
    }

    private void enableControls(boolean bl) {
        this._jApplyFilterButton.setEnabled(bl);
        this._jFetchSize.setEnabled(bl);
        this._jFetchSizeLabel.setEnabled(bl);
        this._jClusterComboLabel.setEnabled(bl);
        this._jClusterCombo.setEnabled(bl);
    }

    private void _jLeafsOnlyCheckBox_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        String string = this._state.getClusterLabel();
        boolean bl = this._jLeafsOnlyCheckBox.isSelected();
        this._state.setLeafsOnly(bl);
        this.loadClusterCombo();
        if (!string.equals(this._state.getClusterLabel())) {
            this._jApplyFilterButton_actionPerformed(null);
        }
    }

    private void _jClusterCombo_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.isLoading()) {
                return;
            }
            if (this._reloadingClusterCombo) {
                return;
            }
            this.setLoading(true);
            String string = (String)this._jClusterCombo.getSelectedItem();
            ClusteringDetailRowShort clusteringDetailRowShort = this._state.getClusterLabelToIDMap().get(string);
            this._state.setCluster_id(clusteringDetailRowShort.getId());
            this._state.setClusterLabel(string);
            if (!this.validateSettings()) {
                return;
            }
            this.prepareReload();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
            this._jApplyFilterButton.setEnabled(true);
        }
    }

    private void setNumber(JSpinner jSpinner, Number number) {
        jSpinner.setValue(number);
    }

    public void setLoading(boolean bl) {
        this.enableControls(!bl);
    }

    private void prepareReload() {
        this.enableControls(false);
        this._mainPanel.prepareReload(false);
    }

    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    public void executeAppy() {
        try {
            this._jApplyFilterButton.setEnabled(false);
            if (this.validateSettings()) {
                this._mainPanel.setFilterState(this._clusterFilterSetting, true);
            }
            this._jApplyFilterButton.setEnabled(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
            this._jApplyFilterButton.setEnabled(true);
        }
    }

    protected void _jApplyFilterButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this._jApplyFilterButton.setEnabled(false);
            if (this.validateSettings()) {
                this._mainPanel.setFilterState(this._clusterFilterSetting, false);
            }
            this._jApplyFilterButton.setEnabled(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
            this._jApplyFilterButton.setEnabled(true);
        }
    }

    private boolean validateSettings() throws Exception {
        boolean bl = false;
        bl = true;
        Number number = this.getNumber(this._jFetchSize);
        this._clusterFilterSetting.setFetchSize(number.intValue());
        this._clusterFilterSetting.setUseFilterSpecification(false);
        return bl;
    }

    private void setLocale(JSpinner jSpinner, Locale locale) {
        jSpinner.setLocale(locale);
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    public void setupUI(ClusteringFilterSetting clusteringFilterSetting) {
        this._clusterFilterSetting = clusteringFilterSetting;
        this.loadStateAttributes();
        this.enableControls(true);
    }

    private void loadStateAttributes() {
        if (this._clusterFilterSetting != null) {
            this.setNumber(this._jFetchSize, this._modelViewerPrefenceSettings.getFetchSizeClusteringModel());
        }
    }

    static {
        _p = Preferences.getPreferences();
    }
}

