/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.renderers.MiniHistogramCellRenderer;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetailsModel;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetailsModelRow;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;
import oracle.dmt.dataminer.mviewer.clustering.SingleClusterMainPanel;
import oracle.dmt.dataminer.mviewer.clustering.SingleClusterViewerState;
import oracle.dmt.dataminer.server.model.ClusteringFilterSetting;
import oracle.dmt.dataminer.utils.DelayedLoadInterface;
import oracle.dmt.dataminer.utils.DelayedProcessWorker;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.BlockingComponent;

public class SingleClusterViewer
extends DataMinerViewGUI
implements DelayedLoadInterface {
    private static final Logger THELOGGER = Logger.getLogger(SingleClusterViewer.class.getName());
    private static final String NO_SELECTED_ATTRS = ClusterLrb.get("NO_HISTOGRAM_TO_DISPLAY");
    private static final String TOO_MANY_ATTRS = ClusterLrb.get("CLUSTER_DETAIL_SELECTED_ATTRIBUTES_LIMIT");
    private static final ModelViewerPreferenceSettings PREF_SETTINGS = ModelViewerPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private SingleClusterViewerState state;
    private SingleClusterMainPanel mainPanel;
    private JPanel jGraphMainPanel;
    private JPanel jGraphPanel;
    private GraphPanel[] graphPanel;
    private JPanel loadingPanel;
    private JPanel singleAttributeMessagePanel;
    private boolean loadedFilterSetting = false;
    private Dimension histogramRowDimension = new Dimension(120, 25);
    private NumberFormat labelPercentageFormat = NumericFormat.getInstance(true, PREF_SETTINGS.getPercentagePrecisionLevel(), 0, 0);
    private BlockingComponent overLayPanel = null;
    private boolean _success = false;
    private DelayedProcessWorker worker;
    private boolean _external = false;
    private boolean _reload = false;
    private JPanel _jDetailPanel;
    private JSplitPane _jMasterSplitPanel;
    private DataMinerTablePanel dataMinerTablePanel;

    public SingleClusterViewer(Editor editor, SingleClusterMainPanel singleClusterMainPanel, Context context, SingleClusterViewerState singleClusterViewerState) {
        super(editor, context);
        this.mainPanel = singleClusterMainPanel;
        this._context = context;
        this.state = singleClusterViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    private void initComponents() {
        this._jMasterSplitPanel = new JSplitPane();
        this._jDetailPanel = new JPanel();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this._jMasterSplitPanel.setDividerLocation(300);
        this._jMasterSplitPanel.setOrientation(0);
        this._jMasterSplitPanel.setResizeWeight(0.8);
        this._jMasterSplitPanel.setLastDividerLocation(400);
        GroupLayout groupLayout = new GroupLayout(this._jDetailPanel);
        this._jDetailPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 544, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 292, Short.MAX_VALUE));
        this._jMasterSplitPanel.setRightComponent(this._jDetailPanel);
        this._jMasterSplitPanel.setLeftComponent(this.dataMinerTablePanel);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this._jMasterSplitPanel).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jMasterSplitPanel, -1, 585, Short.MAX_VALUE));
    }

    @Override
    public void initRes() {
        this.loadRowsOutOfTotalLabel(0, 0);
        this.labelPercentageFormat.setMinimumIntegerDigits(1);
        this.labelPercentageFormat.setMinimumFractionDigits(PREF_SETTINGS.getPercentagePrecisionLevel());
    }

    @Override
    public void initUI() {
        this.jGraphPanel = new JPanel();
        this.jGraphPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.jGraphPanel);
        this.jGraphMainPanel = new JPanel();
        this.jGraphMainPanel.setLayout(new BorderLayout());
        this.jGraphMainPanel.setPreferredSize(new Dimension(300, 300));
        this.jGraphMainPanel.add((Component)jScrollPane, "Center");
        this._jMasterSplitPanel.setResizeWeight(0.8);
        this._jMasterSplitPanel.setDividerLocation(400);
        this._jMasterSplitPanel.setOneTouchExpandable(true);
        this._jMasterSplitPanel.setRightComponent(this.jGraphMainPanel);
        this.dataMinerTablePanel.getTable().setFillsViewportHeight(true);
        this.dataMinerTablePanel.getTable().setShowGrid(true);
        this.dataMinerTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SingleClusterViewer.this.handleSelectionChanged();
            }
        });
        this.setLoading(true);
        this.initializeControls();
        this._jMasterSplitPanel.updateUI();
        this.worker = new DelayedProcessWorker(this);
        this.worker.execute();
    }

    public JPanel createMessagePanel(String string) {
        this.jGraphPanel.removeAll();
        this.jGraphPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont((float)font.getSize() * 2.0f);
        jLabel.setFont(font2);
        int n = this.jGraphPanel.getGraphics() != null ? this.jGraphPanel.getGraphics().getFontMetrics(font2).stringWidth(string) : 400;
        Dimension dimension = this.jGraphPanel.getSize();
        jPanel.add(Box.createHorizontalStrut((dimension.width - n) / 2));
        jPanel.add(jLabel);
        this.jGraphPanel.add(jPanel);
        this.jGraphPanel.updateUI();
        return this.jGraphPanel;
    }

    public void setFilterState(ClusteringFilterSetting clusteringFilterSetting, boolean bl) {
        if (this.isLoading()) {
            return;
        }
        this.state.setFilterSetting(clusteringFilterSetting);
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        this.prepareReload(bl);
    }

    @Override
    public void setLoading(boolean bl) {
        this.mainPanel.updateLoading(bl);
    }

    @Override
    public void setLoaded(boolean bl) {
        if (!this.loadedFilterSetting) {
            this.mainPanel.setFilterPanelInitialState(this.state.getFilterSetting());
            this.loadedFilterSetting = true;
        }
        this.mainPanel.updateLoaded(bl);
    }

    @Override
    public boolean isLoading() {
        return this.mainPanel.isLoading();
    }

    private void initializeControls() {
        this.setupTable(new ClusterDetailsModel());
        this.enableControls(false);
    }

    private void enableControls(boolean bl) {
        this.dataMinerTablePanel.getSearchField().setEnabled(bl);
    }

    private void setupTable(ClusterDetailsModel clusterDetailsModel) {
        this.dataMinerTablePanel.setup((TableModel)((Object)clusterDetailsModel), null, new String[]{ClusterDetailsModel.COL_NAMES[0], ClusterDetailsModel.COL_NAMES[4]}, 0);
        this.dataMinerTablePanel.getTable().setSelectionMode(2);
        this.dataMinerTablePanel.getTable().setRowHeight((int)this.histogramRowDimension.getHeight());
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getColumnModel();
        tableColumnModel.getColumn(5).setCellRenderer(new NumberCellRenderer(NumberCellRenderer.FormatType.NUMERICAL));
        tableColumnModel.getColumn(3).setCellRenderer(new NumberCellRenderer(NumberCellRenderer.FormatType.NUMERICAL));
        tableColumnModel.getColumn(6).setCellRenderer(new NumberCellRenderer(NumberCellRenderer.FormatType.NUMERICAL));
        tableColumnModel.getColumn(1).setCellRenderer(new MiniHistogramCellRenderer((GraphModelProvider)this.state, this.histogramRowDimension));
        tableColumnModel.getColumn(2).setCellRenderer(new HistogramBarRenderer(100L, true, this.labelPercentageFormat));
        tableColumnModel.getColumn(5).setCellRenderer(new NumberCellRenderer());
        tableColumnModel.getColumn(6).setCellRenderer(new NumberCellRenderer());
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        tableColumnModel.getColumn(1).setPreferredWidth(150);
        tableColumnModel.getColumn(2).setPreferredWidth(110);
        tableColumnModel.getColumn(5).setPreferredWidth(90);
        tableColumnModel.getColumn(4).setPreferredWidth(150);
        tableColumnModel.getColumn(3).setPreferredWidth(90);
        tableColumnModel.getColumn(6).setPreferredWidth(90);
    }

    void prepareReload(boolean bl) {
        this.setLoading(true);
        this.enableControls(false);
        this.state.clearRows();
        this.dataMinerTablePanel.getTable().repaint();
        this.createMessagePanel(ClusterLrb.get("NO_HISTOGRAM_TO_DISPLAY"));
        this.worker = new DelayedProcessWorker(this);
        this.worker.setReloadData(true);
        this.worker.execute();
        this._external = bl;
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = ClusterLrb.get("ATTRIBUTES_ROWS_OUT_OF_TOTAL");
        String string2 = NumericFormat.format(n != null ? n : 0);
        String string3 = NumericFormat.format(n2 != null ? n2 : 0);
        String string4 = MessageFormat.format(string, string2, string3);
        this.dataMinerTablePanel.setTitle(string4);
    }

    private void handleSelectionChanged() {
        boolean bl = true;
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        String string = null;
        if (null == nArray || nArray.length == 0) {
            bl = false;
            string = NO_SELECTED_ATTRS;
        } else if (nArray.length > 12) {
            bl = false;
            string = TOO_MANY_ATTRS;
        }
        if (!bl) {
            this.createMessagePanel(string);
            return;
        }
        LoadGraphPanel loadGraphPanel = new LoadGraphPanel(nArray);
        loadGraphPanel.execute();
    }

    public HelpInfo getHelpInfo() {
        return this.state.getHelpInfo();
    }

    @Override
    public void loadDataProcess() {
        try {
            this._reload = false;
            this.state.load();
            this._success = this.state.isLoaded();
        }
        catch (Exception exception) {
            this._success = false;
            THELOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    @Override
    public void reloadDataProcess() {
        try {
            this._reload = true;
            this.state.reload(this._external);
        }
        catch (Exception exception) {
            this._success = false;
            THELOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadGUIProcess() {
        try {
            if (this._success) {
                this.setupTable(this.state.getTableModel());
                this.dataMinerTablePanel.trySearch();
                this.loadRowsOutOfTotalLabel(this.state.getTableModel().getRowCount(), this.state.getTotalNumberOfModelAttributes());
                this.labelPercentageFormat.setMaximumFractionDigits(PREF_SETTINGS.getPercentagePrecisionLevel());
                this.enableControls(true);
                if (this.dataMinerTablePanel.getTable().getRowCount() > 0) {
                    int n = this.dataMinerTablePanel.getTable().convertRowIndexToModel(0);
                    this.dataMinerTablePanel.getTable().setSelectedRowsInModel(new int[]{n});
                }
                if (!this._reload) {
                    this.mainPanel.updateClusterIDs();
                }
                if (this._external) {
                    this.mainPanel.updateClusterIDs();
                }
                this.setLoaded(true);
            } else if (this.state.getTableModel() != null) {
                this.state.getTableModel().setFailedStatus();
                this.setupTable(this.state.getTableModel());
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_TITLE"), (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_MESG"), null);
        }
        finally {
            this.setLoading(false);
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
            }
        }
    }

    static /* synthetic */ GraphPanel[] access$402(SingleClusterViewer singleClusterViewer, GraphPanel[] graphPanelArray) {
        singleClusterViewer.graphPanel = graphPanelArray;
        return graphPanelArray;
    }

    private class LoadGraphPanel
    extends SwingWorker {
        Exception ex = null;
        boolean success = false;
        GraphDataModel[] localGraphModel = null;
        int[] selectedRowsInModel;

        public LoadGraphPanel(int[] nArray) {
            this.selectedRowsInModel = nArray;
            this.localGraphModel = new GraphDataModel[nArray.length];
        }

        protected Object doInBackground() throws Exception {
            try {
                ClusterDetailsModel clusterDetailsModel = (ClusterDetailsModel)((Object)SingleClusterViewer.this.dataMinerTablePanel.getTable().getModel());
                Vector<ClusterDetailsModelRow> vector = clusterDetailsModel.getDataVector();
                for (int i = 0; i < this.selectedRowsInModel.length; ++i) {
                    ClusterDetailsModelRow clusterDetailsModelRow = vector.get(this.selectedRowsInModel[i]);
                    String string = clusterDetailsModelRow.getFullAttributeName();
                    this.localGraphModel[i] = SingleClusterViewer.this.state.createGraphDataModelForAttribute(string);
                    this.localGraphModel[i].setTitle(string);
                }
                this.success = true;
            }
            catch (Exception exception) {
                this.ex = exception;
                this.success = false;
                THELOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return SingleClusterViewer.this.state;
        }

        @Override
        protected void done() {
            super.done();
            if (this.success && this.ex == null) {
                int n;
                int n2 = this.selectedRowsInModel.length;
                SingleClusterViewer.access$402(SingleClusterViewer.this, new GraphPanel[n2]);
                for (n = 0; n < n2; ++n) {
                    ((SingleClusterViewer)SingleClusterViewer.this).graphPanel[n] = new GraphPanel(this.localGraphModel[n]);
                    this.localGraphModel[n].setDepthRadius(SingleClusterViewer.this.state.getDepthRadius());
                    boolean bl = false;
                    if (n2 == 1) {
                        bl = true;
                        this.localGraphModel[n].setLegendSeriesCount(2);
                    }
                    this.localGraphModel[n].setLegendVisible(bl);
                    SingleClusterViewer.this.graphPanel[n].initGraph();
                    this.localGraphModel[n].setStyleSelection(SingleClusterViewer.this.state.getStyleSelection());
                    SingleClusterViewer.this.graphPanel[n].updateGraphStyle();
                }
                SingleClusterViewer.this.jGraphPanel.removeAll();
                if (n2 == 1) {
                    SingleClusterViewer.this.jGraphPanel.setLayout(new BorderLayout());
                    SingleClusterViewer.this.jGraphPanel.add((Component)SingleClusterViewer.this.graphPanel[0], "Center");
                } else if (n2 % 3 == 0) {
                    SingleClusterViewer.this.jGraphPanel.setLayout(new GridLayout(0, 3));
                } else {
                    SingleClusterViewer.this.jGraphPanel.setLayout(new GridLayout(0, 2));
                }
                for (n = 0; n < n2; ++n) {
                    SingleClusterViewer.this.jGraphPanel.add(SingleClusterViewer.this.graphPanel[n]);
                }
                SingleClusterViewer.this.jGraphPanel.updateUI();
                SingleClusterViewer.this.jGraphMainPanel.updateUI();
            }
        }
    }
}

